unit DelphiSnippingToolOCRUnit;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, Vcl.ExtDlgs,
  PngImage, Math, System.AnsiStrings; // DeskewPipeline;

type
  // SnippingToolOcr.Img ɑΉ
  PImg= ^TImg;
  TImg = packed record
    t: Int32;
    col: Int32;
    row: Int32;
    unk: Int32;
    step: Int64;
    data_ptr: Int64;
  end;

  // SnippingToolOcr.BoundingBox ɑΉ
  PBoundingBox = ^TBoundingBox;
  TBoundingBox = packed record
    x1, y1: Single;
    x2, y2: Single;
    x3, y3: Single;
    x4, y4: Single;
  end;

type

  TCreateOcrInitOptions  = function(OutPtr: PInt64): Int64; cdecl;

  TGetOcrLineCount       = function(Instance: Int64; OutPtr: PInt64): Int64; cdecl;
  TGetOcrLine            = function(Instance: Int64; Index: Int64; OutPtr: PInt64): Int64; cdecl;
  TGetOcrLineContent     = function(LineHandle: Int64; OutPtr: PInt64): Int64; cdecl;
  TGetOcrLineBoundingBox = function(LineHandle: Int64; OutPtr: PInt64): Int64; cdecl;
  TGetOcrLineWordCount   = function(LineHandle: Int64; Count: PInt64): Int64; cdecl;

  TGetOcrWord            = function(LineHandle: Int64; Index: Int64; WordHandle: PInt64): Int64; cdecl;
  TGetOcrWordContent     = function(WordHandle: Int64; Content: PInt64): Int64; cdecl;
  TGetOcrWordBoundingBox = function(WordHandle: Int64; OutPtr: PInt64): Int64; cdecl;

  TCreateOcrProcessOptions = function(OutPtr: PInt64): Int64; cdecl;
  TOcrInitOptionsSetUseModelDelayLoad = function(Options: Int64; Flag: AnsiChar): Int64; cdecl;
  TOcrProcessOptionsSetMaxRecognitionLineCount = function(Options: Int64; MaxLines: Int64): Int64; cdecl;
  TRunOcrPipeline        = function(Pipeline: Int64; Img: PImg; Flags: Int64; OutPtr: PInt64): Int64; cdecl;
  TCreateOcrPipeline     = function(ModelPath: Int64; Key: Int64; Ctx: Int64; OutPtr: PInt64): Int64; cdecl;

type
  TForm105 = class(TForm)
    Memo1: TMemo;
    Image1: TImage;
    OpenPictureDialog1: TOpenPictureDialog;
    Button2: TButton;
    Edit1: TEdit;
    Button3: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form105: TForm105;

var
  CreateOcrInitOptions: TCreateOcrInitOptions;

  GetOcrLineCount: TGetOcrLineCount;
  GetOcrLine: TGetOcrLine;
  GetOcrLineContent: TGetOcrLineContent;
  GetOcrLineBoundingBox: TGetOcrLineBoundingBox;

  RunOcrPipeline: TRunOcrPipeline;
  CreateOcrPipeline: TCreateOcrPipeline;
  CreateOcrProcessOptions: TCreateOcrProcessOptions;
  OcrInitOptionsSetUseModelDelayLoad: TOcrInitOptionsSetUseModelDelayLoad;
  OcrProcessOptionsSetMaxRecognitionLineCount: TOcrProcessOptionsSetMaxRecognitionLineCount;

  GetOcrWord: TGetOcrWord;
  GetOcrWordContent: TGetOcrWordContent;
  GetOcrWordBoundingBox: TGetOcrWordBoundingBox;
  GetOcrLineWordCount: TGetOcrLineWordCount;

implementation

{$R *.dfm}

// Img  Image ɕ`
procedure ShowTImgToImage(const Img: TImg; Dest: TImage);
var
  Bmp: TBitmap;
  y: Integer;
  Src: PByte;
  Dst: PByte;
begin
  Bmp := TBitmap.Create;
  try
    Bmp.PixelFormat := pf32bit;
    Bmp.HandleType := bmDIB;
    Bmp.SetSize(Img.col, Img.row);

    for y := 0 to Img.row - 1 do begin
      Src := PByte(NativeUInt(Img.data_ptr) + Img.step * y);
      Dst := Bmp.ScanLine[y];
      Move(Src^, Dst^, Img.col * 4);  // BGRA32 = 4 bytes/pixel
    end;

    Dest.Picture.Bitmap.Assign(Bmp);
    Dest.Repaint;
  finally
    Bmp.Free;
  end;
end;

//// gp
//procedure Bitmap32ToImgBGRA(bmp: TBitmap; var img: TImg);
//var
//  y: Integer;
//  src: PByte;
//  dst: PByte;
//  buf: PByte;
//begin
//  bmp.PixelFormat := pf32bit;
//
//  img.t   := 3;                 // DLL  BGRA
//  img.col := bmp.Width;
//  img.row := bmp.Height;
//  img.unk := 0;
//
//  img.step := img.col * 4;// (img.col * 4 + 3) and not 3;  // 4byte alignment
//
//  GetMem(buf, img.step * img.row);
//  img.data_ptr := NativeInt(buf);
//
//  for y := 0 to img.row - 1 do begin
//    src := bmp.ScanLine[y];          // BGRA
//    dst := buf + y * img.step;       // BGRA
//    //pf32bit    TBitmap   BGRA(B,G,R,A)Ȃ̂ł̂܂
//    Move(src^, dst^, img.col * 4);   // 1 sۂƃRs[
//  end;
//end;



//procedure Bitmap32ToImgMat(bmp: TBitmap;var img:TImg);
//var
//  y: Integer;
//  src: PByte;
//  dst: PByte;
//  buf: PByte;
//  imgl: PIplImage;
//  mat: PCvMat;
//begin
//  bmp.PixelFormat := pf32bit;
//  imgl := BitmapToIplImage(bmp);
//
//  img.t   := 3;                 // DLL  BGRA
//  img.col := bmp.Width;
//  img.row := bmp.Height;
//  img.unk := 0;
//
//  img.step := (img.col * 4 + 3) and not 3;  // 4byte alignment
//  mat:= IplImageToMat(imgl); //PCvMat;
//
//  //GetMem(buf, img.step * img.row);
//  img.data_ptr := Int64(mat.data);
////
////  for y := 0 to img.row - 1 do
////  begin
////    src := bmp.ScanLine[y];          // BGRA
////    dst := buf + y * img.step;       // BGRA
////    //pf32bit    TBitmap   BGRA(B,G,R,A)Ȃ̂ł̂܂
////    Move(src^, dst^, img.col * 4);   // 1 sۂƃRs[
////  end;
//end;
//procedure ShowBmpHeader(const FileName: string; Memo:TMemo);
//var
//  FS: TFileStream;
//  FH: TBitmapFileHeader;
//  IH: TBitmapInfoHeader;
//begin
//  FS := TFileStream.Create(FileName, fmOpenRead or fmShareDenyWrite);
//  try
//    FS.ReadBuffer(FH, SizeOf(FH));
//    FS.ReadBuffer(IH, SizeOf(IH));
//
//    Memo.Lines.Add('=== BITMAPFILEHEADER ===');
//    Memo.Lines.Add('bfType      : '+ Chr(FH.bfType and $FF)+ Chr(FH.bfType shr 8));
//    Memo.Lines.Add('bfSize      : '+ IntToStr(FH.bfSize));
//    Memo.Lines.Add('bfOffBits   : '+ IntToStr(FH.bfOffBits));
//
//    Memo.Lines.Add('=== BITMAPINFOHEADER ===');
//    Memo.Lines.Add('biSize      : '+ IntToStr(IH.biSize));
//    Memo.Lines.Add('biWidth     : '+ IntToStr(IH.biWidth));
//    Memo.Lines.Add('biHeight    : '+ IntToStr(IH.biHeight));
//    Memo.Lines.Add('biPlanes    : '+ IntToStr(IH.biPlanes));
//    Memo.Lines.Add('biBitCount  : '+ IntToStr(IH.biBitCount));
//    Memo.Lines.Add('biCompression: '+ IntToStr(IH.biCompression));
//    Memo.Lines.Add('biSizeImage : '+ IntToStr(IH.biSizeImage));
//  finally
//    FS.Free;
//  end;
//end;

function ContainsInvalidJapaneseChars(const S: string): Boolean;
var
  SJIS: AnsiString; // CodePagevpeBANSI
begin
  // string(Unicode)  AnsiString(CP932) ɑ
  // ϊłȂ͎I '?' ɒu
  SetCodePage(RawByteString(SJIS), 932, False);
  SJIS := AnsiString(S);

  // Ă Unicode(string) ɖ߂āA̕Ɣr
  Result := (string(SJIS) <> S);
end;

procedure TForm105.Button2Click(Sender: TObject);

begin
  with OpenPictureDialog1 do begin
    if Execute then begin
      Edit1.Text:= FileName;
      Memo1.Lines.Clear;
      Image1.Picture:= nil;
    end;
  end;
end;

procedure TForm105.Button3Click(Sender: TObject);
var
  DLL: HMODULE;
  Bmp: TBitmap;
  Png:TPngImage;
  Img:TImg;
  Ctx, Opt, Pipeline, Instance: Int64;

  LineCount, LineWordCount: Int64;
  s: string;
  ContentPtr: PAnsiChar;//Int64;
  LineHandle: Int64;

  ret, ans :Int64;
  i: Integer;
  pbox: PBoundingBox;
  ext:string;
  SavedCW: Word;
  y: Integer;
  src: PByte;
  dst: PByte;
  buf: PByte;
begin
  Memo1.Lines.Clear;

  // dviꂪƉ摜ɂėOŌpłȂj
  System.Math.SetExceptionMask(System.Math.exAllArithmeticExceptions);

  DLL := LoadLibrary('oneocr.dll');
  if DLL = 0 then
    raise Exception.Create('Failed to load oneocr.dll.');

  @CreateOcrInitOptions  := GetProcAddress(DLL, 'CreateOcrInitOptions');
  @GetOcrLineCount       := GetProcAddress(DLL, 'GetOcrLineCount');
  @GetOcrLine            := GetProcAddress(DLL, 'GetOcrLine');
  @GetOcrLineContent     := GetProcAddress(DLL, 'GetOcrLineContent');
  @GetOcrWordBoundingBox := GetProcAddress(DLL, 'GetOcrWordBoundingBox');
  @RunOcrPipeline        := GetProcAddress(DLL, 'RunOcrPipeline');
  @CreateOcrPipeline     := GetProcAddress(DLL, 'CreateOcrPipeline');
  @CreateOcrProcessOptions := GetProcAddress(DLL, 'CreateOcrProcessOptions');
  @OcrInitOptionsSetUseModelDelayLoad := GetProcAddress(DLL, 'OcrInitOptionsSetUseModelDelayLoad');
  @OcrProcessOptionsSetMaxRecognitionLineCount := GetProcAddress(DLL, 'OcrProcessOptionsSetMaxRecognitionLineCount');
  @GetOcrLineBoundingBox := GetProcAddress(DLL, 'GetOcrLineBoundingBox');
  @GetOcrLineWordCount   := GetProcAddress(DLL, 'GetOcrLineWordCount');

  // Ôߏ
  ctx := 0;
  pipeline := 0;
  opt := 0;
  Instance := 0;

  Bmp := TBitmap.Create;
  try
    ext:= UpperCase(ExtractFileExt(Edit1.Text));
    if ext = '.BMP' then begin
      Bmp.LoadFromFile(Edit1.Text);
    end
    else if ext = '.PNG' then begin
      // PNG ǂݍ
      png:= TPngImage.Create;
      try
        png.LoadFromFile(Edit1.Text);
        bmp.Assign(png);
      finally
        png.Free;
      end;
    end;

    bmp.PixelFormat := pf32bit; // dv

    img.t   := 3;                 // DLL  BGRA
    img.col := bmp.Width;
    img.row := bmp.Height;
    img.unk := 0;
    img.step := img.col * 4;

    GetMem(buf, img.step * img.row);
    try
      img.data_ptr := NativeInt(buf);
      for y := 0 to img.row - 1 do begin
        src := bmp.ScanLine[y];          // BGRA
        dst := buf + y * img.step;       // BGRA
        //pf32bit    TBitmap   BGRA(B,G,R,A)Ȃ̂ł̂܂
        Move(src^, dst^, img.col * 4);   // 1 sۂƃRs[
      end;

      ShowTImgToImage(Img, Image1); // mF̂߂ɃC[W`
      Image1.Repaint;

      Memo1.Lines.Add(Format('col=%d, row=%d, step=%d', [Img.col, Img.row, Img.step]));

      SavedCW := Get8087CW;
      try
        Set8087CW($133F); // OꎞIɃ}XNiÔ߁A炭svj

        CreateOcrInitOptions(@Ctx);
        OcrInitOptionsSetUseModelDelayLoad(Ctx, #0);

        // łȂ莞Ԃ
        Memo1.Lines.Add('Create Ocr Pipeline ...');
        ret:= CreateOcrPipeline(
          Int64(PAnsiChar('oneocr.onemodel')),
        @Int64(PAnsiChar('kj)TGtrK>f]b[Piow.gU+nC@s""""""4')),
        @Ctx,
        @@Pipeline
      @);

        if ret = 0 then Memo1.Lines.Add('OCR model loaded ...');

        ret:= CreateOcrProcessOptions(@Opt);
        ret:= OcrProcessOptionsSetMaxRecognitionLineCount(Opt, 1000);
        Memo1.Lines.Add('Img Size='+IntToStr(sizeof(img)));// 32($20) łOK
        //-------------------------------------
        // łOɂ鏜Z ̗OŌpłȂ
        try
          ret := RunOcrPipeline(Pipeline, @Img, Opt, @Instance);
        except
          Memo1.Lines.Add('RunOcrPipeline Error');
          ret:= -1;
        end;
        //-------------------------------------
        if (ret <> 0) then Memo1.Lines.Add('RunOcrPipeline='+IntToStr(Ret));

        if (ret = 0) and (sizeof(img) = 32) then begin
          Memo1.Lines.Add('Running ocr pipeline ...');
          // s擾
          ret := GetOcrLineCount(Instance, @LineCount);
          Memo1.Lines.Add('GetOcrLineCount result= '+ IntToStr(ret));
          Memo1.Lines.Add('Recognize '+ intToStr(LineCount) + ' lines');

          if LineCount > 0 then begin
            for i := 0 to LineCount - 1 do begin
              LineHandle := 0;
              GetOcrLine(Instance, i, @LineHandle);

              if LineHandle <> 0 then begin
                // OCR 擾
                ret := GetOcrLineContent(LineHandle, @ContentPtr);
                if (ret = 0) and (ContentPtr <> nil) then begin
                  // OCR 
                  s := UTF8ToString(PAnsiChar(ContentPtr));
                  // \łȂ܂܂邩̃`FbN

                  if ContainsInvalidJapaneseChars(s) then begin

                    Memo1.Lines.Add('NG= ' + s);
                  end;


                  s := IntToStr(i) + ': ' + s + ':';

                  // Pꐔi{̏ꍇ͕j
                  LineWordCount:= 0;
                  GetOcrLineWordCount(LineHandle, @LineWordCount);

                  // ͂ 4 W
                  ret := GetOcrLineBoundingBox(LineHandle, @ans);
                  if (ret = 0) then begin
                    pbox:= PBoundingBox(ans);
                    s := s + ' '+ Format(
                      '(%.0f,%.0f),(%.0f,%.0f),(%.0f,%.0f),(%.0f,%.0f)',
                       [pbox.x1 -1, pbox.y1 -1, pbox.x2 -1, pbox.y2 -1,
                        pbox.x3 -1, pbox.y3 -1, pbox.x4 -1, pbox.y4 -1]);

                    with Image1.Picture.Bitmap.Canvas do begin
                      Pen.Color:= clRed;
                      Pen.Width:= 2;

                      MoveTo(Trunc(pbox.x1) -1, Trunc(pbox.y1) -1);
                      LineTo(Trunc(pbox.x2) -1, Trunc(pbox.y2) -1);
                      LineTo(Trunc(pbox.x3) -1, Trunc(pbox.y3) -1);
                      LineTo(Trunc(pbox.x4) -1, Trunc(pbox.y4) -1);
                      LineTo(Trunc(pbox.x1) -1, Trunc(pbox.y1) -1);

                      Pixels[Trunc(pbox.x1) -1, Trunc(pbox.y1) -1]:= clLime;
                    end;
                  end;
                  Memo1.Lines.Add(s);
                end;
              end;
            end;
          end;
        end;
      finally
        Set8087CW(SavedCW); // ɖ߂
      end;
    finally
      FreeMem(buf);// obt@
    end;
  finally
    bmp.Free;
  end;
end;

procedure TForm105.FormCreate(Sender: TObject);
begin
  Edit1.Text:='';
  Memo1.Lines.Clear;
end;

end.
