;*****************************************************
;; BTRIMVX232.lsp < BTRIM20.lsp + NSQ.lsp ̔ėp >
;; 2023/05/01
;; for BricCAD V19.2
;; copyright(c) 2008 .. 2023 f.izawa
;*****************************************************
; Tv
;  dCHiV[PXj}ɓ LISP ł
;  VisualLISP  IntersectWithAgetBoundingBox gāABRTIM20.lsp 
;  قړ̋@\񋟂Ă܂D
;
;  H݌vp NSQ.lsp ł͑Ώۂ̃ubNpłAėpubNɑ΂
;  ̋@\񋟂Ă܂D
;  NSQ.lsp lAI}`ɂāAeς܂D
;
; ӎ
;
;  [qA_AA[XV{͐}ʂɑ݂ubND悵Ďgp܂B
;  VKō쐬ꍇ́AACAD-DENKIABJ-Electrical }ʂƂ͈قȂA
;  ܂܂ȂubNgp܂B
;  ACAD-DENKIABJ-Electrical ŕҏW\ꍇ́A
;  ꂼp̃ubN𗬗p邱Ƃ߂܂
;  
;  BricsCAD V19 ȊOłׂ̍mF͂Ă܂B
;
; 
;
;  p̃ubNłȂAʂ̃ubNɑΉĂ܂B
;
; R}h
;
;  BTRIMVX232.TXT QƂĉ
;
; dl
;
;  Jbg}`͐(LINE)
;  ubNɌ̃JbǵAubN "*KOUTEN*,*CMARK*" ȊO
;  ubN̐}`̌óALINEAARCACIRCLEALWPOLYLINÊ݁iǉ\j
;  lXgꂽubNɑΉ
;  BricsCAD ł̐}`̌oΏۂ́AĂ͈͂
;  ̂߁AꎞI ZOOM Ăꍇ
;
; ƐӎA쌠
;
;  { LISP [hA܂͎sƂɂ鎖́AQ̈؂ɂāA
;  ҂͂̐ӂ𕉂܂B
;  { LISP ̒쌠͍ f.izawa LA咣܂B
;  ρAp͎RłB
;
; mF
;
;  BricsCAD V19.2 Pro ̂
;   CAD œƂĂAȂxȂƎv܂B

; 
;@2023/04/20 SBCHK ɃA[XV{̃`FbNǉ
;             ԂŃA[XV{ɂȂĂꍇ́AzƔf
;             ubN SBCHK ŌŒ
;@2023/04/21 SBAUTO ɃA[XV{̃`FbNǉ
;             A[XV{ɂȂĂźAԂ̑ΏۊOƂA
;             Ԓɐ "E" ǉ
;@2023/04/28 IOADRiIOAhXύXjǉ
;             NMUPHi@햼ꊇAbv HEX Łjǉ
;             SBUPHiԈꊇAbv HEX Łjǉ
;             CMTTHALLiPLC I/O Rg̈BύXjǉ
;             NMED i@햼ύXj̊̋@햼̍XV킩ɂ߁A
;             IOPINiPLC I/O [qԍύXjǉ
;             NMCLP, NMPSTi@햼Rs[Ay[Xgjǉ
;             SBCLP, SBPSTiԃRs[Ay[Xgjǉ
;@2023/04/29 SBINX iJEgAbvԍ쐬jŁȀlύXĂfȂ̂蒼
;@2023/05/02 ifs_dxfin_exp p[W܂łȂ̂蒼

(vl-load-com)

;; i؁j
; (defun ifs_isACon (blkname / )
;   (wcmatch blkname "ACON*,RY-A_*,TDR-*-A*,THR-A_*,AX-A_*,FCR-A_*,EAL-A_*")
; )
; (defun ifs_isBCon (blkname / )
;   (wcmatch blkname "BCON*,RY-B_*,TDR-*-B*,THR-B_*,AX-B*,FCR-B_*,EAL-B_*")
; )
; (defun ifs_isCCon (blkname / )
;   (wcmatch blkname "CCON*,RY-C_*,EAL-C_*")
; )
; (defun ifs_isASetsu (blkname / )
;   (wcmatch blkname "ACON*,*-A*,EMSA*,FLSA*,LSA*,PBA*,RRSA*,SSA*,THRA*,TMRA*.TSA*")
; )
; (defun ifs_isBSetsu (blkname / )
;   (wcmatch blkname "BCON*,*-B*,EMSB*,FLSB*,LSB*,PBB*,RRSB*,SSB*,THRB*,TMRB*.TSB*")
; )
; (defun ifs_isCoil (blkname / )
;   (wcmatch blkname "COIL*,AXR_*,MC_*,AXR_*,FCR_")
; )
; (defun ifs_isTimer (blkname / )
;   (wcmatch blkname "COIL*TMR*,TDR-*,FCR_*")
; )

;; CAD ̃tH_擾iŌ "\\" ͕tȂj
(defun ifs_appDirectory (/ res) 
  (setq res (vla-get-Path (vlax-get-Acad-Object)))
  (vl-string-right-trim "\\" res) ;; BricsCAD
)

;; CAD ̃LvV擾
(defun ifs_appCaption()
  (vla-get-caption (vlax-get-Acad-Object))
)

;; ̌ԏI(CopyBasegȂjł邩
(defun ifs_isTrial( / caption)
  (setq caption (vla-get-caption (vlax-get-Acad-Object)))
  (or (vl-string-search "̌" caption) (vl-string-search "p" caption));; ʒu͂Ox[XAƂ nil
)

;; ubN}̃tH_ INI t@Cɏ
(defun ifs_writeIni (fname key str / fullName f) 
  (setq fullName (strcat (ifs_appDirectory) "\\" fname ".ini"))
  (if (setq f (open fullName "w")) 
    (progn 
      (write-line (strcat key "=" str) f)
      (close f)
    )
  )
)

;; ubN}̃tH_ INI t@Cǂݍ
;; Ƃ "" Ԃ
(defun ifs_readIni (fname key / fullName f ln res loop) 
  (setq fullName (strcat (ifs_appDirectory) "\\" fname ".ini")
        res      ""
  )
  (if (setq f (open fullName "r")) 
    (progn 
      (setq loop T)
      (while (and loop (setq ln (read-line f))) 
        (if (= (vl-string-search (strcat key "=") ln) 0) 
          (setq res  (vl-string-left-trim (strcat key "=") ln)
                loop nil
          )
        )
      )
      (close f)
    )
  )
  res
)

;; DXFRUN.exe Ă΂ubN}iubÑtl[AJbgtOAJԂtOj
(defun ifs_dxfIn_cut (dxfName cut rep / ifs_error attreq elast elast2 loop)
  (defun ifs_error(msg)
    (princ msg)
    (command "_UNDO" "END")
    (setvar "ATTREQ" attreq)
    (setvar "CMDECHO" 1)
    (princ)
  )
  (setq *error* ifs_error)
  (setq attreq (getvar "ATTREQ"))
  (setvar "ATTREQ" 0)
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop
    (prompt "\n}w [ESC:I] : ")
    (setq elast (entlast))
    (command "_UNDO" "BE")
    (command "-INSERT" dxfname "S" 1 "R" 0)
    (while (wcmatch (getvar "CMDNAMES") "*INSERT")
      (command pause)
    )    
    (setq elast2 (entlast))
    (if (and cut (not (equal elast elast2)))
      (progn
        (ifs_sub_btrimvx elast2)
        (if (ifs_getAttValue elast2 "NAME")
          (progn
            (ifs_layerOn "NAME")
            (ifs_sub_nmed elast2 nil)
          )
        )
      )
    )
    (setq loop rep)
  )
  (command "_UNDO" "END")
  (setvar "ATTREQ" attreq)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
;; DXFRUN.exe Ă΂ubN}iubÑtl[AtOAp[WtOj
(defun ifs_dxfIn_exp (dxfName expFlag purgeFlag / ifs_error attreq elast elast2 blkname ent)
  (defun ifs_error(msg)
    (princ msg)
    (command "_UNDO" "END")
    (setvar "ATTREQ" attreq)
    (setvar "CMDECHO" 1)
    (princ)
  )
  (setq *error* ifs_error)
  (setq attreq (getvar "ATTREQ"))
  (setvar "ATTREQ" 0)
  (setvar "CMDECHO" 0)
  (prompt "\n}w [ESC:I] : ")
  (setq elast (entlast))
  (command "_UNDO" "BE")
  (command "-INSERT" dxfname "S" 1 "R" 0)
  (while (wcmatch (getvar "CMDNAMES") "*INSERT")
    (command pause)
  )     
  (setq elast2 (entlast))
  (if (and expFlag (not (equal elast elast2)))
    (progn
      (setq ent (entget elast2))
      (if (= "INSERT" (cdr (assoc 0 ent)))
        (progn
          (command "_EXPLODE" elast2) ;; 2023/05/02 Ō "" 폜
          (if purgeFlag
            (progn
              (setq blkname (cdr (assoc 2 ent)))
              (command "_PURGE" "B" blkname "N")
              
            )
          )
        )
      )        
    )
  )
  
  (command "_UNDO" "END")
  (setvar "ATTREQ" attreq)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ubN{p[W
;; t[Yw̐}`͌ĂȂc
(defun c:BEXP( /  blkname ename ent esel )
  (if (setq esel (entsel "\nubNI : "))
    (progn
      (setq ename (car esel) ent (entget ename))
      (if (= "INSERT" (cdr (assoc 0 ent)))
        (progn
          (setq blkname (cdr (assoc 2 ent)))
          (command "_EXPLODE" ename "")
          (command "_PURGE" "B" blkname "N")
        )
      )
    )
  )
  (princ)
)

; (defun c:BEXPEX( /  blkname ename ent esel laylst adoc blkobj lay layname lays lst obj laynames)
;   (if (setq esel (entsel "\nubNI : "))
;     (progn
;       (setq adoc (vla-get-activedocument (vlax-get-Acad-Object))
;             lays (vla-get-layers adoc))
;       ;;      lay (vla-item (vla-get-layers adoc) layname)
;       (setq ename (car esel) ent (entget ename))
;       (if (= "INSERT" (cdr (assoc 0 ent)))
;         (progn
;           (setq blkname (cdr (assoc 2 ent)))
;           (setq blkobj (vlax-ename->vla-object ename))
;           (setq lst (vlax-safearray->list (vlax-variant-value (vla-Explode blkobj ))))
;           (vla-delete blkobj)
;           (foreach obj lst
;             (setq layname (vla-get-layer obj)
;                   lay (vla-item lays layname)
;             )
;             (if (not (and (= :VLAX-TRUE (vla-get-layeron lay)) 
;                           (= :VLAX-FALSE (vla-get-freeze lay))))
;               (progn
;                 (vla-delete obj)
;                 (if (not (member layname laylst))
;                   (setq laylst (append laylst (list layname)))
;                 )
;               )
;             )  
;           )
;           (setq laynames "")
;           (foreach layname laylst
;             (if (= laynames "")
;               (setq laynames layname)
;               (setq laynames (strcat laynames "," layname))
;             )
;           )
;           (command "_PURGE" "B" blkname "N")
;           (if (/= "" laynames)
;             (command "_PURGE" "LA" laynames "N")
;           )
;         )
;       )
;     )
;   )
;   (princ)
; )


;; gp\TBubN𓾂
;; typsw=0:OUT /typsw=1=INT
;;  "" Ԃ
(defun availableTBblkname( typsw / blknames lst ret res len i)
  (if (= typsw 0);; out
    (setq blknames "OUTCIR,OUTCIRC1,OUTCIRC2,OUTCIRC3,OUTCIRC4,OUTCIR00")
    (setq blknames "INTCIR,INTCIR1,INTCIR2,INTCIR3,INTCIR4,INTCIR00")
  )
  (setq lst (ifs_strSplit blknames ",") len (length lst) i 0 ret nil res "")
  (while (and (< i len)(not ret))
    (if (tblobjname "BLOCK" (nth i lst))
      (setq res (nth i lst) ret T)
    )
    (setq i (1+ i))
  )
  res
)

;; IubNA܂͐}` DXF t@Cɏo
(defun c:bOut( / my_error esel opt pt ss fname bname ent flag dxfName dxfPath )
  (defun my_error(msg)
    (princ msg)
    (setvar "FILEDIA" 1)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  
  (setq dxfPath (ifs_readIni "BTRIMVX23" "dxfPath"))
  (setq bname "")
  (Initget "Objects")
  (setq esel (entsel "\nt@CɏoubNI [O:}`I] : "))
  (cond 
    ((and esel (listp esel))
      (progn
        (setq ent (entget (car esel)))
        (if (= "INSERT" (cdr (assoc 0 ent)))
          (setq bname (cdr (assoc 2 ent)) opt "B")
        )
      )
    )
    ((= esel "Objects")
      (if (and (setq ss (ssget ))(setq pt (getpoint "\n_w : ")))
        (setq opt "O")
      )
    )
  )
  (setq fname "")
  (if (and (/= dxfpath "")(/= bname ""))(setq fname (strcat dxfpath "\\" bname ".dxf")))
  (if opt
    (if (setq fname (getfiled "WBLOCK t@C" fname "dxf" (+ 1 4)));; 8
      (progn
        (princ "\n")(princ fname)
        (setq dxfPath (vl-filename-directory fname) ;; Ṓ
              dxfName (vl-filename-base fname)
        )
        (ifs_writeIni "BTRIMVX23" "dxfPath" (strcat dxfPath "\\"))
        
        (setq flag (findfile fname))
        ;;(princ flag)
        (setvar "CMDECHO" 0)
        (setvar "FILEDIA" 0)
        
        (if (= opt "B")
          (if flag
            (command "-WBLOCK" fname "Yes" 16 bname)
            (command "-WBLOCK" fname 16 bname)
          )
          (progn
            (if flag
              (command "-WBLOCK" fname "Yes" 16 "" pt ss "" )
              (command "-WBLOCK" fname 16 "" pt ss "" )
            )
            (command "_OOPS")
          )
        )
        (setvar "FILEDIA" 1)
      )
    )
  )
  (setvar "FILEDIA" 1)
  (setvar "CMDECHO" 1)
  (setq *error* nil)  
  (princ)
)

;; @햼\^\
(defun c:nmHide( / esel ename loop)
	(setq loop T)
	(while loop
		(initget "Exit eXit")
		(setq esel (entsel "\n@햼̕\^\𔽓]ubNI [E,X:I] : "))
		(cond 
			((or (= esel "Exit")(= esel "eXit"))
        (setq loop nil))
			((and esel (listp esel))
			 	(progn
					(setq ename (car esel))
					(ifs_func_attHide ename "NAME"	2)
					(ifs_func_attHide ename "NAME1" 2)
			 	))
		)
	)
	(princ)
)

;; \^\ mode 0:\ /1:\ /2:]
(defun ifs_func_attHide(ename tagName mode / flag ent)
	(setq flag T)
	(while (and flag (setq ename (entnext ename)) (setq ent (entget ename)) (= "ATTRIB" (cdr (assoc 0 ent))))
		;; :"SENBAN" ̓e擾
		(if (= (cdr (assoc 2 ent)) tagName)
			(progn
				(if (= mode 2)
					(if (= "PINOFF" (cdr (assoc 8 ent)))
						(entmod (subst (cons 8 "NAME")(assoc 8 ent) ent))
						(entmod (subst (cons 8 "PINOFF")(assoc 8 ent) ent))
					)
					(if (= mode 1)
						(entmod (subst (cons 8 "NAME")(assoc 8 ent) ent))
						(entmod (subst (cons 8 "PINOFF")(assoc 8 ent) ent))
					)
				)
				(setq flag nil)
			)
		)
	)
)

;; NC|Cō쐬
(defun c:lnkLn( / elast ent kw p1 pts ss p2 str1 str2 ename1 ename2 name name1 )
	(setvar "CMDECHO" 0)
  
  (command "_UNDO" "BE")
	(prompt "\nNC|Cō쐬܂DEnter ŏIĂD")
	(setq elast (entlast))

	(command "_PLINE") 
  (while (wcmatch (getvar "CMDNAMES") "PLINE")
    (command pause)
  )
	(if (not (equal elast (entlast)))
		(progn
			(setq ent (entget (entlast)) p1 (cdr (assoc 10 ent)) p2 (getvar "LASTPOINT"))			
      (entmod (subst (cons 8 "LINK")(assoc 8 ent) ent))
		  (setq str1 "" str2 "")
      (setq name nil name1 nil)
      (setq pts (ifs_pointW p1 3.536));; 2.5*1.414
      (if (setq ss (ssget "C" (car pts)(cadr pts) '((0 . "INSERT"))))
        (setq ename1 (ssname ss 0) 
              name  (ifs_getAttValue ename1 "NAME")
              name1 (ifs_getAttValue ename1 "NAME1")
        )
      )
      (if name  (setq str1 (strcat str1 name)))
      (if name1 (setq str1 (strcat str1 name1)))
    
      (setq name nil name1 nil)
      (setq pts (ifs_pointW p2 3.536));; 2.5*1.414
      (if (setq ss (ssget "C" (car pts)(cadr pts) '((0 . "INSERT"))))
        (setq ename2 (ssname ss 0) 
              name  (ifs_getAttValue ename2 "NAME")
              name1 (ifs_getAttValue ename2 "NAME1")
        )
      )
      (if name  (setq str2 (strcat str2 name)))
      (if name1 (setq str2 (strcat str2 name1)))
      
      (princ str1)(princ ":")(princ str2)
      (if (/= str1 str2)
        (princ (strcat "\n@햼 " str1 " : " str2 " قȂ܂D")) 
        (progn
          (initget "Yes No")
          (if (not (setq kw (getkword "\nn_̋@햼\ɂ܂H[Yes /No] < Yes > ")))
            (setq kw "Yes")
          )
          (if (= kw "Yes")
            (progn		
              (ifs_func_attHide ename1 "NAME"	0)
              (ifs_func_attHide ename1 "NAME1" 0)
            )
          )
        )
			)
		)
	)
	(command "_UNDO" "END")
  (setvar "CMDECHO" 1)
	(princ)
)

;; Ԃ̌Ԃ𓾂
(defun c:sbSpc( / dimsc a p1 p2 sbstart sblst sbspr ok okold sbold i	senban ss )
	(setq dimsc (getvar "DIMSCALE"))
  (setq p1 '(0 0 0)
        p2 '(420.0 297.0 0.0)
        p2 (mapcar (function (lambda (a) (* a dimsc))) p2)
  )
  (if (= "" (setq sbstart (getString "\nԂԂ̊Jnl <101> ")))
		(setq sbstart "101")
	)
	(if (and sbstart (/= sbstart ""))
		(progn
			(setq sbstart (strcase sbstart) sbspr (ifs_sprNum3 sbstart))
			(if (setq ss (ssget "W" p1 p2 '((0 . "INSERT")(8 . "*")(2 . "*SENBAN*"))))
				(progn
					(setq i 0)
					(repeat (sslength ss)
						(if (setq senban (ifs_getAttValue (ssname ss i) "SENBAN"))
							(setq sblst (append sblst (list senban)))
            )
						(setq i (1+ i))
					)
				)
			)
		)
	)
	(if sblst
		(progn
			(setq sblst (ifs_sort sblst));; 
			(setq i 0 ok nil sbold "")
			(while (<= i 101)
				(setq 
					okold ok ok nil
					senban (strcat (car sbspr) (itoa (+ (atoi (cadr sbspr)) i)) (caddr sbspr))
				)
				(if (not (member senban sblst))
					(progn
						(setq ok T sbold senban)
						(if (not okold)
							(princ (strcat " < " senban " .."))
						)
					)
					(progn
						(setq ok nil)
						(if okold
							(princ (strcat " " sbold	" > "))
						)
					)
				)
				(setq i (1+ i))
			)
		)
	)
	(princ)
)

;; -----------------------
;; ύX
;; ꍇ nil Ԃ
(defun ifs_setAttValue(blkEname tagName tagValue / ename ent tag value res loop)
	(setq 
		ename blkename ent (entget ename)
		loop (and (= (cdr (assoc 0 ent)) "INSERT") (assoc 66 ent) (= 1 (cdr (assoc 66 ent))))
	)
	(while (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
		(setq ent (entget ename) tag (cdr (assoc 2 ent)) value (cdr (assoc 1 ent)))
	 	(if (= tagName tag)
			(progn
				(entmod (subst (cons 1 tagvalue)(assoc 1 ent) ent))
		 		(setq loop nil res T)
			)
		)
	)
	res
)

;; ǂݏo
;; ꍇ nil Ԃ
(defun ifs_getAttValue(blkEname tagName / ename ent tag value res loop)
	(setq 
		ename blkename ent (entget ename)
		loop (and 
					 (= (cdr (assoc 0 ent)) "INSERT") 
					 (assoc 66 ent) 
					 (= 1 (cdr (assoc 66 ent)))
				 )
	)
	(while (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
		(setq ent (entget ename) tag (cdr (assoc 2 ent)) value (cdr (assoc 1 ent)))
	 	(if (= tagName tag)
		 	(setq loop nil res value)
		)
	)
	res
)

;; ename ̃Xg _ kp Ɉԋ߂ ename 𓾂
(defun ifs_nearSbe(kp sbes / i idx pt dist dmin)
	(setq i 0)
	(repeat (length sbes)
		(setq 
			pt (cdr (assoc 10 (entget (nth i sbes))))
			dist (distance pt kp)
		)
		(if (= i 0)
			(setq dmin dist idx 0)
			(if (> dmin dist)
				(setq dmin dist idx i)
			)
		)
		(setq i (1+ i))
	)
	(nth idx sbes)
)

;; _ pt  |C̒_邩
(defun ifs_isLWPvertex (pt lwpEname / ent flag loop i cnt len n) 
  (setq ent  (entget lwpEname)
        loop T
        i    0
        cnt  0
        len  (length ent)
        n    (cdr (assoc 90 ent)) ;; 90:_̐
  )
  (while (and loop (< i len)) 
    (if (= 10 (car (nth i ent))) 
      (progn 
        (setq cnt (1+ cnt))
        (if (equal (list (car pt) (cadr pt)) (cdr (nth i ent)) 0.1) 
          (setq flag T loop nil)
        )
        (if loop 
          (setq loop (< cnt n))
        )
      )
    )
    (setq i (1+ i))
  )
  flag
)

;; ̒[_Ƀ|C̒_邩
(defun ifs_checkLwpVertex (lineename / ent p1 p2 pts1 pts2 flag ss dimsc fuz) 
  (setq dimsc (getvar "DIMSCALE")
        fuz   (* dimsc 0.1)
        ent   (entget lineename)
        p1    (cdr (assoc 10 ent))
        p2    (cdr (assoc 11 ent))
        pts1  (ifs_pointW p1 fuz)
        pts2  (ifs_pointW p2 fuz)
  )
  (if (setq ss (ssget "C" (car pts1) (cadr pts1) '((0 . "LWPOLYLINE")))) 
    (if (ifs_isLWPvertex p1 (ssname ss 0))
      (setq flag T)
    )
  )
  (if (and (not flag) (setq ss (ssget "C" (car pts2) (cadr pts2) '((0 . "LWPOLYLINE")))))
    (if (ifs_isLWPvertex p2 (ssname ss 0)) 
      (setq flag T)
    )
  )
  flag
)
;; ̒[_ɃA[XV{邩
(defun ifs_checkEmark (lineename emark / ent p1 p2 pts1 pts2 flag ss dimsc fuz i len) 
  (setq dimsc (getvar "DIMSCALE")
        fuz   (* dimsc 0.1)
        ent   (entget lineename)
        p1    (cdr (assoc 10 ent))
        p2    (cdr (assoc 11 ent))
        pts1  (ifs_pointW p1 fuz)
        pts2  (ifs_pointW p2 fuz)
  )
  ;;(princ emark)
  (if (setq ss (ssget "C" (car pts1) (cadr pts1) '((0 . "INSERT")))) 
    (if (> (setq  len (sslength ss)))
      (progn
        ;;(princ "\nlen=")(princ len)
        (setq i 0 )
        (while (and (not flag)(< i len))
          ;;(princ "\nname1=")
          ;;(princ (cdr (assoc 2 (entget (ssname ss i)))))
          (setq flag (wcmatch (cdr (assoc 2 (entget (ssname ss i)))) emark))
          (setq i (1+ i))
        )
      )
    )
  )
  (if (and (not flag) (setq ss (ssget "C" (car pts2) (cadr pts2) '((0 . "INSERT")))))
    (if (> (setq  len (sslength ss)))
      (progn
        ;;(princ "\nlen=")(princ len)
        (setq i 0 )
        (while (and (not flag)(< i len))
          ;;(princ "\nname2=")
          ;;(princ (cdr (assoc 2 (entget (ssname ss i)))))
          (setq flag (wcmatch (cdr (assoc 2 (entget (ssname ss i)))) emark))
          (setq i (1+ i))
        )
      )
    )
  )
  ;;(princ "\nflag=")(princ flag)
  flag
)
;; XgɁA|C̒_邩
(defun ifs_inLwpVertex (lines / i ret)
  (setq i 0)
  (while (and (not ret) (< i (length lines))) 
    (setq ret (ifs_checkLwpVertex (nth i lines)))
    (setq i (1+ i))
  )
  ret
)
;; XgɁAA[XV{ɂȂ邩
(defun ifs_inEmark (lines emark / i ret) 
  (if (and emark (/= emark ""))
    (progn
      (setq i 0)
      (while (and (not ret) (< i (length lines))) 
        (setq ret (ifs_checkEmark (nth i lines) emark))
        (setq i (1+ i))
      )
    )
  )
  ;;(princ ret)
  ret
)

;; I/O Rg̉WύX
(defun c:cmtTw( / esel ename pick loop tag p0 p1 p2 pickEnt ent pts w wf
               main mes mode )
  (setq mode "start" main t)
	(setvar "CMDECHO" 0)
	(while main
    (cond 
      ((= mode "start")
        (setq mes "\W擾AύXRgI < I > : "))
      ((= mode "copy")
        (setq mes (strcat "\nW " (rtos wf) " ɕύXRgI < W擾ɖ߂ > : ")))
    )
    (if (setq esel (entsel mes))
      (progn
        (setq 
          pickEnt nil
          ename (car esel) pick (cadr esel) ent (entget ename) w wf
          loop (and (= (cdr (assoc 0 ent)) "INSERT") (assoc 66 ent) (= 1 (cdr (assoc 66 ent))))
        )
        (while (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
          (setq 
            ent (entget ename) 
            tag (cdr (assoc 2 ent));; value (cdr (assoc 1 ent))
            p0  (cdr (assoc 10 ent))
          )
          (if (= mode "start")
            (setq wf (cdr (assoc 41 ent)));; Width Factor
          )
          (if (wcmatch tag "JCMNT1,JCMNT2")
            (if (/= "" (cdr (assoc 1 ent)))
              (progn
                (setq 
                  pts (textBox ent)
                  p1	(mapcar '+ p0 (car pts))
                  p2	(mapcar '+ p0 (cadr pts))
                )
                (if (ifs_inArea pick p1 p2)
                  (setq loop nil pickEnt ent)
                )
              )
            )
          )
        )
        (if pickEnt
          (if (= mode "start")
            (progn
              (if (setq w (getreal (strcat "\nVW : < " (rtos wf) " > : ")))
                (setq wf w)
              )
              (entmod (subst (cons 41 wf)(assoc 41 pickEnt) pickEnt))
              (command "regen")
              (setq mode "copy")
            )
            (progn
              (entmod (subst (cons 41 wf)(assoc 41 pickEnt) pickEnt))
              (command "regen")
            )
          )
        )
      )
      (cond 
        ((= mode "start")(setq main nil))
        ((= mode "copy")(setq mode "start"))
      )
    )
  )
	(setvar "CMDECHO" 1)
	(princ)
)
;; I/O Rg̕ύX
(defun c:cmtTH( / esel ename pick loop tag p0 p1 p2 pickEnt ent pts w wf
               main mes mode )
  (setq mode "start" main t)
	(setvar "CMDECHO" 0)
	(while main
    (cond 
      ((= mode "start")
        (setq mes "\擾AύXRgI < I > : "))
      ((= mode "copy")
        (setq mes (strcat "\n " (rtos wf) " ɕύXRgI < 擾ɖ߂ > : ")))
    )
    (if (setq esel (entsel mes))
      (progn
        (setq 
          pickEnt nil
          ename (car esel) pick (cadr esel) ent (entget ename) w wf
          loop (and (= (cdr (assoc 0 ent)) "INSERT") (assoc 66 ent) (= 1 (cdr (assoc 66 ent))))
        )
        (while (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
          (setq 
            ent (entget ename) 
            tag (cdr (assoc 2 ent));; value (cdr (assoc 1 ent))
            p0  (cdr (assoc 10 ent))
          )
          (if (= mode "start")
            (setq wf (cdr (assoc 40 ent)));; 
          )
          (if (wcmatch tag "JCMNT1,JCMNT2")
            (if (/= "" (cdr (assoc 1 ent)))
              (progn
                (setq 
                  pts (textBox ent)
                  p1	(mapcar '+ p0 (car pts))
                  p2	(mapcar '+ p0 (cadr pts))
                )
                (if (ifs_inArea pick p1 p2)
                  (setq loop nil pickEnt ent)
                )
              )
            )
          )
        )
        (if pickEnt
          (if (= mode "start")
            (progn
              (if (setq w (getreal (strcat "\nV : < " (rtos wf) " > : ")))
                (setq wf w)
              )
              (entmod (subst (cons 40 wf)(assoc 40 pickEnt) pickEnt))
              (command "regen")
              (setq mode "copy")
            )
            (progn
              (entmod (subst (cons 40 wf)(assoc 40 pickEnt) pickEnt))
              (command "regen")
            )
          )
        )
      )
      (cond 
        ((= mode "start")(setq main nil))
        ((= mode "copy")(setq mode "start"))
      )
    )
  )
	(setvar "CMDECHO" 1)
	(princ)
)
;; I/O Rg̕ύX
(defun c:cmtTHAll( / esel ename pick loop tag p0 p1 p2 pickEnt ent pts h th
               i kw ss)
  ;;(setq mode "start" main t)
	(setvar "CMDECHO" 0)
  
  (if (setq esel (entsel "\擾AύXRgI  : "))
    (setq 
      ename (car esel) pick (cadr esel) ent (entget ename)
      loop (and (= (cdr (assoc 0 ent)) "INSERT") (assoc 66 ent) (= 1 (cdr (assoc 66 ent))))
    )
  )
  (while (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
    (setq 
      ent (entget ename) 
      tag (cdr (assoc 2 ent));; value (cdr (assoc 1 ent))
      p0  (cdr (assoc 10 ent))
      th (cdr (assoc 40 ent));; 
    )
    (if (wcmatch tag "JCMNT1,JCMNT2")
      (if (/= "" (cdr (assoc 1 ent)))
        (progn
          (setq 
            pts (textBox ent)
            p1	(mapcar '+ p0 (car pts))
            p2	(mapcar '+ p0 (cadr pts))
          )
          (if (ifs_inArea pick p1 p2)
            (setq loop nil pickEnt ent)
          )
        )
      )
    )
  )
  (if pickEnt
    (progn
      (if (setq h (getreal (strcat "\nV : < " (rtos th) " > : ")))
        (setq th h)
      )
      (entmod (subst (cons 40 th)(assoc 40 pickEnt) pickEnt))
      (command "regen")
      
 
    )
  )
  (if pickEnt
    (progn
      (initget "Yes No")
      (if (/= kw "No" (setq kw (getkword "\nׂẴRg̕ύX܂H [Yes/No] < Yes > : ")))
        (if (setq ss (ssget "X" '((0 . "INSERT")(2 . "IO-DEFOUT*,IO-DEFIN*"))))
          (progn
            (princ (sslength ss))
            (setq i 0)
            (repeat (sslength ss)
              (setq ename (ssname ss i) loop T)
              (while (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
                (setq 
                  ent (entget ename) 
                  tag (cdr (assoc 2 ent));; value (cdr (assoc 1 ent))
                )
                (if (wcmatch tag "JCMNT1,JCMNT2")
                  (progn
                    (entmod (subst (cons 40 th)(assoc 40 ent) ent))
                  )
                )
              )
              (setq i (1+ i))
            )
          )
        )
      )
      (command "regen")
    ) 
  )
	(setvar "CMDECHO" 1)
	(princ)
)

;; _`͈͓ɂ邩
(defun ifs_inArea(pt minPt maxPt)
	(and 
    (>= (car pt)(car minPt))(<= (car pt)(car maxPt))
		(>= (cadr pt)(cadr minPt))(<= (cadr pt)(cadr maxPt))
  )
)

;; eLXg͂`4_擾
;; _獶
(defun ifs_textBox2 ( textent / ang sinrot cosrot t1 t2 p0 p1 p2 p3 p4)
	(setq p0 (cdr (assoc 10 textent))
				ang (cdr (assoc 50 textent))
				sinrot (sin ang)
				cosrot (cos ang)
				t1 (car (textbox textent))
				t2 (cadr (textbox textent))
				p1 (list
							 (+ (car p0)
								 (- (* (car t1) cosrot)(* (cadr t1) sinrot))
							 )
							 (+ (cadr p0)
								 (+ (* (car t1) sinrot)(* (cadr t1) cosrot))
							 )
						 )
				p2 (list
							 (+ (car p0)
								 (- (* (car t2) cosrot)(* (cadr t1) sinrot))
							 )
							 (+ (cadr p0)
								 (+ (* (car t2) sinrot)(* (cadr t1) cosrot))
							 )
						 )
				p3 (list
							 (+ (car p0)
								 (- (* (car t2) cosrot)(* (cadr t2) sinrot))
							 )
							 (+ (cadr p0)
								 (+ (* (car t2) sinrot)(* (cadr t2) cosrot))
							 )
						 )
				p4 (list
							 (+ (car p0)
								 (- (* (car t1) cosrot)(* (cadr t2) sinrot))
							 )
							 (+ (cadr p0)
								 (+ (* (car t1) sinrot)(* (cadr t2) cosrot))
							 )
						 )
	)
	;; _獶
	(list p1 p2 p3 p4)
)

;; wpx(deg)Ɉԋ߂px(rad)𓾂
;; gp
(defun ifs_nearStepAng(rad degStep / n step ang m pi2)
	(setq
		pi2 (* pi 2.0)
		n (fix (/ 180 degstep))
		step (/ pi n)
		ang (+ rad pi2)
		m (fix (/ ang step))
	)
	(if (> (- ang (* m step))(/ step 2.0))
		(setq m (1+ m))
	)
	(if (>= m (* n 2))
		(setq m (- m (* n 2)))
	)
	(setq ang (* m step))
	(while (> ang pi2)
		(setq ang (- ang pi2))
	)
	ang
)

;; ԃ`FbN
; (defun c:sbNon (/ ss i j lst lines ename sschk sbes nonlst ovrlst noncnt dbllst 
;                 sblineslst dbltemp len strtemp ovrtemp temp e1 e2 flag item kw sbtemp 
;                 senban senbans senbans1 p1 p2 dimsc a
;                ) 

;   (setq dimsc (getvar "DIMSCALE"))
;   (setq p1 '(0 0 0)
;         p2 '(420.0 297.0 0.0)
;         p2 (mapcar (function (lambda (a) (* a dimsc))) p2)
;   )
;   (setq i 0)
;   ;; 2023/03/01 ͈͂Œ
;   (command "_ZOOM" "none" p1 "none" p2) ;; bricscad
;   (if (setq ss (ssget "C" p1 p2 '((0 . "LINE") (8 . "*WIRE*") (6 . "BYLAYER")))) 
;     (progn 
;       ;; ڑĂO[v
;       (setq sschk (ssadd)) ;; `FbNς line-ename ێ
;       (repeat (sslength ss) 
;         (setq ename (ssname ss i))
;         (if (not (ssmemb ename sschk)) 
;           (if (setq lst (ifs_get_line_all ename)) 
;             (progn 
;               (foreach item lst 
;                 (setq sschk (ssadd item sschk))
;               )
;               (setq lines (append lines (list lst)))
;             )
;           )
;         )
;         (setq i (1+ i))
;       )
;     )
;   )

;   (if lines 
;     (progn 
;       (setq i      0
;             noncnt 0
;       )
;       (repeat (length lines) 
;         (setq sbes (ifs_get_senbanEnames (car (nth i lines))))
;         (if (not sbes)  ;; Ԃ
;           (setq nonlst (append nonlst (nth i lines))
;                 noncnt (1+ noncnt)
;           )
;           (progn  ;; dԃ`FbN
;                  (setq senbans ",")
;                  (foreach item sbes 
;                    (setq senban (ifs_getSenban item))
;                    (if 
;                      (and (/= senban "") 
;                           (not (vl-string-search (strcat "," senban ",") senbans))
;                      )
;                      (setq senbans (strcat senbans senban ","))
;                    )
;                  )
;                  (setq senbans (vl-string-trim "," senbans))
;                  (if (> (vl-string-search "," senbans) 0) 
;                    (setq ovrtemp (append ovrtemp (list senbans))
;                          ovrlst  (append ovrlst (nth i lines))
;                    )
;                  )
;                  ;; zO[vƂ̐Ԃ Lines-ename ێ
;                  (if (/= senbans "") 
;                    (setq sblineslst (append sblineslst 
;                                             (list (list senbans (nth i lines)))
;                                     )
;                    )
;                  )
;           )
;         )
;         (setq i (1+ i))
;       )
;       ;; ʕ\
;       (princ "\nd = ")
;       (if (not ovrtemp) 
;         (princ "Ȃ")
;         (foreach item ovrtemp 
;           (princ (strcat item " "))
;         )
;       )
;       (princ "  ԂȂ = ")
;       (princ noncnt)
;     )
;   )
;   (if (and sblineslst (> (setq len (length sblineslst)) 1)) 
;     (progn  ;;̔zƐԂdĂ
;            ;; dԂoă\[gȂ
;            (setq temp nil)
;            (foreach item sblineslst 
;              (setq senbans (car item)
;                    lines   (cadr item)t
;              )
;              (if (not (vl-string-search "," senbans)) 
;                (setq temp (append temp (list (list senbans lines))))
;                (progn 
;                  (setq lst (ifs_strSplit senbans ","))
;                  (foreach senban lst 
;                    (setq temp (append temp (list (list senban lines))))
;                  )
;                )
;              )
;            )
;            (setq sblineslst temp
;                  temp       nil
;            )
;            ;; ԏŃ\[g
;            (setq sblineslst (vl-sort sblineslst 
;                                      (function 
;                                        (lambda (e1 e2) (< (car e1) (car e2)))
;                                      )
;                             )
;            )
;            ;;(princ sblineslst)
;            ;; ̐O[vƐԂdĂ
;            (setq i    0
;                  flag nil
;            )
;            (repeat (1- len) 
;              (setq senbans (car (nth i sblineslst)))
;              (setq j (1+ i))
;              (setq senbans1 (car (nth j sblineslst)))
;              (if (/= senbans senbans1) 
;                (progn 
;                  (if flag 
;                    (progn 
;                      (if (not (ifs_inLwpVertex dblTemp)) 
;                        (setq dbllst (append dbllst dbltemp))
;                      )
;                      (setq flag    nil
;                            dbltemp nil
;                      )
;                    )
;                  )
;                )
;                (progn 
;                  (setq flag    T
;                        dbltemp (append dbltemp (cadr (nth i sblineslst)))
;                  )
;                  (if (not (member (car (cadr (nth j sblineslst))) dbltemp)) 
;                    (setq dbltemp (append dbltemp (cadr (nth j sblineslst))))
;                  )
;                )
;              )
;              (setq i (1+ i))
;            )
;            (if (and flag dbltemp) 
;              (progn 
;                (if (not (ifs_inLwpVertex dblTemp)) 
;                  (progn 
;                    (setq dbllst (append dbllst dbltemp))
;                  )
;                )
;                (setq flag    nil
;                      dbltemp nil
;                )
;              )
;            )
;            (if strtemp 
;              (foreach item strtemp 
;                (princ (strcat item " "))
;              )
;            )
;            ;; dԂƂ̏d`FbNĂȂ
;            (princ "  d = ")
;            (if (not dbllst) 
;              (princ "Ȃ")
;              (progn 
;                ;; Ԃ蒼
;                (setq sbtemp nil)
;                (foreach ename dbllst 
;                  (if (setq sbes (ifs_get_senbanEnames ename)) 
;                    (foreach item sbes 
;                      (if (setq senban (ifs_getSenban item)) 
;                        (if (not (member senban sbtemp)) 
;                          (setq sbtemp (append sbtemp (list senban)))
;                        )
;                      )
;                    )
;                  )
;                )
;                ;; ʕ\
;                ;;(princ sbtemp)
;                (if sbtemp 
;                  (foreach item sbtemp 
;                    (princ (strcat item " "))
;                  )
;                )
;              )
;            )
;     )
;   )
;   (if (or ovrlst nonlst dbllst) 
;     (progn 
;       (if nonlst 
;         (foreach ename nonlst 
;           (ifs_nsq_set_color ename 1)
;         )
;       )
;       (if ovrlst 
;         (foreach ename ovrlst 
;           (ifs_nsq_set_color ename 6)
;         )
;       )
;       (if dbllst 
;         (foreach ename dbllst 
;           (ifs_nsq_set_color ename 11)
;         )
;       )
;       (initget "Yes No")
;       (setq kw (getkword "\nF\ BYLAYER ɖ߂܂ [Yes /No] < Yes > : "))
;       (if (/= kw "No") 
;         (progn 
;           (if nonlst 
;             (foreach ename nonlst 
;               (ifs_nsq_set_color ename 256)
;             )
;           )
;           (if ovrlst 
;             (foreach ename ovrlst 
;               (ifs_nsq_set_color ename 256)
;             )
;           )
;           (if dbllst 
;             (foreach ename dbllst 
;               (ifs_nsq_set_color ename 256)
;             )
;           )
;         )
;       )
;     )
;   )
;   (princ)
; )

;; ubNAz𕽍sړiPƔŁj
(defun c:trnS (/ my_error orth p1 p2 cmdecho pts base dimsc ename ent esel name
              maxpt minpt loop)
  ;; STRETCH R}h C IvV
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "ORTHOMODE" orth)
    (setvar "CMDECHO" cmdecho)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error
        orth    (getvar "ORTHOMODE")
        cmdecho (getvar "CMDECHO")
  )
  (setq dimsc (getvar "DIMSCALE"))
  (setvar "ORTHOMODE" 1)
  (setvar "CMDECHO" 1)
  
  (setq loop T)
  (while loop
    (initget "Exit eXit")
    (setq esel (entsel "\nsړubNAPI [E,X:I] : ")) 
    (if (or (= esel "Exit")(= esel "eXit"))
      (setq loop nil)
    )
    (if (and loop esel)
      (progn
        (setq minpt nil maxpt nil base nil)
        (setq ename (car esel) ent (entget ename) name (cdr (assoc 0 ent)))
        (cond
          ((= name "INSERT")
            (setq pts (ifs_getBoundingBox ename)
                  pts (ifs_lineW (car pts) (cadr pts) (* 0.1 dimsc))
                  minpt (car pts)
                  maxpt (cadr pts)
                  base (cdr (assoc 10 ent)) 
            ))
          ((= name "LINE")
            (setq p1 (cdr (assoc 10 ent))
                  p2 (cdr (assoc 11 ent))
                  pts (ifs_lineW p1 p2 (* 0.65 dimsc))
                  minpt (car pts)
                  maxpt (cadr pts)
                  base (osnap (cadr esel) "near") 
            ))
        )  
        (if (and minpt maxpt base)
          (if (> (distance minpt maxpt) (* 2.8285 dimsc))
            (progn
              (command "_UNDO" "BE")
              (command "_STRETCH" "C" "none" minpt "none" maxpt "" base pause)
              (command "_UNDO" "END")
            )
          )
        )
      )
    )
  )
  (setvar "ORTHOMODE" orth)
  (setvar "CMDECHO" cmdecho)
  (setq *error* nil)
  (princ)
)

;; `͈͂𕽍sړ
(defun c:trnW (/ my_error orth p1 p2 cmdecho loop)
  ;; STRETCH R}h C IvV
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "ORTHOMODE" orth)
    (setvar "CMDECHO" cmdecho)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error
        orth    (getvar "ORTHOMODE")
        cmdecho (getvar "CMDECHO")
  )
  (setvar "ORTHOMODE" 1)
  (setvar "CMDECHO" 1)
  
  (setq loop T)
  (while loop
    (setq p1 nil p2 nil)
    (initget "Exit eXit")
    (setq p1 (getpoint "\nsړ`R[i[̂P_ڂw [E,X:I]: ")) 
    (if (or (= p1 "Exit")(= p1 "eXit"))
      (setq loop nil)
    )
    (if (and p1 (listp p1))
      (setq p2 (getcorner p1 "\nQ_ڂw : "))
    ) 
    (if (and p1 p2)
      (progn 
        (command "_UNDO" "BE")
        (command "_STRETCH" "C" "none" p1 "none" p2 "" pause pause)
        (command "_UNDO" "END")
      )
    )
  )
  (setvar "ORTHOMODE" orth)
  (setvar "CMDECHO" cmdecho)
  (setq *error* nil)
  (princ)
)

;; ǂݏoAύX
;; value = nil : ǂݏô
;; ߂l nil = tagName Ȃ
(defun ifs_attval (entName tagName value / loop ent ename tag val res) 
  (setq ename entName
        ent   (entget ename)
        loop  (and (= (cdr (assoc 0 ent)) "INSERT") 
                   (assoc 66 ent)
                   (= 1 (cdr (assoc 66 ent)))
              )
  )
  (while 
    (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
    (setq ent (entget ename)
          tag (cdr (assoc 2 ent))
          val (cdr (assoc 1 ent))
    )
    (if (= tagName tag) 
      (progn 
        ;; lύX
        (if value 
          (entmod (subst (cons 1 value) (assoc 1 ent) ent))
        )
        (setq res  val
              loop nil
        )
      )
    )
  )
  res
)

;; ǂݏoAύX(2)
;;  value = nil : ǂݏô
;; ex : (setq lst (ifs_attval2 ename "NAME" "NAME1" nil nil))
;;  value =  : XV
;; ex : (ifs_attval2 ename "NAME" "NAME1" "TEST" "")
;; ߂l nil = tagName Ȃ
(defun ifs_attval2 (entName tagName1 tagName2 value1 value2 / loop ent ename tag val 
                    res1 res2 cnt
                   ) 
  (setq ename entName
        ent   (entget ename)
        loop  (and 
                (= (cdr (assoc 0 ent)) "INSERT")
                (assoc 66 ent)
                (= 1 (cdr (assoc 66 ent)))
              )
  )
  (setq cnt 0)
  (while 
    (and loop (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename)))))))
    (setq ent (entget ename)
          tag (cdr (assoc 2 ent))
          val (cdr (assoc 1 ent))
    )
    (if (= tagName1 tag) 
      (progn  ;; lύX
        (if value1 
          (entmod (subst (cons 1 value1) (assoc 1 ent) ent))
        )
        (setq res1 val
              cnt  (1+ cnt)
        )
      )
      (if (= tagName2 tag) 
        (progn  ;; lύX
          (if value2 (entmod (subst (cons 1 value2) (assoc 1 ent) ent)))
          (setq res2 val cnt  (1+ cnt))
        )
      )
    )
    (setq loop (< cnt 2))
  )
  (list res1 res2)
)


;; @햼XV
(defun ifs_func_edit_bname (ename layerCheck / txt0 txt1 res ret stra strb ent) 
  (if layerCheck 
    (if (setq ent (tblsearch "LAYER" "NAME")) 
      (if (/= (cdr (assoc 70 ent)) 0) 
        (command "_-LAYER" "T" "NAME" "U" "NAME" "")
      )
    )
  )
  (setq res  (ifs_attval2 ename "NAME" "NAME1" nil nil)
        txt0 (car res)
        txt1 (cadr res)
        ret  (or txt0 txt1)
  )
  (if (and txt0 (not txt1)) 
    (progn 
      (setq stra (getstring (strcat "\nV@햼 (= . ) < " txt0 " > : ")))
      (cond 
        ((= stra ".")
          (ifs_setAttvalue ename "NAME" ""))
        ((/= stra "") 
          (ifs_setAttvalue ename "NAME" (strcase stra)))
      )
    )
  )
  (if (and txt0 txt1) 
    (progn 
      (setq stra (getstring (strcat "\nV@햼 1 sڂ (= . ) < " txt0 " > : ")))
      (cond 
        ((= stra ".") 
          (ifs_setAttvalue ename "NAME" ""))
        ((/= stra "") 
          (ifs_setAttvalue ename "NAME" (strcase stra)))
      )
      (setq strb (getstring (strcat "\n@햼 2 sڂ (= . ) < " txt1 " > : ")))
      (cond 
        ((= strb ".") 
          (ifs_setAttvalue ename "NAME1" ""))
        ((/= strb "") 
          (ifs_setAttvalue ename "NAME1" (strcase strb)))
      )
    )
  )
  ;; @햼
  ret
)

(defun c:zoomL () 
  (setvar "CMDECHO" 0)
  (command "ZOOM" (getvar "LIMMIN") (getvar "LIMMAX"))
  (setvar "CMDECHO" 1)
  (princ)
)

;; z쐬iŁj
(defun c:bLn( / loop res mode p1 dist clayer orthoOrg snapOrg snapUnitOrg sunit distdef
             ss dimsc pts distmin ename i len)
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    ;;(command "_UNDO" 1)
    (setvar "ORTHOMODE" orthoOrg)
    (setvar "SNAPMODE" snapOrg)
    (setvar "SNAPUNIT" snapUnitOrg)
    (setvar "CLAYER" clayer)
    (setvar "CMDECHO" 1)

    (setq *error* nil)
  )
  (setq *error* my_error)
  (setq orthoOrg    (getvar "ORTHOMODE")
        snapOrg     (getvar "SNAPMODE")
        snapUnitOrg (getvar "SNAPUNIT")
        orthoOrg    (getvar "ORTHOMODE")
        clayer      (getvar "CLAYER")
  )
  (setvar "ORTHOMODE" 1)
  (setvar "SNAPMODE" 1)
  (setvar "CMDECHO" 0)
  (setq dimsc (getvar "DIMSCALE"))
  (setq sunit (* 1.25 dimsc))
  (setvar "SNAPUNIT" (list sunit sunit))
  (ifs_make_layer "WIRE" 3 nil)  
  (setvar "CLAYER" "WIRE")

  (setq loop T  mode "L" distdef 5.0)
  (while loop
    (setq p1 nil dist nil)
    (initget "L 3 2 N C M Exit eXit F K")
    (cond 
      ((= mode "L")
        (setq res (getpoint "\nPƂP{쐬̎n_w [N:{ /3:O /2:P /C:폜 /F:tFX폜 /M:ړ /K:_}[N] /E,X:I] : ")))
      ((= mode "N")
        (setq res (getpoint "\nPƂ{쐬̎n_w [L:P{ /3:O /2:P /C:폜 /F:tFX폜 /M:ړ /K:_}[N] /E,X:I] : ")))
      ((= mode "3")
        (setq res (getreal (strcat "\nOz̊Ԋu < " (rtos distdef) " > : "))))
      ((= mode "2")
        (setq res (getreal (strcat "\nPz̊Ԋu < " (rtos distdef) " > : "))))
      ((= mode "C")
        (setq res (getpoint "\n폜ẑP_w [L:P{ /N:{ /3:O /2:P /F:tFX폜 /M:ړ /K:_}[N] /E,X:I] : ")))
      ((= mode "K")
        (setq res (getpoint "\n_}[N𔽓]_w [L:P{ /N:{ /3:O /2:P /C:폜 /F:tFX폜 /M:ړ /E.X:I] : ")))
      ((= mode "F")
        (setq res (getpoint "\n폜ItFX̂P_ڂw [L:P{ /N:{ /3:O /2:P /C:폜 /M:ړ /K_}[N] /E,X:I] : ")))
      ((= mode "M")
        (setq res (getpoint "\nړ܂̓ubNATEXTPI [L:P{ /N:{ /3:O /2:P /C:폜 /F:tFX폜 /M:ړ /K_}[N] /E,X:I] : ")))
    )
    (cond 
      ((and res (listp res)) 
        (setq p1 res))
      ((and res (wcmatch res "L,3,2,N,C,M,F,K"))
        (setq mode res))
      ((and res (= (strcase res) "EXIT"))
        (setq loop nil mode res))
      ((and res (numberp res) (or (= mode "3")(= mode "2")))
        (setq dist res distdef res))
      ((and (not res)(or (= mode "3")(= mode "2")))
        (setq dist distdef))
    )
    (cond
      ((and p1   (= mode "L"))
        (ifs_do_blineS p1))
      ((and p1   (= mode "N"))
        (ifs_do_blineN p1))
      ((and dist (= mode "3"))
        (progn
          (ifs_do_sq3w 3 dist)
          (setq mode "L")
        )
      )
      ((and dist (= mode "2"))
        (progn
          (ifs_do_sq3w 2 dist)
          (setq mode "L")
        )
      )
      ((and p1 (listp p1) (= mode "C"))
        (ifs_do_lcutC p1))
      ((and p1 (listp p1) (= mode "F"))
        (ifs_do_lcutF p1))
      ((and p1 (listp p1) (= mode "K"))
        (ifs_do_cmark p1)) 
      ((and p1 (listp p1) (= mode "M"))
        (progn 
          ;; (setq ss (ssget ":E" p1)) ;; IJCAD ł̓G[ɂȂ
          (if (and (setq ss (ssget p1))(= (sslength ss) 1));;sbN{bNXɂ
            (ifs_do_bmvS (ssname ss 0) p1)
            (progn 
              (setq pts (ifs_pointW p1 (* 7.5 dimsc)))
              (if (and (setq ss (ssget "C" (car pts)(cadr pts) '((0 . "INSERT") (-4 . "<NOT")(2 . "*KOUTEN*,*CMARK*")(-4 . "NOT>"))))(>= (setq len (sslength ss)) 1))
                (progn
                  (princ len)
                  (if (> len 1)
                    (progn
                      (setq distmin (* 100 dimsc) i 0)
                      (repeat len
                        (setq dist (distance p1 (cdr (assoc 10 (entget (ssname ss i))))))
                        (if (< dist distmin)
                          (setq distmin dist ename (ssname ss i))
                        )
                        (setq i (1+ i))
                      )
                    )
                    (progn
                      (setq ename (ssname ss 0))
                    )  
                  )
                  (ifs_do_bmvS ename p1)
                )
              )
            )
          )
        )
      )
    )
  )
  (setvar "ORTHOMODE" orthoOrg)
  (setvar "SNAPMODE" snapOrg)
  (setvar "SNAPUNIT" snapUnitOrg)
  (setvar "CLAYER" clayer)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; z쐬
;; ifs_do_blineS/N Ă΂
(defun ifs_sub_bline (p1 p2 kpFlag / ss i loop2 ename ent lay col typ kp cmark1 
                      cmark2 pts fuz dimsc blkname 
                     ) 
  (setq dimsc (getvar "DIMSCALE")
        fuz   (* 0.5 dimsc)
  )
  ;;_}[N`FbN
  (setq pts (ifs_pointW p1 fuz))
  (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "INSERT") (2 . "*KOUTEN*,*CMARK*"))))
    (setq cmark1 T)
  )
  (setq pts (ifs_pointW p2 fuz))
  (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "INSERT") (2 . "*KOUTEN*,*CMARK*"))))
    (setq cmark2 T)
  )

  ;;̐ɍ킹
  (setq pts (ifs_pointW p1 (* 0.1 dimsc)))
  (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE"))))
    (if (> (sslength ss) 0) 
      (progn 
        (setq i     0
              loop2 T
        )
        (while (and loop2 (< i (sslength ss))) 
          (setq ename (ssname ss i)
                ent   (entget ename)
          )
          (if (ifs_is_douitu p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent))) 
            (setq lay (cdr (assoc 8 ent))
                  col (cdr (assoc 62 ent))
                  typ (cdr (assoc 6 ent))
            )
          )
          (setq i (1+ i))
        )
      )
    )
  )
  (setq pts (ifs_pointW p2 (* 0.1 dimsc)))
  (if (not lay) 
    (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE"))))
      (if (> (sslength ss) 0) 
        (progn 
          (setq i     0
                loop2 T
          )
          (while (and loop2 (< i (sslength ss))) 
            (setq ename (ssname ss i)
                  ent   (entget ename)
            )
            (if (ifs_is_douitu p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent))) 
              (setq lay (cdr (assoc 8 ent))
                    col (cdr (assoc 62 ent))
                    typ (cdr (assoc 6 ent))
              )
            )
            (setq i (1+ i))
          )
        )
      )
    )
  )
  (if (not lay) 
    (setq lay (getvar "CLAYER"))
  )
  (if (not col) 
    (setq col 256) ;;BYLAYER
  )
  (if (not typ) 
    (setq typ "ByLayer")
  )
  ;;쐬
  (entmake 
    (list '(0 . "LINE") 
          (cons 8 lay)
          (cons 62 col)
          (cons 6 typ)
          (cons 10 p1)
          (cons 11 p2)
    )
  )
  ;;
  (setq pts (ifs_lineCP p1 p2 (* 0.1 dimsc)))
  (if (setq ss (ssget "CP" pts '((0 . "LINE"))))
    (if (> (sslength ss) 0) 
      (ifs_lineJoint ss nil nil nil)
    )
  )
  ;;ubNg
  (if (setq ss (ssget "F" 
                    (list p1 p2)
                    '((0 . "INSERT")
                      (-4 . "<NOT")
                      (2 . "*KOUTEN*,*CMARK*")
                      (-4 . "NOT>")
                     )
             )
    )
    (if (> (sslength ss) 0) 
      (progn 
        (setq i 0)
        (repeat (sslength ss) 
          (ifs_sub_btrimvx (ssname ss i))
          (setq i (1+ i))
        )
      )
    )
  )
  (if (and kpflag (setq ss (ssget "CP" pts '((0 . "LINE")))))
    (if (> (sslength ss) 0) 
      (progn 
        (if (tblobjname "BLOCK" "CMARK")
          (setq blkname "CMARK")
          (setq blkname "CMARK00")
        )
        
        
        (setq i 0)
        (repeat (sslength ss) 
          (setq ename (ssname ss i)
                ent   (entget ename)
          )
          (if (setq kp (inters p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))) 
            (progn
              ;; n_AI_Ɍ_}[N΂̂܂܂ɂĂ
              (if (and (not (and cmark1 (equal p1 kp (* 0.001 dimsc)))) 
                       (not (and cmark2 (equal p2 kp (* 0.001 dimsc))))
                ) 
                (progn
                  (ifs_kouten_handan kp blkname)
                )
              )
            )
          )
          (setq i (1+ i))
        )
      )
    )
  )
)


;; P{̐쐬
(defun ifs_do_blineS (p1 / p2)
  (if (and p1 (setq p2 (getpoint p1 "\nI_w  < n_ > : ")))
    (progn
      ;; Aɂ
      (if (ifs_isTate p1 p2)
        (setq p2 (list (car p1)(cadr p2)(caddr p1)))
        (setq p2 (list (car p2)(cadr p1)(caddr p1)))
      )
      (command "_UNDO" "BE")
      (ifs_sub_bline p1 p2 T)
      (command "_UNDO" "END")
    )
  )
)

;; n{̐쐬
(defun ifs_do_blineN (p1 / p2 dist i n tateFlag)
  (if (and p1 (setq p2 (getpoint p1 "\nI_w  < n_ > : ")))
    (progn
      ;; Aɂ
      (if (ifs_isTate p1 p2)
        (setq p2 (list (car p1)(cadr p2)(caddr p1)))
        (setq p2 (list (car p2)(cadr p1)(caddr p1)))
      )
      (command "_UNDO" "BE")
      (setq tateFlag (ifs_isTate p1 p2) i 0)
      (if (not (setq dist (getdist "\n쐬ԊúA܂ 2 _w < 10.0 > : "))) 
        (setq dist 10.0)
      )
      (setq dist (* dist (getvar "DIMSCALE"))) 
      (if (not (setq n (getint "\nJԂ񐔂 < 16 > : "))) 
        (setq n 16) 
      )
      (repeat n 
        (ifs_sub_bline p1 p2 T)
        (if tateFlag 
          (setq p1 (list (+ (car p1) dist) (cadr p1) 0.0)
                p2 (list (+ (car p2) dist) (cadr p2) 0.0)
          )
          (setq p1 (list (car p1) (- (cadr p1) dist) 0.0)
                p2 (list (car p2) (- (cadr p2) dist) 0.0)
          )
        )
        (setq i (1+ i))
      )
      (command "_UNDO" "END")
    )
  )
)

;; _V{𔽓]
(defun ifs_do_cmark (pt / dimsc pts ss i flag blkname)
  (if (tblobjname "BLOCK" "CMARK")
    (setq blkname "CMARK")
    (setq blkname "CMARK00")
  )  
  (setq pts (ifs_pointW pt (* 0.625 (setq dimsc (getvar "DIMSCALE")))))
  (if (setq ss (ssget "C" (car pts) (cadr pts)'((0 . "INSERT"))))
    (if (> (sslength ss) 0) 
      (progn 
        (setq i 0)
        (repeat (sslength ss) 
          (entdel (ssname ss i))
          (setq i (1+ i))
        )
      )
      (setq flag T)
    )
    (setq flag T)
  )
  ;; Ƃ͑}
  (if flag
    (if (setq ss (ssget "C" (car pts) (cadr pts)'((0 . "LINE"))))
      (if (> (sslength ss) 0)
        (ifs_insert_kouten blkname pt dimsc) 
      )
    )
  )
)

;; ubNQƃubNɒu
(defun c:bch( / base1 base2 elast1 elast2 ename1 ename2 ent1 ent2 esel esel2 
              name1 name11 name2 name21 spc1 spc2 typ1 typ2 loop loop2 pin11 pin12 pin21 pin22)
  (setq loop T)
  (while loop
    (if (setq esel (entsel "\nQƂubNI < I > : "))
      (progn
        (setq ename1 (car esel) ent1 (entget ename1))
        (if (= "INSERT" (cdr (assoc 0 ent1)))       
          (progn
            (setq loop2 T)
            (while loop2
              (if (setq esel2 (entsel "\nuΏۂ̃ubNI < ߂ > : "))
                (progn
                  (setq ename2 (car esel2) ent2 (entget ename2))
                  (if (= "INSERT" (cdr (assoc 0 ent2)))
                    (progn
                      (setq name2  (ifs_getAttValue ename2 "NAME")
                            name21 (ifs_getAttValue ename2 "NAME1")
                            typ2   (ifs_getAttValue ename2 "TYPE")
                            spc2   (ifs_getAttValue ename2 "SPEC")
                            pin21  (ifs_getAttValue ename2 "PIN1")
                            pin22  (ifs_getAttValue ename2 "PIN2")
                            
                            base1 (cdr (assoc 10 ent1))
                            base2 (cdr (assoc 10 ent2))
                      )
                      (setvar "CMDECHO" 0)
                      (command "_UNDO" "BE")
                      ;;폜
                      (ifs_sub_bjointvx ename2)
                      (entdel ename2)
                      (setq elast1 (entlast))
                      ;;Rs[
                      (command "_COPY" ename1 "" "none" base1 "none" base2)
                    
                      (if (not (equal elast1 (setq elast2 (entlast))))
                        (progn
                          (ifs_sub_btrimvx elast2)
                          (setq name1  (ifs_getAttValue ename1 "NAME")
                                name11 (ifs_getAttValue ename1 "NAME1")
                                typ1   (ifs_getAttValue ename1 "TYPE")
                                spc1   (ifs_getAttValue ename1 "SPEC")
                                pin11  (ifs_getAttValue ename2 "PIN1")
                                pin12  (ifs_getAttValue ename2 "PIN2")                                
                          )
                          (if (and typ1 typ2)
                            (ifs_setAttValue elast2 "TYPE" typ2)
                          )
                          (if (and spc1 spc2)
                            (ifs_setAttValue elast2 "SPEC" spc2)
                          )
                          (if (and pin11 pin21)
                            (ifs_setAttValue elast2 "PIN1" pin21)
                          )
                          (if (and pin21 pin22)
                            (ifs_setAttValue elast2 "PIN2" pin22)
                          )
                          
                          (cond
                            ((and name1 name11 name2 name21)
                              (ifs_attval2 elast2 "NAME" "NAME1" name2 name21))
                            ;; QƐ name   name name1
                            ((and name1 (not name11) name2 name21)
                              (ifs_attval elast2 "NAME" (strcat name2 name21)))
                            ;; QƐ name name1  name ̂
                            ((and name1 name11 name2 (not name21))
                              (ifs_attval2 elast2 "NAME" "NAME1"  name2 "")) 
                            ((and name1 (not name11) name2 (not name21))
                              (ifs_attval elast2 "NAME" name2))  
                          )                
                        )
                      )
                      (command "_UNDO" "END")
                      (setvar "CMDECHO" 1)
                    )
                  )
                )
                (setq loop2 nil)
              )
            )
          )
        )
      )
      (setq loop nil)
    )
  )
  (princ)
)

;; ubNATEXT 1Rs[
;; ԁA@햼ubNA܂܂TEXT̓JEgAbv
(defun c:bCp( / my_error loop loop2 res ename mode snm)
  (defun my_error (msg) 
    (princ msg)
    (setvar "SNAPMODE" snm)
    (princ)
  )
  (setq *error*  my_error)

  (setq loop T mode "S")
  (while loop 
    (setq loop2 T ename nil)
    (while loop2
      (setq snm (getvar "SNAPMODE"))
      (setvar "SNAPMODE" 0)
      (initget "N F Exit eXit")
      (cond
        ((= mode "S")
          (setq res (entsel "\nRs[ubNATEXT PI [N:}`I /E,X:I] :")))
      )
      (setvar "SNAPMODE" snm)
      (cond 
        ((and res (listp res))
          (setq ename (car res) loop2 nil))
        ((= res "N")
          (setq loop2 nil))
        ((or (= res "Exit")(= res "eXit"))
          (setq loop nil loop2 nil))
      )
    )
    (cond 
      ((and res (listp res))
        (ifs_do_bcpS ename))
      ((= res "N")
        (ifs_do_bcpN))
    )
  )
  (setvar "SNAPMODE" snm)
  (setq *error*  my_error)
  (princ)
)

;; ܂܂Ă邩
(defun ifs_isInNumber (str / i len loop c res)
  (setq i 1)
  (if (setq loop (> (setq len (strlen str)) 0))
    (while (and loop (<= i len))
      (setq c (substr str i 1))
      (if (and (>= c "0") (<= c "9"))
        (setq loop nil res T)
      )
      (setq i (1+ i))
    )
  )
  res
)

(defun ifs_do_bcpS ( ename / my_error err orth snm cpm blkname cnt elast elast2 ent lastpt len loop lst mes 
     nstr num objname pt s1 s2 str up name name1 flag flag1)
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "SNAPMODE" snm)
    (setvar "ORTHOMODE" orth)
    (setvar "COPYMODE" cpm)
    (setvar "CMDECHO" 1)
    (setq *error* err)
    (princ)
  )
  (setq err *error*)
  (setq *error*  my_error)
  (setq snm      (getvar "SNAPMODE")
        orth     (getvar "ORTHOMODE")
        cpm      (getvar "COPYMODE")      
  )
  (setvar "ORTHOMODE" 0)
  (setvar "COPYMODE" 1)
  (setvar "CMDECHO" 0)
  (setq up 0)
  
  (if ename
    (progn
      (setq ent (entget ename) objname (cdr (assoc 0 ent)))
      (if (= objname "INSERT") 
        (progn 
          (setq pt      (cdr (assoc 10 ent))
                blkname (cdr (assoc 2 ent))
          )
          (if (wcmatch blkname "*SENBAN*") 
            (progn
              (setq flag T name (ifs_getAttValue ename "SENBAN") name1 "" mes "")
              (if (and name name1) (setq str (strcat name name1)))
            )
            (progn
              (if (or (setq flag (and (ifs_attval ename "NAME" nil) (not (ifs_attval ename "NAME1" nil))))
                      (setq flag1 (and (ifs_attval ename "NAME" nil)(ifs_attval ename "NAME1" nil))))
                (setq mes "@햼")
                (setq mes nil)
              )
              (if flag  
                (setq name (ifs_getAttValue ename "NAME") name1 "")
              )
              (if flag1 
                (setq name (ifs_getAttValue ename "NAME") name1 (ifs_getAttValue ename "NAME1"))
              )
              (if (and name name1) (setq str (strcat name name1)))
            )
          )
          (if (and mes (ifs_isInNumber str))
            (progn 
              (initget "No")
              (if (not (setq up (getint (strcat "\n" mes "̃JEgAbv < 0 > : "))))
                (setq up 0)
                (if (= up "No") (setq up 0))
              )
            )
          )
          (setq loop T cnt 0 )
          (while loop 
            (setq elast (entlast))
            (command "_UNDO" "BE")
            (prompt "\nRs[w [ESC=I] : ")
            (command "_COPY" ename "" "none" pt)
            (while (= (getvar "CMDNAMES") "COPY") 
              (command pause)
            )
            ;;𕔕폜
            (if (not (equal elast (setq elast2 (entlast)))) 
              (progn 
                (setq cnt (+ cnt up))
                (if (wcmatch blkname "*SENBAN*") 
                  (if (> up 0)
                    (ifs_func_sbup elast2 cnt T)
                  )
                  (progn 
                    (ifs_sub_btrimvx elast2)
                    (if (> up 0) 
                      (ifs_func_nmup elast2 cnt T)
                    )
                  )
                )
              )
              (setq loop nil)
            )
            (command "_UNDO" "END")
          )
        )
        (if (= objname "TEXT") 
          (progn 
            (if (or (> (cdr (assoc 72 ent)) 0) (> (cdr (assoc 73 ent)) 0)) 
              (setq pt (cdr (assoc 11 ent)))
              (setq pt (cdr (assoc 10 ent)))
            )
            (setq str  (cdr (assoc 1 ent))
                  lst  (ifs_sprNum3 str)
                  s1   (car lst)
                  nstr (cadr lst)
                  s2   (caddr lst)
                  num  (atoi nstr)
                  len  (strlen nstr)
            )
            (if (/= nstr "") 
              (progn 
                (initget "No")
                (if (not (setq up (getint "\nJEgAbv < 0 > : "))) 
                  (setq up 0)
                  (if (= up "No") 
                    (setq up 0)
                  )
                )
              )
            )
            (setq loop T
                  cnt  0
            )
            (while loop 
              (setq lastpt (getvar "lastpoint"))
              (command "_UNDO" "BE")
              (command "_COPY" ename "" "none" pt)
              (prompt "\nRs[w [ESC=I] : ")
              (while (= (getvar "CMDNAMES") "COPY") 
                (command pause)
              )
              (if (equal lastpt (getvar "LSTPOINT")) 
                (setq loop nil)
                (if (/= nstr "")
                  (progn 
                    (setq cnt   (+ cnt up)
                          str   (itoa (+ cnt num))
                          elast (entlast)
                          ent   (entget elast)
                    )
                    (setq str (ifs_func_strAddZero str len))
                    (entmod 
                      (subst (cons 1 (strcat s1 str s2)) (assoc 1 ent) ent)
                    )
                  )
                )
              )
              (command "_UNDO" "END")
            )
          )
        )
      )
    )
  )
  (setvar "SNAPMODE" snm)
  (setvar "ORTHOMODE" orth)
  (setvar "COPYMODE" cpm)
  (setvar "CMDECHO" 1)
  (setq *error* err)
  (princ)  
)

(defun ifs_do_bcpN( / my_error err cpm orth snm cnt elast fil i loop loop2 lst p1 ss ssnew 
     ssold tagFlag up fil2 )
 (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "SNAPMODE" snm)
    (setvar "ORTHOMODE" orth)
    (setvar "COPYMODE" cpm)
    (setvar "CMDECHO" 1)
    (setq *error* err)
    (princ)
  )
  (setq err *error*)
  (setq *error*  my_error)
  (setq snm      (getvar "SNAPMODE")
        orth     (getvar "ORTHOMODE")
        cpm      (getvar "COPYMODE")      
  )
  (setvar "ORTHOMODE" 0)
  (setvar "COPYMODE" 1)
  (setvar "CMDECHO" 0)
  
  (setq fil '((-4 . "<OR")
              (0 . "LWPOLYLINE,*TEXT,CIRCLE")
              (-4 . "<AND")
              (0 . "INSERT")
              (-4 . "<NOT")
              (2 . "*KOUTEN*,*CMARK*")
              (-4 . "NOT>")
              (-4 . "AND>")
              (-4 . "OR>")
             )
  )
  (setq loop T)
  (while loop 
    (if (setq ss (ssget fil)) 
      (progn 
        (if (setq lst (ifs_func_ssBlkBase ss)) 
          (setq p1 (car lst) tagFlag (cadr lst))
          (setq p1 nil tagFlag nil)
        )
        (if (not p1) 
          (setq p1 (getpoint "\n_w : "))
        )
        (if tagFlag 
          (progn 
            (initget "No")
            (if (not (setq up (getint "\n@햼̃JEgAbv < 0 > : "))) 
              (setq up 0)
              (if (= up "No")(setq up 0))
            )
          )
          (setq up 0)
        )
        (setq fil2 '((0 . "INSERT")(-4 . "<NOT")(2 . "*SENBAN*")(-4 . "NOT>")))
        (setq loop2 T cnt 0)
        (while loop2 
          (setq cnt (+ cnt up))
          (setq elast (entlast))
          (setq ssold (ssget "_X" fil2))
          (command "_UNDO" "BE")
          (command "_COPY" ss "" "none" p1)
          (prompt "\nRs[w [ESC=I] : ")
          (while (= (getvar "CMDNAMES") "COPY") 
            (command pause)
          )
          (if (not (equal elast (entlast))) 
            (progn 
              (setq ssnew (ssget "_X" fil2))
              (if (and ssold ssnew) 
                (progn 
                  (setq i 0)
                  (repeat (sslength ssold) 
                    (setq ssnew (ssdel (ssname ssold i) ssnew))
                    (setq i (1+ i))
                  )
                  (if (> (sslength ssnew) 0) 
                    (progn 
                      (setq i 0)
                      (repeat (sslength ssnew) 
                        (ifs_sub_btrimvx (ssname ssnew i))
                        (setq i (1+ i))
                      )
                      (if (and tagFlag (> up 0)) 
                        (progn 
                          (setq i 0)
                          (repeat (sslength ssnew) 
                            (ifs_func_nmup (ssname ssnew i) cnt T)
                            (setq i (1+ i))
                          )
                        )
                      )
                    )
                  )
                )
              )
            )
            (setq loop2 nil)
          )
          (command "_UNDO" "END")
        )
      )
      (setq loop nil)
    )
  )
  (setvar "SNAPMODE" snm)
  (setvar "ORTHOMODE" orth)
  (setvar "COPYMODE" cpm)
  (setvar "CMDECHO" 1)
  (setq *error* err)
  (princ)  
) 

;; IZbgƂȂubN̊_ƁA@햼邩̃Xg𓾂
;; Ƃ nil Ԃ
(defun ifs_func_ssBlkBase (ss / i ename ent minpt maxpt pts baselist respt e1 e2 ptx 
                           pty dx dy tagFlag dimsc
                          ) 
  (setq i     0
        dimsc (getvar "DIMSCALE")
  )
  (if ss 
    (repeat (sslength ss) 
      (setq ename (ssname ss i)
            ent   (entget ename)
      )
      (if (and (= (cdr (assoc 0 ent)) "INSERT") (not (wcmatch (cdr (assoc 2 ent)) "*SENBAN*")))
        (progn 
          (setq pts   (ifs_getBoundingBox ename)
                pts   (ifs_lineW (car pts) (cadr pts) (* 0.1 dimsc))
                minpt (car pts)
                maxpt (cadr pts)
          )
          (if (and minpt maxpt (not (equal minpt maxpt 0.1))) 
            (setq baselist (append baselist (list (cdr (assoc 10 ent)))))
          )
          (if (not tagFlag) 
            (setq tagFlag
              (or (and (ifs_attval ename "NAME" nil)(not (ifs_attval ename "NAME1" nil)))
                  (and (ifs_attval ename "NAME" nil)(ifs_attval ename "NAME1" nil)))
            )
          )
        )
      )
      (setq i (1+ i))
    )
  )
  (if baselist 
    (progn 
      ;; Y 
      (setq baselist (vl-sort baselist (function (lambda (e1 e2) (> (cadr e1) (cadr e2))))))
      (setq dy  (- (cadr (car baselist)) (cadr (last baselist)))
            pty (car baselist)
      )
      ;; X 
      (setq baselist (vl-sort baselist (function (lambda (e1 e2) (< (car e1) (car e2))))))
      (setq dx  (- (car (last baselist)) (car (car baselist)))
            ptx (car baselist)
      )
      (if (>= (abs dx) (abs dy)) 
        (setq respt ptx)
        (setq respt pty)
      )
    )
  )
  (if respt 
    (setq respt (list respt tagFlag))
  )
)

;; ̃ubN̐Aʒu킹
(defun c:BMvP( / my_error loop base dx dy ename ent i mes pt res ss vflag loop2)
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)  
  
  (setvar "CMDECHO" 0)
  (setq vflag nil loop T)
  (while loop
    (if (setq ss (ssget '((0 . "INSERT")(-4 . "<NOT")(2 . "*KOUTEN*,*CMARK*")(-4 . "NOT>"))))
      (progn  
        (setq loop2 T)
        (while loop2
          (if vflag
            (setq mes "\n킹̊_(XW)w [H:킹 /E,X:I] : ") 
            (setq mes "\n킹̊_(YW)w [V:킹 /E,X:I] : ")
          )
          (setq pt nil)
          (initget "V H Exit eXit")
          (setq res (getpoint mes))
          (cond 
            ((or (= res "Exit") (= res "eXit"))
              (setq loop nil loop2 nil))
            ((= res "V")
              (setq vflag T))
            ((= res "H")
              (setq vflag nil))
            ((and res (listp res))
              (setq pt res loop2 nil))
          )
        )
        (if pt
          (progn 
            (command "_UNDO" "BE")
            (setq i 0)
            (repeat (sslength ss) 
              (setq ename (ssname ss i)
                    ent   (entget ename)
                    base  (cdr (assoc 10 ent))
                    dx    (- (car pt) (car base))
                    dy    (- (cadr pt) (cadr base))
              )
              (if vflag 
                (setq dy 0.0) 
                (setq dx 0.0)
              )
              (ifs_sub_bjointvx ename)
              (command "_MOVE" ename "" "_non" base "_non" (list (+ (car base) dx) (+ (cadr base) dy) (caddr base)))
              (ifs_sub_btrimvx ename)
              (setq i (1+ i))
            )
            (command "_UNDO" "END")
          )
        )
      )
      (setq loop nil)
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ̐̐Aʒu킹
(defun c:lMvP( / my_error loop dx dy ename ent i mes pt res ss vflag loop2  dimsc p10 p11 pts )
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error) 
  (setq dimsc (getvar "DIMSCALE"))
  
  (setvar "CMDECHO" 0)
  (setq vflag nil loop T)
  (while loop
    (if (setq ss (ssget '((0 . "LINE"))))
      (progn  
        (setq loop2 T)
        (while loop2
          (if vflag
            (setq mes "\n킹̊_(XW)w [H:킹 /E,X:I] : ") 
            (setq mes "\n킹̊_(YW)w [V:킹 /E,X:I] : ")
          )
          (setq pt nil)
          (initget "V H Exit eXit")
          (setq res (getpoint mes))
          (cond 
            ((or (= res "Exit") (= res "eXit"))
              (setq loop nil loop2 nil))
            ((= res "V")
              (setq vflag T))
            ((= res "H")
              (setq vflag nil))
            ((and res (listp res))
              (setq pt res loop2 nil))
          )
        )
        (if pt
          (progn 
            (command "_UNDO" "BE")
            (setq i 0)
            (repeat (sslength ss) 
              (setq ename (ssname ss i)
                    ent   (entget ename)
                    p10  (cdr (assoc 10 ent))
                    p11  (cdr (assoc 11 ent))
                    dx    (- (car pt) (car p10))
                    dy    (- (cadr pt) (cadr p10))
              )
              (if vflag 
                (setq dy 0.0) 
                (setq dx 0.0)
              )
              (if (or (and vflag (equal (car p10)(car p11) 0.001))
                      (and (not vflag) (equal (cadr p10)(cadr p11) 0.001)))
                (progn
                  (setq pts (ifs_lineW p10 p11 (* 0.5 dimsc)))
                  (command "_STRETCH" "C" "none" (car pts) "none" (cadr pts) "" 
                          "none" p10 
                          "none" (list (+ (car p10) dx) (+ (cadr p10) dy) (caddr p10)))
                )
              )              
              (setq i (1+ i))
            )
            (command "_UNDO" "END")
          )
        )
      )
      (setq loop nil)
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ubNړiŁj
(defun c:bMv( / my_error snapmode loop res ename pick)
   (defun my_error(msg)
    (princ msg)
    (setvar "SNAPMODE" snapmode)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setq snapmode (getvar "SNAPMODE"))
  (setq loop T)
  (while loop
    (setvar "CMDECHO" 0)
    (setvar "SNAPMODE" 0)
    (initget "Exit eXit N")    
    (setq res (entsel "\nړ}`(BLOCK, LINE, TEXT)PA܂̓|ĈPӂw [N:}` /E,X:I] : "))
    (setvar "SNAPMODE" snapmode)
    (if res
      (cond
        ((or (= res "Exit")(= res "eXit"))
          (setq loop nil))
        ((= res "N")
          (progn
            (ifs_do_bmvN)
          )
        )
        ((and res (listp res))
          (progn
            (setq ename (car res) pick (cadr res))
            (ifs_do_bmvS ename pick)
          )
        )
      )
    )
  )
  (setvar "SNAPMODE" snapmode)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

(defun ifs_do_bmvS ( ename pick / err my_error dimsc ent objname orm osm pt pts snm bname ss
                                deg p10 p11 rot tateFlag senban lastpt pts2 lastpt2)
  (defun my_error(msg)
    (princ msg)
    (command "_UNDO" "END")
    (setvar "SNAPMODE" snm)
    (setvar "ORTHOMODE" orm)
    (setvar "OSMODE" osm)
    (setvar "CMDECHO" 1)
    (setq *error* err)
    (princ)
  )
  (setq err *error*)
  (setq *error* my_error)
  
  (setq 
    snm   (getvar "SNAPMODE")
    dimsc (getvar "DIMSCALE")  
    orm (getvar "ORTHOMODE")
    osm (getvar "OSMODE")
  )
  (setvar "CMDECHO" 0)
  ;;(setq pick (osnap pick "near")) ;; ubN̎Anear Ȃ̂ŃRgAEg
  (if ename 
    (progn 
      (command "_UNDO" "BE")
      (setq ent (entget ename) objname (cdr (assoc 0 ent)))
      (if (= objname "INSERT")
        (progn 
          ;;
          (ifs_sub_bjointvx ename)
          (setq pt (cdr (assoc 10 ent)))
          (prompt "\nړw [ESC = ~] : ")
          ;;(command "_UNDO" "BE")
          (setvar "ORTHOMODE" 0)
          
          (command "_MOVE" ename "" "none" pt)
          (while (= (getvar "CMDNAMES") "MOVE") 
            (command pause)
          )
          (setvar "ORTHOMODE" orm)
          (setq bname (cdr (assoc 2 ent)))
          (if (wcmatch bname "SENBAN*")
            (progn
              (setq deg (ifs_radToDeg (cdr (assoc 50 ent))))
              (if (equal deg 360.0 1.0)(setq deg 0.0))
              
              (setq pt (getvar "LASTPOINT") pts (ifs_pointW pt 0.5))
              (if (setq ss (ssget "C" (car pts)(cadr pts) '((0 . "LINE"))))
                (progn
                  (setq ent (entget (ssname ss 0)) p10 (cdr (assoc 10 ent)) p11 (cdr (assoc 11 ent)))
                  (setq tateFlag (ifs_isTate p10 p11))
                  (cond
                    ((= bname "SENBAN00")
                      (progn
                        (setq rot nil)
                        (if (and tateFlag (equal deg 0.0 1.0)) (setq rot 90.0))
                        (if (and (not tateFlag)(equal deg 90.0 1.0)) (setq rot -90.0))
                        (if rot
                          (command "_ROTATE" ename "" "none" pt rot)
                        )
                      ))
                    ((and (= bname "SENBAN")(not tateFlag));;90x
                      (if (setq senban (ifs_getAttValue ename "SENBAN"))
                        (if (ifs_insert_sb "SENBAN1" pt dimsc 0.0 senban)
                          (entdel ename)
                        )
                      ))
                    ((and (= bname "SENBAN1") tateFlag);;p
                      (if (setq senban (ifs_getAttValue ename "SENBAN"))
                        (if (ifs_insert_sb "SENBAN" pt dimsc 0.0 senban)
                          (entdel ename)
                        )
                      ))
                  )
                )
              )
            )
            (progn
              ;; ͂̐Jbg
              (ifs_sub_btrimvx ename)
            )
          )
        )
        (if (and (= objname "LINE") pick)
          (progn 
            (setvar "ORTHOMODE" 1)
            (setvar "OSMODE" 0)
            (setvar "SNAPMODE" 1)
            (if (setq pt (osnap pick "near"))
              (setq pick pt)
            )
            (ifs_sub_lmove ename pick nil nil)
            (setvar "ORTHOMODE" orm)
            (setvar "OSMODE" osm)
            (setvar "SNAPMODE" snm)
          )
          (if (= objname "TEXT") 
            (progn 
              (if (or (> (cdr (assoc 72 ent)) 0) (> (cdr (assoc 73 ent)) 0)) 
                (setq pt (cdr (assoc 11 ent)))
                (setq pt (cdr (assoc 10 ent)))
              )
              (setvar "ORTHOMODE" 0)
              (command "MOVE" ename "" "none" pt)
              (while (= (getvar "CMDNAMES") "MOVE") 
                (command pause)
              )
              (setvar "ORTHOMODE" orm)
            )
            (if (and (= objname "LWPOLYLINE") pick) 
              (progn
                (if (setq pt (osnap pick "near"))
                  (setq pick pt)
                )
                (if (setq pts (ifs_func_pickEle ename pick)) 
                  (progn 
                    (setq pts2 (ifs_lineW (car pts) (cadr pts) (* 0.5 dimsc))) 
                    (setq lastpt (getvar "LASTPOINT"))
                    (setvar "ORTHOMODE" 1)
                    (command "_STRETCH" "_C" "none" (car pts2) "none" (cadr pts2) "" "none" pick)
                    (while (= (getvar "CMDNAMES") "STRETCH") 
                      (command PAUSE)
                    )
                    (setvar "ORTHOMODE" orm)
                    ;; TEXT Ǐ]Ĉړ
                    (if (not (equal lastpt (setq lastpt2 (getvar "LASTPOINT"))))
                      (progn
                        (setq pts2 (ifs_lineW (car pts) (cadr pts) (* 2.5 dimsc)))
                        (if (setq ss (ssget "C" (car pts2) (cadr pts2) '((0 . "TEXT"))))
                          (command "_MOVE" ss "" "none" pick "none" lastpt2)
                        )
                      )
                    )
                    ;;(command "_UNDO" "END")
                  )
                )
              )
            )
          )
        )
      )
      (command "_UNDO" "END")
    )
  )
  (setvar "SNAPMODE" snm)
  (setvar "ORTHOMODE" orm)
  (setvar "OSMODE" osm)
  (setvar "CMDECHO" 1)
  (setq *error* err)
  (princ)
)

(defun ifs_do_bmvN( / my_error err bklist dimsc ename ent fil i item loop lst maxpt 
     minpt newpt oldpt p1 pts reclist ss tagFlag orm)
  (defun my_error(msg)
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* err)
    (princ)
  )
  (setq err *error*)
  (setq *error* my_error)
  (setq orm (getvar "ORTHOMODE"))
  (setvar "CMDECHO" 0)
  (setq dimsc (getvar "DIMSCALE"))
  (setq fil '((-4 . "<OR")
              (0 . "LWPOLYLINE,*TEXT,CIRCLE")
              (-4 . "<AND")
              (0 . "INSERT")
              (-4 . "<NOT")
              (2 . "*KOUTEN*,*CMARK*")
              (-4 . "NOT>")
              (-4 . "AND>")
              (-4 . "OR>")
             )
  )
  (setq loop T)
  (while loop 
    (setq bklist  nil
          reclist nil
    )
    (prompt "\nȊOŌ_ȊÕ̕ubNATEXTA~A|Cړ܂D< P}`ړɖ߂ > : ")
    (if (setq ss (ssget fil)) 
      (progn 
        (princ "\nI = ")(princ (sslength ss))
        (command "_UNDO" "BE")
        (setq i 0)
        (repeat (sslength ss) 
          (setq ename (ssname ss i)
                ent   (entget ename)
          )
          (if (= (cdr (assoc 0 ent)) "INSERT") 
            (progn 
              (setq pts   (ifs_getBoundingBox ename)
                    pts   (ifs_lineW (car pts) (cadr pts) (* 0.1 dimsc))
                    minpt (car pts)
                    maxpt (cadr pts)
              )
              (if (and minpt maxpt (not (equal minpt maxpt 0.1))) 
                (setq bklist  (append bklist (list ename))
                      reclist (append reclist (list (list minpt maxpt)))
                )
              )
            )
          )
          (setq i (1+ i))
        )
        (if (setq lst (ifs_func_ssBlkBase ss))
          (setq p1      (car lst)
                tagFlag (cadr lst)
          )
          (setq p1      nil
                tagFlag nil
          )
        )
        (if (not p1) 
          (setq p1 (getpoint "\n_w : "))
        )
        (setq oldpt (cdr (assoc 10 (entget (ssname ss 0)))))
        
        (setvar "ORTHOMODE" 0)
        (command "_MOVE" ss "" "none" p1)
        (prompt "\nړw [ESC = ~] : ")
        (while (= (getvar "CMDNAMES") "MOVE") 
          (command pause)
        )
        (setvar "ORTHOMODE" orm)
        
        (setq newpt (cdr (assoc 10 (entget (ssname ss 0)))))
        (if (not (equal oldpt newpt)) 
          (progn 
            (if reclist 
              (foreach item reclist 
                (if (and (setq ss (ssget "C" (car item) (cadr item) '((0 . "LINE")))) 
                         (> (sslength ss) 0))
                  (ifs_lineJoint ss nil nil nil) ;; ss pt minpt maxpt ̏
                )
              )
            )
            (if bklist 
              (foreach ename bklist 
                (ifs_sub_btrimvx ename)
              )
            )
          )
        )
        (command "_UNDO" "END")
      )
      (setq loop nil)
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* err)
  (princ)
)

;; ubN폜A܂͐𕔕폜
(defun c:bErold( / my_error loop loop2 res snm)
  (defun my_error(msg)
    (princ msg)
    (setvar "SNAPMODE" snm)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)

  (setq loop T)
  (while loop 
    (setq loop2 T )
    (while loop2 
      (setq snm (getvar "SNAPMODE"))
      (setvar "SNAPMODE" 0)
      (initget "N Exit eXit")
      (setq res (entsel "\n폜ubNPIA܂͕폜̐_w [N:}`I /E,X:I] : ")) 
      (setvar "SNAPMODE" snm)
      (if res
        (cond 
          ((or (= res "Exit")(= res "eXit"))
            (setq loop  nil loop2 nil))
          ((= res "N")
            (progn (setq loop nil loop2 nil) (ifs_do_berN)));; berN  Loop 
          ((and res (listp res))
            (progn (ifs_do_berS (car res)(cadr res))))
        )
      )
    )
  )
  (setvar "SNAPMODE" snm)
  (setq *error* nil)
  (princ)
)

(defun ifs_do_berS( ename pick / my_error objname snm pt)
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setvar "SNAPMODE" snm)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq snm (getvar "SNAPMODE"))
  (setvar "SNAPMODE" 0)
  
  (if ename 
    (progn 
      (command "_UNDO" "BE")
      (setq objname (cdr (assoc 0 (entget ename))))
      (if (= objname "INSERT") 
        (progn 
          (ifs_sub_bjointvx ename)
          (entdel ename)
        )
        (if (and pick (= objname "LINE"))
          (progn
            (if (setq pt (osnap pick "near"))
              (setq pick pt)
            )
            (ifs_sq_lcut ename pick 1)
          )
          (entdel ename);; INSERT, TEXT ȊO͂̂܂܍폜
        )
      )
      (command "_UNDO" "END")
    )
  )
  
  (setvar "CMDECHO" 1)
  (setvar "SNAPMODE" snm)
  (setq *error* nil)
  (princ)
)

(defun ifs_do_berN (/ my_error ss fil reclist i ename ent minpt maxpt item newss oldss 
               loop pts temp dimsc
              ) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq fil '((-4 . "<OR")
              (0 . "LWPOLYLINE,*TEXT,CIRCLE")
              (-4 . "<AND")
              (0 . "INSERT")
              (-4 . "<NOT")
              (2 . "*KOUTEN*,*CMARK*")
              (-4 . "NOT>")
              (-4 . "AND>")
              (-4 . "OR>")
             )
  )
  (setq loop  T
        dimsc (getvar "DIMSCALE")
  )
  (while loop 
    (setq reclist nil)
    (if (setq ss (ssget fil)) 
      (progn 
        (command "_UNDO" "BE")
        (prompt "\nȊOŁA_ȊÕ̕ubNATEXTA~A|C폜܂D< ߂ > : ")
        (setq i 0)
        (repeat (sslength ss) 
          (setq ename (ssname ss i)
                ent   (entget ename)
          )
          (if (= (cdr (assoc 0 ent)) "INSERT") 
            (progn 
              (setq pts   (ifs_getBoundingBox ename)
                    pts   (ifs_lineW (car pts) (cadr pts) (* 0.1 dimsc))
                    minpt (car pts)
                    maxpt (cadr pts)
              )
              (if (and minpt maxpt (not (equal minpt maxpt 0.1))) 
                (setq temp    (ifs_lineW minpt maxpt (* 0.1 dimsc))
                      reclist (append reclist (list temp))
                )
              )
            )
          )
          (setq i (1+ i))
        )
        (setq oldss (ssget "_X"))
        (command "_ERASE" ss "")
        (while (= (getvar "CMDNAMES") "ERASE") 
          (command pause)
        )
        (setq newss (ssget "_X"))
        (if (and oldss newss (> (sslength oldss) (sslength newss))) 
          (if reclist 
            (foreach item reclist 
              (if (and (setq ss (ssget "C" (car item) (cadr item) '((0 . "LINE")))) 
                       (> (sslength ss) 0))
                (ifs_lineJoint ss nil nil nil)
              )
            )
          )
        )
        (command "_UNDO" "END")
      )
      (setq loop nil)
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ubN̎͂̐ for TEST
(defun c:bJt (/ my_error ename loop snm esel) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setvar "SNAPMODE" snm)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setq snm (getvar "SNAPMODE"))
  (setvar "CMDECHO" 0)
  (setvar "SNAPMODE" 0)
  
  (setq loop T)
  (while loop 
    (if (setq esel (entsel "\n͂̐ubNPI < I > : ")) 
      (progn 
        (setq ename (car esel))
        (if (not ename) 
          (setq loop nil)
          (progn 
            (command "_UNDO" "BE")
            (ifs_sub_bjointvx ename)
            (command "_UNDO" "END")
          )
        )
      )
      (setq loop nil)
    )
  )
  (setvar "CMDECHO" 1)
  (setvar "SNAPMODE" snm)
  (setq *error* nil)
  (princ)
)

;; ̂Ԃ؂ieXgpj
(defun c:lJt (/ my_error ss loop) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  
  (setq loop T)
  (while loop 
    (prompt "\n镡̐I < I > : ")
    (if (setq ss (ssget '((0 . "LINE")))) 
      (ifs_lineJoint ss nil nil nil)
      (setq loop nil)
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;;ubN̎͂̐
(defun ifs_sub_bjointvx (ename / ent maxpt minpt ss temp) 
  (setq ent (entget ename))
  (if (= (cdr (assoc 0 ent)) "INSERT") 
    (progn 
      (setq temp  (ifs_getBoundingBox ename)
            temp  (ifs_lineW (car temp) (cadr temp) (* 0.1 (getvar "DIMSCALE")))
            minpt (car temp)
            maxpt (cadr temp)
      )
      ;;(command "RECTANG" "_none" minpt "_none" maxpt)
      ;;ubN̎͂̐}`擾
      (if (and (setq ss (ssget "C" minpt maxpt '((0 . "LINE")))) 
               (> (sslength ss) 0))
        (ifs_lineJoint ss (cdr (assoc 10 ent)) minpt maxpt) ;; ڑ
      )
    )
  )
)

;; ̃ubŇJbg
(defun c:bTrN (/ my_error loop loop2 ss i len) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop 
    (setq loop2 T
          ss    nil
    )
    (while loop2
      (prompt "\nJbg镡̃ubNI < I > : ")
      (if (setq ss (ssget '((0 . "INSERT")(-4 . "<NOT")(2 . "*KOUTEN*,*CMARK*")(-4 . "NOT>"))))
        (setq loop  nil
              loop2 nil
        )
      )
    )
    (if (and ss (setq len (sslength ss))) 
      (progn 
        (command "_UNDO" "BE")
        (setq i 0)
        (repeat len 
          (ifs_sub_btrimvx (ssname ss i))
          (setq i (1+ i))
        )
        (command "_UNDO" "END")
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ̃ubŇJbg
(defun c:bTrL (/ my_error loop loop2 ss i len ent ss2 len2 j) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop 
    (setq loop2 T
          ss    nil
    )
    (while loop2
      (prompt "\ñubŇJbgI < I > : ")
      (if (setq ss (ssget '((0 . "LINE")))) 
        (setq loop2 nil)
        (setq loop  nil
              loop2 nil
        )
      )
    )
    (if (and ss (setq len (sslength ss))) 
      (progn 
        (command "_UNDO" "BE")
        (setq i 0)
        (repeat len 
          (setq ent (entget (ssname ss i)))
          (if (setq ss2 (ssget "F"  (list (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))
                                   '((0 . "INSERT")(-4 . "<NOT")(2 . "*KOUTEN*,*CMARK*")(-4 . "NOT>"))))
            (progn 
              (setq len2 (sslength ss2)
                    j    0
              )
              (repeat len2 
                (ifs_sub_btrimvx (ssname ss2 j))
                (setq j (1+ j))
              )
            )
          )
          (setq i (1+ i))
        )
        (command "_UNDO" "END")
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ubŇJbg
;; ubN𕪉B̐}`ubNƂȊOɕ
(defun ifs_vla-Explode ( blkobj / obj lst explst blklst)
  (if (= (vla-get-ObjectName blkobj) "AcDbBlockReference")
    (progn
      (setq lst (vlax-safearray->list (vlax-variant-value (vla-Explode blkobj ))))
      (foreach obj lst
        (if (= (vla-get-ObjectName obj) "AcDbBlockReference")
          (setq blklst (append blklst (list obj)))
          (setq explst (append explst (list obj)))
        )  
      )
    )
  )
  (list blklst explst)
)

(defun ifs_func_blkExplode ( topobj / blk blklst dellst explst item loop temp temp_blklst )
  (if  (= (vla-get-ObjectName topobj) "AcDbBlockReference")
    (setq blklst (list topobj) loop T)   
  )
  (while loop
    (setq temp_blklst nil)
    (foreach blk blklst
      (setq temp (ifs_vla-Explode blk));; 
      (if (car temp)
        (foreach item (car temp)
          (setq temp_blklst (append temp_blklst (list item)))
          (if (not (equal item topobj))
            (setq dellst (append dellst (list item)));; ς̃ubN
          )
        )
        (setq loop nil)
      )
      (if (cadr temp)
        (foreach item (cadr temp)
          (setq explst (append explst (list item)));; ꂽ}`
        )
      )
    )
    (setq blklst temp_blklst)
  )
  (list explst dellst)
)

;; ubŇJbg
(defun ifs_sub_btrimvx (ename / ary breaklist i item j lst maxpt minpt obj objname 
                        osm sary ss temp vlaobj vpt xxlst edp ent p1 p2 stp ved vst 
                        pts kp layname lay adoc jogai dimsc dellst explst
                       ) 
  (setq jogai "*KOUTEN*,*CMARK*");; OubN
  (setq breaklist nil
        dimsc     (getvar "DIMSCALE")
  )
  (setq vlaobj (vlax-ename->vla-object ename))
  (if (and (= (vla-get-ObjectName vlaobj) "AcDbBlockReference") 
           (not (wcmatch (vla-get-name vlaobj) jogai)))
    (progn 
      (setq temp  (ifs_getBoundingBox ename)
            temp  (ifs_lineW (car temp) (cadr temp) (* 0.1 dimsc))
            minpt (car temp)
            maxpt (cadr temp)
      )
      ;;ubN̎͂̐}`擾
      (if (and (setq ss (ssget "C" minpt maxpt '((0 . "LINE")))) 
               (> (sslength ss) 0))
        (progn 
          ;;̐}`Xg
          ;; Z l 0 łȂ͌Ȃ̂Ō_ƂȂ
          ;; lXgꂽubNɑΉ
          (setq lst (ifs_func_blkExplode vlaobj))
          (setq explst (car lst) dellst (cadr lst))
          
          (setq i 0)
          (repeat (sslength ss) 
            (setq obj (vlax-ename->vla-object (ssname ss i)))
            (setq xxlst nil)
            (foreach item explst 
              ;; }`̖́@ w̃`FbNǉ
              (setq objname (vla-get-ObjectName item)
                    layname (vla-get-layer item)
                    adoc    (vla-get-activedocument (vlax-get-Acad-Object))
                    lay (vla-item (vla-get-layers adoc) layname)
              )
              ;; C
              (if (not (and (= :VLAX-TRUE (vla-get-layeron lay)) 
                            (= :VLAX-FALSE (vla-get-freeze lay)))) 
                (setq objname "")
              )
              (if (wcmatch objname "AcDbLine,AcDbCircle,AcDbArc,AcDbPolyline")
                (progn 
                  ;;}`m̌_𓾂
                  (setq vpt (vla-intersectwith obj item acExtendThisEntity))
                  (if (and vpt (listp vpt))  ;;Xgł邩
                    (progn  ;;for LT-Extender
                           (setq j 0)
                           (repeat (/ (length vpt) 3) 
                             (setq xxlst (cons (list (nth (* j 3) vpt)(nth (+ (* j 3) 1) vpt)(nth (+ (* j 3) 2) vpt)) xxlst))
                             (setq j (1+ j))
                           )
                    )
                    (if vpt 
                      (progn
                        (setq sary (vlax-variant-value vpt))
                        ;; ubNƂ̌_
                        (if (>= (vlax-safearray-get-u-bound sary 1) 2) 
                          (progn 
                            ;;SzLISPW
                            (setq ary (vlax-safearray->list sary))
                            (setq j 0)
                            (repeat (/ (length ary) 3) 
                              (setq xxlst (cons (list (nth (* j 3) ary)(nth (+ (* j 3) 1) ary)(nth (+ (* j 3) 2) ary)) xxlst))
                              (setq j (1+ j))
                            )
                          )
                        )
                      )
                    )
                  )
                  ;;꒼̐̎́A̒[__Ƃč̗p
                  (if (= objname "AcDbLine") 
                    (progn 
                      (setq vst (vla-get-startpoint item)
                            ved (vla-get-endpoint item)
                            stp (vlax-safearray->list (vlax-variant-value vst))
                            edp (vlax-safearray->list (vlax-variant-value ved))
                            ent (entget (ssname ss i))
                            p1  (cdr (assoc 10 ent))
                            p2  (cdr (assoc 11 ent))
                      )
                      (if (ifs_is_douitu p1 p2 stp edp) 
                        (setq xxlst (cons stp xxlst)
                              xxlst (cons edp xxlst)
                        )
                      )
                    )
                  )
                )
              )
            )
            (if (not xxlst) 
              (progn  ;; IntersectWith Ō_Ȃ = Z <> 0.0
                     ;;  ubN̋`͈͂Ƃ̌_
                     (setq ent (entget (ssname ss i))
                           p1  (cdr (assoc 10 ent))
                           p2  (cdr (assoc 11 ent))
                     )
                     (setq pts (list minpt 
                                     (list (car minpt) (cadr maxpt) 0.0)
                                     maxpt
                                     (list (car maxpt) (cadr minpt) 0.0)
                                     minpt
                               )
                     )
                     (setq j 0)
                     (repeat (1- (length pts)) 
                       (if (setq kp (inters p1 p2 (nth j pts) (nth (1+ j) pts))) 
                         (setq xxlst (cons kp xxlst))
                       )
                       (setq j (1+ j))
                     )
              )
            )
            ;;_Xg}`Ƌɕێ
            (if (and xxlst (= (length xxlst) 1))  ;; _ 1 
              (if (ifs_inWindow p1 minPt maxPt) 
                (setq xxlst (cons p1 xxlst))
                (if (ifs_inWindow p2 minPt maxPt) 
                  (setq xxlst (cons p2 xxlst))
                )
              )
            )
            (if xxlst 
              (setq breaklist (cons (list (ssname ss i) xxlst) breaklist))
            )
            (setq i (1+ i))
          )
          ;;ꂽIuWFNg폜
          (if explst
            (foreach item explst 
              (vla-Delete item)
            )
          )
          ;; ς̃ubN폜
          (if dellst
            (foreach item dellst 
              (vla-Delete item)
            )
          )
          
          ;;Ƃɕ폜
          (setq osm (getvar "OSMODE"))
          (setvar "OSMODE" 0)
          (setvar "CMDECHO" 0)
          (foreach item breaklist 
            (if (>= (length (cadr item)) 2)
              (progn 
                (setq temp (ifs_get_max_pos (cadr item)))
                (command "_break" (car item) "none" (car temp) "none" (cadr temp))
                ;; _̏ꍇ̏lEEE
              )
            )
          )
          (setvar "OSMODE" osm)
        )
      )
    )
  )
)

;; _ pt ` minpt-maxpt ͈͓ɂ邩
(defun ifs_inWindow (pt minPt maxPt) 
  (and (>= (car pt) (car minPt)) 
       (<= (car pt) (car maxPt))
       (>= (cadr pt) (cadr minPt))
       (<= (cadr pt) (cadr maxPt))
  )
)

;;  p1-p2 ` minpt-maxpt Ɍ邩
(defun ifs_isCrossWindow (p1 p2 minpt maxpt / pts i loop ret) 
  (setq pts (list minpt 
                  (list (car minpt) (cadr maxpt) 0.0)
                  maxpt
                  (list (car maxpt) (cadr minpt) 0.0)
                  minpt
            )
  )
  (setq i 0 loop T)
  (while (and (< i 4) loop) 
    (if (inters p1 p2 (nth i pts) (nth (1+ i) pts)) 
      (setq ret  T loop nil)
    )
    (setq i (1+ i))
  )
  ret
)

;; ubNړ
;; t}` SENBAN w INSERTA3 _ LWPOLYLINE ǉ 
(defun ifs_sub_lmove (ename pick topt copymode / ang dx dy ent i j kp lastpt maxpt 
                      minpt p1 p2 p10 p11 p1a p2a pfuz ss ssb sse10 sse11 ssm p1b p2b 
                      temp objname lwpt loop cnt pt dimsc dxyz a b deg ret
                      bname tateFlag ) 
  ;; enext ̒[_ (pnext-pt)  pnext ɌqubNA̒[_𓾂
  ;;jΏۂ͌Ă͈͂
  ;;(princ "\nsub_lmove")(princ pick)(princ topt)
  (if (and pick topt)
    (progn
      (if (= (length pick) 2)
        (setq pick (list (car pick)(cadr pick) 0.0))
      )
      (if (= (length topt) 2)
        (setq topt (list (car topt)(cadr topt) 0.0))
      )
      
      ;; Aړ݂̂ɐ
      (if (ifs_isTate pick topt)
        (setq topt (list (car pick)(cadr topt)(caddr topt)))
        (setq topt (list (car topt)(cadr pick)(caddr topt)))
      )
      (setq dxyz (mapcar (function (lambda (a b) (- b a))) pick topt))
    )
  )
  (setq dimsc (getvar "DIMSCALE"))
  (defun ifs_ssendpt (enext pnext pt / pfuz pst anga angb enamea enameb entb i j loop 
                      loop1 loop2 maxpt minpt pb1 pb2 ssa ssb temp
                     ) 
    ;; BJ-E ̒pTBFIntCir ̔a0.8̂
    ;; BJ-E  IntCiriCvAEggpj ł ͗֊sł͂ȂSŃJbg
    (setq pfuz '(0.6 0.6 0.0) ;; 0.6 ɕύX
          pfuz (mapcar (function (lambda (a) (* a dimsc))) pfuz)
          anga (angle pnext pt)
    )
    (setq pst  pnext
          loop T
    )
    (while loop 
      (if (not (setq ssa (ssget "C" (mapcar '- pnext pfuz)(mapcar '+ pnext pfuz) '((0 . "INSERT")))))
        (setq loop nil)
        (progn 
          (if (= (sslength ssa) 0) 
            (setq loop nil)
            (progn 
              (setq i     0
                    loop1 T
              )
              (while (and (< i (sslength ssa)) loop1) 
                (setq enamea (ssname ssa i)) ;; vlaobj (vlax-ename->vla-object enamea))
                (setq temp  (ifs_getBoundingBox enamea)
                      temp  (ifs_lineW (car temp) (cadr temp) (* 0.1 dimsc)) 
                      minpt (car temp)
                      maxpt (cadr temp)
                )
                (if (not (setq ssb (ssget "C" minpt maxpt '((0 . "LINE"))))) 
                  (setq loop  nil
                        loop1 nil
                  )
                  (progn 
                    (setq ssb (ssdel enext ssb))
                    (if (= (sslength ssb) 0) 
                      (setq loop  nil
                            loop1 nil
                      )
                      (progn 
                        (setq j     0
                              loop2 T
                        )
                        (while (and (< j (sslength ssb)) loop2 loop1) 
                          (setq enameb (ssname ssb j)
                                entb   (entget enameb)
                                pb1    (cdr (assoc 10 entb))
                                pb2    (cdr (assoc 11 entb))
                                angb   (angle pb1 pb2)
                          )
                          (if (ifs_is_douitu pst pt pb1 pb2);; ꒼ɖ߂
                            (progn 
                              (if (> (distance pst pb1) (distance pst pb2)) 
                                (setq pnext pb1)
                                (setq pnext pb2)
                              )
                              (setq enext enameb
                                    loop2 nil
                                    loop1 nil
                              )
                            )
                          )
                          (setq j (1+ j))
                        )
                        (if loop2 (setq loop nil))
                      )
                    )
                  )
                )
                (setq i (1+ i))
                (setq loop1 nil) ;; ubN͂PŏI
              )
            )
          )
        )
      )
    )
    pnext ;
  ) ;; end function

  (setq pfuz    '(0.1 0.1 0.0)
        pfuz (mapcar (function (lambda (a) (* a dimsc))) pfuz)
        ssm     (ssadd)
        sse10   (ssadd)
        sse11   (ssadd)
        ent     (entget ename)
        objname (cdr (assoc 0 ent))
  )
  (if (= objname "LINE") 
    (progn 
      (setq p1   (cdr (assoc 10 ent))
            p2   (cdr (assoc 11 ent))
            ang  (angle p1 p2)
            pick (ifs_to_senjouten pick p1 p2)
      )
      ;; pick ʒuɐ
      (if (setq ss (ssget "C" (mapcar '- pick pfuz)(mapcar '+ pick pfuz) '((0 . "LINE"))))
        (if (> (sslength ss) 1) 
          (progn 
            (prompt "\nLINE  2 {ȏ㑶݂܂D")
            (setq p1a nil
                  p2a nil
            )
          )
          (setq p1a (ifs_ssendpt ename p1 p2)
                p2a (ifs_ssendpt ename p2 p1) ;;΂
                p1a (polar p1a (angle p2a p1a) 0.1)
                p2a (polar p2a (angle p1a p2a) 0.1)
          )
        )
        ;; pick ʒuɐ
        (progn 
          ;;(princ "\npick ʒuɐ")
          (setq p1a  (ifs_ssendpt ename p1 p2)
                p2a  (ifs_ssendpt ename p2 p1) ;;΂
                p1a  (polar p1a (angle p2a p1a) 0.1)
                p2a  (polar p2a (angle p1a p2a) 0.1)
                pick (mapcar (function (lambda (a b) (/ (+ a b) 2.0))) p1 p2)
                topt (mapcar (function (lambda (a b) (+ a b))) pick dxyz)
          )
        )
      )
    )
    (if (= objname "INSERT") 
      (progn 
        ;;(princ "\nInSert!")
        (setq p1  (cdr (assoc 10 ent))
              p2  p1
              ang 0.0
              p1a p1
              p2a p1
        )
      )
    )
  )
  
  ;;擾
  (if (and p1a p2a
           (setq ss (ssget "C" (mapcar '- p1a pfuz)(mapcar '+ p2a pfuz) '((0 . "LINE")))))
    (progn 
      (setq i 0)
      (repeat (sslength ss) 
        (setq ename (ssname ss i)
              ent   (entget ename)
              p10   (cdr (assoc 10 ent))
              p11   (cdr (assoc 11 ent))
        )
        (if (ifs_is_douitu p1a p2a p10 p11)  
          (setq ssm (ssadd ename ssm)) ;;̂܂܈ړ
          (if (setq kp (inters p1a p2a p10 p11)) 
            (progn 
              (if (<= (distance kp p10) 0.01) 
                (setq sse10 (ssadd ename sse10))
              )
              (if (and kp (<= (distance kp p11) 0.01)) 
                (setq sse11 (ssadd ename sse11))
              )
            )
          )
        )
        (setq i (1+ i))
      )
    )
  )
  ;;ubN擾
  (if (and p1a p2a
           (setq ss (ssget "C" (mapcar '- p1a pfuz)(mapcar '+ p2a pfuz) '((0 . "INSERT")))))
    (progn 
      ;;̂܂܈ړ
      (setq i (1- (sslength ss)))
      (repeat (sslength ss) 
        (setq ename (ssname ss i)
              temp  (ifs_getBoundingBox ename)
              temp  (ifs_lineW (car temp) (cadr temp) (* 0.1 dimsc))
              ent   (entget ename)
              pt    (cdr (assoc 10 ent))
        )
        (if (ifs_isCrossWindow p1a p2a (car temp) (cadr temp))
          (setq ssm (ssadd ename ssm)) ;;̂܂܈ړ
          (setq ss (ssdel ename ss))
        )
        (setq i (1- i))
      )
      ;;;[_ubNɂ
      (setq i 0)
      (repeat (sslength ss) 
        (setq ename (ssname ss i)) ;; vlaobj (vlax-ename->vla-object ename))
        (setq temp  (ifs_getBoundingBox ename)
              temp  (ifs_lineW (car temp) (cadr temp) (* 0.1 dimsc))
              minpt (car temp)
              maxpt (cadr temp)
        )
        
        (if (setq ssb (ssget "C" minpt maxpt '((0 . "LINE")))) 
          (progn 
            (setq j 0)
            (repeat (sslength ssb) 
              (setq ename (ssname ssb j))
              (if (and (not (ssmemb ename sse10)) 
                       (not (ssmemb ename sse11))
                       (not (ssmemb ename ssm)))
                (progn 
                  (setq ent (entget ename)
                        p10 (cdr (assoc 10 ent))
                        p11 (cdr (assoc 11 ent))
                  )
                  ;; Ƃ肠P݂̂ɑΉ
                  (cond 
                    ((ifs_is_douitu p1a p2a p10 p11)
                      (setq ssm (ssadd ename ssm)))
                    ((or (and (ifs_isTateReal p1a p2a 0.001)(equal (car p1a)(car p10) 0.01))
                         (and (ifs_isYokoReal p1a p2a 0.001)(equal (cadr p1a)(cadr p10) 0.01)))
                      (setq sse10 (ssadd ename sse10)))
                    ((or (and (ifs_isTateReal p1a p2a 0.001)(equal (car p1a)(car p11) 0.01))
                         (and (ifs_isYokoReal p1a p2a 0.001)(equal (cadr p1a)(cadr p11) 0.01)))
                      (setq sse11 (ssadd ename sse11))) 
                  )
                )
              )
              (setq j (1+ j))
            )
          )
        )
        (setq i (1+ i))
      )
    )
  )
  ;;Ǐ]鑼̐}`擾
  (if T 
    (progn 
      ;; _ 3  2 Ԗڂ̒_[_Ɉv LWPOLYLINE ǉ
      (if (and p1a p2a (setq ss (ssget "C" p1a p2a '((0 . "LWPOLYLINE"))))) 
        (progn 
          (setq i 0)
          (repeat (sslength ss) 
            (setq ent (entget (ssname ss i)))
            (if (and (= (cdr (assoc 90 ent)) 3) (= (cdr (assoc 70 ent)) 0)) 
              (progn 
                (setq j    0
                      loop T
                      cnt  0
                )
                (while (and loop (< j (length ent))) 
                  (if (= (car (nth j ent)) 10) 
                    (progn 
                      (if (= (setq cnt (1+ cnt)) 2) 
                        (progn 
                          (setq lwpt (cdr (nth j ent))
                                lwpt (append lwpt '(0.0))
                          )
                          (if (or (equal p1a lwpt 0.2) (equal p2a lwpt 0.2)) 
                            (setq ssm (ssadd (ssname ss i) ssm))
                          )
                          (setq loop nil)
                        )
                      )
                    )
                  )
                  (setq j (1+ j))
                )
              )
            )
            (setq i (1+ i))
          )
        )
      )
      (if (and p1a p2a) 
        (progn 
          ;; ԁATEXTT
          (if (setq tateFlag (ifs_isTate p1a p2a))
            (setq deg 180.0)
            (setq deg 90.0)
          )
          (setq p1b (polar p1a (ifs_degToRad deg) (* 1.5 dimsc))
                p2b (polar p2a (ifs_degToRad deg) (* 1.5 dimsc))
          )
          ;;(command "_line" "none" p1b "none" p2b "")
          ;; INSERT ǉ
          (if (setq ss (ssget "C" p1b p2b '((0 . "*TEXT,INSERT") (8 . "*SENBAN"))))
            (progn 
              ;;̂܂܈ړ
              (setq i 0)
              (repeat (sslength ss) 
                ;; ړԂ̏cƍĂ邩
                (setq ret T)
                (setq ename (ssname ss i) ent (entget ename))
                (if (and (= (cdr (assoc 0 ent)) "INSERT")(wcmatch (setq bname (cdr (assoc 2 ent))) "SENBAN*"))
                  (progn
                    (setq deg (ifs_radToDeg (cdr (assoc 50 ent))))
                    (setq ret (ifs_isValidSbBlkName tateFlag bname deg))
                  )
                )
                (if ret
                  (setq ssm (ssadd (ssname ss i) ssm)) ;;̂܂܈ړ
                )
                (setq i   (1+ i))
              )
            )
          )
          ;; CIRCLE ǉ
          (if (setq ss (ssget "C" p1b p2b '((0 . "CIRCLE")))) 
            (progn 
              ;;̂܂܈ړ
              (setq i 0)
              (repeat (sslength ss) 
                (setq ssm (ssadd (ssname ss i) ssm) ;;̂܂܈ړ
                      i   (1+ i)
                )
              )
            )
          )
        )
      )
    )
  )
  (if (not copymode) 
    (progn
      (if (and ssm (> (sslength ssm) 0)) 
        (if (not topt) 
          (progn 
            (command "_MOVE" ssm "" "none" pick)
            (while (= (getvar "CMDNAMES") "MOVE") 
              (command pause)
            )
            (setq lastpt (getvar "LASTPOINT"))
            ;; Aړɐ
            (if (ifs_isTate pick lastpt)
              (setq topt (list (car pick)(cadr lastpt)(caddr lastpt)))
              (setq topt (list (car lastpt)(cadr pick)(caddr lastpt)))
            )           
            (if (not (equal lastpt topt))
              (command "_MOVE" ssm "" "none" lastpt topt)
            )
            (setq lastpt topt)    
          )
          (progn 
            (command "_MOVE" ssm "" "none" pick "none" topt)
            (setq lastpt topt)
          )
        )
      )

      ;;̒[_ړ
      (if (and lastpt (not (equal pick lastpt 0.001))) 
        (progn 
          (setq dx (- (car lastpt) (car pick))
                dy (- (cadr lastpt) (cadr pick))
                i  0
          )
          (if (> (sslength sse10) 0) 
            (repeat (sslength sse10) 
              (setq ent (entget (ssname sse10 i))
                    p10 (cdr (assoc 10 ent))
                    ent (subst (cons 10 (list (+ (car p10) dx)(+ (cadr p10) dy)(caddr p10))) (assoc 10 ent) ent)
              )
              (entmod ent)
              (setq i (1+ i))
            )
          )
          (setq i 0)
          (if (> (sslength sse11) 0) 
            (repeat (sslength sse11) 
              (setq ent (entget (ssname sse11 i))
                    p11 (cdr (assoc 11 ent))
                    ent (subst (cons 11 (list (+ (car p11) dx)(+ (cadr p11) dy)(caddr p11)))(assoc 11 ent) ent)
              )
              (entmod ent)
              (setq i (1+ i))
            )
          )
        )
      )
    )
    (if (and ssm (> (sslength ssm) 0)) 
      (progn
        (command "_COPY" ssm "" "none" pick)
        (while (= (getvar "CMDNAMES") "COPY") 
          (command pause)
        )
      )
    )
  )
  (setq ssm   nil
        sse10 nil
        sse11 nil
  )
)

;; ubN͂``ieXgpj
(defun c:bRect (/ my_error temp) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)

  (setq temp (ifs_getBoundingBox (car (entsel "\n`͈͂`ubNw : "))))
  (command "_UNDO" "BE")
  (command "_RECTANG" "_non" (car temp) "_non" (cadr temp))
  (command "_UNDO" "END")
  
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ubN̐}`𐧌āA`̈𓾂
(defun ifs_getBoundingBox (ename / objNames vlaObj objName xLst yLst lst 
                           layName layEnt maxPt minPt minPt2 minVpt2 maxPt2 maxVpt2 
                           res dellst explst item 
                          )
  (setq objNames "AcDbArc,AcDbLine,AcDbCircle,AcDbPolyline"
        vlaObj   (vlax-ename->vla-object ename)
        objName  (vla-get-ObjectName vlaObj)
  )
  (if (= objName "AcDbBlockReference") 
    (progn 
      (setq lst (ifs_func_blkExplode vlaobj))
      (setq explst (car lst) dellst (cadr lst))
      (foreach vlaObj explst 
        (if (wcmatch (vla-get-ObjectName vlaObj) objNames) 
          (progn 
            (setq layName (vla-get-layer vlaObj)
                  layEnt  (tblsearch "Layer" layName)
            )
            (if (= (cdr (assoc 70 layEnt)) 0);;70 = t[Y/bNĂȂ
              (progn 
                ;; `͈͂擾
                (vla-getboundingbox vlaObj 'minVpt2 'maxVpt2)
                (setq minPt2 (vlax-safearray->list minVpt2)
                      maxPt2 (vlax-safearray->list maxVpt2) ;;  XAY WXg
                      xLst   (append xLst (list (car minPt2) (car maxPt2)))
                      yLst   (append yLst (list (cadr minPt2) (cadr maxPt2)))
                )
              )
            )
          )
        )
      )
      ;;ꂽIuWFNg폜
      (if explst
        (foreach item explst 
          (vla-Delete item)
        )
      )
      ;; ς̃ubN폜
      (if dellst
        (foreach item dellst 
          (vla-Delete item)
        )
      )

      ;; XAY ̍ŏAől擾
      (setq minPt2 (list (apply 'min xLst) (apply 'min yLst) 0)
            maxPt2 (list (apply 'max xLst) (apply 'max yLst) 0)
      )
      (if (not (and (equal minPt minPt2 0.0001) (equal maxPt maxPt2 0.0001))) 
        (setq res T)
      )
    )
  )
  (list minPt2 maxPt2)
)

;; POINTXĝőȂQ_𓾂
;; 2_̂Ƃ͂̂܂ܕԂ
(defun ifs_get_max_pos (plist / cnt i j posa posb dist) 
  (setq cnt  (length plist)
        i    0
        posa nil
        posb nil
        dist 0.0
  )
  (if (> cnt 2) 
    (progn 
      (repeat cnt 
        (setq j (+ i 1))
        (repeat (- cnt i 1) 
          (if (> (distance (nth i plist) (nth j plist)) dist) 
            (setq dist (distance (nth i plist) (nth j plist))
                  posa (nth i plist)
                  posb (nth j plist)
            )
          )
          (setq j (1+ j))
        )
        (setq i (1+ i))
      )
    )
    (setq posa (car plist) posb (cadr plist))
  )
  (if (and posa posb) 
    (list posa posb)
    nil
  )
)

;; ꒼̔f
(defun ifs_is_douitu (p1 p2 p3 p4 / res kaku p1 p2 p3 p4 lg1 lg2) 
  (setq kaku (angle p1 p2)
        lg1  (* (distance p1 p3) (sin (- kaku (angle p1 p3))))
  )
  (if (equal 0 lg1 0.001) 
    (setq lg2 (* (distance p1 p4) (sin (- kaku (angle p1 p4))))
          res (equal 0 lg2 0.001)
    )
  )
  res
)

;; IZbg̐m
(defun ifs_lineJoint (ss pt minpt maxpt / i j ename1 ename2 edata1 edata2 sscnt ret 
                       ang ename ent kp p1 p2
                      ) 
  (if ss 
    (progn 
      (setq i     0
            sscnt (sslength ss)
      )
      ;;  ubN̒S܂ŉĂ
      (if (and pt minpt maxpt) 
        (repeat sscnt 
          (setq ename (ssname ss i)
                ent   (entget ename)
                p1    (cdr (assoc 10 ent))
                p2    (cdr (assoc 11 ent))
          )
          (if (ifs_inWindow p1 minpt maxpt) 
            (progn 
              ;; ΐOKv? 
              (setq ang (angle p1 p2))
              (if (setq kp (inters p1 p2 pt (polar pt (+ ang (/ PI 2.0)) 100.0) nil))
                (progn 
                  (setq ent (subst (cons 10 kp) (assoc 10 ent) ent))
                  (entmod ent)
                )
              )
            )
          )
          (if (ifs_inWindow p2 minpt maxpt) 
            (progn 
              (setq ang (angle p1 p2))
              (if (setq kp (inters p1 p2 pt (polar pt (+ ang (/ PI 2.0)) 100.0) nil))
                (progn 
                  (setq ent (subst (cons 11 kp) (assoc 11 ent) ent))
                  (entmod ent)
                )
              )
            )
          )
          (setq i (1+ i))
        )
      )

      (setq i 0)
      (while (< i (1- sscnt)) 
        (setq ename1 (ssname ss i)
              edata1 (entget ename1)
        )
        (setq j (1+ i))
        (while (< j sscnt) 
          (setq ename2 (ssname ss j)
                edata2 (entget ename2)
          )
          (if (= (cdr (assoc 0 edata1)) "LINE") 
            (if (= (cdr (assoc 0 edata2)) "LINE") 
              (progn 
                (if (setq ret (ifs_ketugou ename1 ename2)) 
                  (if (= (logand ret 1) 1) 
                    (setq edata1 (entget ename1))
                  )
                )
              )
            )
          )
          (setq j (1+ j))
        )
        (setq i (1+ i))
      )
    )
  )
)

;; ꒼̔fA
(defun ifs_ketugou (entnm1 entnm2 / entnm1 entnm2 entdt1 entdt2 pos1a pos1b pos2a 
                    pos2b max_pos lay1 lay2 ltype1 ltype2 ret col1 col2 p1a p1b p2a 
                    p2b midp a b
                   ) 
  (setq entdt1 (entget entnm1)
        entdt2 (entget entnm2)
        pos1a  (cdr (assoc 10 entdt1))
        pos1b  (cdr (assoc 11 entdt1))
        pos2a  (cdr (assoc 10 entdt2))
        pos2b  (cdr (assoc 11 entdt2))
  )
  (if (assoc 6 entdt1) 
    (setq ltype1 (cdr (assoc 6 entdt1)))
    (setq ltype1 "Bylayer")
  )
  (if (assoc 6 entdt2) 
    (setq ltype2 (cdr (assoc 6 entdt2)))
    (setq ltype2 "Bylayer")
  )
  (if (assoc 62 entdt1) 
    (setq col1 (cdr (assoc 62 entdt1)))
    (setq col1 "Bylayer")
  )
  (if (assoc 62 entdt2) 
    (setq col2 (cdr (assoc 62 entdt2)))
    (setq col2 "Bylayer")
  )
  (if (ifs_is_douitu pos1a pos1b pos2a pos2b)  ;; ꒼ł
    (if (and (= lay1 lay2) (= ltype1 ltype2) (= col1 col2))  ;; Fǉ
      (progn 
        (setq max_pos (ifs_get_max_pos (list pos1a pos1b pos2a pos2b)))
        (entdel entnm2)
        (setq entdt1 (subst (cons 10 (car max_pos)) (assoc 10 entdt1) entdt1)
              entdt1 (subst (cons 11 (cadr max_pos)) (assoc 11 entdt1) entdt1)
        )
        (entmod entdt1)
        (setq ret 1)
      )
      (progn 
        ;; ꒼Ő킪Ⴄ->_܂ŉ
        (setq max_pos (ifs_get_max_pos (list pos1a pos1b pos2a pos2b)))
        ;; Ԃ؂i󔒂j
        (if (> (distance (car max_pos) (cadr max_pos)) (+ (distance pos1a pos1b) (distance pos2a pos2b)))
          (progn 
            (setq p1a nil
                  p2a nil
                  p1b nil
                  p2b nil
            )
            (if (or (equal (car max_pos) pos1a) (equal (cadr max_pos) pos1a)) 
              (setq p1a pos1b
                    p1b pos1a
              )
              (setq p1a pos1a
                    p1b pos1b
              )
            )
            (if (or (equal (car max_pos) pos2a) (equal (cadr max_pos) pos2a)) 
              (setq p2a pos2b
                    p2b pos2a
              )
              (setq p2a pos2a
                    p2b pos2b
              )
            )
            (if (and p1a p2a p1b p2b) 
              (progn 
                (setq midp (mapcar (function (lambda (a b) (/ (+ a b) 2.0))) p1a p2a))
                (setq entdt1 (subst (cons 10 midp) (assoc 10 entdt1) entdt1)
                      entdt1 (subst (cons 11 p1b) (assoc 11 entdt1) entdt1)
                )
                (entmod entdt1)
                (setq entdt2 (subst (cons 10 midp) (assoc 10 entdt2) entdt2)
                      entdt2 (subst (cons 11 p2b) (assoc 11 entdt2) entdt2)
                )
                (entmod entdt2)
              )
            )
          )
        )
      )
    )
  )
  ret
)

;;_ւ̐̌_߂
;;ۂߏKv
(defun ifs_to_senjouten (pos p1 p2 / pos2) 
  (setq pos2 (polar pos (+ (angle p1 p2) (/ pi 2.0)) 100.0))
  (if (equal (car pos) (car pos2) 0.0001) (setq pos2 (list (car pos) (cadr pos2))))
  (if (equal (cadr pos) (cadr pos2) 0.0001) 
    (setq pos2 (list (car pos2) (cadr pos)))
  )
  (inters pos pos2 p1 p2 nil)
)
;; WIPEOUTiCvAEgjg[qV{iubNjőOʂɂ
(defun c:tbTop (/ cnt ss) 
  (setvar "CMDECHO" 0)
  (setq cnt 0)
  (if (setq ss (ssget "X" '((0 . "INSERT") (2 . "IntCir*,OutCir*,nsqtbwipeout*")))) 
    (if (> (setq cnt (sslength ss)) 0) 
      (progn 
        (command "DRAWORDER" ss "" "F")
        (princ (strcat "\n[qV{ " (itoa cnt) " ̕\őOʂɂ܂."))
      )
    )
  )
  (if (= cnt 0) 
    (princ "\n[qV{͂܂.")
  )
  (setvar "CMDECHO" 1)
  (princ)
)

;; ݂̕\͈͂̍AEW
(defun ifs_viewMinMax ( / p1 p2 scrsize viewCtr viewH viewW )
  (setq viewCtr (getvar "VIEWCTR")
        viewH (getvar "VIEWSIZE")
        scrsize (getvar "SCREENSIZE")
        viewW (* (/ viewH (cadr scrsize))(car scrsize))
        p1 (list (- (car viewctr) (/ viewW 2.0)) (- (cadr viewctr)(/ viewH 2.0)) 0.0)
        p2 (list (+ (car viewctr) (/ viewW 2.0)) (+ (cadr viewctr)(/ viewH 2.0)) 0.0)
  )
  (list p1 p2)
)

;; R[i[Q_𓾂
(defun ifs_getCorner( mes / loop p1 p2 pts dimsc a)
  (setq dimsc (getvar "DIMSCALE") p1 nil p2 nil)
  (setq loop T)
  (while loop
    (initget "L V")
    (setq p1 (getpoint (strcat "\n" mes "P_ڂw [L:0,0-420,297 /V:\͈] < V > : ")))
    (cond
      ((and p1 (listp p1))
          (if (setq p2 (getcorner p1 "\nQ_ڂw < P_ڎw > : "))
            (setq loop nil)
          ))
      ((or (not p1) (= p1 "V"))
        (setq pts (ifs_viewMinMax) 
              p1 (car pts) p2 (cadr pts)
              loop nil)) 
      ((= p1 "L")
        (setq p1 '(0 0 0) p2 '(420 297 0)
              p2 (mapcar (function (lambda (a) (* a dimsc))) p2)
              loop nil))
    )
  )
  (list p1 p2)         
)

;; [qubNɂȂԂ擾A[qubN̎5mm TEXT 擾A
;; [qz}쐬
;; TEXT D悳
(defun c:tbAry (/ ss len i ename ent pt pelist xmin ymin xmax ymax xsrt sbelist 
                sblist e1 e2 flag h item pts sb w x y
                orth ssA j dist distmin txlist txpt txt sblen txlen )
  ;; ԃubN "SENBAN00" ɑΉ
  ;; IJCADAZWCAD ̌ԏIłɑΉ
  (defun my_error(msg)
    (princ msg)
    (if ssA (command "DELETE" ssA ""))
    (command "_UNDO" "END")
    (if orth (setvar "ORTHOMODE" orth))
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setq sblen 0 txlen 0) 
  (setvar "CMDECHO" 0)
  (prompt "\n[qz}쐬[qubNIĂ ")
  (if (setq ss (ssget '((0 . "INSERT") (2 . "NSQTB*,OUTCIR*,INCIR*")))) 
    (progn 
      (setq len (sslength ss)
            i   0
      )
      (repeat len 
        (setq ename  (ssname ss i)
              ent    (entget ename)
              pt     (cdr (assoc 10 ent))
              pelist (append pelist (list (list pt ename)))
        )
        (if (= i 0) 
          (setq xmin (car pt)
                xmax xmin
                ymin (cadr pt)
                ymax ymin
          )
          (progn 
            (if (> xmin (car pt)) 
              (setq xmin (car pt))
              (if (< xmax (car pt)) (setq xmax (car pt)))
            )
            (if (> ymin (cadr pt)) 
              (setq ymin (cadr pt))
              (if (< ymax (cadr pt)) (setq ymax (cadr pt)))
            )
          )
        )
        (setq i (1+ i))
      )
      ;; X Ń\[g
      (setq xsrt (> (- xmax xmin) (- ymax ymin)))
    )
  )
  (if (not pelist)
    (princ "\n[q=0")
    (princ (strcat "\n[q=" (itoa (length pelist))))
  )
  (if pelist 
    (progn
      (if xsrt 
        (setq pelist (vl-sort pelist (function (lambda (e1 e2) (< (car  (car e1)) (car  (car e2)))))))
        (setq pelist (vl-sort pelist (function (lambda (e1 e2) (> (cadr (car e1)) (cadr (car e2)))))))
      )
      ;; ׂĂ̐Ԃ擾
      (setq pts (ifs_getCorner "̐Ԃo͈͂"))
      (setq sbelist (ifs_getSbeAll (car pts)(cadr pts) T nil))
    )
  )
  (if (not sbelist)
    (princ "\nԐ=0")
    (princ (strcat "\nԐ=" (itoa (length sbelist))))
  )
  ;; ex:  ((<}`: da29ac40> <}`: da29ac40>) (U2) 2) ̃Xg
  (if sbelist 
    (progn 
      (foreach item pelist
        ;; [qubN̊_͂̐擾
        (setq pts (ifs_pointW (car item) 2.0))
        ;;(command "RECTANG" "non" (car pts) "non" (cadr pts))
        (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE")(8 . "*WIRE*")(-4 . "<NOT")(8 . "WIREO")(-4 . "NOT>"))))
          (progn 
            (setq len  (length sbelist)
                  i    0
                  flag nil
            )
            (while (and (not flag) (< i len)) 
              ;; [qӂ̐ ename  qO[v ename ̃Xgɑ݂邩
              (setq j 0)
              (repeat (sslength ss);; ɑΉ
                (if (member (ssname ss j) (car (nth i sbelist))) 
                  (progn 
                    (setq sb (cadr (nth i sbelist)) flag T)
                    (if sb 
                      (setq sblist (append sblist (list (car sb))))
                      (setq sblist (append sblist (list nil)))
                    )
                  )
                )
                (setq j (1+ j))
              )
              (setq i (1+ i))
            )
            (if (not flag) 
              (setq sblist (append sblist (list nil)))
            )
          )
          (setq sblist (append sblist (list nil)))
        )
      )
    )
  )
  (setq txlist nil)
  (if pelist
    (progn
      (foreach item pelist
        (setq pts (ifs_pointW (car item) 5.0) txt nil)
        (if (setq ss (ssget "C" (car pts)(cadr pts) '((0 . "TEXT"))))
          (progn
            (setq distmin 100.0 i 0)
            (setq len (sslength ss))
            (if (= len 1)
              (setq txt (cdr (assoc 1 (entget (ssname ss 0)))))
              (repeat len
                (setq ent (entget (ssname ss i)))
                (if (and (= 0 (cdr (assoc 72 ent)))(= 0 (cdr (assoc 73 ent))))
                  (setq txpt (cdr (assoc 10 ent)))
                  (setq txpt (cdr (assoc 11 ent)))
                )
                (setq dist (distance (car item) txpt))
                (if (< dist distmin)(setq distmin dist txt (cdr (assoc 1 ent))))
                (setq i (1+ i))
              )
            )
          )
        )
        (setq txlist (append txlist (list txt)))
      )    
    )
  )
  ;;(princ "\n")(princ (length txlist))(princ txlist)
  ;;(princ "\n")(princ (length sblist))(princ sblist)
  (if txlist (setq txlen (length txlist)))
  (if sblist (setq sblen (length sblist)))
  (if (and (> txlen 0)(= txlen sblen))
    (progn 
      (setq w  5.0
            h  15.0
            x  (/ w 2.0)
            y  (/ h -2.0)
            i  0
            ssA (ssadd)
      )
      (repeat sblen 
        (if (setq ename (ifs_make_CRect (list x y 0) w h)) 
          (setq ssA (ssadd ename ssA))
        )
        (if (nth i txlist) ;; TEXT D悷
          (if (setq ename (ifs_make_Text "MC" (list x y 0) (nth i txlist) 2.5 0.8 (/ pi 2.0)))
            (setq ssA (ssadd ename ssA))
          )
          (if (nth i sblist) 
            (if (setq ename (ifs_make_Text "MC" (list x y 0) (nth i sblist) 2.5 0.8 (/ pi 2.0)))
              (setq ssA (ssadd ename ssA))
            )
          )         
        )
        (setq x (+ x w))
        (setq i (1+ i))
      )
      (if (> (sslength ssA) 0) 
        (progn 
          ;; IJCAD, ZWCAD ̌ԏIłł COPYBASE łȂ
          (command "_UNDO" "BE")
          (if (ifs_isTrial) ;; gCAłɑΉ
            (progn
              (prompt "\n쐬ʒuw : ")
              (setq orth (getvar "ORTHOMODE"))
              (setvar "ORTHOMODE" 0)
              (command "_COPY" ssA "" "none" '(0 0 0))
              (while (wcmatch (getvar "CMDNAMES") "COPY")
                (command pause)
              )
              (command "DELETE" ssA "")
              (setq ssA nil)
              ;;)
              (setvar "ORTHOMODE" orth)
            )
            (progn
              ;;(setvar "cmdecho" 1)
              (prompt "\n}ʒuw : ")
              (command "COPYBASE" "none" '(0 0 0) ssA "" )
              (command "DELETE" ssA "")
              (command "PASTECLIP")
              (while (wcmatch (getvar "CMDNAMES") "PASTECLIP")
                (command pause)
              )
            )
          )
          (command "_UNDO" "END")
        )
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; 2 _w RECTANGLE 쐬
(defun ifs_make_Rect (p1 p2 / layerName elast res ent) 
  (setq layerName "0")
  (setq ent (list '(0 . "LWPOLYLINE") 
                  (cons 8 layerName)
                  '(90 . 4)
                  '(70 . 1)
                  (cons 10 p1)
                  (cons 10 (list (car p2) (cadr p1) 0.0))
                  (cons 10 p2)
                  (cons 10 (list (car p1) (cadr p2) 0.0))
            )
  )
  (setq elast (entlast))
  (entmake ent)
  (if (not (equal elast (entlast))) 
    (setq res (entlast))
  )
  res
)

;; Sw RECTANGLE 쐬
(defun ifs_make_CRect (center w h / layerName elast res p1 p2 ent) 
  (setq layerName "0"
        p1        (list (- (car center) (/ w 2.0)) (- (cadr center) (/ h 2.0)) 0.0)
        p2        (list (+ (car center) (/ w 2.0)) (+ (cadr center) (/ h 2.0)) 0.0)
  )
  (setq ent (list '(0 . "LWPOLYLINE") 
                  (cons 8 layerName)
                  '(90 . 4)
                  '(70 . 1)
                  (cons 10 p1)
                  (cons 10 (list (car p2) (cadr p1) 0.0))
                  (cons 10 p2)
                  (cons 10 (list (car p1) (cadr p2) 0.0))
            )
  )
  (setq elast (entlast))
  (entmake ent)
  (if (not (equal elast (entlast))) 
    (setq res (entlast))
  )
  res
)
;; _ RECT 쐬
(defun ifs_make_LCRect (lc w h / layerName elast res p1 p2 ent) 
  (setq layerName "0"
        p1        (list (car lc) (- (cadr lc) (/ h 2.0)) 0.0)
        p2        (list (+ (car lc) w) (+ (cadr lc) (/ h 2.0)) 0.0)
  )
  (setq ent (list '(0 . "LWPOLYLINE") 
                  (cons 8 layerName)
                  '(90 . 4)
                  '(70 . 1)
                  (cons 10 p1)
                  (cons 10 (list (car p2) (cadr p1) 0.0))
                  (cons 10 p2)
                  (cons 10 (list (car p1) (cadr p2) 0.0))
            )
  )
  (setq elast (entlast))
  (entmake ent)
  (if (not (equal elast (entlast))) 
    (setq res (entlast))
  )
  res
)

;; TEXT 쐬
(defun ifs_make_Text (opt pt txt txtH txtW txtR / layerName styleName keisya code72 
                     code73 color elast res ent
                    ) 
  ;; code72 : 0 = 񂹁A1= A2 = E
  ;;					3 = [(ʒu킹 = 0 ̏ꍇ)
  ;;					4 = S(ʒu킹 = 0 ̏ꍇ)
  ;;					5 = tBbg(ʒu킹 = 0 ̏ꍇ)
  ;; code73 : 0 = A1 = A2 = A3 = 
  (cond 
    ((= opt "TL")
     (setq code73 3
           code72 0
     )
    )
    ((= opt "TC")
     (setq code73 3
           code72 1
     )
    )
    ((= opt "TR")
     (setq code73 3
           code72 2
     )
    )

    ((= opt "ML")
     (setq code73 2
           code72 0
     )
    )
    ((= opt "MC")
     (setq code73 2
           code72 1
     )
    )
    ((= opt "MR")
     (setq code73 2
           code72 2
     )
    )

    ((= opt "BL")
     (setq code73 1
           code72 0
     )
    )
    ((= opt "BC")
     (setq code73 1
           code72 1
     )
    )
    ((= opt "BR")
     (setq code73 1
           code72 2
     )
    )
    (T
     (setq code73 0
           code72 0
     )
    )
  )
  (setq layerName (getvar "CLAYER")
        styleName "Standard"
        color     256
        keisya    0.0
  )
  (setq ent (list '(0 . "TEXT") 
                  (cons 8 layerName)
                  (cons 7 styleName)
                  (cons 10 pt)
                  (cons 11 pt)
                  (cons 40 txtH)
                  (cons 1 txt)
                  (cons 41 txtW)
                  (cons 50 txtR)
                  (cons 51 keisya)
                  (cons 72 code72)
                  (cons 73 code73)
                  (cons 62 color)
            )
  )
  (setq elast (entlast))
  (entmake ent)
  (if (not (equal elast (entlast))) 
    (setq res (entlast))
  )
  res
)



;;_Kvł΂Ɍ_V{}
(defun ifs_kouten_handan (pos blkname / ss i ent1 ent2 p1 p2 p3 p4 flag blkname dimsc 
                          pt pts) 
  (setq dimsc (getvar "DIMSCALE"))
  (setq i    0
        flag nil
  )
  ;;Wӂ̐擾
  (setq pts (ifs_pointW pos (* 0.1 dimsc)))
  (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE"))))
    (progn 
      (repeat (1- (sslength ss)) 
        (setq ent1 (entget (ssname ss i))
              ent2 (entget (ssname ss (1+ i)))
        )
        (setq p1 (cdr (assoc 10 ent1))
              p2 (cdr (assoc 11 ent1))
              p3 (cdr (assoc 10 ent2))
              p4 (cdr (assoc 11 ent2))
        )

        (if (setq pt (inters p1 p2 p3 p4 T)) 
          (if (and (or (equal pt p1 0.01) 
                       (equal pt p2 0.01)
                       (equal pt p3 0.01)
                       (equal pt p4 0.01))
                    (not (and (equal pt p1 0.01) (or (equal pt p3 0.01) (equal pt p4 0.01))))
                    (not (and (equal pt p2 0.01) (or (equal pt p3 0.01) (equal pt p4 0.01)))))
            (setq flag T)
          )
        )
        (setq i (1+ i))
      )
      (setq ss nil)
    )
  )

  ;;Wt߂̌_ubN擾
  (setq pts (ifs_pointW pos (* 0.5 dimsc)))
  (setq ss (ssget "C" (car pts)(cadr pts) '((0 . "INSERT") (2 . "*KOUTEN*,*CMARK*"))))
    (setq i 0)
  (if (and (not ss) flag) 
    (ifs_insert_kouten blkname pos dimsc)
    (if (and ss (not flag)) 
      (repeat (sslength ss) 
        (entdel (ssname ss i))
        (setq i (1+ i))
      )
    )
  )
  (setq ss nil)
)

;; wWɃubN΍폜AΌ_V{}
(defun c:bKp (/ my_error dimsc pt ss i loop pfuz blkname) 
  (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
  )
  (setq *error* my_error)

  (setq dimsc (getvar "DIMSCALE")
        pfuz  '(0.5 0.5 0.5)
        loop  T
  )
  (if (tblobjname "BLOCK" "CMARK")
    (setq blkname "CMARK")
    (setq blkname "CMARK00")
  )
  (while loop 
    (if (setq pt (getpoint "\n_V{}/폜i]jWw < I > : ")) 
      (if (setq ss (ssget "C" (mapcar '- pt pfuz) (mapcar '+ pt pfuz) '((0 . "INSERT")(2 . "*KOUTEN*,*CMARK*"))))
        (if (> (sslength ss) 0) 
          (progn 
            (setq i 0)
            (repeat (sslength ss) 
              (entdel (ssname ss i))
              (setq i (1+ i))
            )
          )
          (ifs_insert_kouten blkname pt dimsc)
        )
        (ifs_insert_kouten blkname pt dimsc)
      )
      (setq loop nil)
    )
  )
  (setq *error* nil)
  (princ)
)

;; _}[N}BC WIREŒB
(defun ifs_insert_kouten (blkname pos sc / clay) 
  ;;ubN΍
  (if (not (tblsearch "BLOCK" blkname)) 
    (progn 
      (setvar "CMDECHO" 0)
      (setq clay (getvar "CLAYER"))
      (command "-LAYER" "M" "WIRE" "")
      (setvar "CLAYER" clay)
      (ifs_make_cmark blkname)
    )
  )
  (entmake 
    (list '(0 . "INSERT") ;berc:ber
          '(8 . "WIRE")
          (cons 2 blkname)
          (cons 10 pos)
          (cons 41 sc)
          (cons 42 sc)
          (cons 43 sc)
    )
  )
)

;; ubŇJbgÄꕔJbgB
(defun c:bEr( / my_error loop loop2 res snm mode mes)
  (defun my_error(msg)
    (princ msg)
    (setvar "SNAPMODE" snm)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)

  (setq loop T mode "D")
  (while loop 
    (setq loop2 T )
    (while loop2 
      (setq snm (getvar "SNAPMODE"))
      (setvar "SNAPMODE" 0)
      (initget "C D N Exit eXit")
      (cond
        ((= mode "D")
          (setq mes "\n폜ubNPIA܂͕폜̂P_w [N:ubN폜 /C:Jbg /E,X:I] : "))
        ((= mode "C")
          (setq mes "\nJbgubNPIA܂͕폜̂P_w [D/:PubN폜 /N:ubN폜 /E,X:I] : "))
        ((= mode "N")
          (setq mes "\n폜ubN̐}`I [D:PubN폜 /C:Jbg /E,X:I] : "))
      )
      (setq res (entsel mes)) 
      (setvar "SNAPMODE" snm)
      (cond 
        ((or (= res "Exit")(= res "eXit"))
          (setq loop  nil loop2 nil))
        ((and res (not (listp res))(wcmatch res "C,N,D"))
          (setq mode res))
      )
      (if (and res (listp res))
        (progn
          (setq loop2 nil)
          (cond
            ((= mode "D")
              (ifs_do_berS (car res)(cadr res)))
            ((= mode "C")
              (ifs_do_bcut (car res)(cadr res)))
          )
        )
        (if (and loop (= mode "N"))
          (ifs_do_berN)
        )
      )
    )
  )
  (setvar "SNAPMODE" snm)
  (setq *error* nil)
  (princ)
)

(defun ifs_do_bcut(ename pick / objname)
  ;;(princ ename)
  (setq objname (cdr (assoc 0 (entget ename))))
  (command "_UNDO" "BE")
  (cond
    ((= objname "LINE")  
      (ifs_sq_lcut ename pick 1))
    ((= objname "INSERT")
      (ifs_sub_btrimvx ename))
    ((= objname "TEXT")  
      (entdel ename))
  )
  (command "_UNDO" "END")
)

;; Jbg
;; mode =1: ̌_}[N܂ŃJbg/ =0: ̌_܂ŃJbg
(defun ifs_sq_lcut (ename pick mode / i j koulist ent ent2 p0 p1 p2 p3 p4 ss len 
                    kouten e1 e2 distmin pa_list p0_list pa k n dimsc pts blkname) 
  (setq dimsc (getvar "DIMSCALE"))
  (setq ent (entget ename))
  (setq p1 (cdr (assoc 10 ent))
        p2 (cdr (assoc 11 ent))
  )
  (setq pick (ifs_to_senjouten pick p1 p2))
  (setq j       1
        pa_list nil
        p0_list nil
  )
  (repeat 2 
    (setq koulist nil
          distmin nil
          i       0
    )
    (if (= j 1) (setq p0 p1) (setq p0 p2))
    ;;mode=1
    (setq pa nil)
    (if (= mode 1) 
      (progn 
        (if (setq ss (ssget "F" (list pick p0) '((0 . "INSERT") (2 . "*KOUTEN*,*CMARK*"))))
          (progn 
            (setq n (sslength ss)
                  k 0
            )
            (repeat n 
              (setq koulist (cons (cdr (assoc 10 (entget (ssname ss k)))) koulist))
              (setq k (1+ k))
            )
            (setq ss nil)
          )
        )
        (if koulist 
          (setq koulist (vl-sort koulist (function (lambda (e1 e2) (< (distance pick e1) (distance pick e2)))))
                pa      (car koulist)
          )
        )
      )
      ;; mode 2
      (progn 
        (setq pts (ifs_lineCP pick p0 (* 0.1 dimsc)))
        (setq ss (ssget "CP" pts '((0 . "LINE"))))
        (setq ss (ssdel ename ss)) ;;g
        (if (and ss (setq len (sslength ss))) 
          (repeat len 
            (setq ent2 (entget (ssname ss i)))
            (setq p3 (cdr (assoc 10 ent2))
                  p4 (cdr (assoc 11 ent2))
            )
            (if (setq kouten (inters pick p0 p3 p4)) 
              (setq koulist (cons kouten koulist))
            )
            (setq i (1+ i))
          )
        )
        (setq ss nil)
      )
    )
    (if koulist 
      (setq koulist (vl-sort koulist (function (lambda (e1 e2) (< (distance pick e1) (distance pick e2)))))
            pa      (car koulist)
      )
    )
    (if pa 
      (setq pa_list (cons pa pa_list)) ;;_i[
      (setq p0_list (cons p0 p0_list)) ;;[_i[
    )
    (setq j (1+ j))
  )
  ;;_
  (if pa_list 
    (progn 
      (if (= (length pa_list) 1) (setq pa_list (append pa_list p0_list)))
      ;;(setvar "CMDECHO" 0)
      (command "BREAK" ename "none" (car pa_list) "none" (cadr pa_list))
    )
    (progn 
      (setq pa_list p0_list)
      (entdel ename)
    )
  )
  (if (and pa_list (= mode 1)) 
    (progn
      (if (tblobjname "BLOCK" "CMARK")
        (setq blkname "CMARK")
        (setq blkname "CMARK00")
      )
      (ifs_kouten_handan (car pa_list) blkname)
      (ifs_kouten_handan (cadr pa_list) blkname)
    )
  )
)

;; AubN̊ԊuψɕύX.qubNAꏏɈړ
(defun c:bPtF (/ my_error p1 p2 ss sscnt i ename ent ang kouten klist item minpt 
                maxpt dpit d dist klist2 n pick pts topt stename loop temp e1 e2 dimsc
               p10 p11 main ngFlag)
  ;; tFXȊΏۂǰԂƌołȂ  
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setq dimsc (getvar "DIMSCALE"))
  (setvar "CMDECHO" 0)
  (setq main T)
  (while main
    (setq p2 nil ss nil klist nil stename nil ngFlag nil)
    (if (setq p1 (getpoint "\nAubN̊Ԋu𑵂tFXÎP_ڂw < I > : ")) 
      (progn 
        (initget 32);;o[oh܂̓o[oh {bNX`
        (setq p2 (getpoint p1 "\nQ_ڂw < I > : "))
      )
      (setq main nil)
    )
    (if (not p2)(setq main nil))
    (if p2 
      (progn
        (if (ifs_isTate p1 p2)
          (setq p2 (list (car p1)(cadr p2)(caddr p1)))
          (setq p2 (list (car p2)(cadr p1)(caddr p1)))
        )
        (setq ss (ssget "F" (list p1 p2) '((-4 . "<OR") (0 . "LINE")
                                                        (-4 . "<AND")(0 . "INSERT") 
                                                                     (-4 . "<NOT") (2 . "*KOUTEN*,*CMARK*")(-4 . "NOT>")
                                                        (-4 . "AND>")
                                           (-4 . "OR>")))
        )
      )
    )
    (if ss 
      (if (> (abs (- (car p1) (car p2))) (abs (- (cadr p1) (cadr p2)))) 
        (setq p2 (list (car p2) (cadr p1)(caddr p2)))
        (setq p2 (list (car p1) (cadr p2)(caddr p2)))
      )
    )
    (if ss 
      (progn 
        (setq sscnt (sslength ss)
              i     0
        )
        (repeat sscnt 
          (setq ename (ssname ss i)
                ent   (entget ename)
          )
          ;;(redraw ename 3)
          (if (= (cdr (assoc 0 ent)) "INSERT") 
            (setq kouten (ifs_to_senjouten (cdr (assoc 10 ent)) p1 p2))
            (setq kouten (inters p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent)) nil))
          )
          (if kouten 
            (setq klist (cons (list kouten ename) klist))
          )
          (setq i (1+ i))
        )
      )
    )
    (if (and klist (> (length klist) 1)) 
      (progn 
        ; p1̋ŕבւ
        (setq klist (vl-sort klist (function (lambda (e1 e2) (< (distance p1 (car e1)) (distance p1 (car e2)))))))
        ;;dWO
        (setq klist2 (list (car klist))
              pts    (car (car klist))
              klist  (cdr klist)
        )
        (foreach item klist 
          (if (not (equal pts (car item) 0.01)) 
            (setq klist2 (cons item klist2)
                  pts    (car item)
            )
            ;;(redraw (cadr item) 4)
          )
        )
        (setq klist2 (reverse klist2)) ;; consgp̂ߔ]
        (setq klist  klist2
              klist2 nil
        )
        (if (> (setq n (length klist)) 1) 
          (progn 
            (command "_UNDO" "BE")
            (princ "\nI :")
            (princ n)
            (setq minpt (car (car klist))
                  maxpt (car (car (reverse klist)))
            )
            (setq stename (cadr (car klist)))
            (setq ang (angle p1 p2)
                  n   (length klist)
            )
            (setq dpit (/ (distance minpt maxpt) (* (1- n) 1.0)))
            (if (setq dist (getdist (strcat "\neԂ̋ (=" (rtos (/ dpit dimsc)) ") <Eneter=I> : ")))
              (progn 
                (setq dist (* dist dimsc))
                (setq klist (cdr klist))
                (if (> dpit dist)  ;;k܂
                  (setq d dist)
                  (setq d     (* (length klist) dist)
                        klist (reverse klist)
                  )
                )
                (foreach item klist 
                  (setq ename (cadr item) pick (car item))
                  ;;(redraw ename 4)
                  (setq topt (polar minpt ang d))
                  (if (= (cdr (assoc 0 (entget ename))) "INSERT") 
                    (progn 
                      (setq temp (ifs_getBoundingBox ename))
                      (setq temp (ifs_lineW (car temp) (cadr temp) (* 0.1 dimsc)))
                      (if (and (setq ss (ssget "C" (car temp) (cadr temp) '((0 . "LINE")))) 
                              (> (sslength ss) 0))
                        (progn 
                          ;; px͖̐
                          (setq loop T
                                i    0
                          )
                          (while (and loop (< i (sslength ss))) 
                            (setq ent (entget (ssname ss i)) p10 (cdr (assoc 10 ent)) p11  (cdr (assoc 11 ent)))
                            ;; ύX
                            (if (not (or (and (ifs_isTateReal p1 p2 0.01)(ifs_isTateReal p10 p11 0.01))
                                         (and (ifs_isYokoReal p1 p2 0.01)(ifs_isYokoReal p10 p11 0.01))))
                              (setq ename (ssname ss i)
                                    loop  nil
                              )
                              (setq ngFlag T);; tFXIƕs
                            )
                            (setq i (1+ i))
                          )
                        )
                        ;;q= ubN̎
                        (progn 
                          (command "_MOVE" ename "" "none" pick "none" topt)
                        )
                      )
                    )
                  )
                  (ifs_sub_lmove ename pick topt nil)
                  (if (> dpit dist) 
                    (setq d (+ d dist))
                    (setq d (- d dist))
                  )
                )
              )
              (redraw)
            )
            (command "_UNDO" "END")
          )
          (redraw)
        )
      )
    )
    (if ngFlag
      (princ "\nIubŇƃtFXIsłD")
    )
    ; (if stename 
    ;   (redraw stename 4)
    ; )
  )  
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ifs_lineCP ̃eXgp
(defun c:lnRect (/ p1 p2 pts) 
  (setq p1 (getpoint "\nn_w : "))
  (setq p2 (getpoint p1 "\nI_w : "))
  (setq pts (ifs_lineCP p1 p2 0.5))
  (command "_PLINE" 
           "none"
           (car pts)
           "none"
           (cadr pts)
           "none"
           (caddr pts)
           "none"
           (cadddr pts)
           "C"
  )
  (princ)
)

;; q̐FύXieXgpj
(defun c:lBl2(/ lst a dimsc p1 p2 loop len i elst flag ename esel)
  ;; w WIRE*  WIREO* łȂAAF BYLAYER ̂
  ;; ~ʂŌqɂ͔ΉB΂ߐOK
  (setq dimsc (getvar "DIMSCALE"))
  (setq p1 '(0.0 0.0 0.0)
        p2 '(420.0 297.0 0.0)
  )
  (setq p2 (mapcar (function (lambda (a) (* a dimsc))) p2))
  (if (setq esel (entsel))
    (progn 
      (setvar "CMDECHO" 0)
      (if (= "Bricsys" (getvar "VENDORNAME")) ;; bricscad
        (command "_ZOOM" "none" p1 "none" p2) ;; bricscad
      )
      (setq lst (ifs_getSbeAll p1 p2 nil nil)) ;; TB ܂߂Ȃ    
      (setq ename (car esel) loop T len (length lst) i 0)
      (while (and loop (< i len))
        (setq elst (car (nth i lst)))
        (if (member ename elst)
          (setq loop nil flag T)
        )
        (setq i (1+ i))
      )
      (if flag 
        (progn
          (ifs_nsq_blink2 elst 1 256 50 5)
        )
      )
      (setvar "CMDECHO" 1)
    )
  )
  (princ)
)

;; Q̐ԃXgɓԂ݂邩
(defun ifs_func_checkSbSame( lst1 lst2 / sblst1 sblst2 sb1 sb2 res )
  ;;(princ "\ncheck=")(princ lst1)(princ " : ")(princ lst2)
  (setq sblst1 (cadr lst1) sblst2 (cadr lst2))
  (if (and sblst1 sblst2 )
    (progn
      (foreach sb1 sblst1
         (foreach sb2 sblst2
           ;;(princ "\n")(princ sb1)(princ " : ")(princ sb2)
           (if (= sb1 sb2)
             (progn
               (setq res (append res (list sb1)))
             )
           )
         )
      )
    )
  )
  ;; Ԃ̃XgԂ
  res
)

;; 񃊃Xg\[g@d͐
;; ̂
(defun ifs_sort (slist / lst s)
  (foreach s  slist 
    (if (not (member s lst))
      (setq lst (append lst (list s)))
    )
  )
  (vl-sort lst '<)
)

;; ׂĂ̐Ԃ擾A( )̃XgԂ
(defun ifs_getSenbanAll( / ss i lst lst2 res cnt s s2 )
  (setq i 0)
  (if (setq ss (ssget "X"'((0 . "INSERT")(2 . "*SENBAN*"))))
    (repeat (sslength ss)
      (if (setq s (ifs_getAttValue (ssname ss i) "SENBAN"))
        (setq lst (append lst (list s)))
      )
      (setq i (1+ i))
    )
  )
  (if lst
    (progn
      (setq lst2 (ifs_sort lst))
      (foreach s2 lst2
        (setq cnt 0)
        (foreach s lst
          (if (= s2 s)(setq cnt (1+ cnt)))
        )
        (setq res (append res (list (list s2 cnt))))
      )
    )
  )
  res
)

;; ׂĂ̋@햼擾A(@햼 )̃XgԂ
(defun ifs_getNameAll( / ss i lst lst2 res cnt s s2 name s1)
  (setq i 0)
  (if (setq ss (ssget "X"'((0 . "INSERT"))))
    (repeat (sslength ss)
      (setq name "")
      (setq s (ifs_getAttValue (ssname ss i) "NAME"))
      (setq s1 (ifs_getAttValue (ssname ss i) "NAME1"))
      (if s (setq name s))
      (if s1 (setq name (strcat name s1)))
      (if (/= name "")  
        (setq lst (append lst (list name)))
      )
      (setq i (1+ i))
    )
  )
  (if lst
    (progn
      (setq lst2 (ifs_sort lst))
      (foreach s2 lst2
        (setq cnt 0)
        (foreach s lst
          (if (= s2 s)(setq cnt (1+ cnt)))
        )
        (setq res (append res (list (list s2 cnt))))
      )
    )
  )
  res
)

;; ԃ`FbN
;; 2023/04/20 A[XV{̎擾ǉ
(defun c:sbChk(/ lst p1 p2 len i j ename item ssDbl ssNon ssSam nonCnt dblCnt samCnt
               sblst sblen item2 ss dblStr samStr sb pts kw emark)
  ;; `FbNΏۂ̐: ͈=0,0 - 420,297 + w WIRE*  WIREO łȂ + AF BYLAER
  ;; _V{ *CMARK*,*KOUTEN*
  (setq pts (ifs_getCorner "ԃ`FbN͈͂")
        p1 (car pts) p2 (cadr pts)
  )
  ;; 2023/04/20 A[XV{̎擾ǉ
  (setq emark "E_T1,E_T00,F-E_T1,E_T01")
  ;; ʂɎ擾ꍇ́ÃRgO
  ; (if (setq esel (entsel "\nA[XV{I < Ȃ> : "))
  ;   (progn
  ;     (setq ent (entget (car esel)))
  ;     (if (= "INSERT" (cdr (assoc 0 ent)))
  ;       (setq emark (cdr (assoc 2 ent)))
  ;     )
  ;   )
  ; )
  
  (initget "Yes No")
  (if (not (setq kw (getkword "\n[qV{Ɍq BYLAYER ̐𓯂zƔf܂H [Yes /No] < Yes > : ")))
    (setq kw "Yes")
  )

  (setvar "CMDECHO" 0)
  ;; IJCAD, ZWCAD ł̓Y[sv
  (if (= "Bricsys" (getvar "VENDORNAME")) ;; bricscad
    (command "_ZOOM" "none" p1 "none" p2)  
  )
  ;; q̂AԁAz̃Xg擾
  ;; TBAEmark Ɍq𓯂zƔf邩 
  (setq lst (ifs_getSbeAll p1 p2 (= kw "Yes") emark)) 
  ;;(princ lst)
  (setq ssNon (ssadd) ssDbl (ssadd) ssSam (ssadd) nonCnt 0 dblCnt 0 samCnt 0 dblStr " " samStr " ")
  (setq len (length lst) i 0)
  (repeat len 
    (setq item (nth i lst))
    ;; Ԗ
    (if (not (setq sblst (cadr item)))
      (progn
        (setq nonCnt (1+ nonCnt))
        (foreach ename (car item)
          (setq ssNon (ssadd ename ssNon))
        )
      )
      (progn
        (setq sblst (ifs_sort sblst) sblen (length sblst))
        ;; Ԃ̐2ȏňقȂ=_u
        (if (>= sblen 2)
          (progn
            (setq dblCnt (1+ dblCnt))
            (foreach ename (car item)
              (setq ssDbl (ssadd ename ssDbl))
            )
            (foreach sb sblst
              (if (not (vl-string-search (strcat " " sb " ") dblStr))
                (setq dblStr (strcat dblStr sb " "))
              )
            )
          )
        )
        ;; Ԃ̐1ȏŁA̔z̐ԂƓ=d
        ;; 2023/04/05 lwp _̔rǉ
        (setq j 0)
        (repeat len
          (if (/= i j)
            (progn
              (setq item2 (nth j lst))           
              (if (setq sblst (ifs_func_checkSbSame item item2))
                ;; ǂ炩LWP_Ȃ 2023/04/05
                ;; ǂ炩ɃA[XV{Ȃ 2023/04/20
                (if (and (not (and (cadddr item)(cadddr item2))) (not (and (nth 4 item)(nth 4 item2))))
                ;;(if (not (and (cadddr item)(cadddr item2)))
                  (progn
                    (setq samCnt (1+ samCnt))
                    (foreach ename (car item)
                      (setq ssSam (ssadd ename ssSam))
                    )                  
                    (foreach ename (car item2)
                      (setq ssSam (ssadd ename ssSam))
                    )               
                    (foreach sb sblst
                      (if (not (vl-string-search (strcat " " sb " ") samStr))
                        (setq samStr (strcat samStr sb " "))
                      )
                    )
                  )
                )
              )
            )
          )
          (setq j (1+ j))
        )
       
      )
    )
    (setq i (1+ i))
  ) 
  ;; \FύXpSS쐬
  (setq ss (ssadd))
  (if (> (setq len (sslength ssNon)) 0)
    (progn
      (setq i 0)
      (repeat len
        (setq ss (ssadd (ssname ssNon i) ss) i (1+ i))
      )
    )
  )
  (if (> (setq len (sslength ssDbl)) 0)
    (progn
      (setq i 0)
      (repeat len
        (setq ss (ssadd (ssname ssDbl i) ss) i (1+ i))
      )
    )
  )
  (if (> (setq len (sslength ssSam)) 0)
    (progn
      (setq i 0)
      (repeat len
        (setq ss (ssadd (ssname ssSam i) ss) i (1+ i))
      )
    )
  )  
  (princ "\n`FbNΏۂ̐: w WIRE*  WIREO łȂ + AF BYLAER")
  (princ "\n_V{:*KOUTEN*,*CMARK* A[XV{:E_T1,E_T00,F-E_T1,E_T01")
  (princ "\n̒[_Ƀ|C̒_AA[XV{铯Ԃ͓̐zƔf")
  
  (if (> (sslength ss) 0)
    (progn
      (princ "\nԖ = ")(princ nonCnt) 
      (princ " /zɈႤԂ = ")(princ dblCnt)
      (if (> dblcnt 0)
        (princ (strcat " (" dblStr ")"))
      )
      (princ " /ႤzɓԂ = ")(princ samCnt) 
      (if (> samcnt 0)
        (princ (strcat " (" samStr ")"))
      )  
      (command "_CHPROP" ss "" "C" "6" "");;bricscad
      (initget "Yes No")
      (if (/= "No" (getkword "\n\ɖ߂܂H [Yes /No] < Yes > : "))
        (progn
          (command "_CHPROP" ss "" "C" "BYLAYER" "")
          (if (= "Bricsys" (getvar "VENDORNAME")) ;; bricscad
            (command "_ZOOM" "PRE")  
          )
        )
      )    
    )
    (progn
      (princ "\nԖAdԁAdԂ̔z͂܂D")
      (if (= "Bricsys" (getvar "VENDORNAME")) ;; bricscad
        (command "_ZOOM" "PRE")  
      )
    )
  )
  (setvar "CMDECHO" 1)
  (princ)
)

;; q擾̃eXg
(defun c:lBl1 (/ lst)
  ;; wA͖Ȃ FBYLAYER̂
  ;; ~ʂŌqo
  (if (setq lst (ifs_get_line_all (car (entsel))))
    (ifs_nsq_blink2 lst 1 256 50 5)
  )
  (princ "\n")
  (princ)
)

;; Ԏ擾ieXgpj
(defun c:getsenban () 
  (princ (ifs_get_senbanEnames (car (entsel))))
  (princ)
)

;; qĂ邷ׂĂ̐ EntityName 𓾂
;; 肱ڂ
(defun ifs_get_line_all (ename / koutenlist loop linelist0 lineall koutenall item0 
                         item item2 linelist temp linelist1
                        cnt) 
  (if (not (setq loop (= (cdr (assoc 0 (entget ename))) "LINE")))
    (princ "\nLINE ł͂܂D")
  )
  (setq linelist0 (list ename)
        lineall   nil
        koutenall nil
        cnt 0
  )
  (while (and loop (< cnt 100));; [v
    (setq cnt (1+ cnt))
    (if (>= cnt 100)(princ "\nLINE-ALLE over"))
    (setq linelist1 nil)
    (foreach item0 linelist0 
      ;;q𓾂
      (if (setq linelist (ifs_get_line_line item0 lineall)) 
        (progn 
          (setq lineall (append lineall linelist))
          ;;ׂ̐̂Ă̌_𓾂
          (setq koutenall nil)
          (foreach item linelist 
            (setq koutenlist (ifs_get_line_kouten item))
            (foreach item2 koutenlist 
              (setq koutenall (cons item2 koutenall))
            )
          )
          (if koutenall 
            (progn 
              (foreach item koutenall 
                (setq temp (ifs_get_point_line item lineall '(0.1 0.1 0.0)))
                (if temp 
                  (setq linelist1 (append linelist1 temp))
                )
              )
            )
          )
        )
      )
    )
    (if linelist1 
      (setq linelist0 linelist1)
      (setq loop nil)
    )
  )
  lineall ;
)

;; ɂȂǂĂ
(defun ifs_get_line_line (ename jogailist / i res loop ent plist item nextpt ss sscnt 
                          ename2 ename1 ent2 p3 p4 flag flag2 entyp p0 r pfuz
                         cnt ) 
  (setq pfuz '(0.1 0.1 0.0));;0.001
  (if (not (member ename jogailist)) (setq res (list ename)))
  (setq ent   (entget ename)
        plist (list (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))
  )
  (foreach item plist 
    (setq nextpt item
          loop   T
          ename1 ename
          cnt 0
    )
    (while (and loop (< cnt 100)) 
      (setq cnt (1+ cnt))
      (if (>= cnt 100)
        (princ "\nLINE-LINE orver")
      )
      (if 
        (setq ss (ssget "C" 
                        (mapcar '+ nextpt pfuz)
                        (mapcar '- nextpt pfuz)
                        '((0 . "LINE,ARC") (62 . 256))
                 )
        )
        (progn 
          (if (> (setq sscnt (sslength ss)) 1) 
            (progn 
              (setq flag nil
                    i    0
              )
              (repeat sscnt 
                (setq ename2 (ssname ss i))
                (if (and (not (equal ename1 ename2)) 
                         (not (member ename2 jogailist)))
                  (progn 
                    (setq ent2  (entget ename2)
                          entyp (cdr (assoc 0 ent2))
                    )
                    (if (= entyp "ARC") 
                      ;;~ʒ[_̃Xg
                      (setq p0 (cdr (assoc 10 ent2))
                            r  (cdr (assoc 40 ent2))
                            p3 (polar p0 (cdr (assoc 50 ent2)) r)
                            p4 (polar p0 (cdr (assoc 51 ent2)) r)
                      )
                      ;;̒[_
                      (setq p3 (cdr (assoc 10 ent2))
                            p4 (cdr (assoc 11 ent2))
                      )
                    )
                    (setq flag2 T)
                    (if (equal nextpt p3 0.1) 
                      (setq nextpt p4)
                      (if (equal nextpt p4 0.1) 
                        (setq nextpt p3)
                        (setq flag2 nil)
                      )
                    )
                    (if flag2 
                      (progn 
                        (setq flag   T
                              ename1 ename2
                        )
                        (if (= entyp "LINE") 
                          (setq res (cons ename2 res))
                        )
                      )
                    )
                  )
                )
                (setq i (1+ i))
              )
              (setq loop flag)
            )
            (setq loop nil)
          )
          (setq ss nil)
        )
        (setq loop nil)
      )
    )
  )
  res ;
)

;; ̌_}[N𓾂
(defun ifs_get_line_kouten (ename / res ent p1 p2 ss sscnt i p0) 
  (setq res nil
        ent (entget ename)
  )
  (setq p1 (list (cdr (assoc 10 ent)) p2 (cdr (assoc 11 ent))))
  (if 
    (setq ss (ssget "F" (list (cdr (assoc 10 ent)) (cdr (assoc 11 ent))) '((0 . "INSERT")(2 . "*KOUTEN*,*CMARK*"))))
    (progn 
      (setq sscnt (sslength ss)
            i     0
      )
      (repeat sscnt 
        (setq ent (entget (ssname ss i))
              p0  (cdr (assoc 10 ent))
        )
        (setq res (cons p0 res))
        (setq i (1+ i))
      )
      (setq ss nil)
    )
  )
  res ;
)
;; W̐擾
(defun ifs_get_point_line (pt jogailist pfuz / ss res sscnt i ename) 
  (setq res nil)
  (if (setq ss (ssget "C" (mapcar '+ pt pfuz)(mapcar '- pt pfuz) '((0 . "LINE") (62 . 256))))
    (progn 
      (setq sscnt (sslength ss)
            i     0
      )
      (repeat sscnt 
        (setq ename (ssname ss i))
        (if (not (member ename jogailist)) 
          (setq res (cons ename res))
        )
        (setq i (1+ i))
      )
      (setq ss nil)
    )
  )
  res ;
)

;; ename Ɍq̐ enames 𓾂
;; ԃubNp
;; ̊pxԃubNŔfĂ
(defun ifs_get_senbanEnames (ename / llist ename2 ent2 p1n p2n p1m p2m ss i j len 
                              lensb tateFlag sbenames dist blkname rot ent pfuzx pfuzy deg
                             ) 
  (setq dist (* 2.25 (getvar "DIMSCALE")))
  (setq pfuzx (list dist 0.0 0.0)
        pfuzy (list 0.0 dist 0.0)
  )
  (if (setq llist (ifs_get_line_all ename)) 
    (progn 
      (setq j   0
            len (length llist)
      )
      (repeat len 
        (setq ename2   (nth j llist)
              ent2     (entget ename2)
              p1n      (cdr (assoc 10 ent2))
              p2n      (cdr (assoc 11 ent2))
              tateFlag (ifs_isTate p1n p2n)
        )
        (if tateFlag 
          (setq p1m (mapcar '- p1n pfuzx)
                p2m (mapcar '- p2n pfuzx)
          )
          (setq p1m (mapcar '+ p1n pfuzy)
                p2m (mapcar '+ p2n pfuzy)
          )
        )
        (setq i 0)
        (if (setq ss (ssget "F" (list p1m p2m) '((0 . "INSERT") (8 . "*")(2 . "*SENBAN*"))))  ;; _TEXT ݂̂Ȃ̂ŗvC
          (progn 
            (setq lensb (sslength ss)
                  i     0
            )
            (repeat lensb 
              (setq ent     (entget (ssname ss i))
                    blkname (cdr (assoc 2 ent))
                    rot     (cdr (assoc 50 ent))
                    deg     (ifs_radToDeg rot)
              )
              ;;(if (>= rot (* PI 2.0))(setq rot (- rot (* PI 2.0))))
              ;;(princ deg)
              ;;(if (equal deg 360.0 1.0)(setq deg 0.0))
              ;; ̊pxɍԃubN
              (if (ifs_isValidSbBlkName tateFlag blkname deg)
                
                ; (or (and tateFlag (or (= blkname "SENBAN") (and (= blkname "SENBAN00") (equal deg 90.0 1.0))))
                ;       (and (not tateFlag) (or (= blkname "SENBAN1") (and (= blkname "SENBAN00") (equal deg 0.0 1.0)))))
                (setq sbenames (append sbenames (list (ssname ss i))))
              )
              (setq i (1+ i))
            )
            (setq ss nil)
          )
        )
        (setq j (1+ j))
      )
    )
  )
  sbenames
)

;; FύX
(defun ifs_nsq_set_color (ename col / ent) 
  (setq ent (entget ename))
  (if (assoc 62 ent) 
    (entmod (subst (cons 62 col) (assoc 62 ent) ent))
    (entmod (append ent (list (cons 62 col))))
  )
)
;; }`_ŕ\
(defun ifs_nsq_blink2 (enamelist onco ofco msec n / ss enamecolist co ename item) 
  (defun ifs_nsq_delay (msec / start) 
    (setq start (getvar "DATE"))
    (while (< (* (- (getvar "DATE") start) 24 60 60 1000) msec))
  )
  (cond 
    ((= onco 256) (setq onco "BYLAYER"))
    ((= onco 0) (setq onco "BYBLOCK"))
  )
  (cond 
    ((= ofco 256) (setq ofco "BYLAYER"))
    ((= ofco 0) (setq ofco "BYBLOCK"))
  )
  (setq ss (ssadd))
  ;;ύXO̐FL
  (foreach ename enamelist 
    (if ename 
      (setq enamecolist (cons (list ename (cdr (assoc 62 (entget ename)))) enamecolist)
            ss          (ssadd ename ss)
      )
    )
  )
  (setvar "CMDECHO" 0)
  (repeat n 
    (command "CHANGE" ss "" "P" "C" onco "")
    (redraw)
    (ifs_nsq_delay (* msec 2.5))
    (command "CHANGE" ss "" "P" "C" ofco "")
    (redraw)
    (ifs_nsq_delay msec)
  )
  (foreach item enamecolist 
    (if (not (setq co (cadr item)))
      (setq co 256)
    )
    (ifs_nsq_set_color (car item) co)
  )
)

;; o^ĂubN̐}` (}ꂽubNł͂Ȃ)
(defun c:bEnt (/ ss ent ename blkname) 
  (if (setq ss (ssget "_:S" '((0 . "INSERT")))) 
    (progn 
      (setq ent     (entget (ssname ss 0))
            blkname (cdr (assoc 2 ent))
      )
      (princ "\nName = ")
      (princ blkname)
      ;;o^ĂubN̐}`
      (setq ename (cdr (assoc -2 (entget (tblobjname "BLOCK" blkname)))))
      (while ename 
        (princ "\n")
        (princ (setq ent (entget ename)))
        (setq ename (entnext ename))
      )
    )
  )
  (princ)
)

;;[q}iɃubNOj
(defun ifs_insert_tb (blkname pos sc) 
  (ifs_make_Layer "WIRE" 3 nil)
  (if (tblsearch "BLOCK" blkname) 
    (progn 
      (entmake 
        (list '(0 . "INSERT") 
              '(8 . "WIRE")
              (cons 2 blkname)
              (cons 10 pos)
              (cons 41 sc)
              (cons 42 sc)
              (cons 43 sc)
        )
      )
    )
  )
)

;; [q}iŁj
(defun c:tbIN (/ my_error mode res pt kw loop p2 mes tbName) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)

  (initget "Out Int")
  (if (not (setq kw (getkword "\n[q^Cv [O:O /I:)] < O > : "))) 
    (setq kw "Out")
  )
  (if (= kw "Out")
    (setq tbname (availableTBblkname 0))
    (setq tbname (availableTBblkname 1))
    ; (setq tbName "OUTCIR00")
    ; (setq tbName  "INTCIR00")
  )
  (setq mode "TBIN")
  (setq loop (and kw (/= tbname "")))
  (while loop 
    (setq pt nil)
    ;;(princ mode)
    
    (initget "1 N F Exit eXit I O ")
    (cond 
      ((= mode "TBIN")
        (setq mes "\n[qP}ʒuw [N: /F:tFXI /O:O[q /I:[q /E,X:I] : "))
      ((= mode "TBNIN")
        (setq mes "\n[q}ʒuw [1:P /F:tFXI /O:O[q /I:[q /E,X:I] : "))      
      ((= mode "TBFIN")
        (setq mes "\ntFXQ_ÎP_ڂw [1:P N: /O:O[q /I:[q /E,X:I] : "))         
    ) 
    (setq res (getpoint mes))
    ;;(princ res)
    (cond 
      ((or (= res "Exit" )(= res "eXit"))
        (setq loop nil mode ""))
      ((= res "1"  )
        (setq mode "TBIN"))
      ((= res "N"  )
        (setq mode "TBNIN"))
      ((= res "F")
        (setq mode "TBFIN"))
      ((= res "O")
        (setq tbname (availableTBblkname 0)))
      ((= res "I")
        (setq tbname (availableTBblkname 1)))
      ((and res (listp res))
        (setq pt res))
    )
    (if pt
      (cond 
        ((= mode "TBIN")
          (ifs_do_tbin pt tbName))
        ((= mode "TBFIN")
          (if (setq p2 (getPoint pt "\n2_ڂw  < ߂ > : "))
            (ifs_do_tbfin pt p2 tbName)
          ))
        ((= mode "TBNIN")
          (ifs_do_tbnin pt tbName))
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; [qV{P쐬
(defun ifs_do_tbin(pt tbname / dimsc elast ename)
  (setq dimsc (getvar "DIMSCALE") elast (entlast))
  (command "_UNDO" "BE")
  (ifs_insert_tb tbName pt dimsc)
  (if (not (equal elast (setq ename (entlast)))) 
    (ifs_sub_btrimvx ename)
  )
  (command "_UNDO" "END")
) 

;; [qV{tFXQ_I̐ɍ쐬
(defun ifs_do_tbfin(p1 p2 tbName / dimsc ent pt elast ename i ss)
  (if (ifs_isTate p1 p2)
    (setq p2 (list (car p1)(cadr p2)(caddr p1)))
    (setq p2 (list (car p2)(cadr p1)(caddr p1)))
  )

  (setq dimsc (getvar "DIMSCALE"))
  (if (setq ss (ssget "F" (list p1 p2) '((0 . "LINE") (8 . "WIRE*"))))
    (progn
      (command "_UNDO" "BE")
      (setq i 0)
      (repeat (sslength ss) 
        (setq ent (entget (ssname ss i)))
        (if (setq pt (inters p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent))))
          (progn 
            (setq elast (entlast))
            (ifs_insert_tb tbName pt dimsc)
            (if (not (equal elast (setq ename (entlast)))) 
              (ifs_sub_btrimvx ename)
            )
          )
        )
        (setq i (1+ i))
      )
      (command "_UNDO" "END")
    )
  )
)

;; [qV{쐬
(defun ifs_do_tbnin(pt tbName / dimsc pt elast ename cnt dist kw2)
  (setq dimsc (getvar "DIMSCALE"))
  (if (not (setq cnt (getint "\n쐬 < 1 > : "))) 
    (setq cnt 1)
  )
  (if (> cnt 1) 
    (progn 
      (initget "Right Down")
      (if (not (setq kw2 (getkword "\n쐬 [R:E/D:] < R > : "))) 
        (setq kw2 "Right")
      )
      (if (not (setq dist (getdist "\n < 5.0 > : "))) 
        (setq dist 5.0)
      )
    )
  )
  (command "_UNDO" "BE")
  (repeat cnt 
    (setq elast (entlast))
    (ifs_insert_tb tbName pt dimsc)
    (if (not (equal elast (setq ename (entlast))))
      (ifs_sub_btrimvx ename)
    )
    (cond 
      ((= kw2 "Right") 
        (setq pt (list (+ (car pt) dist) (cadr pt) 0.0)))
      ((= kw2 "Down" ) 
        (setq pt (list (car pt) (- (cadr pt) dist) 0.0)))
    )
  ) 
  (command "_UNDO" "END")
)

;; Line 2_͂ 4	_issget "CP" pj
(defun ifs_lineCP (pt1 pt2 off / ang off2) 
  (setq ang  (angle pt1 pt2)
        off2 (* off (sqrt 2.0))
  )
  (list 
    (polar pt1 (+ ang (* Pi 0.75)) off2)
    (polar pt1 (+ ang (* Pi 1.25)) off2)
    (polar pt2 (- ang (* Pi 0.25)) off2)
    (polar pt2 (+ ang (* Pi 0.25)) off2)
    ;(polar pt1 (+ ang (* Pi 0.75)) off2)
  )
)

;; WindowQ_
;;  min-max ͖̏Ȃ
;; min-max -ȄŕԂ
(defun ifs_lineW (pt1 pt2 off / p1 p2 off2) 
  (setq off2 (* off (sqrt 2.0)))
  (if (= (length pt1) 3) 
    (setq p1 (list (min (car pt1) (car pt2)) 
                   (min (cadr pt1) (cadr pt2))
                   (caddr pt1)
             )
          p2 (list (max (car pt1) (car pt2)) 
                   (max (cadr pt1) (cadr pt2))
                   (caddr pt1)
             )
    )
    (setq p1 (list (min (car pt1) (car pt2)) (min (cadr pt1) (cadr pt2)))
          p2 (list (max (car pt1) (car pt2)) (max (cadr pt1) (cadr pt2)))
    )
  )
  (list 
    (polar p1 (* Pi 1.25) off2) ;; 
    (polar p2 (* Pi 0.25) off2) ;; E
  )
  ;(setq ang (angle pt1 pt2) off2 (* off (sqrt 2.0)))
  ; (list
  ; 	(polar pt1 (+ ang (* Pi 0.75)) off2)
  ; 	(polar pt2 (- ang (* Pi 0.25)) off2)
  ; )
)

;; pt 1_͂ 2	_issget "W", "C" pj
(defun ifs_pointW (pt off /) 
  (list 
    (list (- (car pt) off) (- (cadr pt) off) 0.0)
    (list (+ (car pt) off) (+ (cadr pt) off) 0.0)
  )
)

;; cɋ߂i΂ߐ܂܂j
(defun ifs_isTate (p1 p2) 
  (< (abs (- (car p1) (car p2))) (abs (- (cadr p1) (cadr p2))))
)

;; ł邩
(defun ifs_isTateReal (p1 p2 fuz)
  (< (abs (- (car p1) (car p2))) fuz)
)

;; ł邩
(defun ifs_isYokoReal (p1 p2 fuz)
  (< (abs (- (cadr p1) (cadr p2))) fuz) 
)

;; ԃubN}
(defun ifs_insert_sb (blkname pos sc deg sbstr / ename elast org clayer attreq attdia 
                      cmdecho
                     ) 
  (ifs_make_Layer "SENBAN" 2 nil)
  (if (or (= blkname "SENBAN") (= blkname "SENBAN1"))
    (ifs_make_Layer "CSENBAN" 2 nil)
  )
  (setq org blkname)
  (if (not (tblsearch "BLOCK" blkname)) 
    (cond 
      ((= blkname "SENBAN")(setq blkname "SENBAN00"  deg 90.0 ))
      ((= blkname "SENBAN1")(setq blkname "SENBAN00" deg 0.0 ))
    )
  )
  (if (tblsearch "BLOCK" blkname) 
    (progn 
      (setq clayer (getvar "CLAYER"))
      (if (or (= blkname "SENBAN") (= blkname "SENBAN1"))
        (setvar "CLAYER" "CSENBAN")
        (setvar "CLAYER" "SENBAN")
      )
      
      (setq elast   (entlast)
            attreq  (getvar "ATTREQ")
            attdia  (getvar "ATTDIA")
            cmdecho (getvar "CMDECHO")
      )
      (setvar "ATTREQ" 0)
      (setvar "ATTDIA" 0)
      (setvar "CMDECHO" 0)
      (command "_-INSERT" blkname "none" pos sc sc deg) ;; sbstr)
      (setvar "ATTREQ" attreq) 
      (setvar "ATTDIA" attdia)
      (setvar "CMDECHO" cmdecho)
      (setvar "CLAYER" clayer)
      (if (not (equal elast (entlast))) 
        (progn 
          (setq ename (entlast))
          (ifs_setAttvalue ename "SENBAN" sbstr)
        )
      )
    )
    (princ (strcat "\nԃubN:" org " ܂D"))
  )
  ename
)

;; Ƀ^O݂邩iChJ[hŔfj
;; gpĂȂ
(defun ifs_existsAttTagName (blkEname tagName / ename ent tag res loop) 
  (setq ename blkename
        ent   (entget ename)
        loop  (and 
                (= (cdr (assoc 0 ent)) "INSERT")
                (assoc 66 ent)
                (= 1 (cdr (assoc 66 ent)))
              )
  )
  (while 
    (and loop 
         (/= "SEQEND" (cdr (assoc 0 (entget (setq ename (entnext ename))))))
    )
    (setq ent (entget ename)
          tag (cdr (assoc 2 ent))
    )
    (if (wcmatch tag tagName) 
      (setq loop nil
            res  T
      )
    )
  )
  res
)

;;𕶎{{ɕi납琔j
(defun ifs_sprNum3 (str / len i istr maestr atostr c sw suuji) 
  (setq len    (strlen str)
        i      len
        istr   ""
        maestr ""
        atostr ""
  )
  (setq sw 0)
  (repeat len 
    (setq c (substr str i 1))
    (setq suuji (and (>= c "0") (<= c "9")))
    (if (and suuji (= sw 0)) (setq sw 1))
    (if (and (not suuji) (= sw 1)) (setq sw 2))
    (cond 
      ((= sw 0) (setq atostr (strcat c atostr)))
      ((= sw 1) (setq istr (strcat c istr)))
      ((= sw 2) (setq maestr (strcat c maestr)))
    )
    (setq i (1- i))
  )
  (list maestr istr atostr)
)

;; 8i10iɕϊ
(defun ifs_octToInt (octstr / len i res c n) 
  (setq len (strlen octstr)
        i   0
        res 0
  )
  (repeat len 
    (setq c   (substr octstr (- len i) 1)
          n   (- (ascii c) 48)
          res (+ res (lsh n (* i 3)))
          i   (1+ i)
    )
  )
  res
)
(defun ifs_intToDec (int len / l decStr) 
  (setq decStr (itoa int)
        l      (strlen decStr)
  )
  (if (> len l) 
    (repeat (- len l) 
      (setq decstr (strcat "0" decstr))
    )
  )
  decStr
)
;; 8iϊ
(defun ifs_intToOct (int len / octstr oct l h m n) 
  (setq h      8
        oct    "01234567"
        octstr ""
  )
  (while (> int 0) 
    (setq m      (rem int h)
          n      (/ m (/ h 8))
          octstr (strcat (substr oct (1+ n) 1) octstr)
          int    (- int m)
          h      (* h 8)
    )
  )
  (setq l (strlen octstr))
  (if (> len l) 
    (repeat (- len l) 
      (setq octstr (strcat "0" octstr))
    )
  )
  octstr
)
;; 16iϊ
(defun ifs_intToHex (int len / hexstr l hex h m n) 
  (setq hex    "0123456789ABCDEF"
        h      16
        hexstr ""
  )
  (while (> int 0) 
    (setq m      (rem int h)
          n      (/ m (/ h 16))
          hexstr (strcat (substr hex (1+ n) 1) hexstr)
          int    (- int m)
          h      (* h 16)
    )
  )
  (setq l (strlen hexstr))
  (if (> len l) 
    (repeat (- len l) 
      (setq hexstr (strcat "0" hexstr))
    )
  )
  hexstr
)

;;̈ʒuԂ(1`)
(defun ifs_strpos (des src / res n m cnt i loop) 
  (setq res 0)
  (setq n    (strlen src)
        m    (strlen des)
        i    1
        loop T
        cnt  (1+ (- n m))
  )
  (while (and (>= cnt i) loop) 
    (if (equal (substr src i m) des) 
      (setq loop nil
            res  i
      )
      (setq i (1+ i))
    )
  )
  res ;
)

;; 16i𐮐Ɂ@vstrpos
;; 2023/04/28 }CiXɑΉ
(defun ifs_hexToInt (hexstr / hex len i res c n mflag) 
  (setq hex    "0123456789ABCDEF"
        len    (strlen hexstr)
        i      0
        res    0
        hexstr (strcase hexstr)
        mflag (= "-" (substr hexstr 1 1))
  )
  (if mflag (setq hexstr (substr hexstr 2) len (1- len)))
  (repeat len 
    (setq c   (substr hexstr (- len i) 1)
          n   (1- (ifs_strpos c hex))
          res (+ res (lsh n (* i 4)))
          i   (1+ i)
    )
  )
  (if mflag (setq res (- res)))
  res
)

;; 10i𐮐
(defun ifs_decToInt (decstr) 
  (atoi decstr)
)

;; Ԃ̃ubN̏cɍĂ邩
(defun ifs_isValidSbBlkName(tate bname deg / ret)
  (if (equal deg 360.0 1.0)(setq deg 0.0))
  (cond
    ((and tate (= bname "SENBAN")(equal deg 0.0 1.0))
      (setq ret T))
    ((and (not tate) (= bname "SENBAN1")(equal deg 0.0 1.0))
      (setq ret T))
    ((and tate (= bname "SENBAN00") (equal deg 90.0 1.0))
      (setq ret T))
    ((and (not tate) (= bname "SENBAN00") (equal deg 0.0 1.0))
      (setq ret T))
  )
  ret
)

;; LȐԂ̃ubNƊpx̃Xg𓾂
;; Ȃꍇ́A ("" 0.0) Ԃ
(defun ifs_ValidSbBlkName(tate / bname deg)
  (setq bname "" deg 0.0)
  (cond
    ((and tate (tblobjname "BLOCK" "SENBAN")
      (setq bname "SENBAN" deg 0.0)))
    ((and (not tate) (tblobjname "BLOCK" "SENBAN1")
      (setq bname "SENBAN1" deg 0.0)))
    ((and tate (tblobjname "BLOCK" "SENBAN00")) 
      (setq bname "SENBAN00" deg 90.0))
    ((and (not tate) (tblobjname "BLOCK" "SENBAN00"))
      (setq bname "SENBAN00" deg 0.0))
  )
  (list bname deg)
)

;; I/O 
;; mode 0:Dec / 1:Oct / 2:Hex
(defun ifs_sub_sbio (mode / my_error ename ent Flag p1 p2 pts i p3 p4 pt e1 e2 senban 
                     mes item kw ato len mae num ss st loop dimsc ret sbenames
                     bname tate deg lst) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (cond 
    ((= mode 0)(setq mes "10i"))
    ((= mode 1)(setq mes "8i"))
    ((= mode 2)(setq mes "16i"))
  )
  (setq loop  T
        dimsc (getvar "DIMSCALE")
        ret T
  )
  (cond 
    ((= mode 2) (setq mes "(HEX)"))
    ((= mode 0) (setq mes "(DEC)"))
    ((= mode 1) (setq mes "(OCT)"))
  )
  (setq mae (strcase (getstring "\nOŒ蕶 < Ȃ > : ")))
  (if 
    (= "" (setq num (strcase (getstring (strcat "\nJnl " mes " < 0000 > : ")))))
    (setq num "0000")
  )
  (setq ato (strcase (getstring "\nŒ蕶 < Ȃ > : ")))
  (initget "Yes No")
  (if (not (setq kw (getkword "\n̐Ԃ鎞AtFXɐ񂵂܂H [Yes /No] < Yes > : ")))
    (setq kw "Yes")
  )
  (while loop 
    (initget "Exit eXit")
    (setq p1 (getpoint (strcat "\n" mes " I/O Ԃ쐬AXVtFXI 1 _ڂw [E,X:I] : ")))
    (cond 
      ((or (= p1 "Exit")(= p1 "eXit")) (setq loop nil ret nil))
      ((and p1 (listp p1))
        (if (setq p2 (getpoint p1 "\n2 _ڂw < 1 _ > : ")) 
          (setq loop nil)
        )
      )
    )
  )
  (setq Flag (and p1 p2))
  (if flag
    (if (ifs_isTate p1 p2)
      (setq p2 (list (car p1)(cadr p2)(caddr p1)))
      (setq p2 (list (car p2)(cadr p1)(caddr p1)))
    )
  )
  (if Flag 
    (if (setq ss (ssget "F" (list p1 p2) '((0 . "LINE")))) 
      (progn 
        (setq i 0)
        (repeat (sslength ss) 
          (setq ent (entget (ssname ss i))
                p3  (cdr (assoc 10 ent))
                p4  (cdr (assoc 11 ent))
          )
          (if (setq pt (inters p1 p2 p3 p4)) 
            (setq pts (cons (list pt p3 p4) pts))
          )
          (setq i (1+ i))
        )
        (if (and pts (> (length pts) 1)) 
          (setq pts (vl-sort pts (function (lambda (e1 e2) (< (distance p1 (car e1)) (distance p1 (car e2)))))))
        )
        (setq Flag pts)
      )
    )
    (setq Flag nil)
  )
  (if flag 
    (progn 
      (command "_UNDO" "BE")
      (cond 
        ((= mode 2) (setq st (ifs_hexToInt num)))
        ((= mode 0) (setq st (ifs_decToInt num)))
        ((= mode 1) (setq st (ifs_octToInt num)))
      )
      (setq len (strlen num))
      (foreach item pts 
        (cond 
          ((= mode 2) (setq senban (strcat mae (ifs_intToHex st len) ato)))
          ((= mode 0) (setq senban (strcat mae (ifs_intToDec st len) ato)))
          ((= mode 1) (setq senban (strcat mae (ifs_intToOct st len) ato)))
        )
        
        (if (setq sbenames (ifs_getSenbanEnamesFromPoint (car item)))
          (progn
            (foreach ename sbenames
              (ifs_setAttvalue ename "SENBAN" senban);; ̐ԂXV
            )
            (if (and (/= "No" kw)(setq ename (ifs_nearSbe (car item) sbenames)));; _Ɉԋ߂ 
              (progn
                (setq ent (entget ename) bname (cdr (assoc 2 ent)) deg (ifs_radToDeg (cdr (assoc 50 ent))))
                (setq tate (ifs_isTate (cadr item) (caddr item)))
                (if (not (ifs_isValidSbBlkName tate bname deg));; pxႢ
                  (progn
                    (setq lst (ifs_ValidSbBlkName tate) bname (car lst) deg (cadr lst))
                    (if (/= bname "")
                      (progn
                        (entdel ename)
                        (ifs_insert_sb bname (car item) dimsc deg senban)
                      )
                    )
                  )
                  (progn;; pxĂ
                    (command "MOVE" ename "" "_non" (cdr (assoc 10 ent)) "_non" (car item))
                  )
                )
              )
            )
          )
          (progn
            ;; VK쐬
            ;;(princ "\nVK쐬")
            (setq tate (ifs_isTate (cadr item) (caddr item)))
            (setq lst (ifs_ValidSbBlkName tate) bname (car lst) deg (cadr lst))
            (if (/= bname "")
              (progn
                (ifs_insert_sb bname (car item) dimsc deg senban)
              )
            )
          )
        )
        (setq st (1+ st))
      )
      (command "_UNDO" "END")
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  ;;(princ)
  ret
)

;; tFXIɈꊇ I/O Ԃ쐬
(defun c:sbIOF( / kw loop k)
  (setq loop T kw "H")
  (while loop
    (initget "H O D Exit eXit")
    (if (setq k (getkword (strcat "\niI [H:16i /O:8i /D:10i /E,X:I] < " kw " > : ")))
      (setq kw k)
    )
    (cond 
      ((or (= kw "Exit")(= kw "eXit"))
        (setq loop nil))
      ((= kw "H")
        (setq loop (ifs_sub_sbio 2)))
      ((= kw "O")
        (setq loop (ifs_sub_sbio 1)))
      ((= kw "D")
        (setq loop (ifs_sub_sbio 0)))
    )
  )
  (princ)  
)
  ;; I/O  16 i
(defun c:sbIoH () 
  (ifs_sub_sbio 2)
  (princ)
)
  ;; I/O  10 i
(defun c:sbIoD () 
  (ifs_sub_sbio 0)
  (princ)
)
  ;; I/O  8 i
(defun c:sbIoO () 
  (ifs_sub_sbio 1)
  (princ)
)
;; tFXI̐ɐԂ쐬
(defun c:sbInF () 
  (ifs_sub_sbio 0)
  (princ)
)
;; W LINE ݂邩 ename ̃XgԂ
(defun ifs_getLineEnamesFromPoint(pt / pts ss lineEnames i)
  (setq pts (ifs_pointW pt (* 0.1 (getvar "DIMSCALE"))) i 0)
  (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE")))) 
    (repeat (sslength ss)
      (setq lineEnames (append lineEnames (list (ssname ss i))))
      (setq i (1+ i))
    )
  )
  lineEnames
)
(defun ifs_getSenbanEnamesFromPoint(pt / lineEnames senbanEnames)
  (if (setq lineEnames (ifs_getLineEnamesFromPoint pt))
    (progn
      (setq senbanEnames (ifs_get_senbanEnames (car lineEnames)))
    )
  )
  senbanEnames
)

;; ԍ쐬iJEgAbvj
(defun c:sbInN( / sbstr loop pt ptn sbes flag1 flag2 i s sbstrs lnes deg ent p1 p2 kw lst
              dimsc blkname)
 (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
  )
  (setq *error* my_error) 
  (setq dimsc (getvar "DIMSCALE"))
  (if (/= "" (setq s (getstring  "\n쐬Ԃ : ")))
    (setq sbstr (strcase s))
  )
  (setq loop (and sbstr (/= sbstr "")))
  (while loop    
    (initget "Sen Exit eXit")
    (setq pt (getPoint (strcat "\n " sbstr " }ʒuw [S:ԓ /E,X:I] : ")))
    (cond
      ((or (= pt "Exit")(= pt "eXit"))
        (setq loop nil))
      ((= pt "Sen")
        (if (/= "" (setq s (getstring (strcat "\n쐬Ԃ < " sbstr " > : "))))
          (setq sbstr (strcase s))
        ))
    )
    (if (and pt (listp pt))
      (progn
        (if (setq ptn (osnap pt "near"))(setq pt ptn))
        (setq sbes nil sbstrs "" flag1 nil flag2 nil)
        (if (setq sbes (ifs_getSenbanEnamesFromPoint pt))
          (progn
            (setq i 0)
            (repeat (length sbes) 
              (if (setq s (ifs_getAttValue (nth i sbes) "SENBAN"));; ̐
                (progn
                  (if (= s sbstr)
                    (setq flag1 T);; Ԃ
                    (setq flag2 T);; قȂԂ
                  )
                  (if (= sbstrs "")
                    (setq sbstrs s)
                    (setq sbstrs (strcat sbstrs " " s))
                  )
                )
              )
              (setq i (1+ i))
            )
          )
        )
        (if (setq lnes (ifs_getLineEnamesFromPoint pt))
          (progn
            (setq ent (entget (car lnes)) p1 (cdr (assoc 10 ent)) p2 (cdr (assoc 11 ent)))
            (setq lst (ifs_ValidSbBlkName (ifs_isTate p1 p2)) blkname (car lst) deg (cadr lst))
            ;;(if (ifs_isTate p1 p2)(setq deg 90.0)(setq deg 0.0))
            (setq kw "Add")
            (if flag2
              (progn ;; قȂԂ
                (initget "Up Add Pass New")
                (if (not (setq kw (getkword (strcat "\nقȂ " sbstrs " ݂܂D[U:XV /A:ǉ+XV /N:Ԃǉ /P:~] < A > : " ))))
                  (setq kw "Add")
                )
                (cond
                  ((and sbes (or (= kw "Up")(= kw "Add")))
                    (progn
                      (setq i 0)
                      (repeat (length sbes)
                        (ifs_setAttvalue (nth i sbes) "SENBAN" sbstr)
                        (setq  i (1+ i))
                      )
                    ))
                )
                (cond
                  ((= kw "Add")
                     (ifs_insert_sb blkname pt dimsc deg sbstr)
                    )
                  ((= kw "New")
                    (progn
                      (setq lst (ifs_strsplit sbstrs " ")
                            lst (ifs_sort lst)
                      )                            
                      (if (= (length lst) 1)
                        (progn
                          (princ (strcat "\nǉ = " (car lst)))
                          (ifs_insert_sb blkname pt dimsc deg (car lst))
                        )
                        (princ "\ndԂłDmFĉD")
                      )
                    ))
                )
              )
              ;; قȂԂ݂Ȃ
              (if (= kw "Add")
                (ifs_insert_sb blkname pt dimsc deg sbstr)
              )
            )
          )
        ) 
      )
    )
  )
  (setq *error* nil)
  (princ)
)

;; ԍ쐬iJEgAbvjǑŒ蕶͎o
(defun c:sbInC (/ my_error pt ss ent tate blkname cnt pts sbstr lst keta numstr 
               loop ename s sbenames i deg kw sbstrs pt2 dimsc
              ) 
  (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setq dimsc (getvar "DIMSCALE"))

  (setq cnt   0
        sbstr "A101"
        sbstrs ""
        loop  T
  ) 

  (if (/= "" (setq s (getstring (strcat "\nJEgAbvԂ̏l <" sbstr "> : ")))) 
    (setq sbstr (strcase s))
  )
  (while loop 
    (initget "Exit Sen eXit")
    (setq pt (getPoint (strcat "\n " sbstr " }ʒuw [S:ԓ /E,X:I] : ")))
    (cond
      ((or (= pt "Exit")(= pt "eXit"))
        (setq loop nil))
      ((= pt "Sen") 
        (if (/= "" (setq s (getstring (strcat "\nJEgAbvԂ̏l < " sbstr " > : ")))) 
          (setq sbstr (strcase s))
        ))
      ((and pt (listp pt))
        (progn 
          ;;(princ pt)
          (setq pt2 (osnap pt "near"))
          
          (if pt2 
            (progn 
              (setq pt   pt2
                    tate T
                    pts  (ifs_pointW pt (* 0.1 dimsc))
              )
              (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE")))) 
                (setq ename    (ssname ss 0)
                      ent      (entget ename)
                      tate     (ifs_isTate (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))
                      sbenames (ifs_get_senbanEnames ename) ;; łɐԂ݂邩
                )
              )
            )
            (progn 
              ;; }`Ȃ
              (princ "\nNot Line")
            )
          )
          (if sbenames 
            (progn 
              (setq sbstrs "" i 0)
              (repeat (length sbenames)
                (if (setq s (ifs_getAttvalue (nth i sbenames) "SENBAN"))
                  (if (= sbstrs "")
                    (setq sbstrs s)
                    (setq sbstrs (strcat sbstrs " " s))
                  )
                )
                (setq i (1+ i))
              )
            )
          )
          ;;(princ "\ntate=")(princ tate)
          ;; ݂̃ubNɍ킹
          (setq lst (ifs_ValidSbBlkName tate) blkname (car lst) deg (cadr lst))
          (princ "\nname")(princ blkname)(princ " deg=")(princ deg) 
          ;; ԂāA쐬ԂƈقȂ
          (setq kw "Add")
          (setq lst (ifs_strsplit sbstrs " ") lst (ifs_sort lst))                            
          (if (and sbenames (not (member sbstr lst)))
            (progn 
              (initget "Add Up Pass New")
              (if (not (setq kw (getkword (strcat "\n " sbstr " ͊̐ " sbstrs " ƈقȂ܂DI [A:ǉ+XV /U:XV̂ /N:̐Ԃǉ /P:~] < A > :"))))
                (setq kw "Add")
              )
              (cond
                ((or (= kw "Add") (= kw "Up")) 
                  (progn 
                    (setq i 0)
                    (repeat (length sbenames) 
                      (ifs_setAttvalue (nth i sbenames) "SENBAN" sbstr)
                      (setq i (1+ i))
                    )
                  ))
                ((= kw "New")
                  (progn
                    (setq lst (ifs_strsplit sbstrs " ")
                          lst (ifs_sort lst)
                    )                            
                    (if (= (length lst) 1)
                      (progn
                        (princ (strcat "\nǉ = " (car lst)))
                        (ifs_insert_sb blkname pt dimsc deg (car lst))
                      )
                      (princ "\ndԂłDmFĉD")
                    )
                  )) 
              )
              (if (= kw "Up") 
                (if (and (/= sbstr "") (setq lst (ifs_sprNum3 sbstr)))
                  (setq numstr (cadr lst)
                        keta   (strlen numstr)
                        numstr (itoa (1+ (atoi numstr)))
                        numstr (ifs_func_strAddZero numstr keta)
                        sbstr (strcat (car lst) numstr (caddr lst))
                  )
                )
              )
            )
          )
          (if (and (= kw "Add")
            (setq ename (ifs_insert_sb blkname pt dimsc deg sbstr)))
            (progn 
              (setq sbstr (ifs_getAttvalue ename "SENBAN"))
              (if (and sbstr ename (/= sbstr "") 
                       (setq lst (ifs_sprNum3 sbstr)))
                (setq numstr (cadr lst)
                      keta   (strlen numstr)
                      numstr (itoa (1+ (atoi numstr)))
                      numstr (ifs_func_strAddZero numstr keta)
                      sbstr (strcat (car lst) numstr (caddr lst))
                )
              )
            )
          )
        )
      )
    )
  )
  (setq *error* nil)
  (princ)
)

;; ԍ쐬iJEgAbvA8iA16iΉj
(defun c:sbinX( / my_error head slen str senban term loop mode n pt ptn
               dimsc ename ent pts sbenames ss tate deg i s sbstrs
               len lst kw blkname)
  (defun my_error(msg)
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  
  (setq dimsc (getvar "DIMSCALE"))
  (initget "Dec Oct Hex")
  (if (not (setq mode (getkword "\ni [D:10i /O:8i /H:16i] < 10i > ")))
    (setq mode "Dec")
  )  
  (setq head (getstring "\nOŒ蕶 < Ȃ > : "))
  (setq head (strcase head))
  (if (= ""  (setq str (getstring "\nJEgAbv̏l < 00 > : ")))
    (setq str "00")
  )
  (setq str (strcase str) slen (strlen str))
  (setq term (getstring "\nŒ蕶 < Ȃ > : "))
  (setq term (strcase term))

  (cond
    ((= mode "Dec")(setq n (ifs_decToint str)))
    ((= mode "Oct")(setq n (ifs_octToint str)))
    ((= mode "Hex")(setq n (ifs_hexToint str)))
  )
  (setq senban (strcat head str term))
  
  (setq loop T)
  (while loop
    (setq sbenames nil ename nil)
    (initget "Exit eXit D H I")
    (setq pt (getpoint (strcat "\n " senban " }_w [D:i /H:Œ蕶 /I:l /E,X:I]: ")))
    (cond
      ((or (= pt "Exit")(= pt "eXit"))(setq loop nil))
      ((= pt "D")
        (progn
          (initget "Dec Oct Hex")
            (if (not (setq mode (getkword "\ni [D:10i /O:8i /H:16i] < 10i > ")))
              (setq mode "Dec")
          )  
        ))
      ((= pt "H")
        (progn
          (setq head (getstring "\nOŒ蕶 < Ȃ > : "))
          (setq head (strcase head))          
          (setq term (getstring "\nŒ蕶 < Ȃ > : "))
          (setq term (strcase term))       
        ))
      ((= pt "I")
        (progn
          (if (= ""  (setq str (getstring "\nJEgAbv̏l < 00 > : ")))
              (setq str "00")
          )
          (setq str (strcase str) slen (strlen str))
          ;; 2023/04/29 ǉ
          (cond
            ((= mode "Dec")(setq n (ifs_decToint str)))
            ((= mode "Oct")(setq n (ifs_octToint str)))
            ((= mode "Hex")(setq n (ifs_hexToint str)))
          )         
          (setq senban (strcat head str term))                        
        ))
      ((and pt (listp pt))
        (progn
          (cond
            ((= mode "Dec")(setq n (ifs_decToint str)))
            ((= mode "Oct")(setq n (ifs_octToint str)))
            ((= mode "Hex")(setq n (ifs_hexToint str)))
          )         
          (setq senban (strcat head str term))         
          
          (if (setq ptn (osnap pt "near"))(setq pt ptn))
          (setq pts  (ifs_pointW pt (* 0.1 dimsc)))
          (if (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE")))) 
            (setq ename    (ssname ss 0)
                  ent      (entget ename)
                  tate     (ifs_isTate (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))
                  sbenames (ifs_get_senbanEnames ename) ;; łɐԂ݂邩AƂnil
            )
          )     
          (setq lst (ifs_ValidSbBlkName tate) blkname (car lst) deg (cadr lst))
          (if (not sbenames)
            ;; ԂȂ
            (progn
              (ifs_insert_sb blkname pt dimsc deg senban)
              (setq n (1+ n))
            )
            ;; Ԃ
            (progn
              (command "_UNDO" "BE")
              (setq sbstrs "" i 0)
              (repeat (length sbenames)
                (if (setq s (ifs_getAttvalue (nth i sbenames) "SENBAN"))
                  (if (= sbstrs "")
                    (setq sbstrs s)
                    (setq sbstrs (strcat sbstrs " " s))
                  )
                )
                (setq i (1+ i))
              )            
              (setq lst (ifs_strsplit sbstrs " ") lst (ifs_sort lst)) 
              (setq len (length lst))
              ;; ̐ԂƓ
              (if (and (= len 1) (= senban (car lst)))
                (progn
                  (ifs_insert_sb blkname pt dimsc deg senban)
                  (setq n (1+ n))                
                )
                ;; ̐ԂƈقȂ
                (progn
                  (initget "Add Up Pass New")
                  (if (not (setq kw (getkword (strcat "\n " senban " ͊̐ " sbstrs " ƈقȂ܂DI [A:ǉ+XV /U:XV̂ /N:̐Ԃǉ /P:~] < A > :"))))
                    (setq kw "Add")
                  )
                  (cond
                    ((or (= kw "Add") (= kw "Up")) 
                      (progn 
                        ;; ̐ԂXV
                        (setq i 0)
                        (repeat (length sbenames) 
                          (ifs_setAttvalue (nth i sbenames) "SENBAN" senban)
                          (setq i (1+ i))
                        )
                      ))
                    ((= kw "New")
                      (if (= (length lst) 1)
                        (progn
                          ;; ̐Ԃǉ
                          (princ (strcat "\nǉ = " (car lst)))
                          (ifs_insert_sb blkname pt dimsc deg (car lst))
                        )
                        (princ "\ndԂłDmFĉD")
                      )) 
                  )
                  (if (= kw "Add")
                    (progn
                      (ifs_insert_sb blkname pt dimsc deg senban)
                      (setq n (1+ n))                    
                    )
                  )
                )
              )
              (command "_UNDO" "END")
            )
          )
          (cond
            ((= mode "Dec")(setq str (ifs_intToDec n slen)))
            ((= mode "Oct")(setq str (ifs_intToOct n slen)))
            ((= mode "Hex")(setq str (ifs_intToHex n slen)))
          ) 
          (setq senban (strcat head str term))          
        )
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; ԉZ
(defun c:sbUp (/ my_error ss up i kw) 
  (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
  )
  (setq *error* my_error)

  (prompt "\nꊇŉZԂIĂ")
  (if (setq ss (ssget '((0 . "INSERT") (2 . "SENBAN*")))) 
    (progn 
      (if (not (setq up (getint "\nZ鐔l < 1 > : "))) 
        (setq up 1)
      )
      (if (< up 0)
        (progn
          (initget "Yes No")
          (if (not (setq kw (getkword "\n킹i[pfBOj܂H [Yes /No] < No > "))) 
            (setq kw "No")
          )
        )
      )
      (setq i 0)
      (repeat (sslength ss) 
        (ifs_func_sbup (ssname ss i) up (= kw "Yes"))
        (setq i (1+ i))
      )
    )
  )
  (setq *error* nil)
  (princ)
)
(defun c:sbUpH (/ my_error ss up i st hlen sup) 
  (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
  )
  (setq *error* my_error)

  (prompt "\nꊇŉZԂIĂ")
  (if (setq ss (ssget '((0 . "INSERT") (2 . "SENBAN*")))) 
    (progn
      (if (not (setq st (getint "\n16il̊Jnʒu < 1 > : "))) 
        (setq st 1)
      )
      (if (not (setq hlen (getint "\n16ǐ < 1 > : "))) 
        (setq hlen 1)
      )      
      (if (= "" (setq sup (getstring nil "\nZ鐔l 16 iœ < 1 > : "))) 
        (setq sup "1")
      )
      (setq up (ifs_hexToInt sup))
 
      (setq i 0)
      (repeat (sslength ss) 
        (ifs_func_sbupH (ssname ss i) up st hlen)
        (setq i (1+ i))
      )
    )
  )
  (setq *error* nil)
  (princ)
)

;; LWPOLYLINE1ӂړ   
(defun c:plMv (/ my_error esel pick pts orthomode dimsc loop) 
  ;; LWPOLYLINE̒_W̎擾(10-42LISTɂj
  ;; ̎́AŌɎn_ǉ
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setvar "ORTHOMODE" orthomode)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq orthomode (getvar "ORTHOMODE")
        dimsc     (getvar "DIMSCALE")
  )
  (setvar "ORTHOMODE" 1)
  (setq loop T)
  (while loop
    (initget "Exit eXit")
    (setq esel (entsel "\nړiXgb`j|ĈPӂw [E,X:I]: ")) 
    (cond
      ((or (= esel "Exit")(= esel "eXit"))
        (setq loop nil))
      ((and esel (listp esel))
        (progn
          (if (setq pick (osnap (cadr esel) "_nea"))
            (setq pts (ifs_func_pickEle (car esel) pick))
          )
          (if (and pick pts)
            (progn 
              (setq pts (ifs_lineW (car pts) (cadr pts) (* 0.5 dimsc)))
              ;; [h ON H
              (command "_UNDO" "BE")
              (command "_STRETCH" "_C" "none" (car pts) "none" (cadr pts) "" pick)
              (while (= (getvar "CMDNAMES") "STRETCH") 
                (command PAUSE)
              )
              (command "_UNDO" "END")
            )
          )
        )
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setvar "ORTHOMODE" orthomode)
  (setq *error* nil)
  (princ)
)
  ;; pick _ɋ߂ LWP Gg 2 _Ԃ
  ;; _Ac݂͖
(defun ifs_func_pickEle (ename pick / ename ent enttype pick i p list10 v10 loop res 
                         cnt len p1 p2 v70
                        ) 
  (setq ent     (entget ename)
        enttype (cdr (assoc 0 ent))
        cnt     (cdr (assoc 90 ent))
  )
  (if (= enttype "LWPOLYLINE") 
    (progn 
      ;;(princ "LWP")
      (setq i 0)
      (repeat (length ent) 
        (setq p (nth i ent))
        ;ł邩̎擾
        (if (= (car p) 70) (setq v70 (cdr p)))
        (if (= (car p) 10) 
          (setq  ;10̒l
                v10    (cdr (nth i ent)) ;c݂̒l
                 ;v42 (cdr (nth (+ i 3) ent ))
                 ;;i (+ i 3)
                list10 (cons v10 list10)
          )
        )
        (setq i (1+ i))
      )
      (if (= v70 1) 
        (setq list10 (cons (last list10) list10))
      )
    )
  )
  (if (and list10 (>= (setq len (length list10)) 2)) 
    (progn 
      (setq loop T
            i    0
      )
      (while (and loop (< i (1- len))) 
        (setq p1 (nth i list10)
              p2 (nth (1+ i) list10)
        )
        (if (< (abs (- (distance p1 p2) (distance p1 pick) (distance pick p2))) 0.0001)
          (setq res  (list p1 p2)
                loop nil
          )
        )
        (setq i (1+ i))
      )
    )
  )
  res
)
 
  ;; ubN ename Ԃ擾
  ;; TagName = "SENBAN" Œ
  ;; Ԃ "" Ԃ
(defun ifs_getSenban (ename / flag ent senban) 
  (setq flag   T
        senban ""
  )
  (while 
    (and flag 
         (setq ename (entnext ename))
         (setq ent (entget ename))
         (= "ATTRIB" (cdr (assoc 0 ent)))
    )
    ;; :"SENBAN" ̓e擾
    (if (= (cdr (assoc 2 ent)) "SENBAN") 
      (setq senban (cdr (assoc 1 ent)) ;; I
            flag   nil
      )
    )
  )
  senban
)

;; Ԓǉ
(defun c:sbAdd (/ my_error p1 p2 i ss ename ent p3 p4 kp sbes sbp tateFlag sbename 
              senban sbname deg dimsc loop res mode mes
              loop2 pts lst) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setq dimsc (getvar "DIMSCALE"))
  (setvar "CMDECHO" 0)

  (setq loop T mode "P")
  (while loop
    (setq p1 nil p2 nil loop2 T)
    (while loop2
      (if (= mode "P")
        (setq mes "\n̐Ԃǉ̂P_w [F:tFXQ_w /E,X:I] : ")
        (setq mes "\n̐ԂǉtFXÎP_ڂw [P:P_w /E,X:I] : ")
      )
      (initget "E X P F")
      (setq res (getPoint mes))
      (cond
        ((or (= res "E")(= res "X"))(setq loop nil loop2 nil))
        ((or (= res "P")(= res "F"))(setq mode res))
        ((and res (listp res) (= mode "F"))
          (progn
            (setq p1 res)
            (if (setq p2 (getPoint p1 "\nQ_ڂw < 1_ > : "))
              (setq loop2 nil)
            )
          )
        )
        ((and res (listp res) (= mode "P"))
          (progn 
            (setq p1 res loop2 nil)
          )
        )
      )
    )
    (if (or (and p1 p2 (= mode "F"))(and p1 (= mode "P")))
      (progn 
        (if (= mode "P")
          (progn
            (setq pts (ifs_pointW p1 0.1))
            (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE") (8 . "*WIRE*"))))
          )
          (progn
            (if (ifs_isTate p1 p2)
              (setq p2 (list (car p1)(cadr p2)(caddr p1)))
              (setq p2 (list (car p2)(cadr p1)(caddr p1)))
            )
            (setq ss (ssget "F" (list p1 p2) '((0 . "LINE") (8 . "*WIRE*"))))
          )
        )
        (if (and ss (> (sslength ss) 0))
          (progn 
            (setq i 0)
            (repeat (sslength ss) 
              (setq ename    (ssname ss i)
                    ent      (entget ename)
                    p3       (cdr (assoc 10 ent))
                    p4       (cdr (assoc 11 ent)) 
                    sbes     (ifs_get_senbanEnames ename);; Ԃ擾
                    tateFlag (ifs_isTate p3 p4)
              )
              (if (= mode "P")
                (setq kp p1)
                (setq kp (inters p1 p2 p3 p4))
              )
              (if sbes  ;; ɐԂ
                (progn 
                  (setq sbename (ifs_nearSbe kp sbes)
                        ent     (entget sbename)
                        senban  (ifs_getSenban sbename)
                        sbname  (cdr (assoc 2 ent))
                        sbp     (cdr (assoc 10 ent))
                  )
                  
                  (setq lst (ifs_ValidSbBlkName tateFlag) sbname (car lst) deg (cadr lst))
                   (command "_UNDO" "BE")
                  (ifs_insert_sb sbname kp dimsc deg senban)
                  (command "_UNDO" "END")
                )
              )
              (setq i (1+ i))
            )
          )
        )
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; pt
(defun ifs_sub_sbmvp (lnename kp / blkname deg dimsc ent lst p3 p4 sbename 
                                sbes sbname sbp senban tateFlag )
  (setq dimsc (getvar "DIMSCALE"))
  (setq ent      (entget lnename)
        p3       (cdr (assoc 10 ent))
        p4       (cdr (assoc 11 ent)) 
        sbes     (ifs_get_senbanEnames lnename);; łɐԂ݂邩
        tateFlag (ifs_isTate p3 p4)
    )
  (if sbes  ;; ɐԂ
    (progn 
      (setq sbename (ifs_nearSbe kp sbes)
            ent     (entget sbename)
            senban  (ifs_getSenban sbename)
            sbname  (cdr (assoc 2 ent))
            sbp     (cdr (assoc 10 ent))
      )
      ;; ォ]px킹邽߁A]pxȂ
      (if (or (and (not tateFlag) (or (= sbname "SENBAN1") (= sbname "SENBAN00")))
              (and tateFlag (or (= sbname "SENBAN") (= sbname "SENBAN00"))))
        (progn ;;Ԃ
          (command "_UNDO" "BE")
          (command "_move" sbename "" "_non" sbp "_non" kp)
          (if (= sbname "SENBAN00") 
            (progn 
              ;;]␳
              (setq ent (entget sbename) deg (ifs_radToDeg (cdr (assoc 50 ent))))
              (if (equal 360.0 deg 1.0)(setq deg 0.0))
              (if tateFlag 
                (if (equal deg 0.0 1.0) 
                  (command "_ROTATE" sbename "" "none" kp 90.0)
                )
                (if (equal deg 90.0 1.0) 
                  (command "_ROTATE" sbename "" "none" kp -90.0)
                )
              )
            )
          )
          (command "_UNDO" "END")
        )
        (progn 
          (entdel sbename)
          (setq lst (ifs_ValidSbBlkName tateFlag) blkname (car lst) deg (cadr lst))
          (command "_UNDO" "BE")
          (ifs_insert_sb blkname kp dimsc deg senban)
          (command "_UNDO" "END")
        )
      )
    )
    (princ "\n񂷂Ԃ܂D")
  )

)
;; ԈړiP_w^ړtFXQ_wj
(defun c:sbMv (/ my_error p1 p2 i ss loop ename ent kp loop2 mes mode pts res) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  
  (setq loop T mode "P")
  (while loop
    (setq p1 nil p2 nil loop2 T)
    (while loop2
      (if (= mode "P")
        (setq mes "\n̐Ԃړ̂P_w [F:tFXQ_w /E,X:I] : ")
        (setq mes "\n̐ԂړtFXÎP_ڂw [P:P_w /E,X:I] : ")
      )
      (initget "E X P F")
      (setq res (getPoint mes))
      (cond
        ((or (= res "E")(= res "X"))(setq loop nil loop2 nil))
        ((or (= res "P")(= res "F"))(setq mode res))
        ((and res (listp res) (= mode "F"))
          (progn
            (setq p1 res)
            (if (setq p2 (getPoint p1 "\nQ_ڂw < 1_ > : "))
              (setq loop2 nil)
            )
          )
        )
        ((and res (listp res) (= mode "P"))
          (progn 
            (setq p1 res loop2 nil)
          )
        )
      )
    )
    (if (or (and p1 p2 (= mode "F"))(and p1 (= mode "P")))
      (progn 
        (if (= mode "P")
          (progn
            (setq pts (ifs_pointW p1 0.1))
            (setq ss (ssget "C" (car pts) (cadr pts) '((0 . "LINE") (8 . "*WIRE*"))))
          )
          (progn
            (if (ifs_isTate p1 p2)
              (setq p2 (list (car p1)(cadr p2)(caddr p1)))
              (setq p2 (list (car p2)(cadr p1)(caddr p1)))
            )
            (setq ss (ssget "F" (list p1 p2) '((0 . "LINE") (8 . "*WIRE*"))))
          )
        )
        (if (and ss (> (sslength ss) 0))
          (progn 
            (setq i 0)
            (repeat (sslength ss) 
              (setq ename    (ssname ss i)
                    ent      (entget ename)
              )
              (if (= mode "P")
                (setq kp p1)
                (setq kp (inters p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent)) ))
              )
              (ifs_sub_sbmvp ename kp)
              (setq i (1+ i))
            )
          )
        )
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
  ;; t@CI_CAOubN}
(defun c:bIn (/ my_error fname dwgPath dwgName insName elast attreq clayer 
              ename gridmode gridunit snapmode snapunit dimsc)
              ;;lst s1 s2 s3) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "ATTREQ" attreq)
    ;;(setvar "ATTDIA" attdia)
    (setvar "CLAYER" clayer)
    (setvar "SNAPUNIT" snapunit)
    (setvar "SNAPMODE" snapmode)
    (setvar "GRIDUNIT" gridunit)
    (setvar "GRIDMODE" gridmode)

    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setq attreq   (getvar "ATTREQ")
        ;;attdia   (getvar "ATTDIA")
        clayer   (getvar "CLAYER")
        snapunit (getvar "SNAPUNIT")
        snapmode (getvar "SNAPMODE")
        gridunit (getvar "GRIDUNIT")
        gridmode (getvar "GRIDMODE")
        dimsc    (getvar "DIMSCALE")
  )
  ;;(setvar "ATTDIA" 0)
  (setvar "ATTREQ" 0)
  (setvar "CLAYER" "WIRE")
  (setvar "CMDECHO" 0)
  (setvar "SNAPUNIT" '(1.25 1.25))
  (setvar "SNAPMODE" 1)
  (setvar "GRIDUNIT" '(5.0 5.0))
  (setvar "GRIDMODE" 1)

  (setq dwgPath (ifs_readIni "BTRIMVX23" "dwgPath"))
  ;;(princ dwgPath)
  (if (setq fname (getfiled "Select a dwg File" dwgPath "dwg;dxf" 8)) 
    (progn 
      (setq dwgPath (vl-filename-directory fname) ;; Ṓ
            dwgName (vl-filename-base fname)
      )
      (ifs_writeIni "BTRIMVX23" "dwgPath" (strcat dwgPath "\\"))

      (if (tblsearch "BLOCK" dwgName) 
        (setq insName dwgName)
        (setq insName fname)
      )
      (while T
        (prompt "\n}ʒuw [ESC:I] : ")
        (setq elast (entlast))
        (command "-INSERT" insName "S" dimsc "R" 0)
        (while (= (getvar "CMDNAMES") "-INSERT") 
          (command pause)
        )
        (if (not (equal elast (setq ename (entlast)))) 
          (progn 
            (ifs_sub_btrimvx ename)
            (if (ifs_getAttValue ename "NAME")
              (progn
                (ifs_layerOn "NAME")
                (ifs_sub_nmed ename nil)
                ;; JEgAbv
                ; (setq lst (ifs_SprNum3 org) s1 (car lst) s2 (cadr lst) s3 (caddr lst))
                ; (if (/= s2 "")
                ;   (setq org (strcat s1 (itoa (1+ (atoi s2))) s3))
                ; )
              )
            )
            ;;(ifs_func_edit_bname ename T)
          )
        )
      )
      
    )
  )
  (setvar "ATTREQ" attreq)
  ;;(setvar "ATTDIA" attdia)
  (setvar "CLAYER" clayer)
  (setvar "SNAPUNIT" snapunit)
  (setvar "SNAPMODE" snapmode)
  (setvar "GRIDUNIT" gridunit)
  (setvar "GRIDMODE" gridmode)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; RST, UVW, PN, LN ...  3 A2 pԂ쐬
(defun c:sb3w (/ my_error ename ent head numstr p1 p2 p3 p4 kp kps cnt e1 e2 i len 
               loop senban ss tateFlag mode j kw sbenames sbestrs sbname dimsc deg
               lst sb newstr blkname lstn up)
  ;; łɐԂ݂ꍇ͂ύXAړDꍇ͐VKɍ쐬B
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setvar "CMDECHO" 0)
  (setq *error* my_error)
  (setq mode  "Up"
        loop  T
        dimsc (getvar "DIMSCALE")
  )
  (while loop 
    (if (= mode "Up") 
      (progn 
        (setq up (getint "\nJEgAbv < 1 >"))
        (if (not up)(setq up 1))
        (setq mode "Head")
        ;;(if (not cnt)(setq cnt 0 numstr "1"))
      )
    )  
    (if (= mode "Head") 
      (progn 
        (setq head (getstring "\n3A2̐Ԃ̌Œ蕶 < RST > "))
        (if (= "" head) (setq head "RST"))
        (setq head (strcase head))
        (setq mode "Num")
      )
    )
    (if (= mode "Num") 
      (progn 
        (setq numstr (getstring "\n̏l ( . = Ȃ) < 1 >"))
        (if (= numstr "")(setq numstr "1"))
        (setq cnt  0
              mode ""
        )
      )
    )
    (setq p1  nil
          p2  nil
          kps nil
    )
    (initget "Exit Head Num eXit Up")
    (if (= numstr ".")
      (setq newstr "")
      (setq newstr  (itoa (+ (atoi numstr) cnt)))
    )
    (setq p1 (getpoint 
               (strcat "\n" head 
                       " "
                       newstr ;; (itoa (+ (atoi numstr) cnt))
                       " 쐬ʒu3A2tFXI1_ڂw [H:Œ蕶 /N: /U:Abv /E,X:I] : "
               )
             )
    )
    (cond 
      ((or (= p1 "Exit")(= p1 "eXit")) (setq loop nil))
      ((= p1 "Head") (setq mode "Head"))
      ((= p1 "Num") (setq mode "Num"))
      ((= p1 "Up") (setq mode "Up"))
      ((and p1 (listp p1))(setq p2 (getpoint p1 "\n2_ڂw < 1_ڎw > ")))
    )
    (if (and p1 p2)
      (if (ifs_isTate p1 p2)
        (setq p2 (list (car p1)(cadr p2)(caddr p1)))
        (setq p2 (list (car p2)(cadr p1)(caddr p1)))
      )
    )
    (if (and p1 p2) 
      (if (setq ss (ssget "F" (list p1 p2) '((0 . "LINE")(8 . "*WIRE*")(-4 . "<NOT")(8 . "WIREO")(-4 . "NOT>"))))
        (progn 
          (setq tateFlag (not (ifs_isTate p1 p2))
                len      (sslength ss)
                i        0
                kps      nil
          )
          (if (> len (strlen head)) (setq len (strlen head)))
          (repeat len 
            (setq ent (entget (ssname ss i))
                  p3  (cdr (assoc 10 ent))
                  p4  (cdr (assoc 11 ent))
            )
            (if (setq kp (inters p1 p2 p3 p4)) 
              ;; tFXƂ̌_A̎n_AI_AENAME
              (setq kps (append kps (list (list kp p3 p4 (ssname ss i)))))
            )
            (setq i (1+ i))
          )
        )
      )
    )
    (if kps 
      (progn 
        (setq kps (vl-sort kps (function (lambda (e1 e2) (< (distance p1 (car e1)) (distance p1 (car e2)))))))
        (setq i  0
              kw nil
        )
        (repeat (length kps) 
          (if (= "." numstr) 
            (setq senban (substr head (1+ i) 1)) ;; Ȃ
            (setq senban (strcat (substr head (1+ i) 1) 
                                 (itoa (+ (atoi numstr) cnt))
                         )
            )
          )
          ;;IɂłɐԂ
          (if (and T (setq sbenames (ifs_get_senbanEnames (cadddr (nth i kps))))) 
            (progn 
              (setq sbestrs ""
                    j       0
              )
              (repeat (length sbenames)
                (if (setq sb (ifs_getAttvalue (nth j sbenames) "SENBAN"))
                  (if (= sbestrs "")
                    (setq sbestrs sb)
                    (setq sbestrs (strcat sbestrs " " sb))
                  )
                )
                (setq j (1+ j))
              )
              (if (not kw) 
                (progn 
                  (initget "Move Add Up New Pass")
                  (if (not (setq kw (getkword (strcat "\n " senban " ͊̐ " sbestrs " ƈقȂ܂DI [M:ړ /A:ǉ /U:XV̂ /N:̐Ԃǉ /P:pX] < U > : "))))
                    (setq kw "Up")
                  )
                )
              )
            )
          )
          (cond 
            ((or (= kw "Add") (= kw "Up"));; ԂXV
             (progn 
               (setq j 0)
               (repeat (length sbenames) 
                 (command "_UNDO" "BE")
                 (ifs_setAttvalue (nth j sbenames) "SENBAN" senban)
                 (command "_UNDO" "END")
                 (setq j (1+ j))
               )
             )
            )
            ((= kw "Move");; Ԃړ
              (progn  ;;;(princ "\nԈړ ");i]pxKvj
                    (setq ename  (car sbenames)
                          ent    (entget ename)
                          sbname (cdr (assoc 2 ent))
                    )
                    (if (= sbname "SENBAN00") 
                      (progn 
                        (command "_UNDO" "BE")
                        (command "move" ename "" "_non" (cdr (assoc 10 ent)) "_non" (car (nth i kps)))
                        (ifs_setAttvalue ename "SENBAN" senban)
                        (setq deg (ifs_radToDeg (cdr (assoc 50 ent))))
                        (if (equal 360.0 deg 1.0)(setq deg 0.0))
                        (if tateFlag 
                          (if (equal deg 0.0 1.0) 
                            (command "_ROTATE" ename "" "_non" (car (nth i kps)) 90.0)
                          )
                          (if (equal deg 90.0 1.0) 
                            (command "_ROTATE" ename "" "_non" (car (nth i kps)) -90.0)
                          )
                        )
                        (command "_UNDO" "END")
                      )
                      (if (or (= sbname "SENBAN") (= sbname "SENBAN1")) 
                        (progn 
                          (command "_UNDO" "BE")
                          (entdel ename)
                          (setq lstn (ifs_ValidSbBlkName tateFlag) blkname (car lstn) deg (cadr lstn))
                          (ifs_insert_sb blkname (car (nth i kps)) dimsc deg senban)
                          (command "_UNDO" "END")
                        )
                      )
                    )
              )
            )
          )
          (if (or (not kw)(= kw "Add"))  ;; Ԃ쐬
            (progn
              (command "_UNDO" "BE")
              (setq lstn (ifs_ValidSbBlkName tateFlag) blkname (car lstn) deg (cadr lstn))
              (ifs_insert_sb blkname (car (nth i kps)) dimsc deg senban)
              (command "_UNDO" "END")
            )
          )
          (if (and kw (= kw "New")) ;;Ԃ쐬
            (if (/= sbestrs "")
              (if (and (setq lst (ifs_strSplit sbestrs " ")) (>= (length lst) 1))
                (progn
                  (command "_UNDO" "BE")
                  (setq lstn (ifs_ValidSbBlkName tateFlag) blkname (car lstn) deg (cadr lstn))
                  (ifs_insert_sb blkname (car (nth i kps)) dimsc deg (car lst))
                  (command "_UNDO" "END")                  
                )
              )
            )
          )
          (setq i (1+ i))
        )
        (if (and (/= kw "Pass")(/= kw "New"));; JEgAbv̏
          (setq cnt (+ cnt up))
        )
      )
    )
  )
  (setq *error* nil)
  (princ)
)

;; R`
(defun c:sq3w (/ w) 
  (if (not (setq w (getreal "\n̊Ԋu < 5.0 > : "))) 
    (setq w 5.0)
  )
  (setvar "CMDECHO" 0)
  (ifs_do_sqww 3 w)
  (setvar "CMDECHO" 1)
  (princ)
)
;; Q쐬
(defun c:sq2w (/ w) 
  (if (not (setq w (getreal "\nn̊Ԋu < 5.0 >	: "))) 
    (setq w 5.0)
  )
  (setvar "CMDECHO" 0)
  (ifs_do_sqww 2 w)
  (setvar "CMDECHO" 1)
  (princ)
)

;; _}[N}BĆwWIRExŒB
(defun ifs_insert_cmark (blkname pos sc / clay cmdecho) 
  (ifs_make_layer "WIRE" 3 nil)
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (if (not (tblsearch "BLOCK" blkname)) 
    (ifs_make_cmark blkname)
  )
  (setq clay (getvar "CLAYER"))
  (setvar "CLAYER" "WIRE")
  (command "-INSERT" blkname "none" pos sc sc 0)
  (setvar "CLAYER" clay)
  (setvar "CMDECHO" cmdecho)
)
;; pxϊiWA -> xj
(defun ifs_degToRad (deg / rad) 
  (setq rad (* pi (/ deg 180.0)))
  (if (>= (* PI 2.0) rad )(setq rad (- rad (* PI 2.0))))
  rad
)
;; pxϊix -> WAj
(defun ifs_radToDeg (rad / deg) 
  (setq deg (* 180.0 (/ rad pi)))
  (if (>= deg 360.0)(setq deg (- deg 360.0)))
  deg
)
;; ifs_do_sqww, ifs_do_sq3w Ă΂鋤p
;; 3A2쐬̎s
(defun ifs_sub_sqww3w (p1 p2 sqn sqw / ang cnt dimsc e1 e2 ename ent i j keisuu 
     kelist kp kw n p1n p2n pst s
     ss stFlag tateFlag w )
  
  (setq dimsc (getvar "dimscale"))
  (setq kelist nil tateFlag (ifs_isTate p1 p2))
  (if tateFlag
    (setq p2 (list (car p1)(cadr p2)(caddr p1)))
    (setq p2 (list (car p2)(cadr p1)(caddr p1)))
  )

  (if tateFlag (setq ang PI) (setq ang (/ PI 2.0)))
  (if (not (setq ss (ssget "F" (list (polar p1 ang 0.5) p2) '((0 . "LINE"))))) 
    (setq stFlag T)
    (progn 
      (setq cnt (sslength ss) i 0)
      (repeat cnt 
        (setq ename (ssname ss i) ent(entget ename))
        (if (setq kp (inters p1 p2 (cdr (assoc 10 ent))(cdr (assoc 11 ent)) nil))
          (setq kelist (append kelist (list (list kp ename))))
        )
        (setq i (1+ i))
      )
      (if (not kelist) 
        (setq stFlag T)
        (progn 
          ;;enamen_̋߂Ƀ\[g
          (setq kelist (vl-sort kelist (function (lambda (e1 e2) (< (distance p1 (car e1)) (distance p1 (car e2)))))))
          (setq ang (angle p1 p2))
          (if (or (< ang (* pi 0.5)) (> ang (* pi 1.5))) 
            (setq ang (- ang (/ pi 2.0)))
            (setq ang (+ ang (/ pi 2.0)))
          )
          ;;R葽Ƃ͂Rɂ
          (if (> (setq n (length kelist)) 3) (setq n 3))
          (if (and (= n 3) (= sqn 2)) 
            (progn 
              (initget "RS TS RT")
              (if (not (setq kw (getkword "\nI [RS/TS/RT] < RS > : "))) 
                (setq kw "RS")
              )
              (cond 
                ((= kw "RS") (setq s 2))
                ((= kw "TS") (setq s 0))
                ((= kw "RT") (setq s 1))
              )
            )
          )
          (if (or (= n 2) s) 
            (progn 
              ;;(princ " typeA")
              (if (= s 0) 
                (setq keisuu '(1.0 0.0))
                (setq keisuu '(0.0 1.0))
              )
            )
            (progn 
              ;;(princ " typeB")
              (setq keisuu '(0.0 1.0 2.0))
            )
          )
          (setq i 0
                j 0
          )
          (setvar "CMDECHO" 0)
          (command "_UNDO" "BE")
          (repeat n 
            (if (not (and s (= i s))) 
              (progn 
                (setq w   (* sqw (nth j keisuu))
                      p1n (polar p1 ang w)
                      p2n (polar p2 ang w)
                      ent (entget (cadr (nth i kelist)))
                      pst (inters (cdr (assoc 10 ent)) 
                                  (cdr (assoc 11 ent))
                                  p1n
                                  p2n
                                  nil
                          )
                )
                (ifs_sub_bline pst p2n nil)
                (ifs_insert_cmark "CMARK" pst dimsc)
                (setq j (1+ j))
              )
            )
            (setq i (1+ i))
          )
          (if (and (= sqn 3) (= n 0)) 
            (progn 
              (ifs_sub_bline 
                (polar p1 ang (- sqw))
                (polar p2 ang (- sqw))
                nil
              )
              (ifs_sub_bline p1 p2 nil)
              (ifs_sub_bline (polar p1 ang sqw) (polar p2 ang sqw) nil)
            )
          )
          (command "_UNDO" "END")
        )
      )
    ) ;; end progn
  )
  (if stFlag 
    ;;  ŏ̕` Ɠ꒼ŉ
    (progn 
      (if (= sqn 2) 
        (if tateFlag 
          (setq keisuu '(0.0 1.0))
          (setq keisuu '(0.0 -1.0))
        )
        (if tateFlag 
          (setq keisuu '(0.0 1.0 2.0))
          (setq keisuu '(0.0 -1.0 -2.0))
        )
      )
      (setq i 0)
      (if tateFlag (setq ang (+ ang PI)))
      (setvar "CMDECHO" 0)
      (command "_UNDO" "BE")
      (repeat sqn 
        (setq w   (* sqw (nth i keisuu))
              p1n (polar p1 ang w)
              p2n (polar p2 ang w)
        )
        (ifs_sub_bline p1n p2n T);; _fǉ              
        (setq i (1+ i))
      )
      (command "_UNDO" "END")
    )
  )
  (command "_regen");; nCCg\cƂ肠̓
)
;; R}h bln Ă΂iP@\Łj
(defun ifs_do_sq3w (sqn w / loop p1 p2 loop2 dimsc sqw stFlag )
   (setq dimsc (getvar "DIMSCALE")
        sqw   (* w dimsc)
   )
  (setq loop T)
  (while loop 
    (setq p1 nil p2 nil stFlag nil)
    (setq loop2 T)
    (while loop2
      (setq p1 (getpoint (strcat "\n" (itoa sqn) " ̎n_(^㑤)w < ߂ > : ")))
      (cond 
        ((or (= p1 "E")(= p1 "X"))(setq loop nil loop2 nil))
        ((and p1 (listp p1))
          (if (setq p2 (getpoint p1 "\nI_w < n_w > : "))
            (setq loop2 nil)
          )
        )
        (T (setq loop nil loop2 nil))
      )
    )
    (if (and p1 p2 (listp p1)(listp p2))
      (ifs_sub_sqww3w p1 p2 sqn sqw)
    )
  )
)

(defun ifs_do_lcutC ( p1 / pt ss)
  (if (setq pt (osnap p1 "near"))
    (progn
      ;;(setq ss (ssget ":S" pt '((0 . "LINE"))));;IJCAD ŃG[ɂȂ
      (if (and (setq ss (ssget  pt '((0 . "LINE"))))(> (sslength ss) 0))
        (progn
          (command "_UNDO" "BE")
          (ifs_sq_lcut (ssname ss 0) pt 1)
          (command "_UNDO" "END")
        )
      )
    )
  )
)
(defun ifs_do_lcutF ( p1 / p2 ename ent i kp p1n p2n ss)
  (if (setq p2 (getpoint p1 "\nQ_ڂw : "))
    (progn
      (if (ifs_isTate p1 p2)
        (setq p2 (list (car p1)(cadr p2)(caddr p1)))
        (setq p2 (list (car p2)(cadr p1)(caddr p1)))
      )
      (if (setq ss (ssget "F" (list p1 p2) '((0 . "LINE")))) 
        (progn 
          (setq i 0)
          (command "_UNDO" "BE")
          (repeat (sslength ss) 
            (setq ename (ssname ss i)
                  ent   (entget ename)
                  p1n   (cdr (assoc 10 ent))
                  p2n   (cdr (assoc 11 ent))
            )
            (if (setq kp (inters p1 p2 p1n p2n)) 
              (ifs_sq_lcut ename kp 1)
            )
            (setq i (1+ i))
          )
          (command "_UNDO" "END")
        )
      )
    )
  )
)
;; V[PXpQAR쐬
;; ^
;; R}h sq3w, sq2w Ă΂(ifs_do_sq3w ɋ@\ǉ)
(defun ifs_do_sqww (sqn0 ww / my_error orthoOrg snapOrg snapUnitOrg sunit dimsc 
                    sqw p1 p2 ss i ename ent p1n p2n  
                    loop sqn mes mode esel name pick stFlag clayer kp) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    ;;(command "_UNDO" 1)
    (setvar "ORTHOMODE" orthoOrg)
    (setvar "SNAPMODE" snapOrg)
    (setvar "SNAPUNIT" snapUnitOrg)
    (setvar "CLAYER" clayer)
    (setvar "CMDECHO" 1)

    (setq *error* nil)
  )
  (setq *error* my_error)
  (setq orthoOrg    (getvar "ORTHOMODE")
        snapOrg     (getvar "SNAPMODE")
        snapUnitOrg (getvar "SNAPUNIT")
        orthoOrg    (getvar "ORTHOMODE")
        clayer      (getvar "CLAYER")
  )
  (setvar "ORTHOMODE" 1)
  (setvar "SNAPMODE" 1)
  (setq dimsc (getvar "DIMSCALE")
        sqw   (* ww dimsc)
        sunit (* dimsc 1.25)
  )
  (setvar "SNAPUNIT" (list sunit sunit))
  (setvar "CLAYER" "WIRE")

  (ifs_make_layer "WIRE" 3 nil)
  (setq loop T
        sqn  sqn0
        mode "sqww"
  )
  (while loop 
    (setq p2     nil
          stFlag nil
    )
    (if (= sqn 2) 
      (setq mes (strcat "\n" (itoa sqn) " ̎n_(^㑤)w [3:3쐬 /C:폜 /F:tFX폜 /E,X:I] : "))
      (setq mes (strcat "\n" (itoa sqn) " ̎n_(^㑤)w [2:2쐬 /C:폜 /F:tFX폜 /E,X:I] : "))
    )
    (if (= mode "sqww") 
      (progn 
        (initget "Exit 2 3 Cut Fence eXit")
        (setq p1 (getpoint mes))
        (cond 
          ((or (= p1 "Exit")(= p1 "eXit")) (setq loop nil))
          ((= p1 "2") (setq sqn  2 mode "sqww"))
          ((= p1 "3") (setq sqn  3 mode "sqww"))
          ((= p1 "Cut") (setq mode "Cut"))
          ((= p1 "Fence") (setq mode "Fence"))
          ((and p1 (listp p1))
            (progn 
              (initget 32)
              (setq p2 (getpoint p1 "\nI_w < n_w > : "))
            )
          )
        )
      )
    )
    (if (= mode "Cut") 
      (progn 
        (initget "Exit 2 3 Fence eXit")
        (setq esel (entsel "\nJbgI [2:2쐬 /3:3쐬 /F:tFX폜 /E,X:I] : "))
        (cond 
          ((or (= esel "Exit")(= esel "eXit")) (setq loop nil))
          ((= esel "2") (setq sqn  2 mode "sqww"))
          ((= esel "3") (setq sqn  3 mode "sqww"))
          ((= esel "Fence") (setq mode "Fence"))
          ((and esel (listp esel))
            (progn 
              (setq ename (car esel)
                   pick  (cadr esel)
                   ent   (entget ename)
                   name  (cdr (assoc 0 ent))
              )
              (cond 
                ((= name "LINE")
                  (progn 
                    (command "_UNDO" "BE")
                    (ifs_sq_lcut ename pick 1)
                    (command "_UNDO" "END")
                  )
                )
              )
            )
          )
        )
      )
    )
    (if (= mode "Fence") 
      (progn 
        (initget "Exit 2 3 Cut eXit")
        (setq p1 (getpoint "\n폜tFXI1_ڂw [2:2쐬 /3:3쐬 /C:폜 /E.X:I] : "))
        (cond 
          ((or (= p1 "Exit")(= p1 "eXit"))(setq loop nil))
          ((= p1 "2")
           (setq sqn  2
                 mode "sqww"
           )
          )
          ((= p1 "3")
           (setq sqn  3
                 mode "sqww"
           )
          )
          ((= p1 "Cut") (setq mode "Cut"))
          ((and p1 (listp p1))
            (if (setq p2 (getpoint p1 "\n2 _ڂw : ")) 
              (progn
                (if (ifs_isTate p1 p2)
                  (setq p2 (list (car p1)(cadr p2)(caddr p1)))
                  (setq p2 (list (car p2)(cadr p1)(caddr p1)))
                )
                (if (setq ss (ssget "F" (list p1 p2) '((0 . "LINE")))) 
                  (progn 
                    (setq i 0)
                    (command "_UNDO" "BE")
                    (repeat (sslength ss) 
                      (setq ename (ssname ss i)
                          ent   (entget ename)
                          p1n   (cdr (assoc 10 ent))
                          p2n   (cdr (assoc 11 ent))
                      )
                      (if (setq kp (inters p1 p2 p1n p2n)) 
                        (ifs_sq_lcut ename kp 1)
                      )
                      (setq i (1+ i))
                    )
                    (command "_UNDO" "END")
                    (setq p1 nil
                        p2 nil
                    )
                  )
                )
              )
            )
          )
        )
      )
    )
    (if (and p1 p2 (listp p1)(listp p2))
      (ifs_sub_sqww3w p1 p2 sqn sqw)
    )
  )
  (setvar "ORTHOMODE" orthoOrg)
  (setvar "SNAPMODE" snapOrg)
  (setvar "SNAPUNIT" snapUnitOrg)
  (setvar "CLAYER" clayer)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
)

(defun ifs_func_sbup (ename up ketaFlag / lst keta numstr senban ret c) 
  (if (setq senban (ifs_attval ename "SENBAN" nil)) 
    (progn 
      (setq lst    (ifs_sprNum3 senban)
            numstr (cadr lst)
            ret    T
      )
      (if (/= "" numstr) 
        (setq keta   (strlen numstr)
              c (substr numstr 1 1)
              numstr (itoa (+ (atoi numstr) up))     
        )
      )
      ;;̐擪 "0" łΖŃ[pfBO
      (if (and (or ketaFlag (= c "0")) keta (< (strlen numstr) keta)) 
        (repeat (- keta (strlen numstr)) 
          (setq numstr (strcat "0" numstr))
        )
      )
      (setq senban (strcat (car lst) numstr (caddr lst)))
      (ifs_setAttvalue ename "SENBAN" senban)
    )
  )
  ret
)
(defun ifs_func_sbupH (ename up st hlen / senban ret head hex hexstr n term) 
  (if (setq senban (ifs_attval ename "SENBAN" nil)) 
    (if (/= "" senban) 
      (progn
        (setq head (substr senban 1 (1- st))
              hex  (substr senban st hlen)
              term (substr senban (+ st hlen))
              ret T
        )
        (setq n (ifs_hexToInt hex))
        (setq hexstr (ifs_intToHex (+ n up) hlen))
        (setq senban (strcat head hexstr term))
        (ifs_setAttvalue ename "SENBAN" senban)
      )
    )
  )
  ret
)


;; @햼Z
(defun ifs_func_nmup (ename up ketaFlag / lst name len1 len2 keta numstr ret c) 
  (setq numstr "")
  (setq lst (ifs_attval2 ename "NAME" "NAME1" nil nil))
  (if (or (car lst) (cadr lst)) 
    (progn 
      (setq name "")
      ;; NAME 
      (if (car lst) 
        (setq len1 (strlen (car lst))
              name (car lst)
        )
      )
      ;; NAME1 
      (if (cadr lst) 
        (setq len2 (strlen (cadr lst))
              name (strcat name (cadr lst))
        )
      )
      ;; NAME + NAME1 
      (if (/= name "") 
        (progn 
          (setq lst    (ifs_sprNum3 name)
                ret    T
                numstr (cadr lst)
          )
          (if (/= "" numstr) 
            (setq keta   (strlen numstr)
                  c (substr numstr 1 1)
                  numstr (itoa (+ (atoi numstr) up))
            )
          )
          ;; ̐擪 "0" łΖŃ[TvX
          (if (and (or ketaFlag (= c "0")) keta (< (strlen numstr) keta)) 
            (repeat (- keta (strlen numstr)) 
              (setq numstr (strcat "0" numstr))
            )
          )
          (setq name (strcat (car lst) numstr (caddr lst)))
          (if (and len1 (not len2)) 
            (ifs_attval ename "NAME" name)
            (if (and len1 len2)
              (ifs_attval2 ename "NAME" "NAME1" (substr name 1 len1) (substr name (1+ len1) (- (strlen name) len1)))
            )
          )
        )
      )
    )
  )
  ret
)
;; @햼ꊇŃAbv
(defun c:nmUpH (/ my_error ss up i hlen st sup) 
  (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
  )
  (setq *error* my_error)

  (prompt "\n@햼ꊇŉZubNIĂ")
  (if (setq ss (ssget '((0 . "INSERT") (-4 . "<NOT") (2 . "SENBAN*") (-4 . "NOT>")))) 
    (progn 

      (if (not (setq st (getint "\nPUil̐擪̕ʒu < 1 > : "))) 
        (setq st 1)
      )
      (if (not (setq hlen (getint "\nPUiľ < 1 > : "))) 
        (setq hlen 1)
      ) 
      (if (= "" (setq sup (getstring nil "\nZ鐔l 16 iœ < 1 > : "))) 
        (setq sup "1")
      )
      (setq up (ifs_hexToInt sup))
 
       (setq i 0)
      (repeat (sslength ss) 
        (ifs_func_nmupH (ssname ss i) up st hlen)
        (setq i (1+ i))
      )
    )
  )
  (setq *error* nil)
  (princ)
)
;; @햼Z(HEX)
(defun ifs_func_nmupH (ename up st hlen / lst name len1 len2 ret head term hex hexstr n)
  ;;(princ "\nup=")(princ up) (princ " st=")(princ st) (princ " hlen=")(princ hlen)
  ;;(setq numstr "")
  (setq lst (ifs_attval2 ename "NAME" "NAME1" nil nil))
  (if (or (car lst) (cadr lst)) 
    (progn 
      (setq name "")
      ;; NAME 
      (if (car lst) 
        (setq len1 (strlen (car lst))
              name (car lst)
        )
      )
      ;; NAME1 
      (if (cadr lst) 
        (setq len2 (strlen (cadr lst))
              name (strcat name (cadr lst))
        )
      )
      ;; NAME + NAME1 
      (if (/= name "") 
        (progn 
          ;;(princ name)
          (setq head (substr name 1 (1- st))
                hex  (substr name st hlen)
                term (substr name (+ st hlen))
          )
          ;;(princ "\nhead=")(princ head) (princ " hex=")(princ hex) (princ " term=")(princ term)
          (setq n (ifs_hexToInt hex))
          (setq hexstr (ifs_intToHex (+ n up) hlen))
          (setq name (strcat head hexstr term))
          (if (and len1 (not len2)) 
            (ifs_attval ename "NAME" name)
            (if (and len1 len2)
              (ifs_attval2 ename "NAME" "NAME1" (substr name 1 len1) (substr name (1+ len1) (- (strlen name) len1)))
            )
          )
        )
      )
    )
  )
  ret
)

;; @햼ꊇŃAbv
(defun c:nmUp (/ my_error ss up i kw) 
  (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
  )
  (setq *error* my_error)

  (prompt "\n@햼ꊇŉZubNIĂ")
  (if (setq ss (ssget '((0 . "INSERT") (-4 . "<NOT") (2 . "SENBAN*") (-4 . "NOT>")))) 
    (progn 
      (if (not (setq up (getint "\nZ鐔l < 1 > : "))) 
        (setq up 1)
      )
      (if (< up 0);; Z̎
      	(progn
          (initget "Yes No")
          (setq kw (getkword "킹i[pfBOj܂H [Yes /No] < No > "))
      	)
      	(setq kw "No")
      )
      (setq i 0)
      (repeat (sslength ss) 
        (ifs_func_nmup (ssname ss i) up (= kw "Yes"))
        (setq i (1+ i))
      )
    )
  )
  (setq *error* nil)
  (princ)
)
  ;; A[XV{}
(defun c:etIn (/ my_error kw typ elast pos cmdecho loop mes) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" cmdecho)
    (setq *error* nil)

    (princ)
  )

  (setq *error* my_error)
  (setq cmdecho (getvar "CMDECHO"))
 
  (setvar "CMDECHO" 0)
  (initget "1 2 3 4")
  (setq kw (getkword "\nA[XV{̃^Cv [1:R /2:΂ߐ /3:~tLG}[N /4:~tFG}[N] < 1 > : "))
  (cond 
    ((or (not kw) (= kw "1")) (setq typ "00"))
    ((= kw "2") (setq typ "01"))
    ((= kw "3") (setq typ "02"))
    ((= kw "4") (setq typ "03"))
  )
  (setq mes kw)
  (setq loop typ)
  (while loop
    (initget "Exit eXit 1 2 3 4")
    (setq pos (getPoint (strcat "\n^Cv " mes " ̑}ʒuw [1:R /2:΂ߐ /3:~tLG}[N /4:~tFG}[N /E,X:I] : ")))
    (cond
      ((or (= pos "Exit")(= pos "eXit"))
        (setq loop nil))
      ((and pos (= pos "1")) (setq typ "00" mes "1"))
      ((and pos (= pos "2")) (setq typ "01" mes "2"))
      ((and pos (= pos "3")) (setq typ "02" mes "3"))
      ((and pos (= pos "4")) (setq typ "03" mes "4"))      
      ((and pos (listp pos ))
        (progn 
          (command "_UNDO" "BE")
          (setq elast (entlast))
          (ifs_insert_earth typ pos 1)
          
          (if (not (equal elast (entlast)))
            (ifs_sub_btrimvx (entlast))
          )
          (command "_UNDO" "END")
        ))
    )
  )
  (setvar "CMDECHO" cmdecho)
  (setq *error* nil)
  (princ)
)

;; A[XV{쐬
(defun ifs_insert_earth (typ pos sc / blkname cmdecho clay) 
  (cond 
    ((= typ "00")
      (if (tblobjname "BLOCK" "E_T1")
        (setq blkname "E_T1")
        (progn
          (setq blkname "E_T00")
          (ifs_make_sqe1)
        )
      ))
    ((= typ "01")
      (if (tblobjname "BLOCK" "F-E_T1")
        (setq blkname "F-E_T1")
        (progn
          (setq blkname "E_T01")
          (ifs_make_sqe2))
      ))
    ((= typ "02")
      (progn
        (setq blkname "EMARK_LG")
        (ifs_make_emarkLG "EMARK_LG")
      ))
    ((= typ "03")
      (progn
        (setq blkname "EMARK_FG") 
        (ifs_make_emarkFG "EMARK_FG")
      ))
  )
  (setq cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq clay (getvar "CLAYER"))
  (command "-LAYER" "M" "WIRE" "")
  (setvar "CLAYER" clay)
  (setvar "CMDECHO" cmdecho)

  (entmake 
    (list '(0 . "INSERT") 
          '(8 . "WIRE")
          (cons 2 blkname)
          (cons 10 pos)
          (cons 41 sc)
          (cons 42 sc)
          (cons 43 sc)
    )
  )
  ;;(command "_-INSERT" blkname pos sc sc 0)
)
;; I/O [qԍύX
(defun c:ioPIN( / my_error esel ename ent name p1 p2 pts ss lst str head num up e1 e2 i )
  (defun my_error(msg)
    (princ msg)
    (setq *error* nil)
  )  
  (setq *error* my_error)
  
  (initget "eXit")
	(setq esel (entsel "IO [qԍ̐擪ubNI [eXit] < X = I > : "))
	(if (and esel (/= esel "eXit"))
		(progn
			(setq ename (car esel) ent (entget ename))
			(if (= "INSERT" (cdr (assoc 0 ent)))
		 		(progn
		 			(setq name (cdr (assoc 2 ent)) p1 (cdr (assoc 10 ent)))
				)
			)
		)
	)
	(if (and name (wcmatch name "IO-DEF*"))
		(progn
			(setq
				p2 (polar p1 (* pi 1.5) 190)
				pts (ifs_lineCP p1 p2 0.5)
				str (ifs_getAttValue ename "PIN1")
				str (substr str 1 1)
			)
		)
	)
	(if pts
		(if	(setq ss (ssget "CP" pts '((0 . "INSERT") (2 . "IO-DEF*"))))
			(progn
				(setq i 0)
		 		(repeat (sslength ss)
					(setq 
						ename (ssname ss i) ent (entget ename)
						lst (append lst (list (list ename (cdr (assoc 10 ent)))))
						i (1+ i)
					)
				)
				(setq ss nil)
				(if lst
					(setq lst 
						(vl-sort lst (function (lambda (e1 e2)(< (distance p1 (cadr e1)) (distance p1 (cadr e2))))))
					)
				)
			)
		)
	)
	(if lst
		(progn
			(setq head (getstring (strcat "Œ蕶 <Enter = Ȃ> ")))
			(setq 
				head (strcase head)
				num (getint "̏l < 1 > ")
				up  (getint "JEgAbv < 1 > ")
			)
			(if (not num)(setq num 1))
			(if (not up )(setq up  1))

			(setq i 0)
			(repeat (length lst) 
				(setq str (ifs_intToDec (+ num (* up i)) 1))
        (setq ename (car (nth i lst)))
				(ifs_setAttValue ename "PIN1" (strcat head str))
				(setq i (1+ i))
			)
		)
	)
  (setq *error* nil)
  (princ)
)

;; PLC I/O AhXύX
;; Œ蕶𖳂ɏoȂ
(defun c:ioADR( / my_error esel ename ent name p1 p2 pts ss lst str head num numstr e1 e2 i kw len)
  (defun my_error(msg)
    (princ msg)
    (setq *error* nil)
  )  
  (setq *error* my_error)
  
  (initget "eXit")
	(setq esel (entsel "IO AhX̐擪ubNI [eXit] < X = I > : "))
	(if (and esel (/= esel "eXit"))
		(progn
			(setq ename (car esel) ent (entget ename))
			(if (= "INSERT" (cdr (assoc 0 ent)))
		 		(progn
		 			(setq name (cdr (assoc 2 ent)) p1 (cdr (assoc 10 ent)))
				)
			)
		)
	)
	(if (and name (wcmatch name "IO-DEF*"))
		(progn
			(setq
				p2 (polar p1 (* pi 1.5) 190)
				pts (ifs_lineCP p1 p2 0.5)
				str (ifs_getAttValue ename "IOADRS")
				str (substr str 1 1)
			)
		)
	)
	(if pts
		(if	(setq ss (ssget "CP" pts '((0 . "INSERT") (2 . "IO-DEFIN*,IO-DEFOUT*"))))
			(progn
				(setq i 0)
		 		(repeat (sslength ss)
					(setq 
						ename (ssname ss i) ent (entget ename)
						lst (append lst (list (list ename (cdr (assoc 10 ent)))))
						i (1+ i)
					)
				)
				(setq ss nil)
				(if lst
					(setq lst 
						(vl-sort lst (function (lambda (e1 e2)(< (distance p1 (cadr e1)) (distance p1 (cadr e2))))))
					)
				)
			)
		)
	)
	(if lst
		(progn
			(setq head (getstring (strcat "Œ蕶 <Enter = Ȃ> ")))
			(setq 
				head (strcase head)
				numstr (getstring "̏l <Enter = 00> ")
			)
			(if (= numstr "")(setq numstr "00"))
			(initget "Dec Oct Hex")
			(if (not (setq kw (getkword "IO AhX̃^Cv [Dec/Oct/Hex] <Enter = Hex> :")))
				(setq kw "Hex")
			)
			(setq i 0)
			(repeat (length lst) 
				(setq len (strlen numstr))
				(cond
					((= kw "Dec")(setq num (ifs_decToInt numstr)))
					((= kw "Oct")(setq num (ifs_octToInt numstr)))
					((= kw "Hex")(setq num (ifs_hexToInt numstr)))
				)
				(setq ename (car (nth i lst)))
				;;(princ ename)
				(cond
					((= kw "Dec")(setq str (ifs_intToDec (+ num i) len)))
					((= kw "Oct")(setq str (ifs_intToOct (+ num i) len)))
					((= kw "Hex")(setq str (ifs_intToHex (+ num i) len)))
				)
				(ifs_setAttValue ename "IOADRS" (strcat head str))
				(setq i (1+ i))
			)
		)
	)
  (setq *error* nil)
  (princ)
)
;; I/O ԂtFXɍ쐬
(defun c:sbAdrF (/ my_error ename ent flag i ioadrs kp len lst lstA p1 p2 ptA ptB 
                  ptC ptD ss cnt attreq_org loop dimsc
                 sboff sbename blkname deg main)
  ;; łɂꍇ͍XVAʒuύX
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setvar "ATTREQ" attreq_org)
    (setq *error* nil)

    (princ)
  )
  (setq *error* my_error)
  (setq attreq_org (getvar "ATTREQ")
        dimsc      (getvar "DIMSCALE")
  )
  (setvar "ATTREQ" 0)
  (setvar "CMDECHO" 0)

  (setq sboff (* 2.0 (getvar "DIMSCALE")))
  (setq main T)
  (while main

    (setq lst  nil lstA nil loop T p1 nil p2 nil)
    (while loop 
      (initget "Exit eXit") 
      (setq p1 (getpoint "\nI/O Ԃ쐬tFXQ_őIP_ڂw [E,X:I] : "))
      (cond 
        ((or (= p1 "Exit")(= p1 "eXit")) (setq loop nil main nil))
        ((and p1 (listp p1))
          (if (setq p2 (getpoint p1 "\nQ_ڂw < P_ > : ")) 
            (setq loop nil)
        )
        )
      )
    )
    ;;(princ p2)
    (if (and p1 p2) 
      ;; tFXQ_̔z擾
      (if (setq ss (ssget "C" p1 p2 '((0 . "LINE") (8 . "WIRE*")))) 
        (progn 
          (setq len (sslength ss) i 0)
          (repeat len 
            (setq ename (ssname ss i)
                  ent   (entget ename)
                  lst   (append (list (list (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))) lst)
                  i     (1+ i)
            )
          )
          (setq ss nil)
        )
      )
    )
    ;(princ "\nlst")
    (if lst 
      ;; zɂȂ IO-DEF ubNƂ̃AhX擾
      (progn 
        (setq len (length lst)
              i   0
        )
        (repeat len 
          ;; [_
          (setq ptA (car (nth i lst))
                ptB (cadr (nth i lst))
          )
          ;; w = "WIRE*", ubN = "IO=DEF*" 擾
          (setq ss (ssget "C" ptA ptB '((0 . "INSERT") (8 . "WIRE*") (2 . "IO-DEF*"))))
          (if ss 
            (progn 
              (setq ename (ssname ss 0)
                    sbename ename
                    flag  T
              )
              ;; ubN̑
              (while 
                (and flag 
                    (setq ename (entnext ename))
                    (setq ent (entget ename))
                    (= "ATTRIB" (cdr (assoc 0 ent)))
                )
                ;; IOAhX擾
                (if (= (cdr (assoc 2 ent)) "IOADRS") 
                  (progn 
                    ;; z̍WƃAhXXg
                    (setq lstA (append (list (list ptA ptB (cdr (assoc 1 ent)))) lstA))
                    ;; I
                    (setq flag nil)
                  )
                )
              )
              (setq ss nil)
            )
          )
          (setq i (1+ i))
        )
        (setq lst nil)
      )
    )
    ;(princ "lstA")
    (if lstA 
      ;; Ԃ擾
      (progn 
        (setq cnt 0
              len (length lstA)
              i   0
        )
        (command "_UNDO" "BE")
        (repeat len 
          ;; [_
          (setq lst (nth i lstA))
          (setq ptA (car lst) ptB (cadr lst) ioadrs (caddr lst))
          ;; tFXIƂ̌_
          (setq kp (inters p1 (polar p1 (+ (angle ptA ptB) (/ PI 2.0)) 100.0) ptA ptB nil ))
          
          ;; Ԃ͔z sboff ɂƑz
          (setq ptC (list (car ptA) (+ (cadr ptA) sboff) (caddr ptA))
                ptD (list (car ptB) (+ (cadr ptB) sboff) (caddr ptB))
          )
          (setq ss (ssget "C" ptC ptD '((0 . "INSERT") (8 . "*") (2 . "*SENBAN*"))))
          (if ss 
            ;; Ԃ݁iԂύXj
            (progn 
              (setq ename (ssname ss 0)
                    sbename ename
                    flag  T
              )
              (while 
                (and flag 
                    (setq ename (entnext ename))
                    (setq ent (entget ename))
                    (= "ATTRIB" (cdr (assoc 0 ent)))
                )
                ;; :"SENBAN" ̓ei=IOAhX)擾
                (if (= (cdr (assoc 2 ent)) "SENBAN") 
                  (progn 
                    (if (/= ioadrs (assoc 1 ent)) 
                      ;; Ԃ
                      (entmod (subst (cons 1 ioadrs) (assoc 1 ent) ent))
                    )
                    (command "_MOVE" sbename "" "none" (cdr (assoc 10  (entget sbename))) "none" kp)
                    ;; _ړ邾ŁAԂ̈ʒu͂̂܂
                    ;;(setq ent (entget ename))
                    ;;(entmod (subst (cons 10 kp) (assoc 10 ent) ent))
                    ;; I
                    (setq flag nil)
                  )
                )
              )
              (setq ss nil)
            )
            ;; ԂiubN}j
            (progn
              (setq lst (ifs_ValidSbBlkName (ifs_isTate ptA ptB)) blkname (car lst) deg (cadr lst))
              (ifs_insert_sb blkname kp dimsc deg ioadrs)
            )
          )
          (setq i (1+ i))
        )
        (command "_UNDO" "END")
        (setq lstA nil)
      )
    )
  )
  (setvar "ATTREQ" attreq_org)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

  ;; dTCYL
(defun c:sqSize (/ myerror lay col i ang ang1 ang2 loop elast ent kp p1 p2 pn ss 
                   plist p3 txtsize txtW dimsc yasize txt
                  ) 
  (defun myerror (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CLAYER" lay)
    (setvar "CECOLOR" col)
    (setvar "CMDECHO" 1)
  )
  (setq *error* myerror)
  (setq dimsc   (getvar "DIMSCALE")
        lay     (getvar "CLAYER")
        col     (getvar "CECOLOR")
        txtsize (* 2.0 dimsc)
        yasize  (* 1.8 dimsc)
  )

  (setvar "CLAYER" "0")
  (setvar "CECOLOR" "4")
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop 
    (setq plist nil)
    (initget 0 "Exit eXit")
    (if (setq p1 (getpoint "\ndTCYL̎n_w [E,X:I] : ")) 
      (progn 
        (if (or (= p1 "Exit")(= p1 "eXit")) 
          (setq loop nil)
          (if (setq p2 (getpoint p1 "\nI_w : ")) 
            (progn 
              (grdraw p1 p2 -1)
              (setq ang (angle p1 p2)
                    p1  (polar p1 (+ ang PI) 1.0)
              )
              (if (setq p3 (getpoint p2 "\nL̕w : ")) 
                (if (setq ss (ssget "F" (list p1 p2) '((0 . "LINE")))) 
                  (progn 
                    (setq ang2 (angle p2 p3))
                    (if (or (<= ang (* PI 0.5)) (> ang (* PI 1.5))) 
                      (setq ang1 (+ ang (/ (* 25 PI) 180)))
                      (setq ang1 (- ang (/ (* 25 PI) 180)))
                    )
                    (setq i 0)
                    (repeat (sslength ss) 
                      (setq ent   (entget (ssname ss i))
                            kp    (inters p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent)) nil)
                            plist (append (list kp) plist)
                            i     (1+ i)
                      )
                    )
                    (setq elast (entlast))
                    (command "_UNDO" "BE")
                    (setq txt (getstring T "\nL : ")) ;; 󔒂
                    (if (or (<= ang2 (* PI 0.5)) (> ang2 (* PI 1.5))) 
                      (progn 
                        ;; E
                        (setq pn (list (+ (car p2) (* txtsize 0.5)) 
                                       (+ (cadr p2) (* txtsize 0.2))
                                       0
                                 )
                        )
                        (command "_TEXT" "J" "BL" "_none" pn txtsize 0 txt)
                      )
                      (progn 
                        (setq pn (list (- (car p2) (* txtsize 0.5)) (+ (cadr p2) (* txtsize 0.2)) 0))
                        (command "_TEXT" "J" "BR" "_none" pn txtsize 0 txt)
                      )
                    )
                    (if (not (equal elast (entlast))) 
                      (progn 
                        (setq ent (entget (entlast))
                              ent (subst (cons 41 0.8) (assoc 41 ent) ent)
                        )
                        (entmod ent)
                        ;; ̃C𕶎̒ɍ킹
                        (setq txtW (fix (car (cadr (textbox ent)))))
                        (if (or (<= ang2 (* PI 0.5)) (> ang2 (* PI 1.5))) 
                          (setq p3 (polar p2 0 (+ txtW (* txtsize 1.5))))
                          (setq p3 (polar p2 PI (+ txtW (* txtsize 1.5))))
                        )
                      )
                    )
                    (setq i 0)
                    (repeat (length plist) 
                      (setq kp (nth i plist)
                            pn (polar kp ang1 yasize)
                      )
                      (command "PLINE" "non" pn "non" kp "non" p2 "non" p3 "")
                      (setq i (1+ i))
                    )
                    (redraw)
                    (command "_UNDO" "END")
                  )
                )
              )
            )
          )
        )
      )
      (setq loop nil)
    )
  )
  (setvar "CLAYER" lay)
  (setvar "CECOLOR" col)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; I/O Ԃ쐬iAhXԂƂč쐬j
(defun c:sbAdrC (/ my_error esel ename ent name p1 p2 pts ss lst str e1 e2 i dimsc loop
                 blst) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)

    (princ)
  )
  (setq *error* my_error)
  (setq dimsc (getvar "DIMSCALE"))
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop
    (setq pts nil lst nil name nil)
    (initget "Exit eXit")
    (setq esel (entsel "\nI/O AhX̐擪ubNI [E,X:I] : "))
    (cond
      ((or (= esel "Exit")(= esel "eXit"))(setq loop nil))
      ((and esel (listp esel))
        (progn 
          (setq ename (car esel)
                ent   (entget ename)
          )
          (if (= "INSERT" (cdr (assoc 0 ent))) 
            (setq name (cdr (assoc 2 ent))
                  p1   (cdr (assoc 10 ent))
            )
          )
        )
      )
    )
    (if (and name (wcmatch name "IO-DEF*")) 
      (setq p2  (polar p1 (* pi 1.5) (* 190.0 dimsc))
            pts (ifs_lineCP p1 p2 0.5)
      )
    )
    (if pts 
      (if (setq ss (ssget "CP" pts '((0 . "INSERT") (2 . "IO-DEFIN*,IO-DEFOUT*")))) 
        (progn 
          (setq i 0)
          (repeat (sslength ss) 
            (setq ename (ssname ss i)
                  ent   (entget ename)
                  lst   (append lst (list (list ename (cdr (assoc 10 ent)))))
                  i     (1+ i)
            )
          )
          (setq ss nil)
          (if lst 
            (setq lst (vl-sort lst (function (lambda (e1 e2) (< (distance p1 (cadr e1)) (distance p1 (cadr e2)))))))
          )
        )
      )
    )
    (if lst 
      (progn 
        (command "_UNDO" "BE")
        (setq ss (ssadd)
              i  0
        )
        (repeat (length lst) 
          (setq ename (car (nth i lst))
                p1    (cadr (nth i lst))
                str   (ifs_getAttvalue ename "IOADRS") ;; 쐬̓RԂ̂
          )
          (if str
            (progn
              (setq blst (ifs_ValidSbBlkName nil))            
              (setq ename (ifs_insert_sb (car blst) p1 dimsc 0.0 str)
                  ss    (ssadd ename ss)
              )
            )
          )
          (setq i (1+ i))
        )
        (if (> (sslength ss) 0) 
          (progn 
            (command "_move" ss "" "none" (cadr (car lst)))
            (while (= (getvar "CMDNAMES") "MOVE") 
              (command pause)
            )
          )
        )
        (command "_UNDO" "END")
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; I/O Rgւ
(defun c:cmtCv (/ my_error cmt0a cmt1a cmt2a cmt0b cmt1b cmt2b ent0a ent1a ent2a 
                  ename enext ent esel name loop
                 ) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (princ)
  )
  (setvar "CMDECHO" 0)
  (setq *error* my_error)
  
  (setq loop T)
  (while loop
    (setq ent0a nil ent1a nil ent2a nil)
    (initget "Exit eXit")
    (setq esel (entsel "\nI/O RgւubNI [E,X:I] : ")) 
    (cond
      ((or (= esel "Exit")(= esel "eXit"))(setq loop nil))
    )
    (if (and loop esel (listp esel)) 
      (progn 
        (setq ename (car esel)
              enext (entnext ename)
        )
        (while enext 
          (setq ent  (entget enext)
                name (cdr (assoc 2 ent))
          )
          (cond 
            ((= name "JCMNT")
              (setq cmt0a (cdr (assoc 1 ent))
                    ent0a ent
              )
            )
            ((= name "JCMNT1")
              (setq cmt1a (cdr (assoc 1 ent))
                    ent1a ent
              )
            )
            ((= name "JCMNT2")
              (setq cmt2a (cdr (assoc 1 ent))
                    ent2a ent
              )
            )
          )
          (if (= (cdr (assoc 0 ent)) "SEQEND") 
            (setq enext nil)
            (setq enext (entnext enext))
          )
        )
      )
    )
    ;; 擾f
    (if (and ent0a ent1a ent2a) 
      (if (setq esel (entsel "\nւ̃ubNI < ߂ > : "))
        (progn
          (setq ename (car esel)
                enext (entnext ename)
          )
          (command "_UNDO" "BE")
          (while enext 
            (setq ent  (entget enext)
                  name (cdr (assoc 2 ent))
            )
            (cond 
              ((= name "JCMNT")
                (progn 
                  (setq cmt0b (cdr (assoc 1 ent)))
                  (entmod (subst (cons 1 cmt0a) (assoc 1 ent) ent))
                  (entmod (subst (cons 1 cmt0b) (assoc 1 ent0a) ent0a))
                  (princ "\nJCMNT0:")(princ cmt0a) (princ "<>")(princ cmt0b)
                )
              )
              ((= name "JCMNT1")
                (progn 
                  (setq cmt1b (cdr (assoc 1 ent)))
                  (entmod (subst (cons 1 cmt1a) (assoc 1 ent) ent))
                  (entmod (subst (cons 1 cmt1b) (assoc 1 ent1a) ent1a))
                  (princ "\nJCMNT1:")(princ cmt1a) (princ "<>")(princ cmt1b)
                )
              )
              ((= name "JCMNT2")
                (progn 
                  (setq cmt2b (cdr (assoc 1 ent)))
                  (entmod (subst (cons 1 cmt2a) (assoc 1 ent) ent))
                  (entmod (subst (cons 1 cmt2b) (assoc 1 ent2a) ent2a))
                  (princ "\nJCMNT2:")(princ cmt2a) (princ "<>")(princ cmt2b)
                )
              )
            )
            (if (= (cdr (assoc 0 ent)) "SEQEND") 
              (setq enext nil)
              (setq enext (entnext enext))
            )
          )
          (command "_UNDO" "END")
        ) 
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)


;; V[h`
(defun c:sqSc (/ typ kw) 
  (setvar "CMDECHO" 0)
  (initget "0 1 2")
  (setq kw (getkword "\nA[XV{I [0:V{ /1:3{ /2:ΐ3{] < 1 > : "))
  ;; typ 𕶎ɕύX
  (cond 
    ((or (not kw) (= kw "1")) 
      (setq typ "00"))
    ((= kw "2")
      (setq typ "01"))
    (T 
      (setq typ ""))
  )
  (ifs_make_sqsc typ)
  (setvar "CMDECHO" 1)
  (princ)
)

;; V[h쐬
(defun ifs_make_sqsc (typ / myerror osm dimsc p1 p2 ang pe pf rad ss kplist kp i ent 
                      p1a lineType e1 e2
                     ) 
  (defun myerror (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setvar "ORTHOMODE" osm)
    (setq *error* nil)
  )
  (setq *error* myerror)
  (setvar "CMDECHO" 0)
  (setq osm (getvar "ORTHOMODE"))
  (setvar "ORTHOMODE" 1)

  (command "_UNDO" "BE")
  (setq dimsc 1.0
        rad   (* 1.25 dimsc)
  ) ;;a1.25
  (if (setq p1 (getpoint "\nn_w : ")) 
    (progn 
      (initget 32)
      (setq p2 (getpoint p1 "\nI_w : "))
    )
  )
  (if p2 
    (progn 
      (if (ifs_isTate p1 p2)
        (setq p2 (list (car p1)(cadr p2)(caddr p1)))
        (setq p2 (list (car p2)(cadr p1)(caddr p1)))
      )

      
      (setq ang (angle p1 p2)
            pe  (polar p2 ang rad)
            p1a (polar p1 ang -0.1)
      )
      
      (if (setq ss (ssget "F" (list p1a p2) '((0 . "LINE")))) 
        (progn 
          (setq i 0)
          (repeat (sslength ss) 
            (setq ent (entget (ssname ss i)))
            (if (setq kp (inters p1 p2 (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))) 
              (setq kplist (append kplist (list kp)))
            )
            (setq i (1+ i))
          )
          (if kplist 
            (setq kplist (vl-sort kplist (function (lambda (e1 e2) (< (distance p1 e1) (distance p1 e2)))))
                  p1     (car kplist)
                  p2     (car (reverse kplist))
                  p1     (polar p1 ang (- rad))
                  p2     (polar p2 ang rad)
                  pe     (polar p2 ang rad)
            )
          )
        )
      )
      ;; 킪[hĂȂ BYLAYER ō쐬
      (setq lineType "HIDDEN2")
      (if (not (tblsearch "LTYPE" lineType)) 
        (setq lineType "BYLAYER")
      )
      (entmake 
        (list 
          '(0 . "LWPOLYLINE")
          '(100 . "AcDbEntity")
          '(67 . 0)
          (cons 8 (getvar "CLAYER"))
          '(100 . "AcDbPolyline")
          '(62 . 256)
          (cons 6 lineType)
          '(90 . 4)
          '(70 . 1)
          '(38 . 0)
          '(39 . 0)
          (cons 10 (polar p1 (+ ang (/ pi 2.0)) rad))
          '(40 . 0)
          '(41 . 0)
          '(42 . 1.0)
          (cons 10 (polar p1 (- ang (/ pi 2.0)) rad))
          '(40 . 0)
          '(41 . 0)
          '(42 . 0.0)
          (cons 10 (polar p2 (- ang (/ pi 2.0)) rad))
          '(40 . 0)
          '(41 . 0)
          '(42 . 1.0)
          (cons 10 (polar p2 (+ ang (/ pi 2.0)) rad))
          '(40 . 0)
          '(41 . 0)
          '(42 . 0.0)
        )
      )
    )
  )
  (if (setq pf pe) 
    (progn 
      ;;_}
      (ifs_insert_cmark "CMARK00" pf dimsc)
      (while pf 
        (if (setq pf (getpoint pe "\nʉߓ_w < I > :")) 
          (progn 
            (entmake 
              (list '(0 . "LINE") 
                    '(62 . 256)
                    (cons 10 pe)
                    (cons 11 pf)
              )
            )
            (setq pe pf)
          )
        )
      )
      (if (/= typ "")  ;; typ 𕶎ɕύX
        ;;A[X}
        (ifs_insert_earth typ pe dimsc)
      )
    )
  )
  (command "_UNDO" "END")
  (setvar "ORTHOMODE" osm)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; cCXgC(=^=)쐬
(defun c:sqTw (/ my_error p1 p2 ang ss i ename ent p3 p4 ip ptes dist pts loop e1 e2 lay typ col) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop 
    (initget "Exit eXit")
    (setq p2 (getpoint "\ncCXgtFXIP_ځiˏojw [E,X:I] : "))
    (cond 
      ((or (= p2 nil) (= p2 "Exit")(= p2 "eXit"))
       (setq loop nil
             ss   nil
       )
      )
      ((and p2 (listp p2))
        (if (setq p1 (getpoint p2 "\nQ_ځiJjw < P_ > : ")) 
          ;;(setq ss (ssget "F" (list p1 p2) '((0 . "LINE") (8 . "WIRE*"))))
          (progn
            (if (ifs_isTate p1 p2)
              (setq p2 (list (car p1)(cadr p2)(caddr p1)))
              (setq p2 (list (car p2)(cadr p1)(caddr p1)))
            )

            (setq ss (ssget "F" (list p1 p2) '((0 . "LINE") )))
          )
        )
      )
    )
    (setq i    0
          ptes nil
    )
    (if ss 
      (repeat (sslength ss) 
        (setq ename (ssname ss i)
              ent   (entget ename)
              lay   (cdr (assoc 8 ent))
              p3    (cdr (assoc 10 ent))
              p4    (cdr (assoc 11 ent))
              ip    (inters p1 p2 p3 p4 nil)
              ptes  (append ptes (list (list ip ename)))
              i     (1+ i)
        )
        (if (assoc 62 ent)(setq col (cdr (assoc 62 ent)))(setq col 256))
				(if (assoc 6  ent)(setq typ (cdr (assoc 6  ent)))(setq typ "BYLAYER"))
      )
    )
    (if (and ptes (>= (length ptes) 2)) 
      (progn 
        (command "_UNDO" "BE")
        (setq ptes  (vl-sort ptes (function (lambda (e1 e2) (< (distance p1 (car e1)) (distance p1 (car e2))))))
              ang   (angle (car (car ptes)) (car (last ptes)))
              dist  (distance (car (car ptes)) (car (last ptes)))
              ename (cadr (car ptes))
              pts   (ifs_draw_tw (car (car ptes)) ang 2.5 (+ dist 2.0) lay col typ)
        )
        (command "_break" ename "none" (car pts) "none" (cadr pts)) ;; bricscad
        (command "_UNDO" "END")
      )
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)

;; cCXgC쐬
(defun ifs_draw_tw (pt ang w h lay col typ / p1 p2 p3) 
  (setq p1 (polar pt (+ ang (/ PI 2.0)) (/ w 2.0))
        p2 (polar pt (- ang (/ PI 2.0)) (/ w 2.0))
        p3 (polar pt ang h)
  )
  ;;(ifs_make_Layer "WIRE" 3 nil) ;; load ɍ쐬Ă̂ŕsv
  (entmake 
    (list '(0 . "LINE") (cons 8 lay) (cons 62 col) (cons 6 typ) (cons 10 p1) (cons 11 p3) '(62 . 256))
  )
  (entmake 
    (list '(0 . "LINE") (cons 8 lay) (cons 62 col) (cons 6 typ) (cons 10 p2) (cons 11 p3) '(62 . 256))
  )
  (list p1 p2)
)

;; Q~ʕtcCXgyAɕύX
(defun c:sqTw2( / my_error r rdo p1 p2 ss i ename1 ename2 ent1 ent2 k k1 k2 cen p1x p2x p1y p2y ename
	ang ang1 ang2 elast1 elast2 elast3 ent3 frad old_error osm p1a p1b p1c p2a p2b p2c ltype col elast)
	;; ۂߔa͂Q̋1/10
  ;; AutoCADɑΉ entmakeȂƂ̑Ήǉ
  (defun my_error(msg)
    (princ msg)
		(command "_UNDO" "END")
    (setvar "FILLETRAD" frad)
		(setvar "OSMODE" osm)
		(setvar "CMDECHO" 1)
		(princ)
	)
	(setq
		rdo (* pi 0.1);;БJpxiWAj
	)
	(setq osm (getvar "OSMODE"))
	(setvar "CMDECHO" 0)
	(setvar "OSMODE" 0)
	(setq old_error *error*)
	(setq *error* my_error)
	
	(setq frad (getvar "FILLETRAD"))
	(if (setq p1 (getpoint "\nQ{tFXQ_őI n_w : "))
		(progn
			(initget 32)
			(setq p2 (getpoint p1 "\nI_w : "))
		)
	)
	(if (setq ss (ssget "_F" (list p1 p2) '((0 . "LINE"))))
		(if (= (sslength ss) 2)
			(progn
				(setq ename1 (ssname ss 0) ent1 (entget ename1)
					  p1a (cdr (assoc 10 ent1)) p2a (cdr (assoc 11 ent1))
					  k1 (inters p1 p2 p1a p2a	nil) ang1 (angle p1a p2a))
				(setq ename2 (ssname ss 1) ent2 (entget ename2)
					  p1b (cdr (assoc 10 ent2)) p2b (cdr (assoc 11 ent2))
					  k2 (inters p1 p2 p1b p2b	nil) ang2 (angle p1b p2b))
				;;̪ݽ̒S
				(setq cen (list (/ (+ (car k1)(car k2)) 2.0)(/ (+ (cadr k1)(cadr k2)) 2.0)))
				(setq i 0)
        (command "_UNDO" "BE")
				(repeat 2
					(if (= i 0)
						(setq p1x p1a p2x p2a p1y p1b p2y p2b ang ang1 ename ename2)
						(setq p1x p1b p2x p2b p1y p1a p2y p2a ang ang2 ename ename1)
					)
					(setq k (inters p1x p2x cen (polar cen (+ ang (* pi 0.5)) 100.0) nil))
					;;ۂߔa͂Q̋1/10
					(if (not r)
						(progn
							(setq r (* (distance k cen) 2.0 0.1))
							(setvar "FILLETRAD" r)
						)
					)
					(setq ang (angle cen k) k (polar k ang (- (/ r (sin rdo)) r)))
					
					(setq k1 (inters p1y p2y k (polar k (+ ang rdo) 100.0) nil)
						  k2 (inters p1y p2y k (polar k (- ang rdo) 100.0) nil))
					
					(if (assoc 62 ent1)(setq col   (cdr (assoc 62 ent1)))(setq col   256))
					(if (assoc 6  ent1)(setq ltype (cdr (assoc 6  ent1)))(setq ltype "BYLAYER"))
					(setq elast (entlast))
          (entmake (list '(0 . "LINE")(assoc 8 ent1)(cons 10 k1)(cons 62 col)(cons 6 ltype)(cons 11 k)))
					(setq elast1 (entlast))
					(if (not (equal elast elast1))
						(progn
							(if (assoc 62 ent2)(setq col (cdr (assoc 62 ent2)))(setq col 256))
							(if (assoc 6 ent2)(setq ltype (cdr (assoc 6 ent2)))(setq ltype "BYLAYER"))
							(setq elast (entlast))
							(entmake (list '(0 . "LINE")(assoc 8 ent2)(cons 10 k)(cons 62 col)(cons 6 ltype)(cons 11 k2)))
							(setq elast2 (entlast))
							(if (not (equal elast elast2))
								(progn
									(command "FILLET" elast1 elast2)
									(command "BREAK" ename k1 k2)
									(setq elast3 (entlast))
									(setq ent3 (entget elast3) p1c (cdr (assoc 10 ent3)) p2c (cdr (assoc 11 ent3)))
									(if (or (< (distance k1 p1c) 0.01)(< (distance k1 p2c) 0.01))
										(progn
											(command "FILLET" elast3 elast1)
											(command "FILLET" ename elast2)
										)
										(progn
											(command "FILLET" elast3 elast2)
											(command "FILLET" ename elast1)
										)
									)
								)
							)
						)
					)
					(setq i (1+ i))
				)
        (command "_UNDO" "END")
				(redraw)
			)
			(princ "\nQ{ł͂Ȃ.")
		)
	)
	(setq *error* old_error)
	(setvar "OSMODE" osm)
	(setvar "FILLETRAD" frad)
  (setvar "CMDECHO" 1)
	(princ)
)

;;Жt쐬
(defun c:sq1ya () 
  (command "_UNDO" "BE")
  (setvar "CMDECHO" 0)
  (ifs_make_sqya 3.0 25.0 1 2.5)
  (command "_UNDO" "END")
  (setvar "CMDECHO" 1)
  (princ)
)
;;t+쐬.
(defun c:sq2ya () 
  (setvar "CMDECHO" 0)
  (command "_UNDO" "BE")
  
  (ifs_make_sqya 3.0 25.0 3 2.5)
  (command "_UNDO" "END")
  (setvar "CMDECHO" 1)
  (princ)
)

;; 쐬iŁj
(defun c:sqYa (/ dimsc l kakudo n txth temp) 
  (setq dimsc (getvar "DIMSCALE"))
  (setq l      (* 2.5 dimsc)
        kakudo 30.0
        n      (* 3 dimsc)
        txth   (* 2.5 dimsc)
  )
  (initget "1 2 3")
  (if (setq temp (getkword "\n[1:Ж+ /2: /3:+] < 3 > : ")) 
    (setq n (atoi temp))
    (setq n 3)
  )
  (setvar "CMDECHO" 0)
  (command "_UNDO" "BE")
  (ifs_make_sqya l kakudo n txth)
  (command "_UNDO" "END")
  (setvar "CMDECHO" 1)
  (princ)
)

;;PLINEŖ
(defun ifs_make_plya (l ;;
                     kakudo ;;Jpx
                     px ;;[W
                     ang ;;]px
                     / dimsc rad w) 
  (if (> (length px) 2) (setq px (list (car px) (cadr px))))
  (setq dimsc 1.0
        l     (* l dimsc)
  )
  (setq rad (/ (* kakudo pi) 180.0 2.0)
        w   (* (abs l) (/ (sin rad) (cos rad)) 2.0)
  )
  (entmake 
    (list 
      '(0 . "LWPOLYLINE")
      '(100 . "AcDbEntity")
      '(67 . 0)
      (cons 8 (getvar "CLAYER"))
      '(100 . "AcDbPolyline")
      '(90 . 2)
      '(70 . 0)
      '(38 . 0)
      '(39 . 0)
      (cons 10 px)
      (cons 40 0.0)
      (cons 41 w)
      (cons 42 0.0)
      '(62 . 256)
      (cons 10 (polar px ang l))
      (cons 40 w)
      (cons 41 w)
      (cons 42 0.0)
      '(210 0.0 0.0 1.0)
    )
  )
)

;; t쐬
;; ̎́A̒Sɕ`B
(defun ifs_make_sqya (l kakudo n txth / mes tsw dimsc p1 p2 px ang ename txt etext 
                      tbox dist code72 code73 ent p3
                     ) 
  (setq dimsc 1.0)
  (if txth (setq txth (* txth dimsc))) ;;
  (if (= n 3) 
    (setq n   2
          tsw 2
    )
  ) ;;̍쐬
  (if (= n 1) 
    (setq mes "\nʉߓ_܂͏I_ : "
          tsw 0
    )
    (setq mes "\nI_ : ")
  )
  (if (setq p1 (getpoint "\nn_ : ")) 
    (progn 
      (initget 32)
      (setq p2 (getpoint p1 mes))
    )
  )
  (if p2 
    (progn 
      (setq px  p1
            ang (angle p1 p2)
      )
      (entmake (list '(0 . "LINE") '(62 . 256) (cons 10 p1) (cons 11 p2)))
      (setq ename (entlast)) ;;ێ
      (repeat n 
        (ifs_make_plya l kakudo px ang)
        (setq px p2
              l  (* l -1.0)
        )
      )
      (if (= n 1) 
        (progn 
          (initget 32)
          (if (setq p3 (getpoint p2 "\nI_w < I > : ")) 
            (progn 
              (entmake (list '(0 . "LINE") '(62 . 256) (cons 10 p2) (cons 11 p3)))
              (setq ename (entlast))
              (setq p1  p2
                    p2  p3
                    ang (angle p1 p2)
                    tsw 1
              )
            )
            (setq tsw 0)
          )
        )
      )
    )
  )
  (if (and p2 tsw (setq txt (getstring T "\nL < Ȃ > : "))) 
    (progn 
      (if (< tsw 2) 
        (if (equal ang pi (* pi 0.5)) 
          ;;̎
          (progn 
            (setq ang (- ang pi))
            (cond 
              ((= tsw 0)
               (setq px     (polar p2 ang txth)
                     code72 0
                     code73 1
               )
              ) ;;BL
              ((= tsw 1)
               (setq px     (polar p1 ang (* txth -1.0))
                     code72 2
                     code73 1
               )
              ) ;;BR
            )
          )
          ;;E̎
          (progn 
            (cond 
              ((= tsw 0)
               (setq px     (polar p2 ang (* txth -1.0))
                     code72 2
                     code73 1
               )
              ) ;;BR
              ((= tsw 1)
               (setq px     (polar p1 ang txth)
                     code72 0
                     code73 1
               )
              ) ;;BL
            )
          )
        )
        ;;
        (progn 
          (setq px     (list (/ (+ (car p1) (car p2)) 2.0) 
                             (/ (+ (cadr p1) (cadr p2)) 2.0)
                       )
                code72 1
                code73 2
          )
          (if (>= ang pi) (setq ang (- ang pi)))
        )
      )
      (entmake 
        (list '(0 . "TEXT") 
              (cons 10 px)
              (cons 72 code72)
              (cons 73 code73)
              '(62 . 256)
              (cons 1 txt)
              (cons 11 px)
              (cons 40 txth)
              (cons 50 ang)
              (cons 41 0.8) ;;W
        )
      )
      (setq etext (entlast) ;;ێ
            tbox  (cadr (textbox (entget etext)))
            dist  (+ (/ (car tbox) 2.0) (cadr tbox))
      )
      (if (= tsw 1) 
        ;;̒𒲐
        (progn 
          (setq ent (entget ename)
                p1  (cdr (assoc 10 ent))
                p2  (cdr (assoc 11 ent))
                ang (angle p1 p2)
          )
          (setq p2 (polar p1 ang (* dist 2.0)))
          (entmod (subst (cons 11 p2) (assoc 11 ent) ent))
        )
      )
      (if (= tsw 2) 
        ;;ŕt̎A̒Jbg
        (progn 
          (command "BREAK" ename ;;"First"
                   "none" (polar px ang dist) "none" (polar px ang (* dist -1.0)))
          (redraw etext)
        )
      )
    )
  )
)

;; Ԃ̔z擾
(defun c:sbCnt (/ res lst item sblst cnt sbstr sb p1 p2 pts)
  ;; Ԃ̎A[_Ƀ|CڑĂƂ͌Ɣf
  ;; [qoRƔf
  (setq pts (ifs_getCorner "ԏWv͈͂"))
  (setq p1 (car pts) p2 (cadr pts))

  (if (= "Bricsys" (getvar "VENDORNAME")) ;; bricscad
    (command "_ZOOM" "none" p1 "none" p2)
  )  
 
  (setq res (ifs_getSbeAll p1 p2 nil nil)) ;; TB ܂߂Ȃ
  (setq lst   nil
        sblst nil
  )
  (foreach item res 
    (if (cadr item) 
      (setq  
            lst   (append lst (list (list (car (cadr item)) (caddr item))));; ԂƔz̃Xg 
            sblst (append sblst (list (car (cadr item))));; Ԃ̃Xg
      )
    )
  )
  (setq sblst (ifs_sort sblst));; 
  ;; Wv
  (setq sbstr "")
  (princ "\n--------")
  (foreach sb sblst 
    (setq cnt 0)
    (foreach item lst 
      (if (= sb (car item)) 
        (setq cnt (+ cnt (cadr item)))
      )
    )
    (princ "\n")
    (princ sb)
    (princ "\t")
    (princ cnt)
    (setq sbstr (strcat sbstr sb "\t" (itoa cnt) "\n"))
  )
  (princ "\n--------")
  (if (> (strlen sbstr) 0) 
    (progn 
      (ifs_SetClipBoardText sbstr)
      (princ "\nNbv{[hɃRs[܂D")
    )
  )
  (princ)
)

;; ׂĂ̔zƐԂ擾Ai EntityNameAԁAzj̃XgԂ
;; _擾AtbFlag ǉA
;; LWP_邩ǉ 2023/04/05
;; A[XV{邩ǉ 2023/04/20

;; ŏIIɕԂl
;; (((<Entity name: 1546ec00> <Entity name: 1546b988>) (P24) 2 T T).... 
;; L̂悤 ((( EntityNames)() z=_+1, LWP_邩, A[XV{邩) ̃XgɂȂ
;; 2023/04/20 A[XV{̃`FbNǉ
(defun ifs_getSbeAll (pt1 pt2 tbFlag emark / ssln lnlst i j len ent idx sscp cplst cpw e1 
                      e2 ename enlst eplst fuz flag idxi idxj idxlst item loop nolst 
                      p1 p2 p3 p4 sbelst sblst senban ss cp elst cpelst cnt item2 
                      enames res lst fil dimsc a ret temp
                     ) 
  (setq fuz 0.1)
  (setq dimsc (getvar "DIMSCALE"))
  ;; z擾
  (setq lnlst nil) ;; ׂĂ̔z ename n_-I_ێ
  (if (not pt1) 
    (setq pt1 '(0.0 0.0 0.0))
  )
  (if (not pt2) 
    (setq pt2 '(420.0 297.0 0.0)
          pt2 (mapcar (function (lambda (a) (* a dimsc))) pt2))
  )
  (prompt "\nԌ͈ = ")
  (princ (rtos (car pt1) 2 0))(princ ",")(princ (rtos (cadr pt1) 2 0))
  (princ " ` ")
  (princ (rtos (car pt2) 2 0))(princ ",")(princ (rtos (cadr pt2) 2 0))
  
  (if 
    (setq ssln (ssget "C" pt1 pt2 '((0 . "LINE")(8 . "*WIRE*")(62 . 256)(6 . "BYLAYER")(-4 . "<NOT")(8 . "WIREO")(-4 . "NOT>"))))
    (progn 
      (setq len (sslength ssln)
            i   0
      )
      (repeat len 
        (setq ename (ssname ssln i)
              ent   (entget ename)
        )
        (if (assoc 62 ent) 
          (entmod (subst (cons 62 256) (assoc 62 ent) ent))
        )
        ;; index ename startPoint endPoint ̏
        ;; ex: (0 #<Entity name: 06DA3D98> (260.0 226.0 0.0) (260.0 219.0 0.0))
        (setq lnlst (append lnlst (list (list i ename (cdr (assoc 10 ent)) (cdr (assoc 11 ent))))))
        (setq i (1+ i))
      )
      (setq ssln nil)
    )
  )
  ;;(princ "\nlnlst=") (princ lnlst)
  (setq eplst  nil ;; [_ȂĂ
        nolst  nil ;; PƂő݂
        cplst  nil ;; _Ɍ
        idxlst nil ;; ׂ L eplst + nolst + cplst 
  )
  ;; [_ɂȂ
  (if (and lnlst (>= (setq len (length lnlst)) 2)) 
    (progn 
      (setq i 0)
      (repeat (1- len) 
        (setq flag nil
              item (nth i lnlst)
              idxi (car item)
              p1   (caddr item)
              p2   (cadddr item)
              j    (1+ i)
        )
        (repeat (- len i 1) 
          (setq item (nth j lnlst)
                idxj (car item)
                p3   (caddr item)
                p4   (cadddr item)
          )
          (if 
            (or (equal p1 p3 fuz) 
                (equal p1 p4 fuz)
                (equal p2 p3 fuz)
                (equal p2 p4 fuz)
            )
            (setq flag  T
                  eplst (append eplst (list (list idxi idxj)))
            )
          )
          (setq j (1+ j))
        )
        (setq i (1+ i))
      )
    )
  )
  ;; PƐ
  (setq i 0
        j 0
  )
  (repeat (length lnlst) 
    (setq idx  (car (nth i lnlst))
          len  (length eplst) ;;loop T
          j    0
          flag nil
    )
    ;;(princ "\nlen=")(princ len)
    (setq loop (> len 0))
    (while loop 
      (if (member idx (nth j eplst)) 
        (setq flag T
              loop nil
        )
      )
      (setq j (1+ j))
      (if loop (setq loop (< j len)))
    )
    (if (not flag) 
      (setq nolst (append nolst (list (list idx))))
    )
    (setq i (1+ i))
  )
  ;; _AO[qɌ
  ;; Oڑp[q OutCirC3, 4 ǉDWvPʂ ...
  (if tbFlag 
    (setq fil "*CMARK*,*KOUTEN*,OUTCIRC*,NSQTBL")
    (setq fil "*CMARK*,*KOUTEN*")
  )
  (if 
    (setq sscp (ssget "W" pt1 pt2 (list '(0 . "INSERT") (cons 2 fil))));; ͈͓̌_擾
    (progn 
      (setq len    (sslength sscp)
            i      0
            cplst  nil
            cpelst nil
      )
      (repeat len 
        (setq lst  nil
              elst nil
              ent  (entget (ssname sscp i))
              cp   (cdr (assoc 10 ent))
              cpw  (ifs_pointW cp (* 1.55 dimsc)) ;;_̔a= 0.5, [q̔a = 1.5̂
        )
        ;; Oz͏O
        ;; _̐擾
        (if (setq ss (ssget "C" (car cpw) (cadr cpw) '((0 . "LINE")(8 . "*WIRE*")(-4 . "<NOT")(8 . "WIREO")(-4 . "NOT>"))))
          (progn 
            (setq j 0)
            (repeat (sslength ss) 
              (setq elst (append elst (list (ssname ss j))))
              (if (setq idx (ifs_enameInlineList (ssname ss j) lnlst)) 
                (setq lst (append lst (list idx)))
              )
              (setq j (1+ j))
            )
          )
        )
        (if lst 
          (setq cplst (append cplst (list lst))) ;;CfbNX̃Xg
        )
         (if elst 
          (setq cpelst (append cpelst (list elst)));; _̐ EntityName
        )
        (setq i (1+ i))
      )
      (setq sscp nil)
    )
  )
  ;; 
  (setq idxlst (append nolst eplst)
        idxlst (append idxlst cplst)
        eplst  nil
        nolst  nil
        cplst  nil
  )
  ;; ȂƂ̃O[vɐ
  ;; O[vɂȂĂCfbNX̃Xg
  ;;  lnlst ɂ
  (setq idxlst (ifs_groupIdx idxlst)
        idxlst (vl-sort idxlst (function (lambda (e1 e2) (< (car e1) (car e2)))))
  )
  
  ;; O[vƂ̐Ԃ𓾂
  (setq i      0
        sbelst nil
  )
  ;; CfbNXO[vƂɐo
  (repeat (length idxlst) 
    (setq sblst nil
          enlst nil
          item  (nth i idxlst)
          j     0
    )
    (repeat (length item) 
      (setq idx   (nth j item)
            lst   (nth idx lnlst);; ̎o
            ename (cadr lst);; Entity Name
            p1    (caddr lst);; n_
            p2    (cadddr lst);; I_
            enlst (append enlst (list ename));; Entity Name ̃Xg
      )
      (if (setq senban (ifs_lineSenban p1 p2)) 
        (if (not (member senban sblst)) ;; ̌ sort Ő̂ŕsvƌΕsv
          (setq sblst (append sblst senban))
        )
      )
      (if (>= (length sblst) 2) 
        (setq sblst (ifs_sort sblst))
      )
      (setq j (1+ j))
    )
    (setq sbelst (append sbelst (list (list enlst sblst))))
    (setq i (1+ i))
  )
  (setq idxlst nil
        lnlst  nil
  )
  ;; sbelst = (((ename1 ename2 ...)("SENBAN1" "SENBAN2" ...) cnt T)...)
  ;; ((q ename)() z LWP_邩) ̏
  ;; res	= (((#<Entity name: 06A62F88> #<Entity name: 06A64F18> #<Entity name: 06A5FAB8>) (R21) 2 nil)
  ;;			 ((#<Entity name: 06A65328>) nil 1 T) ... ) ;; Ԃ nil (list nil) ł͂Ȃ nil
  ;;  zi_+1jŌɒǉ
  (setq res nil)
  (foreach item sbelst 
    (setq enames (car item) cnt 1)
    (foreach item2 cpelst ;; _̐ EntityName ̃Xg
      (if (member (car item2) enames) 
        (setq cnt (1+ cnt))
      )
    )
    (setq res (append res (list (append item (list cnt)))))
  )
  (setq cpelst nil
        sbelst nil
  )
  ;; LWP ̒_邩ǉ 2023/04/05
  (setq temp nil)
  (foreach item res
    (setq ret (ifs_inLwpVertex (car item)))
    (setq temp (append temp (list (append item (list ret))))) 
  )
  (setq res temp temp nil)
  
  ;; A[XV{邩ǉ 2023/04/20
  (foreach item res
    (setq ret (ifs_inEmark (car item) emark))
    (setq temp (append temp (list (append item (list ret))))) 
  )
  (setq res temp temp nil)
  res
)

;; Xg̒gւ
(defun ifs_swapListItem (lst index item / temp i) 
  (setq temp nil
        i    0
  )
  (repeat (length lst) 
    (if (= i index) 
      (setq temp (cons item temp))
      (setq temp (cons (nth i lst) temp))
    )
    (setq i (1+ i))
  )
  (reverse temp)
)

;; Xgւ
;; gp
(defun ifs_swapListNth (lst index1 index2 / temp item1 item2 i) 
  (setq item1 (nth index1 lst)
        item2 (nth index2 lst)
        i     0
  )
  (repeat (length lst) 
    (if (= i index1) 
      (setq temp (cons item2 temp))
      (if (= i index2) 
        (setq temp (cons item1 temp))
        (setq temp (cons (nth i lst) temp))
      )
    )
    (setq i (1+ i))
  )
  (reverse temp)
)

;; ԍO[v
(defun ifs_groupIdx (lst / len i j item1 item2 res grp) 
  (setq len (length lst)
        i   0
  )
  (repeat (1- len) 
    (setq item1 (nth i lst)
          j     (1+ i)
    )
    (repeat (- len i 1) 
      (setq item2 (nth j lst))
      ;; O[v̏ꍇ͍̂BȊO nil
      (if (setq grp (ifs_checkIdx item1 item2)) 
        (setq lst (ifs_swapListItem lst i (list nil))
              lst (ifs_swapListItem lst j grp)
        )
      )
      (setq j (1+ j))
    )
    (setq i (1+ i))
  )
  ;; (nil)f[^폜 N[Abv
  (setq i   0
        res nil
  )
  (repeat (length lst) 
    (if (car (setq item1 (nth i lst))) 
      (setq res (append res (list item1)))
    )
    (setq i (1+ i))
  )
  res
)

;; ԍO[v܂Ƃ߂
;; (77 81):(80 81) -> res:(77 80 81)
;; ȊO nil
(defun ifs_checkIdx (lst1 lst2 / i res loop len) 
  (setq i    0
        res  nil
        loop T
        len  (length lst1)
  )
  (while loop 
    (if (member (nth i lst1) lst2) 
      (setq res  (append lst1 lst2)
            res  (ifs_sort res);; ԍ͐
            loop nil
      )
    )
    (setq i (1+ i))
    (if loop (setq loop (< i len)))
  )
  res
)

;; Line 2_Ԃ擾
;; Ԃ̃XgԂB݂Ȃ= nil Ԃ
(defun ifs_lineSenban (p1 p2 / off ang fpts ss i sblst senban blkname bname deg ent bdeg ename) 
  (setq off (* 1.5 (getvar "DIMSCALE")))
  (if (> (abs (- (car p1) (car p2))) (abs (- (cadr p1) (cadr p2)))) 
    (setq ang     (/ pi 2) deg 0
          blkname "SENBAN1"
    ) ;; =㑤
    (setq ang     pi deg 90
          blkname "SENBAN"
    ) ;; =
  )
  ;;tFXIp̂Q_
  (setq fpts (list (polar p1 ang off) (polar p2 ang off)))
  ;; (command "_Line" "none" (car fpts) "none" (cadr fpts) "")
  (setq i 0)
  (if (setq ss (ssget "F" fpts '((0 . "INSERT") (8 . "*") (2 . "*SENBAN*"))))
    (progn
      ;;(princ (sslength ss))
      (repeat (sslength ss) 
        ;; ubNł̐ǉ
        (setq ename (ssname ss i) ent (entget ename))
        (setq bname (strcase (cdr (assoc 2 ent))))
        (setq bdeg (ifs_radToDeg (cdr (assoc 50 ent))))
        (if bdeg (equal 360.0 bdeg 1.0)(setq bdeg 0.0))
        ;;(princ bdeg)
        (if (or (= blkname bname)(and (= bname "SENBAN00")(equal bdeg deg 1))) 
          (progn 
            (setq senban (ifs_getSenban ename))
            ;;(princ senban)
            (if (and senban (not (member senban sblst))) 
              (setq sblst (append sblst (list senban)))
            )
          )
        )
        (setq i (1+ i))
      )
    )
  )
  (setq ss nil)
   sblst
)

;; Line 2_Ԃ擾
;; ԃubN ename ̃XgԂ
;; gp
(defun ifs_getSenbanEnamesFromLine2p (p1 p2 / off ang fpts ss i enames) 
  (setq off (* 1.5 (getvar "DIMSCALE")))
  (if (> (abs (- (car p1) (car p2))) (abs (- (cadr p1) (cadr p2)))) 
    (setq ang (/ pi 2)) ;; =㑤
    (setq ang pi) ;; =
  )
  ;;tFXIp̂Q_
  (setq fpts (list (polar p1 ang off) (polar p2 ang off)))
  (setq i 0)
  (if 
    (setq ss (ssget "F" fpts '((0 . "INSERT") (8 . "*") (2 . "*SENBAN*"))))
    (repeat (sslength ss) 
      (setq enames (append enames (list (ssname ss i)))
            i      (1+ i)
      )
    )
  )
  (setq ss nil)
  enames
)

;; ename  ɂ ename Xg𓾂
;; gp
; (defun ifs_getSebanEnamesFromLineEname (lineEname / ent) 
;   (setq ent (entget lineEname))
;   (ifs_getSenbanEnamesFromLine2p (cdr (assoc 10 ent)) (cdr (assoc 11 ent)))
; )

;; ubNPtFXɃRs[(CopyBase )
(defun c:bCpF (/ my_error esel ename ent Flag insPt elast elast2 loop kw s1 s2 typ 
               hlen head numstr term lst keta p1 p2 pts p3 p4 ip pt ss e1 e2 str i up 
               elist len snmode loop2 main
              ) 
  (defun my_error (msg) 
    (princ msg)
    (command "_UNDO" "END")
    (setvar "SNAPMODE" snmode)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)

  (setq snmode (getvar "SNAPMODE"))
  (setq main T)
  (while main 
    (setq flag nil p1 nil p2 nil)
    (setvar "CMDECHO" 0)
    (setvar "SNAPMODE" 0)
    (setq loop2 T)
    (while loop2 
      (initget "Exit eXit")
      (if (setq esel (entsel "\nRs[ubNPI [E,X:I] : ")) 
        (if (or (= esel "Exit")(= esel "eXit")) 
          (setq loop2 nil main nil)
          (setq ename (car esel)
                ent   (entget ename)
                Flag  (= "INSERT" (cdr (assoc 0 ent)))
                loop2  (not Flag)
          )
        )
      )
    )
    (setvar "SNAPMODE" snmode)
    (if Flag 
      (progn 
        (cond 
          ((setq s1 (ifs_getAttvalue ename "NAME"))(setq typ 1))
          ((setq s2 (ifs_getAttvalue ename "NAME1"))(setq typ 2))
          ((setq s1 (ifs_getAttvalue ename "SENBAN"))(setq typ 3))
        )
        (if typ 
          (progn 
            (cond 
              ((= typ 2)
                (setq str  (strcat s1 s2) hlen (strlen s1)))
              (T (setq str  s1 hlen 0))
            )
            (if (/= str "")
              (setq lst    (ifs_sprNum3 str)
                    head   (car lst)
                    keta   (strlen (cadr lst))
                    numstr (cadr lst)
                    term   (caddr lst)
              )
            )
            (if (and numstr (/= "" numstr)) 
              (if (not (setq up (getint "\nJEgAbv < 0 > : "))) 
                (setq up 0 kw "No")
                (setq kw "Yes")
              )
            )
          )
        )
        (setq insPt (cdr (assoc 10 ent)))
        (command "_copybase" "none" insPt ename "") ;; bricscad
        (setvar "snapmode" 1)
        (initget "X")
        (if (/= "X" (setq p1 (getPoint "\ntFXI 1 _ڂw [X:ʍWw] : "))) 
          (setq p2 (getPoint p1 "\ntFXI 2 _ڂw : "))
          (setq loop T)
        )
        (if (and p1 p2)
          (if (ifs_isTate p1 p2)
            (setq p2 (list (car p1)(cadr p2)(caddr p1)))
            (setq p2 (list (car p2)(cadr p1)(caddr p1)))
          )
        )
        ;; ----------
        (if 
          (and p2 (setq ss (ssget "F" (list p1 p2) '((0 . "LINE") (8 . "WIRE*")))))
          (progn 
            (setq i   0
                  pts nil
            )
            (repeat (sslength ss) 
              (setq ename (ssname ss i)
                    ent   (entget ename)
                    p3    (cdr (assoc 10 ent))
                    p4    (cdr (assoc 11 ent))
                    ip    (inters p1 p2 p3 p4 nil)
                    pts   (append pts (list ip))
                    i     (1+ i)
              )
            )
            (if pts 
              (setq pts (vl-sort pts (function (lambda (e1 e2) (< (distance p1 e1) (distance p1 e2))))))
            )
          )
        )
        (command "_UNDO" "BE")
        (if pts 
          (foreach pt pts 
            (setq elast (entlast))
            (command "_PASTECLIP" "none" pt) ;; bricscad
            (if (not (equal elast (setq elast2 (entlast)))) 
              (progn 
                (if (= kw "Yes") 
                  (progn 
                    ;; 킹
                    (setq numstr (itoa (+ (atoi numstr) up)))
                    (setq numstr (ifs_func_strAddZero numstr keta))
                    (setq str (strcat head numstr term))
                    (cond 
                      ((= typ 1) 
                        (ifs_setAttvalue elast2 "NAME" str))
                      ((= typ 2)
                        (ifs_attval2 elast2 "NAME" "NAME1"
                          (substr str 1 hlen)
                          (substr str (1+ hlen) (- (strlen str) hlen))
                        ))
                      ((= typ 3) 
                        (ifs_setAttvalue elast2 "SENBAN" str))
                    )
                  )
                )
                (if (not (wcmatch (cdr (assoc 2 (entget elast2))) "*SENBAN*")) 
                  (setq elist (append elist (list elast2)))
                )
              )
            )
          )
        )
        (if elist 
          (progn 
            (setq len (length elist) i 0)
            (repeat len 
              (ifs_sub_btrimvx (nth i elist))
              (setq i (1+ i))
            )
          )
        )
        (command "_UNDO" "END")
        ;; ʂɎw
        (while loop 
          (setq elast (entlast))
          (prompt "\nRs[w [ESC:ubNIɖ߂] : ")
          (command "_UNDO" "BE")
          (command "_PASTECLIP") ;; bricscad
          (while (= (getvar "CMDNAMES") "PASTECLIP") 
            (command pause)
          )
          (if (not (equal elast (setq elast2 (entlast)))) 
            (progn 
              (if (= kw "Yes") 
                (progn 
                  ;; 킹
                  (setq numstr (itoa (+ (atoi numstr) up)))
                  (setq numstr (ifs_func_strAddZero numstr keta))
                  (setq str (strcat head numstr term))
                  (cond 
                    ((= typ 1) 
                      (ifs_setAttvalue elast2 "NAME" str))
                    ((= typ 2)
                      (ifs_attval2 elast2 "NAME" "NAME1"
                        (substr str 1 hlen)
                        (substr str (1+ hlen) (- (strlen str) hlen))
                      ))
                    ((= typ 3)
                      (ifs_setAttvalue elast2 "SENBAN" str))
                  )
                )
              )
              (if (not (wcmatch (cdr (assoc 2 ent)) "*SENBAN*")) 
                (ifs_sub_btrimvx elast2)
              )
            )
            (setq loop nil)
          )
          (command "_UNDO" "END")
        )
      )
    )
  )
  (setvar "SNAPMODE" snmode)
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
; ;; ubNPtFXɃRs[iCOPYŁj
; (defun c:bCpFx (/ my_error esel ename ent Flag insPt elast elast2 loop kw s1 s2 typ 
;                hlen head numstr term lst keta p1 p2 pts p3 p4 ip pt ss e1 e2 str i up 
;                elist len enameorg ptorg snmode loop2
;               ) 
;   (defun my_error (msg) 
;     (princ msg)
;     (command "_UNDO" "END")
;     (setvar "SNAPMODE" snmode)
;     (setvar "CMDECHO" 1)
;     (setq *error* nil)
;   )
;   (setq *error* my_error)

;   (setvar "CMDECHO" 0)
;   (setq snmode (getvar "SNAPMODE"))
;   (setq loop T)
;   (while loop
;     (setvar "SNAPMODE" 0)
;     (setq loop2 T)
;     (while loop2 
;       (initget "Exit eXit")
;       (if (setq esel (entsel "\ntFXIɃRs[ubNPI [E,X:I] : ")) 
;         (if (or (= esel "Exit")(= esel "eXit")) 
;           (setq loop nil)
;           (setq ename (car esel)
;                 ent   (entget ename)
;                 Flag  (= "INSERT" (cdr (assoc 0 ent)))
;                 loop2  (not Flag)
;           )
;         )
;       )
;     )
;     (setvar "SNAPMODE" snmode)
;     (if Flag 
;       (progn 
;         (if (setq s1 (ifs_getAttvalue ename "NAME")) 
;           (progn 
;             (setq typ 1)
;             (if (setq s2 (ifs_getAttvalue ename "NAME1")) 
;               (setq typ 2)
;             )
;           )
;           (if (setq s1 (ifs_getAttvalue ename "SENBAN")) 
;             (setq typ 3)
;           )
;         )
;         (if typ 
;           (progn 
;             (cond 
;               ((= typ 2)
;               (setq str  (strcat s1 s2)
;                     hlen (strlen s1)
;               )
;               )
;               (T
;               (setq str  s1
;                     hlen 0
;               )
;               )
;             )
;             (if (/= str "")
;               (setq lst    (ifs_sprNum3 str)
;                     head   (car lst)
;                     keta   (strlen (cadr lst))
;                     numstr (cadr lst)
;                     term   (caddr lst)
;               )
;             )
;             (if (and numstr (/= "" numstr)) 
;               (progn 
;                 (if (not (setq up (getint "\nJEgAbv < 0 > : "))) 
;                   (setq up 0 kw "No")
;                   (setq kw "Yes")
;                 )
;               )
;             )
;           )
;         )
;         (setq insPt (cdr (assoc 10 ent)))
;         ;; IJCAD ̌ԏIłł CopyBase łȂ(ZWCAD ł CopyClip)
;         (setq enameorg ename ptorg insPt)

;         (initget "X")
;         (if (/= "X" (setq p1 (getPoint "\ntFXI 1 _ڂw [X:ʎw] : "))) 
;           (setq p2 (getPoint p1 "\ntFXI 2 _ڂw : "))
;           (setq loop T)
;         )
;         (if (and p1 p2)
;           (if (ifs_isTate p1 p2)
;             (setq p2 (list (car p1)(cadr p2)(caddr p1)))
;             (setq p2 (list (car p2)(cadr p1)(caddr p1)))
;           )
;         )
;         ;; ----------
;         (if 
;           (and p2 (setq ss (ssget "F" (list p1 p2) '((0 . "LINE") (8 . "WIRE*")))))
;           (progn 
;             (setq i   0
;                   pts nil
;             )
;             (repeat (sslength ss) 
;               (setq ename (ssname ss i)
;                     ent   (entget ename)
;                     p3    (cdr (assoc 10 ent))
;                     p4    (cdr (assoc 11 ent))
;                     ip    (inters p1 p2 p3 p4 nil)
;                     pts   (append pts (list ip))
;                     i     (1+ i)
;               )
;             )
;             (if pts 
;               (setq pts (vl-sort pts (function (lambda (e1 e2)(< (distance p1 e1) (distance p1 e2))))))
;             )
;           )
;         )
;         (command "_UNDO" "BE")
;         (if pts 
;           (foreach pt pts 
;             (setq elast (entlast))
;             (command "_PASTECLIP" "none" pt) ;; bricscad
;             ;;(command "_COPY" enameorg "" "none" ptorg "none" pt)
            
;             (if (not (equal elast (setq elast2 (entlast)))) 
;               (progn 
;                 (if (= kw "Yes") 
;                   (progn 
;                     ;; 킹
;                     (setq numstr (itoa (+ (atoi numstr) up)))
;                     (setq numstr (ifs_func_strAddZero numstr keta))
;                     (setq str (strcat head numstr term))
;                     (cond 
;                       ((= typ 1) (ifs_setAttvalue elast2 "NAME" str))
;                       ((= typ 2)
;                       (ifs_attval2 
;                         elast2
;                         "NAME"
;                         "NAME1"
;                         (substr str 1 hlen)
;                         (substr str (1+ hlen) (- (strlen str) hlen))
;                       )
;                       )
;                       ((= typ 3) (ifs_setAttvalue elast2 "SENBAN" str))
;                     )
;                   )
;                 )
;                 (if (not (wcmatch (cdr (assoc 2 (entget elast2))) "*SENBAN*")) 
;                   (setq elist (append elist (list elast2)))
;                 )
;               )
;             )
;           )
;         )
;         (if elist 
;           (progn 
;             (setq len (length elist)
;                   i   0
;             )
;             (repeat len 
;               (ifs_sub_btrimvx (nth i elist))
;               (setq i (1+ i))
;             )
;           )
;         )
;         (command "_UNDO" "END")
;         ;; ʂɎw
;         (while loop 
;           (setq elast (entlast))
;           (prompt "\nRs[w < ESC:I > : ")
;           ;;(command "paste")
;           (command "_UNDO" "BE")
;           ;; ZWCAD ŃANeBuɂȂȂ
;           (setvar "CMDECHO"  1)
;           (command "_COPY" enameorg "" "none" ptorg)
;           ;;(command "_PASTECLIP") ;; bricscad
;           (while (= (getvar "CMDNAMES") "COPY") 
;             (command pause)
;           )
;           (if (not (equal elast (setq elast2 (entlast)))) 
;             (progn 
;               (if (= kw "Yes") 
;                 (progn 
;                   ;; 킹
;                   (setq numstr (itoa (+ (atoi numstr) up)))
;                   (setq numstr (ifs_func_strAddZero numstr keta))
;                   (setq str (strcat head numstr term))
;                   (cond 
;                     ((= typ 1) (ifs_setAttvalue elast2 "NAME" str))
;                     ((= typ 2)
;                     (ifs_attval2 
;                       elast2
;                       "NAME"
;                       "NAME1"
;                       (substr str 1 hlen)
;                       (substr str (1+ hlen) (- (strlen str) hlen))
;                     )
;                     )
;                     ((= typ 3) (ifs_setAttvalue elast2 "SENBAN" str))
;                   )
;                 )
;               )
;               (if (not (wcmatch (cdr (assoc 2 ent)) "*SENBAN*")) 
;                 (ifs_sub_btrimvx elast2)
;               )
;             )
;             (setq loop nil)
;           )
;           (command "_UNDO" "END")
;         )
;       )
;     )
;   )
;   ;---
;   (setvar "CMDECHO" 1)
;   (setq *error* nil)
;   (princ)
; )

;; ^ԕҏW
(defun c:typEd (/ myerror esel loop) 
  (defun myerror (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* myerror)
  
  (ifs_layerOn "TYPE")
  
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop 
    (initget "Exit eXit")
    (setq esel (entsel "\n^ (TYPE) ҏWubNPI [E,X:I] : "))
    ;;(princ esel)
    (cond 
      ((or (= esel "Exit")(= esel "eXit")) (setq loop nil))
      ((and esel (listp esel))(setq loop (ifs_sub_typed (car esel))))
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)


;; ^ԕҏW
(defun ifs_sub_typed (ename / typ str kw esel ss i elst ename typ1 typnew ret loop) 
  (setq ret T)
  (if (= "INSERT" (cdr (assoc 0 (entget ename)))) 
    (progn 
      (if (setq typ (ifs_getAttvalue ename "TYPE"))
        (if (/= "" (setq str (getstring T (strcat "\nV^Ԃ(.=Ȃ) < " typ " > : ")))) 
          (progn
            (if (= str ".")(setq str ""))
            (command "_UNDO" "BE")
            (ifs_setAttvalue ename "TYPE" (setq typnew (strcase str)))
            (command "_UNDO" "EMD")
          )
          (setq typnew typ)
        )
      )
      ;; ύXǑ^ԂT
      (setq i 0 elst nil)
      (if (setq ss (ssget "X" '((0 . "INSERT"))))
        (repeat (sslength ss)
          (setq ename (ssname ss i))
          (if (setq typ1 (ifs_getAttValue ename "TYPE"))
            (if (= typ1 typ)
              (setq elst (append elst (list ename)))
            )
          )
          (setq i (1+ i))
        )
      )
      (if (and elst (/= typ typnew))
        (progn
          (initget "Yes No")
          (if (not (setq kw (getkword (strcat "\n^ " typ "  " (itoa (length elst)) " ܂DXV܂H [Yes /No] < No > : "))))
            (setq kw "No")
          )
          (if (= kw "Yes")
            (progn
              (command "_UNDO" "BE")
              (foreach ename elst
                (ifs_setAttValue ename "TYPE" typnew)
              )
              (command "_UNDO" "END")
            )
          )
        )
      )
      (if (/= typ typnew)
        (progn
          (initget "Yes No")
          (if (not (setq kw (getkword "\ñubNɃRs[܂H [Yes /No] < No > : "))) 
            (setq kw "No")
          )
          (if (= kw "Yes")
            (progn
              (setq loop T)
              (while loop
                (initget "Exit eXit")
                (setq esel (entsel (strcat "\n" typnew " Rs[ubNI [E,X:I] < ߂ > : ")))
                (cond 
                  ((or (= esel "Exit")(= esel "eXit"))(setq loop nil ret nil))
                  ((= esel nil)(setq loop nil))
                  ((and esel (listp esel))
                    (progn
                      (command "_UNDO" "BE")
                      (ifs_setAttvalue (car esel) "TYPE" typnew)
                      (command "_UNDO" "END")
                    )
                  )
                )     
              )
            )
          )
        )
      )
    )
  )
  ret
)
;; ^ԁAdlRs[
(defun c:TypSpcCp (/ my_error esel loop) 
  (defun my_error (msg) 
    (princ msg)
    (setq *error* nil)
    (setvar "CMDECHO" 1)
    (princ)
  )
  (setq *error* my_error)
  
  (ifs_layerOn "TYPE")
  (ifs_layerOn "SPEC")  
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop
    (initget "Exit eXit")
    (setq esel (entsel "\ndl(SPEC)A^(TYPE) QƂubNPI [E,X:I] : "))
    (cond
      ((or (= esel "Exit")(= esel "eXit"))(setq loop nil)) 
      ((and esel (listp esel)) (setq loop (ifs_sub_sptypcp (car esel))))
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
;; ^ԁAgpRs[
(defun ifs_sub_sptypcp (ename / sptp esel ent name typ spc loop ret) 
  (setq ret T)
  (setq ent  (entget ename)
        name (cdr (assoc 0 ent))
  )
  (if (= name "INSERT") 
    (setq sptp (ifs_attval2 ename "SPEC" "TYPE" nil nil)
          spc  (car sptp)
          typ  (cadr sptp)
    )
  )
  (if sptp 
    (progn 
      (setq loop T)
      (while loop 
        (initget "Exit eXit")
        (setq esel (entsel (strcat "\n" spc " , " typ " Rs[ubNI [E,X:I] < ߂ > : ")))
        (cond 
          ((or (= esel "Exit")(= esel "eXit")) (setq loop nil ret nil))        
          ((and esel (listp esel))
            (progn
              (command "_UNDO" "BE")
              (ifs_attval2 (car esel) "SPEC" "TYPE" spc typ)
              (command "_UNDO" "END")
            )
          )
          (T (setq loop nil))
        )
      )
    )
  )
  ret
)

;; ^ԃRs[
(defun c:typCp (/ my_error esel loop) 
  (defun my_error (msg) 
    (princ msg)
    
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop
    (initget "Exit eXit")
    (setq esel (entsel "\n^ (TYPE) QƂubN܂ TEXT PI [E,X:I] : "))
    (cond
      ((or (= esel "Exit")(= esel "eXit"))(setq loop nil)) 
      ((and esel (listp esel))(setq loop (ifs_sub_typcp (car esel))))
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
;; ^ԃRs[
(defun ifs_sub_typcp (ename / typ esel ent name loop ret) 
  (setq ret T)
  (setq ent  (entget ename)
        name (cdr (assoc 0 ent))
  )
  (cond 
    ((= name "INSERT") (setq typ (ifs_getAttvalue ename "TYPE")))
    ((= name "TEXT"  ) (setq typ (cdr (assoc 1 ent))))
  )
  (if typ 
    (progn 
      (setq loop T)
      (while loop 
        (initget "Exit eXit")
        (setq esel (entsel (strcat "\n^ " typ " Rs[ubNI [E,X:I] < ߂ > : ")))
        (cond 
          ((or (= esel "Exit") (= esel "eXit"))(setq loop nil ret nil))              
          ((and esel (listp esel))
            (progn
              (command "_UNDO" "BE")
              (ifs_setAttvalue (car esel) "TYPE" typ)
              (command "_UNDO" "END")
            )
          )
          (T (setq loop nil))
        )
      )
    )
  )
  ret
)

;; dlҏW
(defun c:spcEd ( / my_error esel loop) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
  )
  (setq *error* my_error)
  (ifs_layerOn "SPEC")
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop 
    (initget "Exit eXit")
    (setq esel (entsel "\ndl (SPEC) ҏWubNPI [E,X:I] : "))
    (cond 
      ((or (= esel "Exit")(= esel "eXit")) (setq loop nil))
      ((and esel (listp esel))(ifs_sub_speced (car esel)))
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
;; dlҏW
(defun ifs_sub_speced (ename / spec str kw esel loop specnew elst i spec1 ss ret) 
  (setq ret T)
  (if (= "INSERT" (cdr (assoc 0 (entget ename)))) 
    (progn 
      (if (setq spec (ifs_getAttvalue ename "SPEC"))
        (if (/= "" (setq str (getstring T (strcat "\nVdl (.= ) < " spec " > : "))))
          (progn 
            (if (= str ".")(setq str ""))
            (ifs_setAttvalue ename "SPEC" (setq specnew (strcase str)))
          )
          (setq specnew spec)
        )
      )
      ;; ύXO SPEC T
      (setq i 0 elst nil)
      (if (setq ss (ssget "X" '((0 . "INSERT"))))
        (repeat (sslength ss)
          (setq ename (ssname ss i))
          (if (setq spec1 (ifs_getAttValue ename "SPEC"))
            (if (= spec1 spec)
              (setq elst (append elst (list ename)))
            )
          )
          (setq i (1+ i))
        )
      )
      (if (and elst (/= spec specnew))
        (progn
          (initget "Yes No")
          (if (not (setq kw (getkword (strcat "\ndl " spec "  " (itoa (length elst)) " ܂DXV܂H [Yes /No] < Yes > : "))))
            (setq kw "Yes")
          )
          (if (= kw "Yes")
            (progn
              (command "_UNDO" "BE")
              (foreach ename elst (ifs_setAttValue ename "SPEC" specnew))
              (command "_UNDO" "END")
            )
          )
        )
      ) 
      (if (/= spec specnew)
        (progn
          (initget "Yes No")
          (if (not (setq kw (getkword "\ñubNɃRs[܂H [Yes /No] < Yes > : "))) 
            (setq kw "Yes")
          )
          (if (= kw "Yes") 
            (progn 
              (setq loop T)
              (while loop 
                (initget "Exit eXit")
                (setq esel (entsel (strcat "\n" specnew " Rs[ubNI [E,X:I] < ߂ > : ")))
                (cond
                  ((or (= esel "Exit")(= esel "eXit"))(setq loop nil ret nil))
                  ((and esel (listp esel))
                    (progn
                      (command "_UNDO" "BE")
                      (ifs_setAttvalue (car esel) "SPEC" specnew)
                      (command "_UNDO" "END")
                    )
                  )
                  (T (setq loop nil))
                )
              )
            )
          )
        )
      )
    )
  )
  ret
)
;; dlRs[
(defun c:spcCp (/ my_error esel loop) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop
    (initget "Exit eXit")
    (setq esel (entsel "\ndl (SPEC) QƂubN܂ TEXT PI [E,X:I] : "))
    (cond 
      ((or (= esel "Exit")(= esel "eXit"))(setq loop nil)) 
      ((and esel (listp esel))(setq loop (ifs_sub_speccp (car esel))))
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
;; dlRs[
(defun ifs_sub_speccp (ename / spec esel ent name loop ret) 
  (setq ret T)
  (setq ent  (entget ename)
        name (cdr (assoc 0 ent))
  )
  (cond 
    ((= name "INSERT") (setq spec (ifs_getAttvalue ename "SPEC")))
    ((= name "TEXT") (setq spec (cdr (assoc 1 ent))))
  )
  (if spec 
    (progn 
      (setq loop T)
      (while loop 
        (initget "Exit eXit")
        (setq esel (entsel (strcat "\ndl " spec " Rs[ubNI [E.X:I] < ߂ > : ")))
        (cond
          ((or (= esel "Exit")(= esel "eXit")) (setq loop nil ret nil))
          ((and esel (listp esel))
            (progn
              (command "_UNDO" "BE")
              (ifs_setAttvalue (car esel) "SPEC" spec)
              (command "_UNDO" "END")
            )
          )
          (T (setq loop nil))
        )
      )
    )
  )
  ret
)

;; wIAt[Y
(defun ifs_layerOn( layerName / adoc ent lay lays )
  (if (setq ent (tblsearch "Layer" layerName))
    (if (/= (cdr (assoc 70 ent)) 0)
      (progn
        (setq adoc (vla-get-activedocument (vlax-get-Acad-Object))
              lays (vla-get-layers adoc)
              lay (vla-item lays layerName)
        )
        (if (= :vlax-false (vla-get-layeron lay))
          (vla-put-layeron lay :vlax-true)
        )   
        (if (= :vlax-true (vla-get-freeze lay))
          (vla-put-freeze lay :vlax-false )
        )
      )
    )
  )
)

(defun c:nmclp( / ename ent hand i len name name1 p0 ss 
     str lst xlst ylst x y dx dy e1 e2 item s)
  (if (setq ss (ssget '((0 . "INSERT"))))
    (progn
      (setq i 0 len (sslength ss) str "")
      (repeat len
        (setq ename (ssname ss i)
              ent (entget ename)
              p0 (cdr (assoc 10 ent))
              x (car p0) y (cadr p0)
              name (ifs_getAttvalue ename "NAME")
              name1 (ifs_getAttvalue ename "NAME1")
              hand  (vla-get-Handle (vlax-ename->vla-object ename))
        )
        (if (or name name1)
          (progn
            (setq 
              xlst (append xlst (list x))
              ylst (append ylst (list y))
              lst (append lst (list (list hand x y name name1)))
            )
          )        
        )
        (setq i (1+ i))
      )
      (setq dx (- (apply 'max xLst) (apply 'min xLst))
            dy (- (apply 'max yLst) (apply 'min yLst)))
      (if (> dy dx)
        (setq lst (vl-sort lst (lambda (e1 e2) (> (caddr e1) (caddr e2)))))
        (setq lst (vl-sort lst (lambda (e1 e2) (< (cadr e1) (cadr e2)))))
      )
      (if lst
        (progn
          (setq len (length lst) i 0)
          (repeat len
            (setq item (nth i lst) s "")
            (setq s (strcat (car item) "\t"));(cadddr item)))
            (if (nth 4 item )
              (setq s (strcat s "^\t" (cadddr item) "\t" (nth 4 item)))
              (setq s (strcat s "\t"  (cadddr item) "\t"))
            )
            (if (= str "")
              (setq str s)
              (setq str (strcat str "\n" s))
            )
            (setq i (1+ i))
          )
          (princ str)
        )
      )
    )
  )
  (if (/= str "")
    (progn
      (ifs_clearClipBoardText)
      (ifs_setClipBoardText str) 
      (if (/= "" (ifs_getClipBoardText))
        (progn
          (princ "\nNbv{[hɃRs[܂D")
          (princ "\nExcel ŕҏWꍇ́AΏۂ̃Z̏ݒuvɕύXĂy[XgĉD")
        )
        (princ "\nNbv{[hւ̃Rs[Ɏs܂D")
      )
      
    )
  )
  (princ)
)
(defun c:nmpst( / doc ename hand item items lst str)
  (setq doc (vla-get-ActiveDocument (vlax-get-acad-object)))
  (setq str (ifs_getClipBoardText))
  (if (and str (/= str ""))
    (progn
      (princ str)
      (setq lst (ifs_strSplit str "\n"))
      (foreach items lst
        (setq item (ifs_strSplit items "\t"))
        (if (/= (car item ""))
          (progn
            (setq hand (car item) ename (handent hand) )
            (if (= (cadr item) "^")
              (ifs_attval2 ename "NAME" "NAME1" (caddr item) (cadddr item))
              (ifs_attval ename "NAME" (caddr item))
            )
          )
        )
      )
    )
    (princ "\nNbv{[hɕ񂪂܂D")
  )
  (princ)
)
(defun c:sbclp( / ename ent hand i len name p0 ss 
     str lst xlst ylst x y dx dy e1 e2 item s)
  (if (setq ss (ssget '((0 . "INSERT"))))
    (progn
      (setq i 0 len (sslength ss) str "")
      (repeat len
        (setq ename (ssname ss i)
              ent (entget ename)
              p0 (cdr (assoc 10 ent))
              x (car p0) y (cadr p0)
              name (ifs_getAttvalue ename "SENBAN")
              hand  (vla-get-Handle (vlax-ename->vla-object ename))
        )
        (if name
          (progn
            (setq 
              xlst (append xlst (list x))
              ylst (append ylst (list y))
              lst (append lst (list (list hand x y name)))
            )
          )        
        )
        (setq i (1+ i))
      )
      (setq dx (- (apply 'max xLst) (apply 'min xLst))
            dy (- (apply 'max yLst) (apply 'min yLst)))
      (if (> dy dx)
        (setq lst (vl-sort lst (lambda (e1 e2) (> (caddr e1) (caddr e2)))))
        (setq lst (vl-sort lst (lambda (e1 e2) (< (cadr e1) (cadr e2)))))
      )
      (if lst
        (progn
          (setq len (length lst) i 0)
          (repeat len
            (setq item (nth i lst) s "")
            (setq s (strcat (car item) "\t" (cadddr item)))
            (if (= str "")
              (setq str s)
              (setq str (strcat str "\n" s))
            )
            (setq i (1+ i))
          )
          (princ str)
        )
      )
    )
  )
  (if (/= str "")
    (progn
      (ifs_clearClipBoardText)
      (ifs_setClipBoardText str) 
      (if (/= "" (ifs_getClipBoardText))
        (progn
          (princ "\nNbv{[hɃRs[܂D")
          (princ "\nExcel ŕҏWꍇ́AΏۂ̃Z̏ݒuvɕύXĂy[XgĉD")
        )
        (princ "\nNbv{[hւ̃Rs[Ɏs܂D")
      )
      
    )
  )
  (princ)
)
(defun c:sbpst( / doc ename hand item items lst str)
  (setq doc (vla-get-ActiveDocument (vlax-get-acad-object)))
  (setq str (ifs_getClipBoardText))
  (if (and str (/= str ""))
    (progn
      (princ str)
      (setq lst (ifs_strSplit str "\n"))
      (foreach items lst
        (setq item (ifs_strSplit items "\t"))
        (if (/= (car item)"")
          (progn
            (setq hand (car item) ename (handent hand) )
            (ifs_attval ename "SENBAN" (cadr item))
          )
        )
      )
    )
    (princ "\nNbv{[hɕ񂪂܂D")
  )
  (princ)
)

;; @햼ҏW
(defun c:nmEd( / my_error esel loop)
  ;; @햼 ^ ܂ނƂQsɂȂ
  ;;  : MC^21 ͂Ł@NAME = MCANAME1 = 21
  ;; NAME1 Ȃꍇ́A^ 폜PsōXV
  ;; ͂łĂA@햼͑啶ɂȂ
  ;; ɓ@햼ꍇ́AXV\
	(defun my_error(msg)
		(princ msg)
    (setvar "CMDECHO" 1)
		(setq *error* nil)
    (princ)
	)
	(setq *error* my_error)
  
  ;; t[Y
  (ifs_layerOn "NAME")
  (setvar "CMDECHO" 0)  
	(setq loop T)
	(while loop
		(initget "Exit eXit")
		(setq esel (entsel "\n@햼ҏWubNPI [E,X:I] : "))
		(cond
			((or (= esel "Exit")(= esel "eXit"))(setq loop nil))
			((and esel (listp esel))(ifs_sub_nmed (car esel) nil))
		)
	)
  (setvar "CMDECHO" 1)
	(setq *error* nil)
	(princ)
)
;; Qs@햼̂Psڂ̕ύX
(defun c:nmLen( / i len name name1 nmlen s ss ename loop ret n)
  (defun my_error(msg)
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  
  (setvar "CMDECHO" 0)
  (setq nmlen 2)
  (setq loop T)
  (while loop
    (setq ret nil)
    (initget "Exit eXit")
    
    (if (setq n (getint (strcat "\n@햼̂Psڂ̕ [E,X:I] < " (itoa nmlen) " > : ")))
      (setq nmlen n)
    )
    (cond
      ((or (= nmlen "Exit")(= nmlen "eXit"))(setq loop nil))
      ((and nmlen (numberp nmlen))(setq ret T))
    )
    (if ret (prompt "\n@햼QŝPsڂ̕ύXubNI : "))
    (if (and ret (setq ss (ssget '((0 . "INSERT")))))
      (progn
        (setq len (sslength ss) i 0)
        (command "_UNDO" "BE")
        (repeat len
          (setq ename (ssname ss i))
          (setq name  (ifs_getAttValue ename "NAME"))
          (setq name1 (ifs_getAttValue ename "NAME1"))
          (if (and name name1)
            (progn
              (setq s (strcat name name1))
              (setq name  (substr s 1 nmlen)
                    name1 (substr s (1+ nmlen) (- (strlen s) nmlen))
              )
              (ifs_attval2 ename "NAME" "NAME1" name name1)
            )
          )
          (setq i (1+ i))
        )
        (command "_UNDO" "END")
      )
    )
  )
  (setvar "CMDECHO" 0)
  (setq *error* nil)
  (princ)
)
;; @햼ҏW
(defun ifs_sub_nmed( enameorg org / ent lst org name name1 typ mes str n ss i len s1 s2 
                           kw s new elst1 cnt1 elst2 cnt2 ret ename res)
  (setq res "")
	(setq ent (entget enameorg))
	(if (= "INSERT" (cdr (assoc 0 ent)))
		(progn
			(setq lst (ifs_attval2 enameorg "NAME" "NAME1" nil nil))
			(if (and (car lst)(cadr lst))
				(setq name (car lst) name1 (cadr lst) typ 2);; NAME, NAME1 
				(if (car lst)(setq name (car lst) name1 "" typ 1));;NAME ̂ݑ
			)
		)
	)
	(if (and name name1)
		(progn
      (if (not org)
        (setq org (strcase (strcat name name1)))
      )
      ;;(princ "\norg=")(princ org)
      (if (= typ 2)
        (setq s (strcat name "^" name1))
        (setq s org)
      )
			(setq mes (strcat "\nV@햼( ^ 2s\A . = ) < " s " > : "))
			(setq str (strcase (getstring T mes)))
      (if (= str "")(setq str s))
      ;;(princ str)
      (if (/= str "")
				(progn
					(if (= "." str)(setq str ""))
          (if (> (setq n (ifs_strpos	"^" str)) 0)
            (setq name  (substr str 1 (1- n))
						      name1 (substr str (1+ n) (- (strlen str) n))
            )
            (setq name str name1 "")
          )
          (setq new (strcat name name1))
          (setq cnt1 0 cnt2 0)
          ;; Ő@햼ύX(OO)
          (if (and (/= org new) (setq ss (ssget "X" '((0 . "INSERT")))));;
            (progn
              (setq len (sslength ss) i 0)
              (repeat len
                (setq ename (ssname ss i)
                      s1 (ifs_getAttValue ename "NAME" )
                      s2 (ifs_getAttValue ename "NAME1")
                )
                (if s1 (setq s1 (strcase s1)))
                (if s2 (setq s2 (strcase s2)))
                (if (and (/= org "")(/= org "^"))
                  (if (or (and s1 s2 (= (strcat s1 s2) org)) (and s1 (= s1 org)))
                    (setq cnt1 (1+ cnt1) elst1 (append elst1 (list ename)))
                  )
                )
                (if (or (and s1 s2 (= (strcat s1 s2) new)) (and s1 (= s1 new)))
                  (setq cnt2 (1+ cnt2) elst2 (append elst2 (list ename)))
                )               
                (setq i (1+ i))
              )
              ; (setq ret nil)
              ; (if (and (/= new "")(> cnt2 0))
              ;   (progn
              ;     (initget "Yes No")
              ;     (setq kw (getkword (strcat "\nV@햼 " new " Ɠ@햼 " (itoa cnt2) " ܂Ds܂HuYes /No] < Yes > : ")))
              ;     (setq ret (/= kw "No"))
              ;   )
              ;   (setq ret T)
              ; )
              (setq ret T)
              (if ret
                (progn
                  (command "_UNDO" "BE")
                  (if (= typ 2)
                    (ifs_attval2 enameorg "NAME" "NAME1" name name1)
                    (ifs_attval  enameorg "NAME" (strcat name name1))
                  )
                  (command "_UNDO" "END")
                  (setq res str);; ͕Ԃ
                )
              )
              (if (/= org "")(setq kw "Yes"))
              (if (and ret (> cnt1 1)(/= org ""))
                (progn
                  ; (initget "Yes No")
                  ; ;; 
                  ; (if (not (getkword (strcat "\n̋@햼 " org " Ɠ@햼 " (itoa (1- cnt1)) " ܂DXV܂HuYes /No] < Yes > : ")))
                  ;   (setq kw "Yes")
                  ; )
                  (setq kw "No")
                  (if (and (= kw "Yes") elst1)
                    (progn
                      (command "_UNDO" "BE")
                      (setq i 0)
                      (repeat (length elst1)
                        (setq ename (nth i elst1))
                        (if (not (equal ename enameorg))
                          (progn
                            (setq s1 (ifs_getAttValue ename "NAME" )
                                  s2 (ifs_getAttValue ename "NAME1")
                            )
                            (if (and s1 s2)
                              (ifs_attval2 ename "NAME" "NAME1" name name1)
                              (if s1
                                (ifs_attval ename "NAME" (strcat name name1))
                              )
                            )
                          )
                        )
                        (setq i (1+ i))
                      )
                      (command "_UNDO" "END")
                    )
                  )
                )
              )
            )
          )
				)
			)
		)
	)
  res;; ͂@햼Ԃ
)

;; chk = T : dȂ","؂̕ɂǉ
;; chk = nil : Œǉ
(defun ifs_func_strAddStrs (strs str chk)
  (if (not strs)(setq strs ""))
  (if str
    (if (= strs "")
      (setq strs str)
      (if (or (not chk) (and chk (not (wcmatch str strs))))
        (setq strs (strcat strs "," str))
      )
    )
  )
  strs
)

;; ̌ɃXy[Xǉ
(defun ifs_func_addSpace(str len / slen)
  (if (< (setq slen (strlen str)) len)
    (repeat (- len slen)(setq str (strcat str " ")))
  )
  str
)
; ̑O"0"ǉ
(defun ifs_func_strAddZero(str len / slen)
  (if (< (setq slen (strlen str)) len) 
    (repeat (- len slen)(setq str (strcat "0" str)))
  )
  str
)
;; ","؂̕𐮗 str1+"x 2", str2 + "x 3"̂悤Ɍǉ
(defun ifs_func_strCountStr( str / lst res i len n bname)
  (setq res "" i 0)
  (setq lst (ifs_func_strsCountList str))
  (if (> (setq len (length lst)) 0)
    (repeat len
      (setq bname (car (nth i lst))
            n (cadr (nth i lst))
      )
      (if (/= res "")(setq res (strcat res ",")))
      (setq res (strcat res bname " x "  (itoa n)))
      (setq i (1+ i))
    )
  )
  res
)

;; ƌ̃XgԂ
(defun ifs_func_strsCountList(str / lst lst2 res len len2 cnt s s2)
  (if (/= str "")
    (progn
      (setq lst (ifs_strSplit str ",") len (length lst))
      ;;2023/03/31 sort œf[^͐
      (setq lst2 (ifs_sort lst) len2 (length lst2)) ;;ubNŃ\[g
      (cond
        ((and (>= len 1) (= len len2))
          (foreach s lst
            (setq res (append res (list (list s 1))))
          ))
        ((and (>= len 1)(> len len2))
          (progn
            (foreach s2 lst2
              (setq cnt 0)
              (foreach s lst
                (if (= s s2) (setq cnt (1+ cnt)))
              )
              (setq res (append res (list (list s2 cnt))))
            )
          )
        )
      )
    )
  )
  res  
)
;; @햼Wv
(defun c:nmCnt( / ss name ename i j len s1 s2 lst mkr typ e1 e2 abcnt rycnt nmlen slen bnm
               abbnames rybnames chkFlag p1 p2 spname clipstr pts) 
  (defun nmcnt_dispData()
    (princ "\n")(princ spname)
    (princ "\t")(princ rycnt)
    (if (> rycnt 0)(progn (princ " (")(princ rybnames)(princ ")"))) 
    (princ "\t/\t")(princ abcnt)
    (if (> abcnt 0)(progn (princ " (")(princ abbnames)(princ ")")))
  )

  (setq clipstr "")
  (setq pts (ifs_getCorner "@햼Wv͈͂"))
  (setq p1 (car pts) p2 (cadr pts))

  (setvar "CMDECHO" 0)
  (if (= "Bricsys" (getvar "VENDORNAME"))
    (command "_ZOOM" "none" p1 "none" p2)
  )
  (setvar "CMDECHO" 1)
  
  (if (setq ss (ssget "W" p1 p2 '((0 . "INSERT"))))
    (progn
      (setq len (sslength ss) i 0)
      (repeat len
        (setq ename (ssname ss i)
              s1  (ifs_getAttValue ename "NAME" )
              s2  (ifs_getAttValue ename "NAME1")
              mkr (ifs_getAttValue ename "MAKER")
              typ (ifs_getAttValue ename "TYPE")
              bnm (cdr (assoc 2 (entget ename)))
              name ""
        )
        (if s1 (setq name s1))
        (if s2 (setq name (strcat name s2)))
        (if (and s1 typ)
          ;;ex: ((TM8 NIL ACON 0)....) Ō i ̓_~[igpjf[^̐h
          (setq lst (append lst (list (list (strcase name) (or mkr typ) bnm i) )))
        )
        (setq i (1+ i))
      )
      ;; @햼Ń\[g
      (setq lst (vl-sort lst (function (lambda (e1 e2) (< (car e1) (car e2))))))
      (setq nmlen 0 i 0)
      (if (> (setq len (length lst)) 0)
        (repeat len
          (setq slen (strlen (car (nth i lst))))
          (if (> slen nmlen)(setq nmlen slen))
          (setq i (1+ i))
        )
      )   
      (setq chkFlag nil);; ubN̏d`FbN
      (setq abcnt 0 rycnt 0 i 0 abbnames "" rybnames "")
      (if (> (setq len (length lst)) 1)
        (repeat (1- len)
          (setq j (1+ i))
          (if (cadr (nth i lst))
            (setq rycnt (1+ rycnt) rybnames (ifs_func_strAddStrs rybnames (caddr (nth i lst)) chkFlag))
            (setq abcnt (1+ abcnt) abbnames (ifs_func_strAddStrs abbnames (caddr (nth i lst)) chkFlag))
          )          
          (if (/= (setq name (car (nth i lst)))(car (nth j lst)))
            (progn            
              (setq spname (ifs_func_addSpace name nmlen))
              (setq rybnames (ifs_func_strCountStr rybnames))
              (setq abbnames (ifs_func_strCountStr abbnames))
              (nmcnt_dispData)
              (if (/= clipstr "")(setq clipstr (strcat clipstr "\n")))
              (setq clipstr (strcat clipstr name "\t" (itoa rycnt) "\t" (itoa abcnt) "\t" rybnames "\t" abbnames))
              (setq abcnt 0 rycnt 0 abbnames "" rybnames "")
            )
          )
          (setq i (1+ i))
        )
      )
      (if (> len 0)
        (progn
          (if (cadr (nth (1- len) lst))
            (setq rycnt (1+ rycnt) rybnames (ifs_func_strAddStrs rybnames (caddr (nth (1- len) lst)) chkFlag))
            (setq abcnt (1+ abcnt) abbnames (ifs_func_strAddStrs abbnames (caddr (nth (1- len) lst)) chkFlag))
          )
          (setq name (car (nth (1- len) lst)))
          (setq spname   (ifs_func_addSpace name nmlen))
          (setq rybnames (ifs_func_strCountStr rybnames))
          (setq abbnames (ifs_func_strCountStr abbnames))
          (nmcnt_dispData)
          (if (/= clipstr "")
            (setq clipstr (strcat clipstr "\n"))
          )
          (setq clipstr (strcat clipstr name "\t" (itoa rycnt) "\t" (itoa abcnt) "\t" rybnames "\t" abbnames))
        )
      )
    )
  )
  (if (/= clipstr "")
    (progn 
      (ifs_SetClipBoardText clipstr)
      (princ "\nNbv{[hɃRs[܂D")
    )
  )
  (princ)
)

;; @햼Rs[
(defun c:nmCp (/ my_error esel loop) 
  (defun my_error (msg) 
    (princ msg)
    (setvar "CMDECHO" 1)
    (setq *error* nil)
    (princ)
  )
  (setq *error* my_error)
  (setvar "CMDECHO" 0)
  (setq loop T)
  (while loop
    (initget "Exit eXit")
    (setq esel (entsel "\n@햼 (NAME, NAME1) QƂubNA܂ TEXT PI [E,X:I] : "))
    (cond
      ((or (= esel "Exit")(= esel "eXit"))
        (setq loop nil))
      ((and esel (listp esel))
        (setq loop (ifs_sub_namecp (car esel))))
    )
  )
  (setvar "CMDECHO" 1)
  (setq *error* nil)
  (princ)
)
;; @햼Rs[
(defun ifs_sub_namecp (ename / esel ent name loop kname kname1 lst ret) 
  (setq ret T)
  (setq ent  (entget ename)
        name (cdr (assoc 0 ent))
  )
  (cond 
    ((= name "INSERT") 
      (setq kname (ifs_getAttvalue ename "NAME") kname1 (ifs_getAttvalue ename "NAME1")))
    ((= name "TEXT")
      (setq kname (cdr (assoc 1 ent))))
  )
  (if kname 
    (progn 
      (if (not kname1)(setq kname1 ""))
      (setq loop T)
      (while loop 
        (initget "Exit eXit")
        (setq esel (entsel (strcat "\n@햼 " kname kname1 " Rs[ubNI [E,X:I] < ߂ > : ")))
        (cond 
          ((or (= esel "Exit")(= esel "eXit")) 
            (setq loop nil ret nil))
          ((and esel (listp esel))
            (progn
              (command "_UNDO" "BE")
              (setq ename (car esel))
              (setq lst (ifs_attval2 ename "NAME" "NAME1" nil nil))
              (if (and (car lst)(cadr lst))
			      	  (ifs_attval2 ename "NAME" "NAME1" kname kname1)
				        (if (car lst)
                  (ifs_attval ename "NAME"  (strcat kname kname1))
                )
              )
              (command "_UNDO" "END")
            )
          )
          (T (setq loop nil))
        )
      )
    )
  )
  ret
)


;; ԕҏW
(defun c:sbEd( / myerror esel loop)
	(defun myerror(msg)
		(princ msg)
		(setq *error* nil)
	)
	(setq *error* myerror)
	(setvar "CMDECHO" 0)

	(setq loop T)
	(while loop
		(initget "Exit eXit")
	 	(setq esel (entsel "\nҏWԂPI [E,X:I] : "))
		(cond
			((or (= esel "Exit")(= esel "eXit"))
        (setq loop nil))
			((and esel (listp esel))
        (ifs_sub_sbed (car esel)))
		)
	)
	(setvar "CMDECHO" 1)
	(setq *error* nil)
	(princ)
)

;; ԕҏW
(defun ifs_sub_sbed(ename / senban str pt sbenames cnt i len lst kw ret)
	(if (= "INSERT" (cdr (assoc 0 (entget ename))))
		(progn
			(setq pt (cdr (assoc 10 (entget ename)))
            sbenames (ifs_getSenbanEnamesFromPoint pt)
      )
      (if (setq senban (ifs_getAttValue ename "SENBAN"))
        (if (/= "" (setq str (getstring T (strcat "\nVԂ < " senban " > : "))))
          (progn
            (setq str (strcase str))
            (setq i 0 cnt nil len (length (setq lst (ifs_getSenbanAll))))
            (while (and (not cnt) (< i len))
              (if (= (car (nth i lst)) str)
                (setq cnt (cadr (nth i lst)))
              )
              (setq i (1+ i))
            )
            (if (and cnt (> cnt 0)) 
              (progn
                (initget "Yes No")
                (setq kw (getkword (strcat "\nV " str "  " (itoa cnt) " ܂Ds܂H [Yes /No] < Yes > : ")))
                (setq ret (/= kw "No"))
              )
              (setq ret T)
            )
            (if ret
              (foreach ename sbenames
                (ifs_setAttValue ename "SENBAN" str)
              )
            )
          )
        )	
      )
		)
	)
)

;; I/O RgNbv{[hɃRs[
(defun c:cmtClp (/ esel ename ent name p1 p2 pts lst i str e1 e2 ss s1 s2 s3) 
  (setq str "")
  (if (setq esel (entsel "\nRs[ I/O RgubN̐擪I : ")) 
    (if (= "INSERT" (cdr (assoc 0 (setq ent (entget (car esel)))))) 
      (setq name (cdr (assoc 2 ent))
            p1   (cdr (assoc 10 ent))
      )
    )
  )
  (if (and name (wcmatch name "IO-DEF*")) 
    (setq p2  (polar p1 (* pi 1.5) 190)
          pts (ifs_lineCP p1 p2 0.5)
    )
  )
  (if pts 
    (if (setq ss (ssget "CP" pts '((0 . "INSERT") (2 . "IO-DEFIN*,IO-DEFOUT*")))) 
      (progn 
        (setq i 0)
        (repeat (sslength ss) 
          (setq ename (ssname ss i)
                ent   (entget ename)
                lst   (append lst (list (list ename (cdr (assoc 10 ent)))))
                i     (1+ i)
          )
        )
        (setq ss nil)
        (if lst 
          (setq lst (vl-sort lst (function (lambda (e1 e2) (< (distance p1 (cadr e1)) (distance p1 (cadr e2)))))))
        )
      )
    )
  )
  (if lst 
    (progn 
      (setq i 0)
      (repeat (length lst) 
        (setq ename (car (nth i lst)))
        (setq s1 (ifs_getAttvalue ename "IOADRS")
              s2 (ifs_getAttvalue ename "JCMNT1")
              s3 (ifs_getAttvalue ename "JCMNT2")
        )
        (if (and s1 s2 s3)
          (setq str (strcat str s1 "\t" s2 "\t" s3 "\r\n"))
        )
        (setq i (1+ i))
      )
    )
  )
  (if (/= str "") 
    (progn 
      (princ str)
      (ifs_clearClipBoardText)
      (ifs_setClipBoardText str) 
      (if (/= "" (ifs_getClipBoardText))
        (princ "\nNbv{[hɃRs[܂D")      
        (princ "\nNbv{[hւ̃Rs[Ɏs܂D")
      )
    )
  )
  (princ)
)
;; 񕪗
(defun ifs_strSplit (str delim / ptr lst) 
  (while (setq ptr (vl-string-search delim str)) 
    (setq lst (cons (substr str 1 ptr) lst)
          str (substr str (+ ptr 2))
    )
  )
  (reverse (cons str lst))
)
;; Nbv{[h̕RgɃy[Xg
(defun c:cmtPst (/ esel ename ent name p1 p2 pts lst i str sList s slst cnt e1 e2 
                   kw ss
                  ) 
  (setq cnt 0)
  (setq str (ifs_GetClipBoardText))
  (princ str)
  (if (/= str "")      
    (setq sList (ifs_strSplit str "\n"))
  )
  (if (and sList (>= (length sList) 1))  ;; f[^̐𖳂
    (if (setq esel (entsel "\ny[Xg I/O RgubN̐擪I ")) 
      (if (= "INSERT" (cdr (assoc 0 (setq ent (entget (car esel)))))) 
        (setq name (cdr (assoc 2 ent))
              p1   (cdr (assoc 10 ent))
        )
      )
    )
    ;(princ "\nf[^قȂ܂D")
  )
  (if (and name (wcmatch name "IO-DEF*")) 
    (setq p2  (polar p1 (* pi 1.5) 190)
          pts (ifs_lineCP p1 p2 0.5)
    )
  )
  (if pts 
    (if (setq ss (ssget "CP" pts '((0 . "INSERT") (2 . "IO-DEFIN*,IO-DEFOUT*")))) 
      (progn 
        (setq i 0)
        (repeat (sslength ss) 
          (setq ename (ssname ss i)
                ent   (entget ename)
                lst   (append lst (list (list ename (cdr (assoc 10 ent)))))
                i     (1+ i)
          )
        )
        (setq ss nil)
        (if lst 
          (setq lst (vl-sort lst (function (lambda (e1 e2) (< (distance p1 (cadr e1))(distance p1 (cadr e2)))))))
        )
      )
    )
  )
  (if lst 
    (progn 
      (initget "Yes No")
      (setq kw (getkword "\nI/O AhXXV܂H [Yes /No] < No > : "))
      (setq i 0)
      (repeat (length lst) 
        (setq ename (car (nth i lst)))
        (if (< i (length sList)) 
          (progn 
            (setq s (vl-string-trim "\r\n" (nth i sList)))
            (if (= 3 (length (setq slst (ifs_strSplit s "\t")))) 
              (progn 
                (if (= kw "Yes") (ifs_setAttvalue ename "IOADRS" (car slst)))
                (ifs_setAttvalue ename "JCMNT1" (cadr slst))
                (ifs_setAttvalue ename "JCMNT2" (caddr slst))
                (setq cnt (1+ cnt))
              )
            )
          )
        )
        (setq i (1+ i))
      )
    )
  )
  (if (> cnt 0) 
    (princ "\nNbv{[hy[Xg܂D")
  )
  (princ)
)
;;
;; ԍ폜
(defun c:sber( / ss)
  (if (setq ss (ssget '((0 . "INSERT")(8 . "*")(2 . "*SENBAN*"))))
    (if (> (sslength ss)0)
      (progn
        (setvar "CMDECHO" 0)
        (command "_UNDO" "BE")
        (command "_DELETE" ss "")
        (command "_UNDO" "END")
        (setvar "CMDECHO" 1)
      )
    )
  )
  (princ)
)

;; -------------------------------------------------------------------------------
;   Ԋt̎菇
; 	EsbAll Őԏ擾
; 	EOwijOXgisbAll ̃CfbNXj쐬
; 	E\[g@́iAォjcDAD
; 	EԂ̏l
; 	EsbAll Xg̃O[v xAY ̈ԏƃCfbNX̃Xg쐬
; 	ẼXg\[giCfbNXꏏɁj
; 	ẼXgƂ sbAll Xg̐Ԃ擾
; 	EO[vׂ̂Ă̐Ԃ
; 	EԂ́Aɍ쐬Xg̐̒_ɐԂ쐬

(defun ifs_sortMpiList(mpiList tateFlag / len i j p1 p2 fuz flag)
	(setq len (length mpiList) fuz 0.001 i 0)
	(repeat (1- len)
		(setq j (1+ i))
		(repeat (- len i 1)
			(setq flag nil)
			(setq p1 (car (nth i mpiList)) p2 (car (nth j mpiList)))
			(if tateFlag 
				(if (equal (car p1)(car p2) fuz)
					(setq flag (< (cadr p1)(cadr p2)))
					(setq flag (> (car p1)(car p2)))
				)
				(if (equal (cadr p1)(cadr p2) fuz)
					(setq flag (> (car p1)(car p2)))
					(setq flag (< (cadr p1)(cadr p2)))
				)				
			)
			(if flag (setq mpiList (ifs_swapListNth mpiList i j)))
			(setq j (1+ j))
		)
		(setq i (1+ i))
	)
	mpiList
)
(defun ifs_enameInlineList(ename linelst / i loop idx l item)
	(setq loop T i 0 l (length linelst))
	(while (and loop (< i l))
		(setq item (nth i linelst))
		(if (equal ename (cadr item))
			(setq idx (car item) loop nil)
		)
		(setq i (1+ i))
	)
	idx
)

; (defun ifs_func_sbIn(blkname senban pos / 
; 								ename clayer flag doc vpos mspc obj)
; 	(if (tblsearch "BLOCK" blkname)
; 		(setq flag T)
; 	)
; 	(setq clayer (getvar "CLAYER"))
; 	(ifs_make_Layer "CSENBAN" 2)
; 	(setvar "CLAYER" "CSENBAN") 
	
; 	;(setq elast (entlast))
; 	(setq 
; 		doc (vla-get-ActiveDocument (vlax-get-acad-object))
; 		vpos(vlax-3d-point pos)
; 		mspc (vla-get-ModelSpace doc)
; 	)
  
; 	(if (not flag)
; 		(setq blkname (strcat ELECVBSPATH "\\" blkname ".dwg"))
; 	)			 
	
;   (setq obj (vla-InsertBlock mspc vpos blkname 1 1 1 0))
; 	(if (setq ename (vlax-vla-object->ename obj))
; 		(ifs_setAttValue ename "SENBAN" senban)
; 	)
; 	ename
; )

;; gp
(defun ifs_onTateLine(pt / pts ss res ent p1 p2)
	(setq pts (ifs_pointW pt 0.1))
	(if (setq ss (ssget "C" (car pts)(cadr pts) '((0 . "LINE"))))
		(setq 
			ent (entget (ssname ss 0))
			p1 (cdr (assoc 10 ent)) p2 (cdr (assoc 11 ent))
			res (< (abs (- (car p1)(car p2)))(abs (- (cadr p1)(cadr p2))))
		)
	)
	res
)

;; Line 2_Ԃ擾
;; ԃubN ename ̃XgԂ
(defun ifs_lineSenbanEnames(p1 p2 / off ang fpts ss i enames)
	(setq off 1.5)
	(if (> (abs (- (car p1)(car p2)))(abs (- (cadr p1)(cadr p2))))
		(setq ang (/ pi 2));; =㑤
		(setq ang pi);; =
	)
	;;tFXIp̂Q_ 
	(setq fpts (list (polar p1 ang off) (polar p2 ang off)))
	(setq i 0)
	(if (setq ss (ssget "F" fpts '((0 . "INSERT")(8 . "*")(2 . "*SENBAN*"))))
		(repeat (sslength ss)
			(setq 
				enames (append enames (list (ssname ss i)))
				i (1+ i)
			)
		)
	)
	(setq ss nil)
	enames
)

;; Ԏ쐬
;; A[XɂȂԂ̑Ώۂ珜Oǉ 2023/04/21
;; A[XɂȂԒɐ "E" 쐬ǉ 2023/04/21
(defun c:sbauto( / sbelist sw item i ename ent p1 p2 mp mps mpilist
				flag jogailst repcnt addcnt pts
				ato e1 e2 enames enm idx kw mae 
				pt ret sbe sbst senban ss stlen 
				tateFlag dimsc sbsorg len sb chgFlag loop blkname deg lst
        emark kizon kizonlst kizonret ecnt )
  (setq sbsorg "" chgFlag T);; ԂXV
  ;; A[XV{ɂȂ͏O 2023/04/21
  (setq emark "E_T1,E_T00,F-E_T1,E_T01")
	(setvar "CMDECHO" 0)
  (setq dimsc (getvar "DIMSCALE"))
	(setq
		sw 0 ;; \[g 0:X, 1:Y D
		sbst "101"
		repcnt 0 addcnt 0
	)
	(if T
		(progn
			(prompt "\nOijI < II > : ")
			(if (setq ss (ssget '((0 . "LINE")(8 . "*WIRE*")(-4 . "<NOT")(8 . "WIREO")(-4 . "NOT>"))))	
				(progn
					(setq i 0)
					(repeat (sslength ss)
						(setq 
							jogailst (append jogailst (list (ssname ss i)))
							i (1+ i)
						)
					)
				)
			)
		)
	)
	(if T
		(progn
			(setq flag nil)
      (if (setq pts (ifs_getCorner "쐬Ώۂ͈̔́i܂߂Ij"))
        (setq p1 (car pts) p2 (cadr pts) flag T)
      )
		)
	)
	(if flag
		(progn
			(setq sw 0)
			(initget "Tate Yoko")
			(setq kw (getkword "\nƂz̏cI [T:c /Y:] < T > : ")) 
			(if (= kw "Yoko")(setq sw 1))
			(setq mae (strcase (getstring "\nOŒ蕶 < Ȃ > : ")))		
			(if (= "" (setq sbst (getstring "\nԂ̏l < 101 > : ")))
				(setq sbst "101")
			)
			(setq stlen (strlen sbst))
			(setq ato (strcase (getstring "\nŒ蕶 < Ȃ > : ")))	
			(setq tateFlag (= sw 0))
		)
	)
	(if flag
		(progn
      ;; Bricscad Zoom
      (setvar "CMDECHO" 0)
      ;; IJCAD, ZWCAD ł̓Y[sv
      (if (= "Bricsys" (getvar "VENDORNAME")) ;; bricscad
        (command "_ZOOM" "none" p1 "none" p2)  
      )    
      ;; ̐Ԃ擾A"," ؂ŕێ
			(if (setq ss (ssget "W" p1 p2 '((0 . "INSERT")(8 . "*")(2 . "*SENBAN*"))))
        (progn
          (setq i 0 len (sslength ss))
          (repeat len
            (if (setq sb (ifs_getAttValue (ssname ss i) "SENBAN"))
              (if (= sbsorg "")
                (setq sbsorg sb)
                (setq sbsorg (strcat sbsorg "," sb))
              )
            )
            (setq i (1+ i))
          )
          (princ sbsorg)
          (if (/= sbsorg "")
            (progn
              (initget "Yes No")
              (if (not (setq kw (getkword "\n̐ԂύXɂ̂܂܎gp܂H [Y:Ԗzɒǉ /N:O̕v鐔ԂXV{ǉ] < Yes > : ")))
                (setq kw "Yes")
              )
              (setq chgFlag (= kw "No"))
            )
          )
        )
      ) 
      ;; 2023/04/21 emark ǉ
      (setq sbelist (ifs_getsbeall p1 p2 T emark) idx 0)
			(foreach item sbelist
				;; O܂܂Ă邩
		 		(setq ret T i 0)
				(if jogailst
					(while (and ret (< i (length jogailst)))
						(if (member (nth i jogailst) (car item))
							(setq ret nil)
						)
						(setq i (1+ i))
					)
				)
        ;; A[XɂȂ܂܂Ă邩 2023/04/21
        (if ret
          (setq ret (not (nth 4 item)))
        )
				(setq i 0 mps nil)
				(if ret
					(repeat (length (car item))
						(setq ename (nth i (car item)) ent (entget ename) 
							    p1 (cdr (assoc 10 ent)) p2 (cdr (assoc 11 ent))
                  i (1+ i)
            )
            ;; ΂ߐ͐ԍ쐬̑ΏۂɂȂ
						(if (or (ifs_isTateReal p1 p2 0.001)(ifs_isYokoReal p1 p2 0.001))
              (setq mp (list (/ (+ (car p1)(car p2)) 2.0)(/ (+ (cadr p1)(cadr p2)) 2.0) 0.0)
							    mps (append mps (list mp))
              )    
						)
					)
				)
				(if (and mps (> (length mps) 1))	
					(if (= sw 0)
						(setq mps (vl-sort mps (function (lambda (e1 e2)(> (cadr e1)(cadr e2)))))
							    mps (vl-sort mps (function (lambda (e1 e2)(< (car e1)(car e2)))))	
						)
						(setq mps (vl-sort mps (function (lambda (e1 e2)(< (car e1)(car e2)))))
							    mps (vl-sort mps (function (lambda (e1 e2)(> (cadr e1)(cadr e2)))))
						)
					)
				)
				(if mps (setq mpilist (append mpilist (list (list (car mps) idx)))))
				(setq idx (1+ idx))
			)
			;; \[g
			(setq mpiList (ifs_sortMpiList mpiList tateFlag))
      (setvar "CMDECHO" 0)
      (command "_UNDO" "BE")
			(setq i 0)
			(foreach item mpilist
				(setq idx (cadr item) pt (car item) senban nil
					    sbe (nth idx sbelist)
        )    

				(if (cadr sbe)
					;; Ԃ
          (if chgFlag
            (progn        
              ;; ̐ԂlԂł邩
              (setq kizonret nil)
              (if (setq kizon (car (cadr sbe)))
                (setq kizonlst (ifs_sprnum3 kizon)
                      kizonret (and (= (car kizonlst) mae)(/= (cadr kizonlst) "")(= (caddr kizonlst) ato))
                )
              )
              (if kizonret
                (progn
                  ;; ԍ쐬
                  (setq senban (itoa (+ (atoi sbst) i)))
                  ;; 킹
                  (setq senban (ifs_func_strAddZero senban stlen))
                  (setq i (1+ i)) 
                  ;; XV
                  (foreach ename (car sbe)
                    (setq
                      ent (entget ename) p1 (cdr (assoc 10 ent)) p2 (cdr (assoc 11 ent)) 
                      enames (ifs_lineSenbanEnames p1 p2)
                    )
                    (if (and enames (> (length enames) 0))
                      (foreach enm enames
                        (ifs_setAttValue enm "SENBAN" (strcat mae senban ato))
                        (setq repcnt (1+ repcnt))
                      )
                    )
                  )
                )
              )
            )
          )
					;; ԂȂ
					(progn
            (if chgFlag	
              (progn
                ;; ԍ쐬
                (setq senban (itoa (+ (atoi sbst) i)))
                ;; 킹
                (setq senban (ifs_func_strAddZero senban stlen))
                (setq i (1+ i))
              )
              (if (/= sbsorg "")
                (progn
                  ;; ԂƏdȂȂԂT
                  (setq loop T)
                  (while loop
                    (setq senban (itoa (+ (atoi sbst) i)))
                    (setq senban (ifs_func_strAddZero senban stlen))
                    (if (not (wcmatch (strcat mae senban ato) sbsorg))
                      (setq loop nil )
                    )
                    (setq i (1+ i))
                  )
                )
              )
            )       
            (setq lst (ifs_ValidSbBlkName (ifs_onTateLine pt)) blkname (car lst) deg (cadr lst))
            (setq ename (ifs_insert_sb blkname pt dimsc deg (strcat mae senban ato)))
            (setq addcnt (1+ addcnt))
					)
				)
			)
      ;; A[X̐ԍ쐬 2023/04/21
			(setq ecnt 0)
      (foreach item sbelist
				;; A[XV{ɂȂĂāAԂ
        (if (and (nth 4 item)(not (car (cadr item))))
          (setq     
            ent (entget (ifs_maxDistLine (car item)));; Ԓ      
            pt (ifs_midPoint (cdr (assoc 10 ent))(cdr (assoc 11 ent)))
            lst (ifs_ValidSbBlkName (ifs_onTateLine pt)) blkname (car lst) deg (cadr lst)
            ename (ifs_insert_sb blkname pt dimsc deg "E")
            addcnt (1+ addcnt)
            ecnt (1+ ecnt)
          )            
        )    
      )
      (command "_UNDO" "END")
		)
	)
	(prompt (strcat "\n" (itoa repcnt) " A" (itoa addcnt) " iA[X " (itoa ecnt) " jǉ܂D"))
	(setvar "CMDECHO" 1)
	(princ)
)

;;  Ename Xĝ̒ Ename Ԃ
(defun ifs_maxDistLine( elist / distmax dist ename res ent)
  (setq distmax 0.0)
  (foreach ename elist
    (setq ent (entget ename))
    (setq dist (distance (cdr (assoc 10 ent))(cdr (assoc 11 ent))))
    (if (> dist distmax)(setq distmax dist res ename))
  )
  res
)
;; Q_Ԓ_
(defun ifs_midPoint(p1 p2 / a b)
  (mapcar (function (lambda (a b) (/ (+ a b) 2.0))) p1 p2)
)
;; -----------------------------------------------------------------------------
;; Nbv{[h֐
;; Q :	 http://www.theswamp.org/index.php?topic=21764.0
;; -----------------------------------------------------------------------------
(defun ifs_setClipBoardText (text / htmlfile result) 
  ;;	Caller's sole responsibility is to pass a
  ;;	text string. Anything else? Pie in face.
  ;;	Attribution: Reformatted version of
  ;;	post by XShrimp at theswamp.org.
  ;;
  ;;	See http://tinyurl.com/2ngf4r.
  (setq result (vlax-invoke 
                 (vlax-get 
                   (vlax-get 
                     (setq htmlfile (vlax-create-object "htmlfile"))
                     'ParentWindow
                   )
                   'ClipBoardData
                 )
                 'SetData
                 "Text"
                 text
               )
  )
  (vlax-release-object htmlfile)
  text
)
;; Nbv{[h֐
(defun ifs_getClipBoardText (/ htmlfile result) 
  ;;	Attribution: Reformatted version of
  ;;	post by Patrick_35 at theswamp.org.
  ;;
  ;;	See http://tinyurl.com/2ngf4r.
  (setq result (vlax-invoke 
                 (vlax-get 
                   (vlax-get 
                     (setq htmlfile (vlax-create-object "htmlfile"))
                     'ParentWindow
                   )
                   'ClipBoardData
                 )
                 'GetData
                 "Text"
               )
  )
  (vlax-release-object htmlfile)
  result
)
;; -----------------------------------------------------------------------------
;; Nbv{[h֐
;; gp
(defun ifs_clearClipBoardText (/ htmlfile result) 
  (setq result (vlax-invoke 
                 (vlax-get 
                   (vlax-get 
                     (setq htmlfile (vlax-create-object "htmlfile"))
                     'ParentWindow
                   )
                   'ClipBoardData
                 )
                 'ClearData
                 "Text"
               )
  )
  (vlax-release-object htmlfile)
  result
)
;; ------------------------------------------

;; 탍[h
(defun loadLineType ( lineType / linFile acad adoc vendor ret ltypes lType)
  (setq lineType (strcase lineType))
  (setq acad (vlax-get-Acad-Object))
  ;; t@C
  (setq vendor (getvar "VENDORNAME"))
  (cond 
    ((wcmatch vendor "*Bricsys*")(setq linFile "iso.lin"))
    ((wcmatch vendor "*IntelliJapan*")(setq linFile "gcadiso.lin"))
  )
  (if (not linFile)
    (if (wcmatch (vla-get-caption acad) "*ZWCAD*")
      (setq linFile "zwcadiso.lin")
      (setq linFile "acadiso.lin")
    )
  )
  (if linFile
    (progn
      ;; 킪[hĂ邩
      (setq adoc (vla-get-activedocument acad))
      (setq lTypes  (vla-get-linetypes adoc))
      (vlax-for ltype lTypes
        (if (= (strcase (vla-get-name ltype)) lineType)
          (setq ret T)
        )
      )
      (if (not ret)
        ;; [h
        (vla-load lTypes lineType linFile)
      )
    )
  )
)

(defun IFS_MAKE_SQE2 ()
  (if (not (tblsearch "BLOCK" "E_T01")) 
    (progn
      (entmake '((0 . "BLOCK") (2 . "E_T01") (10 0.0 0.0 0.0) (70 . 0)))
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (62 . 0)
          (6 . "BYBLOCK")
          (10 -1.0 0.0 0.0)
          (11 -2.5 -1.5 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (62 . 0)
          (6 . "BYBLOCK")
          (10 -2.5 0.0 0.0)
          (11 2.5 0.0 0.0)
        )
      )
      ;;(entmake '((0 . "LINE")(8 . "0")(62 . 0)(6 . "BYBLOCK")(10 0.0 2.5 0.0)(11 0.0 0.0 0.0)))
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (62 . 0)
          (6 . "BYBLOCK")
          (10 0.5 0.0 0.0)
          (11 -1.0 -1.5 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (62 . 0)
          (6 . "BYBLOCK")
          (10 2.0 0.0 0.0)
          (11 0.5 -1.5 0.0)
        )
      )
      (entmake '((0 . "ENDBLK")))
    )
  )
)

(defun IFS_MAKE_SQE1 () 
  (if (not (tblsearch "BLOCK" "E_T00")) 
    (progn  
      (entmake '((0 . "BLOCK") (2 . "E_T00") (10 0.0 0.0 0.0) (70 . 0)))
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (62 . 0)
          (6 . "BYBLOCK")
          (10 -0.833333333333 -2.0 0.0)
          (11 0.833333333333 -2.0 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (62 . 0)
          (6 . "BYBLOCK")
          (10 2.5 0.0 0.0)
          (11 -2.5 0.0 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (62 . 0)
          (6 . "BYBLOCK")
          (10 -1.666666666667 -1.0 0.0)
          (11 1.666666666667 -1.0 0.0)
        )
      )
      ;;(entmake '((0 . "LINE")(8 . "0")(62 . 0)(6 . "BYBLOCK")(10 0.0 0.0 0.0)(11 0.0 2.5 0.0)))
      (entmake '((0 . "ENDBLK")))
    )
  )
)
(defun ifs_make_wipeoutTB (blkname outTB / makelist stp ang d gen code10 code11 
                            code12 r
                           ) 
  ;; 62:F 0=ByBlock 256=ByLayer
  ;; 8:w
  (if (not (tblsearch "BLOCK" blkname)) 
    (progn 
      (if outTB 
        (setq r      1.0
              code10 '(-1.0 -1.0 0.0)
              code11 '(2.0 0.0 0.0)
              code12 '(0.0 2.0 0.0)
        )
        (setq r      0.8
              code10 '(-0.8 -0.8 0.0)
              code11 '(1.6 0.0 0.0)
              code12 '(0.0 1.6 0.0)
        )
      )

      (setq makelist (list 
                       '(0 . "WIPEOUT")
                       '(100 . "AcDbEntity")
                       '(67 . 0)
                       '(8 . "SYMBOL")
                       '(100 . "AcDbWipeout")
                       (cons 10 code10)
                       (cons 11 code11)
                       (cons 12 code12)
                       '(13 1.0 1.0 0.0)
                       '(70 . 7)
                       '(280 . 1)
                       '(281 . 50)
                       '(282 . 50)
                       '(283 . 0)
                       '(71 . 2)
                       '(91 . 33)
                     )
      )
      (setq stp (/ PI 16)
            ang 0
            d   0.5
            gen '(0 0 0)
      )
      (repeat 33 
        (setq makelist (append makelist (list (cons 14 (polar gen ang d)))))
        (setq ang (+ ang stp))
      )
      (entmake 
        (list '(0 . "BLOCK") (cons 2 blkname) '(10 0.0 0.0 0.0) '(70 . 0))
      )
      (entmake makelist)
      (if (not outTB) 
        (entmake 
          '((0 . "CIRCLE")
            (67 . 0)
            (8 . "SYMBOL")
            (100 . "AcDbCircle")
            (10 0.0 0.0 0.0)
            (40 . 0.8)
            (62 . 256)
           )
        )
        (progn 
          (entmake 
            '((0 . "CIRCLE")
              (67 . 0)
              (8 . "SYMBOL")
              (100 . "AcDbCircle")
              (10 0.0 0.0 0.0)
              (40 . 1.0)
              (62 . 256)
             )
          )
          (entmake 
            '((0 . "CIRCLE")
              (67 . 0)
              (8 . "SYMBOL")
              (100 . "AcDbCircle")
              (10 0.0 0.0 0.0)
              (40 . 1.5)
              (62 . 256)
             )
          )
        )
      )
      (entmake '((0 . "ENDBLK")))
    )
  )
)
(defun ifs_make_cmark (blkname) 
  ;;62:F 0=ByBlock 256=ByLayer
  ;; 8:w
  (if (not (tblsearch "BLOCK" blkname)) 
    (progn 
      (entmake 
        (list '(0 . "BLOCK") (cons 2 blkname) '(10 0.0 0.0 0.0) '(70 . 0))
      )
      (entmake 
        '((0 . "CIRCLE")
          (8 . "SYMBOL")
          (100 . "AcDbCircle")
          (10 0.0 0.0 0.0)
          (40 . 0.10)
          (62 . 256)
         )
      )
      (entmake 
        '((0 . "CIRCLE")
          (8 . "SYMBOL")
          (100 . "AcDbCircle")
          (10 0.0 0.0 0.0)
          (40 . 0.20)
          (62 . 256)
         )
      )
      (entmake 
        '((0 . "CIRCLE")
          (8 . "SYMBOL")
          (100 . "AcDbCircle")
          (10 0.0 0.0 0.0)
          (40 . 0.30)
          (62 . 256)
         )
      )
      (entmake 
        '((0 . "CIRCLE")
          (8 . "SYMBOL")
          (100 . "AcDbCircle")
          (10 0.0 0.0 0.0)
          (40 . 0.40)
          (62 . 256)
         )
      )
      (entmake 
        '((0 . "CIRCLE")
          (8 . "SYMBOL")
          (100 . "AcDbCircle")
          (10 0.0 0.0 0.0)
          (40 . 0.50)
          (62 . 256)
         )
      )
      (entmake '((0 . "ENDBLK")))
    )
  )
)
;; ~tA[X}[N
(defun ifs_make_emarkLG (blkname) 
  ;;62:F 0=ByBlock 256=ByLayer
  ;; 8:w
  (if (not (tblsearch "BLOCK" blkname)) 
    (progn 
      (entmake 
        (list '(0 . "BLOCK") (cons 2 blkname) '(10 0.0 0.0 0.0) '(70 . 0))
      )
      (entmake 
        '((0 . "CIRCLE")
          (8 . "SYMBOL")
          (100 . "AcDbCircle")
          (10 0.0 0.0 0.0) 
          (40 . 1.75)
          (62 . 256)
         )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 0.0 -0.25 0.0)
          (11 0.0 1.0 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 -0.2 -1.15 0.0) (11 0.2 -1.15 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 -0.4 -0.75 0.0) (11 0.4 -0.75 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 -0.8 -0.35 0.0) (11 0.8 -0.35 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 0.0 -0.35 0.0)  (11 0.0 1.25 0.0)
        )
      )
      (entmake '((0 . "ENDBLK")))
    )
  )
)
(defun ifs_make_emarkFG (blkname) 
  ;;62:F 0=ByBlock 256=ByLayer
  ;; 8:w
  (if (not (tblsearch "BLOCK" blkname)) 
    (progn 
      (entmake 
        (list '(0 . "BLOCK") (cons 2 blkname) '(10 0.0 0.0 0.0) '(70 . 0))
      )
      (entmake 
        '((0 . "ARC")
          (8 . "SYMBOL")
          (100 . "AcDbArc")
          (10 0.0 0.0 0.0) 
          (40 . 1.75) 
          (50 . 5.91797808588919) (51 . 3.50679987488018)
          ;;(62 . 256)
         )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 0.0 -0.25 0.0)
          (11 0.0 1.0 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 -0.2 -1.15 0.0) (11 0.2 -1.15 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 -0.4 -0.75 0.0) (11 0.4 -0.75 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 -0.8 -0.35 0.0) (11 0.8 -0.35 0.0)
        )
      )
      (entmake 
        '((0 . "LINE")
          (8 . "SYMBOL")
          (10 0.0 -0.35 0.0)  (11 0.0 1.25 0.0)
        )
      )
      (entmake '((0 . "ENDBLK")))
    )
  )
)

(defun ifs_make_senban (blkname VFlag / makelist r code10 code11) 
  (if (not (tblsearch "BLOCK" blkname)) 
    (progn 
      (if VFlag 
        (setq r      (/ PI 2.0)
              code11 '(-1.0 0.0 0.0)
              code10 '(-1.0 0.0 0.0)
        )
        (setq r      0.0
              code11 '(0.0 1.0 0.0)
              code10 '(0.0 1.0 0.0)
        )
      )
      (setq makelist (list 
                       ; blockName = SENBAN1
                       (cons 0 "ATTDEF")
                       (cons 8 "SENBAN")
                       (cons 10 code10)
                       (cons 40 2.5)
                       (cons 1 "")
                       (cons 3 "SENBAN?")
                       (cons 2 "SENBAN")
                       (cons 70 0)
                       (cons 73 0)
                       (cons 50 r) ;;(50 . 0.0)
                       (cons 41 0.8)
                       (cons 51 0.0)
                       (cons 7 "Standard")
                       (cons 71 0)
                       (cons 72 1)
                       (cons 73 1)
                       (cons 11 code11)
                       (cons 210 (list 0 0 1))
                       (cons 74 0)
                       (cons 62 256)
                       (cons 39 0)
                       (cons 6 "BYLAYER")
                       ;;'(100 . "AcDbAttributeDefinition")
                     )
      )
      (entmake 
        (list (cons 0 "BLOCK") 
              (cons 2 blkname)
              (cons 70 2);; code70 = 2 
              (cons 10 (list 0.0 0.0 0.0))
        )
      )
      ;; AutoCAD ō쐬oȂߒǉ
      (entmake '((0 . "POINT") (8 . "SENBAN") (10 0.0 0.0 0.0) (62 . 256)))
      (entmake makelist)
      (entmake (list (cons 0 "ENDBLK")))
    )
  )
)
;; AutoCAD œȂߏC
(defun ifs_make_Layer (layname color lineType /)
  (if (not lineType) (setq lineType "Continuous"))
  (if (not (tblsearch "LAYER" layname)) 
    (entmake 
      (list 
        (cons 0 "LAYER")
        (cons 100 "AcDbSymbolTableRecord")
        (cons 100 "AcDbLayerTableRecord")
        (cons 2 layname)
        (cons 70 0)
        (cons 62 color) ;; color
        (cons 6 lineType ) ;; linetype
      )
    )
  )
)
;; 탍[h
(loadLineType "HIDDEN2")

;; w쐬
;; łɑ݂Ƃ́AFA͂̂܂
(ifs_make_Layer "WIRE" 3 nil) ;; green
(ifs_make_Layer "SENBAN" 2 nil) ;; yellow
(ifs_make_Layer "LINK" 7 "HIDDEN2") ;; white

;; ubNi[qAO[qA_AԉAԏcj쐬
;; iwĂ쐬j
(ifs_make_wipeoutTB "INTCIR00" nil);; nil = IntTb
(ifs_make_wipeoutTB "OUTCIR00" T)  ;; T = OutTB
(ifs_make_cmark "CMARK00")
;;(ifs_make_emark "EMARK00")
(ifs_make_emarkLG "EMARK_LG")
(ifs_make_emarkFG "EMARK_FG")

(ifs_make_senban "SENBAN00" nil) ;; p ]Ȃ
;; (ifs_make_senban "SENBAN90" T);; cp 90x]
(ifs_make_sqe1) ;;
(ifs_make_sqe2) ;;
(setvar "SNAPUNIT" '(1.25 1.25))
(setvar "GRIDUNIT" '(5.0 5.0))
(setvar "ORTHOMODE" 1)
(setvar "SNAPMODE" 1)
(setvar "GRIDMODE" 1)
(setvar "OSMODE" (+ 1 2 4 32 64 128 512 1024))
(princ "\nBTRIMVX232.lsp Ver.2023/05/01 : [h܂D")
(princ)

  ; (logand 8 (getvar "OSMODE"))
  ; 0	NON[]
  ; 1	END[[_]
  ; 2	MID[_]
  ; 4	CEN[S]
  ; 8	NOD[_]
  ; 16	QUA[l~_]
  ; 32	INT[_]
  ; 64	INS[}_]
  ; 128	PER[]
  ; 256	TAN[ڐ]
  ; 512	NEA[ߐړ_]
  ; 1024	GCE[}c]
  ; 4096	APP[z_]
  ; 8192	PAR[s]
  ; 16384	݂̒IuWFNg Xibv𖳌
