;; makeR12DXF2.lsp
;; 2025/11/25
;; f.izawa

;; CAD őI}` R12 `́@DXF t@Cɕۑ܂B
;;  ܂ ZWCAD, AutoCAD ŕsS DXF G[ɂȂ邱Ƃ܂B
;;  ܂ DXF R[h󔒂Ŏ̍s󔒂ɂȂiDXF R[hG[jƂ܂B
;;  ODA File Converter ŏC (Audit) ƁAɓǂ߂\Ȃ܂B

;;  ꕔ̐@}`ɂ͑ΉĂ܂B
;;  ̑AR12 ɑ݂Ȃ}`(WIPEOUT ...)͑ΉĂ܂B

;; 
;; 2025/08/24  : ō쐬(makeR12DXF.lsp)@
;; 2025/08/24a : t@Cgp̃bZ[Wǉ
;; 2025/08/25  : t@Cۑ_CAO̕\ǉ
;; 2025/08/26 : insertEXP R}hFDXF,DWG t@C𕪉}iړx 1.0Apx 0.0 Œjǉ
;; 2025/09/03 : LWPOLYLINE  POLYLINE ɕϊǉ
;;              ubN̐}`iȊOj̕\ɑΉiwAF̍Č͖Ήj
;; 2025/09/05 : ubN BricsCAD ŘAubNɂȂ̂C 
;; 2025/09/07 : Ώې}` SOLID ǉ
;;              ubN̉ẅꕔ擾ĂȂ̂C
;;              쐬̉ʈʒu̍Čǉ
;;              TEXT "^"܂܂ĂƂAZWCADAAutoCAD ŃG[ɂȂȂ邽߁ASpOɒuǉ
;; 2025/10/13 : TEXT ɉs܂܂ĂƂADXF t@Cɋ󔒂Qsǉ̂΍
;;              DIMENSION ɑΉ(ړxɂ͖Ή)
;;              CODE ̎o
;;              POLYLINE ̕ɑΉ
;;              lXgꂽubNɑΉ(10w܂)
;; 2025/10/14 : LEADER ɑΉi̓|CɁA߂ TEXT ɕϊj
;;              MTEXT ɑΉiꎞIɕāAUNDO Ŗ߂Ăj
;; 2025/10/23 : WIPEOUT ܂ރubN̕\ǉiEBhEŊmFj
;;              TEXT  "\n", "\n" ܂܂ĂƂADXF t@Cɋ󔒂Qsǉ΍􂪌ĂȂ̂蒼

;; 2025/11/25 : ELLIPSE -> PLINE ǉ

;; Ώې}`́ALINE, CIRCLE, ARC, TEXT, LWPOLYLINE, INSERT, SOLID, DIMENSION, LEADER, MTEXT, ELLIPSE ̂
;; o͐}`́ALINE, CIRCLE, ARC, TEXT, POLYLINE(LWPOLYLINE, SOLID, ELLIPSE  POLYLINEɕϊj, INSERT, DIMENSION

;; ݂邷ׂĂ oldStr  newStr ɒuivle-string-replace Ɠj
(defun string_replace (newStr oldStr srcStr / lastStr i len)
  ;; 2025/09/07 [vǉ
  ;; "1"  "10" ɒuƂ̓_B
  ;; uΏۂ "1" ȂȂ̂Ŗ[vɂȂB
  (setq len (strlen srcStr) i 0)  
  (while (and (/= lastStr srcStr) (< i len)) 
    (setq lastStr srcStr)
    (setq srcStr (vl-string-subst newStr oldStr srcStr))
    (setq i (1+ i))
  )
  srcStr
)
;; Pu
(defun chrReplace (old new str / x) 
  (vl-list->string 
    (mapcar 
      '(lambda (x) 
         (if (= x (ascii old)) (ascii new) x)
       )
      (vl-string->list str)
    )
  )
)

;; 擪ɃXy[Xǉ
(defun addSpace(str n / len)
  (setq len (strlen str))
  (if (> n len)
    (repeat (- n len)
      (setq str (strcat " " str))
    )
  )
  str
)

; Xg̃CfbNX(0x[X)
(defun indexOf (item lst / temp res)
  (if (setq temp (member item lst)) 
    (setq res(- (length lst) (length temp) 1))
    (setq res -1)
  )
  res
)

;; _~[ VIEW e[uǉ
(defun viewR12DXF(fp / dummy code i len str)
  (setq dummy (list
    0 "TABLE" 2 "VIEW" 70 "0" 0 "ENDTAB"
  ))
  (setq len (/ (length Dummy) 2) i 0)
  (repeat len
    (setq 
      code (nth (* i 2) Dummy)
      str (nth (1+ (* i 2))  Dummy)
    )
    (princ (strcat (addSpace (itoa code) 3) "\n" str "\n") fp)
    (setq i (1+ i))
  )
)

;; VPORT e[uǉ
(defun vportR12DXF( fp / code i str codes ename ent j pt n)
  (setq codes (list 10 11 12 13 14 15 16 17 40 41 42 43 44 50 51 71 72 73 74 75 76 77 78))
  (if (setq ename (tblobjname "VPORT" "*ACTIVE"))
    (progn
      (setq ent (entget ename))
      (princ "  0\nTABLE\n" fp)
      (princ "  2\nVPORT\n" fp)
      (princ " 70\n1\n" fp)
      (princ "  0\nVPORT\n" fp)
      (princ "  2\n*ACTIVE\n" fp)
      (princ " 70\n0\n" fp)
      (setq i 0)
      (repeat (length codes)
        (setq code (nth i codes)) 
        (if (assoc code ent)
          (progn 
            (cond
              ((and (>= code 10) (<= code 18))
                (progn
                  (setq pt (cdr (assoc code ent)))
                  (setq j 0)
                  (if (and (>= code 16) (<= code 17))
                    (setq n 3)
                    (setq n 2)
                  )
                  (repeat n
                    (princ (strcat (addSpace (itoa code) 3) "\n") fp)
                    (princ (nth j pt) fp)(princ "\n" fp)
                    (setq j (1+ j) code (+ code 10))
                  )
                )
              )
              ((and (>= code 50) (<= code 58))
                (progn
                  (princ (strcat  " " (itoa code) "\n") fp)
                  (princ (* 180.0 (/ (cdr (assoc code ent)) PI)) fp) 
                  (princ "\n" fp)
                )
              )
              ( T
                (if (assoc code ent)
                  (progn
                    (setq str (addSpace (itoa code) 3))
                    (princ (strcat str "\n") fp)(princ (cdr (assoc code ent)) fp)(princ "\n" fp)
                  )
                )               
              )
            )
          )
        )
        (setq i (1+ i))
      )  
      (princ "  0\nENDTAB\n" fp)
    )
  )
)

;; _~[ UCS, APPID, DIMSTYLE(dimFlag ɂ)
(defun UcsAppidDimstyleR12DXF( fp dimFlag / Dummy code i len str )
  (setq Dummy (list
      ;; UCS
      0 "TABLE" 2 "UCS" 70 "0" 0 "ENDTAB"
      ;; APPID          
      0 "TABLE"
      2 "APPID" 70 "     1"  0 "APPID"  2 "ACAD"  70 "     0"
      0 "ENDTAB"
  ))
  (if dimFlag
    (setq Dummy (append Dummy (list (list
      ;; DIMSTYLE          
      0 "TABLE"
      2 "DIMSTYLE" 70 "     1" 0 "DIMSTYLE" 2 "STANDARD" 70 "     0" 
      3 ""  4 "" 5 "" 6 "" 7 ""
      40 "1.0" 41 "0.18" 42 "0.0625" 43 "0.38" 44 "0.18" 45 "0.0" 46 "0.0" 47 "0.0" 48 "0.0"
      140 "0.18" 141 "0.09" 142 "0.0" 143 "25.4" 144 "1.0" 145 "0.0" 146 "1.0" 147 "0.09"
      71 "     0" 72 "     0" 73 "     1" 74 "     1" 75 "     0" 76 "     0" 77 "     0" 78 "     0"
      170 "     0" 171 "     2" 172 "     0" 173 "     0" 174 "     0" 175 "     0" 176 "     0" 177 "     0"  178 "     0"
      0 "ENDTAB"
    ))
    ))
  )
  (setq len (/ (length Dummy) 2) i 0)
  (repeat len
    (setq 
      code (nth (* i 2) Dummy)
      str (nth (1+ (* i 2))  Dummy)
    )
    (princ (strcat (addSpace (itoa code) 3) "\n" str "\n") fp)
    (setq i (1+ i))
  )
)

;; HEADER ZNV
(defun headerR12DXF( fp / code i j len res varListR12 varname )
  (setq varListR12 (list
    ;;"ACADVER" 1 
    ;;"DWGCODEPAGE" 3 
    "INSBASE" 10 
    "EXTMIN" 10 "EXTMAX" 10 
    "LIMMIN" 10 "LIMMAX" 10
    "ORTHOMODE" 70 "REGENMODE" 70 "FILLMODE" 70 "QTEXTMODE" 70 "MIRRTEXT" 70 "DRAGMODE" 70 "LTSCALE" 40
    "OSMODE" 70 "ATTMODE" 70 "TEXTSIZE" 40 "TRACEWID" 40 "TEXTSTYLE" 7 "CLAYER" 8 "CELTYPE" 6
    "CECOLOR" 62 
    "DIMSCALE" 40 "DIMASZ" 40 "DIMEXO" 40 "DIMDLI" 40 "DIMRND" 40 "DIMDLE" 40
    "DIMEXE" 40 "DIMTP" 40 "DIMTM" 40 "DIMTXT" 40 "DIMCEN" 40 "DIMTSZ" 40 "DIMTOL" 70 "DIMLIM" 70
    "DIMTIH" 70 "DIMTOH" 70 "DIMSE1" 70 "DIMSE2" 70 "DIMTAD" 70 "DIMZIN" 70 "DIMBLK" 1 "DIMASO" 70
    "DIMSHO" 70 "DIMPOST" 1 "DIMAPOST" 1 "DIMALT" 70 "DIMALTD" 70 "DIMALTF" 40 "DIMLFAC" 40 "DIMTOFL" 70
    "DIMTVP" 40 "DIMTIX" 70 "DIMSOXD" 70 "DIMSAH" 70 "DIMBLK1" 1 "DIMBLK2" 1 "$DIMSTYLE" 2 "DIMCLRD" 70
    "DIMCLRE" 70 "DIMCLRT" 70 "DIMTFAC" 40 "DIMGAP" 40 
    "LUNITS" 70 "LUPREC" 70 "SKETCHINC" 40 "FILLETRAD" 40 "AUNITS" 70 "AUPREC" 70
    "MENU" 1 "ELEVATION" 40 "PELEVATION" 40 "THICKNESS" 40 "LIMCHECK" 70 "CHAMFERA" 40
    "CHAMFERB" 40 "SKPOLY" 70 "TDCREATE" 40 "TDUPDATE" 40 "TDINDWG" 40 "TDUSRTIMER" 40 "USRTIMER" 70
    "ANGBASE" 50 "ANGDIR" 70 "PDMODE" 70 "PDSIZE" 40 "PLINEWID" 40 "COORDS" 70 "SPLFRAME" 70 "SPLINETYPE" 70
    "SPLINESEGS" 70 "ATTDIA" 70 "ATTREQ" 70 "HANDLING" 70                 
    ;;"HANDSEED" 5;; ǉȂ
    "SURFTAB1" 70 "SURFTAB2" 70 "SURFTYPE" 70 "SURFU" 70 "SURFV" 70 "UCSNAME" 2 "UCSORG" 10 "UCSXDIR" 10
    "UCSYDIR" 10 
    ;; "PUCSNAME" 2 ;; 20251022 
    "PUCSORG" 10 "PUCSXDIR" 10 "PUCSYDIR" 10
    "USERI1" 70 "USERI2" 70 "USERI3" 70 "USERI4" 70 "USERI5" 70
    "USERR1" 40 "USERR2" 40 "USERR3" 40 "USERR4" 40 "USERR5" 40
    "WORLDVIEW" 70 "SHADEDGE" 70 "SHADEDIF" 70 "TILEMODE" 70 "MAXACTVP" 70 "PLIMCHECK" 70
    "PEXTMIN" 10 "PEXTMAX" 10 "PLIMMIN" 10 "PLIMMAX" 10 "UNITMODE" 70 "VISRETAIN" 70 "PLINEGEN" 70 "PSLTSCALE" 70
    ;; VPORT Ɋ܂܂
    ;;"VIEWCTR" 10 "VIEWDIR" 10 "VIEWSIZE" 40
  ))
  ;; R12 DXF 
  (princ (strcat "  9\n" "$ACADVER\n") fp) 
  (princ (strcat "  1\n" "AC1009\n")  fp)
  (princ (strcat "  9\n" "$DWGCODEPAGE\n") fp) 
  (princ (strcat "  3\n" "ANSI_932\n")  fp)
  (setq len (/ (length varListR12) 2) i 0)
  (repeat len
    (setq 
      varname (nth (* i 2) varListR12)
      code (nth (1+ (* i 2)) varListR12)
    )
    (if (setq res (getvar varname))
      (progn
        (princ (strcat "  9\n$" varname "\n") fp)
        (cond 
          ((= code 10)
            (progn
              (setq j 0)
              (repeat (length res);; 2D W݂ 
                (princ (strcat " " (itoa code) "\n") fp)
                (princ (nth j res) fp)
                (princ "\n" fp)
                (setq j (1+ j) code (+ code 10))
              )
            )
          )
          ((and (>= code 50)(<= code 58))
            (progn
              (princ (strcat  " " (itoa code) "\n") fp)
              (princ (* 180.0 (/ res PI)) fp) 
              (princ "\n" fp)
            )
          )
          ((= code 62)
            (progn
              (princ (strcat  " " (itoa code) "\n") fp)
              (setq res (strcase res))
              (cond
                ((= res "BYBLOCK")(setq res 0))
                ((= res "BYLAYER")(setq res 256))
              )
              (princ (strcat (itoa res) "\n") fp) 
            )
          )
          ( T
            (progn
              (princ (strcat (addSpace (itoa code) 3) "\n") fp)
              (princ res fp)
              (princ "\n" fp)
            )
          )
        )
      )
    )
    (setq i (1+ i))
  )
)

;; ENT ̃R[hoꏇɏo
(defun writeDxfCodesEnt(ent codes fp / code h j name pt rad scode str src item )
  (setq j 0)
  (repeat (length ent)
    (setq code (car (nth j ent)))
    (if (member code codes)
      (progn     
        (setq item (cdr (assoc code ent)))
        (cond
          ((and (>= code 10)(<= code 18));;(assoc code ent))
            (progn
              (setq pt item h 0 )
              (repeat (length pt)
                (princ (strcat " " (itoa code) "\n") fp)(princ (nth h pt) fp)(princ "\n" fp)
                (setq h (1+ h ) code (+ code 10))
              )
            )
          )
          ((and (>= code 50)(<= code 58))
            (progn
              (setq rad item)
              (princ (strcat " " (itoa code) "\n") fp)(princ (* 180.0 (/ rad PI)) fp) (princ "\n" fp)
            )
          )
          ((and (= code 1)(= (cdr (assoc 0 ent)) "TEXT"))
            (progn
              (setq src item)
              ;; 2025/10/23 C
              (setq src (string_replace "" "\n" src)) ;; 2025/10/13
              (setq src (string_replace "" "\r" src)) ;; 2025/10/13
              (if (not (= item src))
                (princ (strcat "\nCR, LF ܂ TEXT = " item))
              )
              (setq str (string_replace "O" "^" src))
              (princ (strcat "  1\n" str "\n") fp)
              (if (not (= str src))
                (princ "O>Sp ") 
              )
            )
          )
          ((and (>= code 2)(<= code 3))
            (progn
              (setq name (string_replace "_" " "  item ))              
              (princ (strcat " " (itoa code) "\n" name "\n") fp)
            )
          )
          (T
            (progn
              (setq scode (addSpace (itoa code) 3))
              (princ (strcat scode "\n") fp)(princ item fp)(princ "\n" fp)
            )
          )
        )                              
        
      )
    )
    (setq j (1+ j))
  )
)

(defun addR12Entities (ename fp attFlag / ent etype j k pt codes attcodes
                       loop lay seqFlag)
  ;; K{ = 0 67 8 6 62 210
  ;; ARC = 39 10 40 50 51
  ;; ATTRIB = 39 10 40 1 2 70 50 41 51 7 71 72 11 70 73 74
  ;; INSERT= 66 2 10 41 42 43 50 70 71 44 45
  ;; POLYLINE = 39 66 10 70 40 41 71 72 73 74 75
  ;; VERTEX = 10 40 41 42 70 50 71 72 73 74 
  (setq ent (entget ename) etype (cdr (assoc 0 ent)))
  (cond 
    ((= etype "LINE" )
      (setq codes (list 39 10 11))
    )
    ((= etype "CIRCLE")
      (setq codes (list 39 10 40))
    )
    ((= etype "ARC")
      (setq codes (list 39 10 40 50 51))  
    )
    ((= etype "TEXT")
      (setq codes (list 39 10 40 1 50 41 51 7 71 72 11 73))
    )
    ((= etype "LWPOLYLINE")
      (lwpToPlineDXF ent fp)
    )
    ((= etype "SOLID")
      (SolidToPlineDXF ent fp)
    )
    ((= etype "LEADER") ;; 2025/10/14
      (LeaderToPlineDXF ent fp)
    )
    ((= etype "INSERT")
      (setq codes (list 2 10 41 42 43 50));; 66 70 71 44 45))
    )
    ((= etype "DIMENSION");; 2025/10/13
      (setq codes (list 2 10 11 12 70 1 52 53 3 13 14 15 16 40 50 51));; 66 70 71 44 45))
    )
    ((= etype "ELLIPSE");; 2025/11/25
      (progn
        (EllipseToPlineDXF ename fp)
      )
    )
  )
  (if codes
    (progn
      (princ (strcat "  0\n" etype "\n") fp)
      (princ (strcat " 67\n" (itoa (cdr (assoc 67 ent))) "\n") fp)
      
      (princ (strcat "  8\n" (cdr (assoc 8 ent)) "\n") fp) ;; w
      (if (assoc 6 ent)
        (princ (strcat "  6\n" (cdr (assoc 6 ent)) "\n") fp) ;; 햼
      )      
      (if (assoc 62 ent)
        (princ (strcat " 62\n" (itoa (cdr (assoc 62 ent))) "\n") fp)
        (princ (strcat " 62\n" "256\n") fp) ;; F 0= BYBLOCK, 256= BYLAYER
      )
      (if (assoc 210 ent)
        (progn
          (setq pt  (cdr (assoc 210 ent)))
          (setq j 0 k 210)
          (repeat 3
            (princ (strcat " " (itoa k) "\n") fp)(princ (nth j pt) fp)(princ "\n" fp)
            (setq j (1+ j ) k (+ k 10))
          )
        )
      )
      (if (= etype "INSERT")
        (progn
          (if (assoc 66 ent);; 㑱}`P̎SEQEND ŏI
            (progn
              (princ (strcat " 66\n"  (itoa (cdr (assoc 66 ent))) "\n") fp)
              (setq seqFlag (= 1 (cdr (assoc 66 ent))))            
            )
          )
        )
      )
      (writeDxfCodesEnt ent codes fp)
      (if (and (= etype "INSERT") attFlag) ;;(= etype "INSERT");; Ԃ̂Ŏ߁EEE
        (progn
          (setq lay (cdr (assoc 8 ent)))
          (setq attcodes (list 0 8 39 10 40 1 2 70 50 41 51 7 71 72 11 73 74))
          (setq loop T)
          (while (and loop (setq ename (entnext ename)))
            (if ename
              (progn
                (setq ent (entget ename))
                (if (= "ATTRIB" (cdr (assoc 0 ent)))
                  (progn
                    ;; ENT ̓oꏇɏo
                    (writeDxfCodesEnt ent attcodes fp)
                  )
                  (progn
                    (setq loop nil)
                  )
                )
              )
            )
          )
          (if seqFlag
            (progn
              (princ "  0\nSEQEND\n" fp)
              (princ (strcat "  8\n" lay "\n") fp)
            )
          )
        )
      )
    )
  )
)

;; LWP -> LINE, ARCigpj
(defun lwpToLineArcDXF (ent fp / list1042  arc bulge cen code ed eddeg i j k len
                        p1 p2 pt r st stdeg )
  (setq list1042 (LwpEntToList1042 ent))
  (setq len (length list1042) i 0)
  (repeat (1- len)
    (setq p1 (car (nth i list1042)))
    (setq p2 (car (nth (1+ i) list1042)))
    (setq bulge (cadr (nth i list1042)))
    (if (equal bulge 0.0 10e-8)
      (progn
        ;; LINE
        (princ "  0\nLINE\n" fp)
        (princ "  8\n0\n" fp)
        (princ "  6\nBYLAYER\n" fp);; 햼
        (if (assoc 62 ent)
          (progn
            (princ " 62\n" fp)
            (princ (cdr (assoc 62 ent)) fp)
            (princ "\n" fp)
          )
          (princ " 62\n256\n" fp) ;; F
        )
        (setq code 10 pt (list (car p1)(cadr p1) 0.0))
        (repeat 2
          (setq j 0 k code)
          (repeat 3
            (princ (strcat " " (itoa k) "\n") fp)
            (princ (nth j pt)  fp)
            (princ "\n" fp)
            (setq j (1+ j ) k (+ k 10))
          )
          (setq code 11 pt (list (car p2)(cadr p2) 0.0))         
        )          
      )
      (progn
        ;; ARC
        (setq arc (BulgeToArc p1 p2 bulge))
        (setq cen (car arc) r (cadr arc) st (caddr arc) ed (cadddr arc))
        (setq stdeg (* 180.0 (/ st PI)) eddeg (* 180.0 (/ ed PI)))
        (princ "  0\nARC\n" fp)
        (princ "  8\n0\n" fp)
        (princ "  6\nBYLAYER\n" fp);; 햼
        (if (assoc 62 ent)
          (progn
            (princ " 62\n" fp)
            (princ (cdr (assoc 62 ent)) fp)
            (princ "\n" fp)
          )
          (princ (strcat " 62\n" "256\n") fp) ;; F
        )
        (setq cen (list (car cen)(cadr cen) 0.0))
        (setq code 10)
        (setq pt  cen j 0 k code)
        (repeat 3
          (princ (strcat " " (itoa k) "\n") fp)
          (princ (nth j pt)  fp)
          (princ "\n" fp)
          (setq j (1+ j ) k (+ k 10))
        )
        (princ " 40\n" fp)(princ r fp)(princ "\n" fp)
        (princ " 50\n" fp)(princ stdeg fp)(princ "\n" fp)
        (princ " 51\n" fp)(princ eddeg fp)(princ "\n" fp)
        
      )
    )
    (setq i (1+ i))
  )
  fp
)

;; LWPOLYLINE̒_W̎擾Q(10-42LISTɂj̎́AŌɎn_ǉ
(defun LwpEntToList1042 (ent / i p v70 v10 v42 list1042) 
  ;_W̎擾2(10-42LISTɂj
  (setq list1042 '()) ;;Iɏ
  (setq i   0
        v70 0
  )
  (repeat (length ent) 
    (setq p (nth i ent))
    ;ł邩̎擾
    (if (= (car p) 70) (setq v70 (cdr p)))
    (if (= (car p) 10) 
      (setq  ;10̒l
            v10      (cdr (nth i ent)) ;c݂̒l
            v42      (cdr (nth (+ i 3) ent))
            i        (+ i 3)
            list1042 (cons (list v10 v42) list1042)
      )
    )
    (setq i (1+ i))
  )
  (if (/= v70 0) (setq list1042 (cons (last list1042) list1042)))
  (reverse list1042)
)

;; LW |C̖c݂~ʂɕϊ
(defun BulgeToArc (p1 p2 bulge / naikaku d hankei kakudo1 ed p0 r st) 
  (setq naikaku (* (atan bulge) 4.0))
  (setq d (/ (distance p1 p2) 2.0))
  (setq hankei (/ d (sin (/ naikaku 2.0))))
  (setq r (abs hankei))
  (setq kakudo1 (- (/ pi 2.0) (/ naikaku 2.0)))
  (setq p0 (polar p1 (+ kakudo1 (angle p1 p2)) hankei))
  (if (< bulge 0.0) 
    (setq st (angle p0 p2)
          ed (angle p0 p1)
    )
    (setq st (angle p0 p1)
          ed (angle p0 p2)
    )
  )
  (list p0 r st ed)
)
(defun explodeMtextDXF( ss / len i mtlst txlst ename elast ent)
  (setq len (sslength ss) i (1- len))
  (repeat len
    (setq ename (ssname ss i))
    (if (= "MTEXT" (cdr (assoc 0 (entget ename))))
      (progn
        (setq ss (ssdel ename ss))
        (setq mtlst (append mtlst (list ename)))
      )    
    )
    (setq i (1- i))
  )
  (if mtlst
    (progn
      (setvar "cmdecho" 0)
      (setq len (length mtlst) i 0)
      (repeat len
        (setq ename (nth i mtlst))
        (setq ent (entget ename))
        (setq elast (entlast))
        (vl-cmdf "explode" ename)
        (while (and elast (entnext elast)) 
          (setq txlst (append txlst (list (entnext elast))))
          (setq elast (entnext elast))
        )      
        (setq i (1+ i))
      )
      (setvar "cmdecho" 1)
    )
  )
  (if txlst
    (progn
      (setq len (length txlst) i 0)
      (repeat len
        (setq ss (ssadd (nth i txlst) ss))
        (setq i (1+ i))
      )
    )  
  )
  ss
)

;; ֐̃eXgpiCAD ̐}` R12 ` DXF ŕۑj
(defun c:makeR12DXF2( / fname ss kw )
  (if (setq ss (ssget '((0 . "LINE,CIRCLE,ARC,LWPOLYLINE,TEXT,INSERT,SOLID,DIMENSION,LEADER,MTEXT,ELLIPSE"))))
    (if (setq fname (getfiled "R12 DXF t@C̕ۑ" "" "dxf" 1))
      (progn
        (initget "Yes No")
        (if (not (setq kw (getkword "\nMTEXT ͈ꎞIɕAϊ UNDO Ŗ߂܂B낵łH [Yes(Y)/No(N)] < Yes > : ")))
          (setq kw "Yes")
        )
        (if (= kw "Yes")
          (progn
            (setvar "cmdecho" 0)
            (vl-cmdf "_UNDO" "M")
            (setq ss (explodeMtextDXF ss))
            ;;(vl-cmdf "_UNDO" "E")
            (setvar "cmdecho" 1)
          )
        )
        (makeR12DXF fname ss)
        (if (= kw "Yes")
          (progn
            (setvar "cmdecho" 0)
            (vl-cmdf "_UNDO" "B")
            (setvar "cmdecho" 1)
          )
        )
        (if (findfile fname)
          (progn
            (princ " > ")(princ fname)
            ;;(princ "\nDXF t@C`FbN ...")
            ;;(checkDXF fname)
          )
        )
      )
    )
  )
  (princ)
)

;; DXFt@C𕪉}iړx 1.0Apx 0.0 Œj
(defun c:insertEXP ( / fname)
  (if (setq fname (getfiled "} DXFADWG t@CI" "" "dxf;dwg" 8))
    (progn
      (vl-cmdf "-insert" (strcat "\"*" fname "\"")  pause 1 0)
    )
  )
  (princ)
)
;; I}`̉wAAX^CA@X^C̖O擾
(defun getEntLayLTypStyNames(ss / ent i len name lays stys ltyps dims)
  (setq len (sslength ss) i 0)
  (setq lays (list "0"))
  (repeat len
    (setq ent (entget (ssname ss i)))
    (setq name (cdr (assoc 8 ent)))
    (if (and name (not (and lays (member name lays))))
      (setq lays (append lays (list name)))
    )
    (setq name (cdr (assoc 6 ent)))
    (if (and name (not (and ltyps (member name ltyps))))
      (setq ltyps (append ltyps (list name)))
    )
    (setq name (cdr (assoc 7 ent)))
    (if (and name (not (and stys (member name stys))))
      (setq stys (append stys (list name)))
    )
    (if (= "DIMENSION" (cdr (assoc 0 ent)))
      (progn
        (setq name (cdr (assoc 3 ent)))
        (if (and name (not (and dims (member name dims))))
          (setq dims (append dims (list name)))
        )
      )
    )
    (setq i (1+ i))
  )
  (list lays ltyps stys dims)
)

(defun layersR12DXF( layNames fp / len i ent)
  ;; K{ = 2 70 62 6 
  (setq len (length laynames) i 0)
  (if (> len 0)
    (progn
      (princ (strcat "  0\n" "TABLE\n") fp)
      (princ (strcat "  2\n" "LAYER\n") fp)
      (princ (strcat " 70\n" (itoa len) "\n") fp);; w̐
      (repeat len
        (setq ent (entget (tblobjname "LAYER" (nth i laynames))))
        ;;(setq ent (tblsearch "LAYER" (nth i laynames)))
        (princ "  0\nLAYER\n" fp);; 
        ;; w̖O
        (princ (strcat "  2\n" (cdr (assoc 2 ent)) "\n") fp)
        ;; WtO(rbgR[h 1=t[YA2=Vr[|[gŃt[YA4=bN)
        (if (assoc 70 ent)
          (princ (strcat " 70\n" (itoa (cdr (assoc 70 ent))) "\n") fp)
          (princ " 70\n0\n" fp)
        )
        ;; w̐F
        (if (assoc 62 ent)
          (princ (strcat " 62\n" (itoa (cdr (assoc 62 ent))) "\n") fp)
          (princ " 62\n7\n" fp)
        )
        ;; w̐
        (princ (strcat "  6\n" (cdr (assoc 6 ent)) "\n") fp)
        (setq i (1+ i))
        ;;(princ "\n")(princ (cdr (assoc 2 ent)))(princ " code=")(princ (cdr (assoc 70 ent)) )
      )
      (princ "  0\nENDTAB\n" fp)
      
    )
  )
)

(defun ltypesR12DXF(ltypeNames fp / len i ent code codes j)
  ;; K{ = 2 70 3 72 73 40 49 
  (setq len (length ltypenames))
  (if (> len 0)
    (progn
      (princ (strcat "  0\n" "TABLE\n") fp)
      (princ (strcat "  2\n" "LTYPE\n") fp)
      (princ (strcat " 70\n" (itoa (1+ len)) "\n") fp);; 퐔

      (setq i 0)
      (repeat len
        (setq ent (entget (tblobjname "LTYPE" (nth i ltypenames))))
        (princ "  0\nLTYPE\n" fp);; 
        (setq codes (list 2 3 70 72 73 40 49) j 0)
        (repeat (length ent)
          (setq code (car (nth j ent)))
          (if (member code codes)
            (progn
              (princ (strcat " " (itoa code) "\n") fp) 
              (princ (cdr (nth j ent)) fp) 
              (princ "\n" fp);; 
            )
          )
          (setq j (1+ j))
        )
        (setq i (1+ i))
      )
      (princ "  0\nENDTAB\n" fp)
    )
  )
)

(defun stylesR12DXF(styleNames  fp dimFlag / code codes ent i j len style)
  (if dimFlag
    (setq style "DIMSTYLE" 
          codes (list 2 70 3 4 5 6 7 
                   40 41 42 43 44 45 46 47 48 
                   140 141 142 143 145 146 147 
                   71 72 73 74 75 76 77 78 
                   170 171 172 173 174 175 176 177 178)
    )
    (setq style "STYLE" 
           ;; K{ = 2 70 40 41 42 3 4
          codes (list 2 70 40 41 50 71 42 3 4)
    )
  )
  (setq len (length stylenames))
  (if (> len 0)
    (progn
      (princ "  0\nTABLE\n" fp)
      (princ (strcat "  2\n" style "\n") fp)
      (princ (strcat " 70\n" (itoa len) "\n") fp);; X^C 
      (setq i 0)
      (repeat len
        (setq ent (entget (tblobjname style (nth i stylenames))))
        (princ (strcat "  0\n" style "\n") fp);; 
        (setq j 0)
        (repeat (length ent)
          (setq code (car (nth j ent)))
          (if (member code codes);; (= (car (nth j ent)) code)
            (progn
              (princ (strcat " " (itoa code) "\n") fp) 
              (princ (cdr (nth j ent)) fp) 
              (princ "\n" fp);; 
            )
          )            
          (setq j (1+ j))
        )
        (setq i (1+ i))        
      )
      (princ "  0\nENDTAB\n" fp)
    )
  )
)

(defun getBNameLays(ss / len i ename ent name names lays)
  (setq len (sslength ss) i 0)
  (repeat len
    (setq ename  (ssname ss i))
    (setq ent (entget ename))
    (if (= (cdr (assoc 0 ent)) "INSERT")
      (progn
        (setq name (cdr (assoc 2 ent)))
        (if (and name (not (and names (member name names))))
          (setq names (append names (list name)))
        )
        (setq name (cdr (assoc 8 ent)))
        (if (and name (not (and lays (member name lays))))
          (setq lays (append lays (list name)))
        )
      )
    )
    (setq i (1+ i))
  )
  (list names lays)
)

;; ubN̐}`̉w擾
(defun getInBlockLayers( blknames / lays ename ent i lay )
  (if blknames
    (progn
      (setq i 0)
      (repeat (length blknames)
        (setq ename (tblobjname "BLOCK" (nth i blknames)))
        (setq ent (entget ename))
        (setq lay (cdr (assoc 8 ent)))
        (while ename
          (if (setq ename (entnext ename))
            (progn
              (setq ent (entget ename))
              (if (= "SEQEND" (cdr (assoc 0 ent)))
                (setq ename nil)
              )
              (if ename
                (progn
                  (setq lay (cdr (assoc 8 ent)))
                  (if (not (member lay lays))
                    (setq lays (append lays (list lay)))
                  )
                )
              )
            )
          )
        )
        (setq i (1+ i))
      )
    )
  )
  
  lays
)

;; ubNƂɓ}`擾ilXgꂽubNԂj
(defun blocksR12DXF( blkNames fp  attFlag / i ent ename etype layer 
                     code codes j k m layname pt bname nestblk name wipeouts)
  (if blknames
    (progn
      ;;INSERT 67 6 62 210 66, 41 42 43 50 70 71 44 45
      (setq i 0)
      (repeat (length blknames)
        ;; 0 BLOCK Ŏn܂ 0 ENDBLK ŏIǍJԂ
        (setq ename (tblobjname "BLOCK" (nth i blknames)))
        (setq ent (entget ename))
        (princ "  0\nBLOCK\n" fp)
        (princ (strcat "  8\n" (cdr (assoc 8 ent)) "\n") fp);; w
        (setq bname (string_replace "_" " " (cdr (assoc 2 ent))))
        (princ (strcat "  2\n" bname "\n") fp);; ubN
        (if (assoc 67 ent)
          (princ (strcat " 67\n" (itoa (cdr (assoc 67 ent))) "\n") fp) 
          (princ " 67\n0\n" fp) 
        )
        (if (assoc 6 ent);; 
          (princ (strcat "  6\n"  (cdr (assoc 67 ent)) "\n") fp) 
          (princ "  6\nBYLAYER\n" fp) 
        )
        (if (assoc 62 ent);; F
          (princ (strcat " 62\n"  (itoa (cdr (assoc 6 ent))) "\n") fp) 
          (princ " 62\n256\n" fp) 
        ) 
        (setq layname (cdr (assoc 8 ent)))
        (setq codes (list 210 70 10 1 3))
        (setq j 0)
        (repeat (length ent)
          (setq k 0) 
          (repeat (length codes)
            (setq code (nth k codes))
            
            (if (= (car (nth j ent)) code)
              (cond
                ((OR (= code 10)(= code 210))
                  (progn
                    (setq m 0)
                    (repeat 3
                      (princ (strcat " " (itoa code) "\n") fp)(princ (nth m (cdr (nth j ent))) fp)(princ "\n" fp);; 
                      (setq code (+ code 10))
                      (setq m (1+ m))
                    )                
                  )
                )
                ((= code 3)
                  (progn
                    (setq bname (string_replace "_" " " (cdr (assoc 3 ent))))
                    (princ (strcat "  3\n" bname "\n") fp);; ubN
                  )
                )
                ( T
                  (progn
                    (princ (strcat " " (itoa code) "\n") fp)(princ (cdr (nth j ent)) fp)(princ "\n" fp);; 
                  )
                )
              )
            )            
            (setq k (1+ k))
          ) 
          (setq j (1+ j))          
        )
        (while ename
          (setq ename (entnext ename))  
          (if ename
            (progn
              (setq codes nil)
              (setq ent (entget ename))
              (setq etype (cdr (assoc 0 ent)))
              (setq layer (cdr (assoc 8 ent)))
              (cond 
                ((= etype "LINE" )
                  (setq codes (list 39 10 11))
                )
                ((= etype "CIRCLE")
                  (setq codes (list 39 10 40))
                )
                ((= etype "ARC")
                  (setq codes (list 39 10 40 50 51))  
                )
                ((= etype "TEXT")
                  (setq codes (list 39 10 40 1 50 41 51 7 71 72 11 73))
                )
                ((= etype "LWPOLYLINE")
                  (lwpToPlineDXF ent fp)
                )
                ((= etype "SOLID")
                  (SolidToPlineDXF ent fp)
                )
                ((= etype "LEADER") ;; 2025/10/14
                  (LeaderToPlineDXF ent fp)
                )
                ((and attFlag (= etype "ATTDEF"))
                  (setq codes (list 39 10 40 1 50 41 51 7 71 72 11 3 2 70 73 74))
                )
                ((= etype "INSERT");; 2025/10/13
                  (progn
                    (setq name (cdr (assoc 2 ent)))
                    (if (and (not (member name blknames)) (not (member name nestblk)))
                      (setq nestblk (append nestblk (list name)))
                    )
                    (setq codes (list 2 10 41 42 43 50));; 66 70 71 44 45))
                  )
                )
                ((= etype "WIPEOUT");; 2025/10/23
                  (if (not (member bname wipeouts))
                    (setq wipeouts (append wipeouts (list bname)))
                  )
                )
              )          
              (if codes
                (progn
                  (princ (strcat "  0\n" etype "\n") fp)
                  (if (assoc 67 ent) ;; 0 or 1
                    (princ (strcat " 67\n" (itoa (cdr (assoc 67 ent))) "\n") fp)
                    (princ (strcat " 67\n" "0\n") fp) ;; f
                  )
                  (princ (strcat "  8\n" (cdr (assoc 8 ent)) "\n") fp) ;; w
                  (if (assoc 6 ent)
                    (princ (strcat "  6\n" (cdr (assoc 6 ent)) "\n") fp) ;; 햼
                    (princ (strcat "  6\n" "BYLAYER\n") fp)
                  )      
                  (if (assoc 62 ent)
                    (princ (strcat " 62\n" (itoa (cdr (assoc 62 ent))) "\n") fp)
                    (princ (strcat " 62\n" "256\n") fp) ;; F 0= BYBLOCK, 256= BYLAYER
                  )
                  (if (assoc 210 ent)
                    (setq pt  (cdr (assoc 210 ent)))
                    (setq pt (list 0.0 0.0 1.0))
                  )                  
                  (setq j 0 k 210)
                  (repeat (length pt)
                    (princ (strcat " " (itoa k) "\n") fp)(princ (nth j pt) fp)(princ "\n" fp)
                    (setq j (1+ j ) k (+ k 10))
                  )
                  (writeDxfCodesEnt ent codes fp)
                )
              ) 
            )
          )                  
        )
        (princ "  0\nENDBLK\n" fp)
        (princ (strcat "  8\n"  layname "\n") fp);; wKv
        (setq i (1+ i))
      )
    )
  )
  (if wipeouts ;; 2025/10/23
    (progn
      (princ "\nWIPEOUT_BLOCK = ")(princ wipeouts)
      (princ "\np ... ")
    )
  )
  ;;  lXgꂽubNԂ
  nestblk
)

;; makeR12DXF2 ̃C֐iCAD ̐}` R12 ` DXF ŕۑ)
(defun makeR12DXF( fname ss / fp len i blkNames names  blay blays lays blklayNames attFlag)
  (if ss 
    (if (not (setq fp (open fname "w")))
      (progn
        (princ "\nt@CgpłB")
      )
      (progn
        ;; ubNƉw̃Xg
        (princ "}`擾 ...")
        (setq blklayNames (getBNameLays ss))
        (setq blknames (car blkLayNames))
        ;;(setq ticks (getvar "cdate"))
        ;; }`ɎgĂwBAX^CA@X^C̏i@X^C͖gpj
        (setq names (getEntLayLTypStyNames ss))
        ;; DIMENSION 2025/10/13
        (setq lays (car names) i 0)
        (if (setq blays (cadr blkLaynames))
          (repeat (length blays)
            (setq blay (nth i blays))
            (if (and blay (not (member blay lays)))
              (setq lays (append lays (list blay)))
            )
            (setq i (1+ i))
          )
        )
        
        ;; wɃubN}`̉wǉ
        (setq blays (getInBlockLayers blknames))
        (if blays 
          (progn
            (setq i 0)
            (repeat (length blays)
              (setq blay (nth i blays))
              (if (and blay (not (member blay lays)))
                (setq lays (append lays (list blay)))
              )
              (setq i (1+ i))
            )          
          )
        )
        
        (princ "\nR12 DXF t@C쐬 ...")
        ;; HEADER
        (princ (strcat "  0\n" "SECTION\n") fp)
        (princ (strcat "  2\n" "HEADER\n")  fp)
        (headerR12DXF fp)
        (princ (strcat "  0\n" "ENDSEC\n") fp) 
        
        (princ (strcat "  0\n" "SECTION\n") fp)
        (princ (strcat "  2\n" "TABLES\n") fp)
        ;; VPORT
        (vportR12DXF fp)
        ;; LTYPE
        (if (cadr names)
          (ltypesR12DXF (cadr names) fp)
        )
        ;; LAYER
        (if lays
          (layersR12DXF lays fp)
        )
        ;; STYLE
        (if (caddr names)
          (stylesR12DXF (caddr names) fp nil)
        )
        ;; DIMSTYLE 2025/10/13
        (if (cadddr names)
          (stylesR12DXF (cadddr names) fp T)
        )
        ;; VIEW _~[
        (viewR12DXF fp)
        ;; UCS + APPID + DIMSTYLE _~[
        (ucsAppidDimstyleR12DXF fp nil);; _~[ DIMSTYLE ǉȂ   
        (princ (strcat "  0\n" "ENDSEC\n") fp)
        
        ;; BLOCKS
        (princ (strcat "  0\n" "SECTION\n") fp)
        (princ (strcat "  2\n" "BLOCKS\n") fp)
        (setq attFlag T)
        ;; lXgꂽubN܂߂āAubNǉ
        (setq i 0);; Ôߖ[v
        (while (and (< i 10) (setq blknames (blocksR12DXF blkNames fp  attFlag)))
          (setq i (1+ i))
        )
        
        (princ (strcat "  0\n" "ENDSEC\n") fp)
        ;; ENTITIES
        (princ (strcat "  0\n" "SECTION\n") fp)
        (princ (strcat "  2\n" "ENTITIES\n") fp)
        (setq len (sslength ss) i 0)
        
        (repeat len
          (addR12Entities (ssname ss i) fp attFlag)
          (setq i (1+ i))
        )
        (princ (strcat "  0\n" "ENDSEC\n") fp)
        ;; EOF
        (princ (strcat "  0\n" "EOF\n") fp)
        (close fp) 
        (princ "\nI܂B")
        ;;(setq ticks (* (- (getvar "cdate") ticks) 24.0 60.0 60.0 10000.0))
        ;;(princ "\nmsec=")(princ (rtos ticks 2 1))
      )        
    )
  )
  (princ)
)
; (0 . "LEADER")
; (67 . 0) 
; (8 . "0") 
; (100 . "AcDbLeader") 
; (3 . "ISO-25") ;;@X^C
; (71 . 1) ;; tO 1=L
; (72 . 0) ;; opX^Cv 0=ZOg
; (73 . 0) ;; o쐬tO 0= 1=􉽌 2=ubNQ 3=ߖ 
; (74 . 0) ;; tbNCtO
; (75 . 0) ;; tbNCtO
; (40 . 2.5) ;; ߂̍ 
; (41 . 7.38095) ;; ߂̕ 
; (76 . 3) ;; _̐
; (10 719.004 461.072 0.0)
; (10 719.004 471.25 0.0) 
; (10 747.5 471.25 0.0)
; DIMASZ=2.5

;; LEADER ̖ POLYLINE őp
(defun leaderToPlineDXF(ent fp / len i pts lay pt dimasz ang w p1 p2 txw)
  (if (= (cdr (assoc 0 ent)) "LEADER")
    (progn
      (setq len (length ent) i 0)
      (repeat len
        (if (= 10 (car (nth i ent)))
          (setq pts (append pts (list (cdr (nth i ent)))))
        )
        (setq i (1+ i))
      )      
      (princ "  0\nPOLYLINE\n" fp)
      (setq lay (cdr (assoc 8 ent)))
      (princ (strcat "  8\n" lay "\n") fp)
      (princ " 66\n  1\n" fp);; 㑱}`tO(Œ)
      (princ " 10\n0.0\n" fp);; _~[
      (princ " 20\n0.0\n" fp);; _~[
      (princ " 30\n0.0\n" fp);; x 
      (princ " 70\n0\n" fp);; 
      (princ " 40\n0.0\n" fp);; Jn  
      (princ " 41\n0.0\n" fp);; I
      ;; ߂̉̒ZȂ
      (if  (assoc 41 ent)
        (progn
          (setq txw (cdr (assoc 41 ent))); ߂̕
          (setq pts (append pts (list (polar (last pts) 0.0 txw))))
        )
      )
      (setq len (length pts) i 0)
      (repeat len
        (setq pt (nth i pts))
        (princ "  0\nVERTEX\n" fp)
        (princ (strcat "  8\n" lay "\n") fp);; w
        (princ " 10\n" fp)(princ (car pt) fp)(princ "\n" fp)
        (princ " 20\n" fp)(princ (cadr pt) fp) (princ "\n" fp)       
        (princ " 30\n0.0\n" fp)        
        (princ " 42\n0.0\n" fp);
        (setq i (1+ i))
      )      
      (princ "  0\nSEQEND\n" fp)
      ;; @X^C
      ;;(setq styname (cdr (assoc 3 ent)))
      (setq dimasz (getvar "dimasz"))
      (setq ang (angle (car pts)(cadr pts)))
      (princ "  0\nPOLYLINE\n" fp)
      (setq lay (cdr (assoc 8 ent)))
      (princ (strcat "  8\n" lay "\n") fp)
      (princ " 66\n  1\n" fp);; 㑱}`tO(Œ)
      (princ " 10\n0.0\n" fp);; _~[
      (princ " 20\n0.0\n" fp);; _~[
      (princ " 30\n0.0\n" fp);; x 
      (princ " 70\n0\n" fp);; Ȃ
      (princ " 40\n0.0\n" fp);; Jn  
      (setq w (* (/ dimasz 2.5) 0.83333333333))
      (princ (strcat " 41\n" (rtos w 2 8) "\n") fp);; I
      (setq p1 (car pts))
      (setq p2 (polar p1 ang dimasz))
      (princ "  0\nVERTEX\n" fp)
      (princ (strcat "  8\n" lay "\n") fp);; w
      (princ " 10\n" fp)(princ (car p1) fp)(princ "\n" fp)
      (princ " 20\n" fp)(princ (cadr p1) fp) (princ "\n" fp)       
      (princ " 30\n0.0\n" fp)        
      (princ " 42\n0.0\n" fp);
      (princ "  0\nVERTEX\n" fp)
      (princ (strcat "  8\n" lay "\n") fp);; w
      (princ " 10\n" fp)(princ (car p2) fp)(princ "\n" fp)
      (princ " 20\n" fp)(princ (cadr p2) fp) (princ "\n" fp)       
      (princ " 30\n0.0\n" fp)        
      (princ " 42\n0.0\n" fp);
      (princ "  0\nSEQEND\n" fp)  
    )
  )
)


;; LWPOLYLINE -> POLYLINE
(defun lwpToPlineDXF(ent fp  /  closed i item len list1042 v70 lay ltyp)
  (if (= (cdr (assoc 0 ent)) "LWPOLYLINE")
    (progn
      (setq list1042 (LwpEntToList1042 ent)
        v70      (cdr (assoc 70 ent))
        closed   (and v70 (/= v70 0))
        lay (cdr (assoc 8 ent))
        ltyp (cdr (assoc 6 ent))
      )
      (princ "  0\nPOLYLINE\n" fp)
      (princ (strcat "  8\n" lay "\n") fp)
      (if ltyp
        (princ (strcat "  6\n" ltyp "\n") fp)
        (princ "  6\nBYLAYER\n" fp);; 햼
      )
      (if (assoc 62 ent)
        (progn
          (princ " 62\n" fp)
          (princ (cdr (assoc 62 ent)) fp)
          (princ "\n" fp)
        )
        (princ " 62\n256\n" fp) ;; F
      )
      (princ " 66\n  1\n" fp);; 㑱}`tO(Œ)
      (princ " 10\n0.0\n" fp);; _~[
      (princ " 20\n0.0\n" fp);; _~[
      (princ " 30\n0.0\n" fp);; x
      (princ " 39\n0.0\n" fp);; 
      (if closed
        (princ " 70\n1\n" fp)
        (princ " 70\n0\n" fp)
      )
      (if (assoc 40 ent)
        (progn
          (princ " 40\n" fp)
          (princ (cdr (assoc 40 ent)) fp)
          (princ "\n" fp)
        )
        (princ " 40\n0.0\n" fp);; Jn
      )
      (if (assoc 41 ent)
        (progn
          (princ " 41\n" fp)
          (princ (cdr (assoc 41 ent)) fp)
          (princ "\n" fp)
        )      
        (princ " 41\n0.0\n" fp);; I
      )
      (setq len (length list1042))
      (setq i 0)
      (repeat len
        (setq item (nth i list1042))
        (princ "  0\nVERTEX\n" fp)
        (princ (strcat "  8\n" lay "\n") fp);; w
        (princ " 10\n" fp)(princ (car (car item)) fp)(princ "\n" fp)
        (princ " 20\n" fp)(princ (cadr (car item)) fp) (princ "\n" fp)       
        (princ " 30\n0.0\n" fp)
        (if (assoc 40 ent)
          (progn
            (princ " 40\n" fp)
            (princ (cdr (assoc 40 ent)) fp)
            (princ "\n" fp)
          )
          (princ " 40\n0.0\n" fp);; Jn
        )
        (if (assoc 41 ent)
          (progn
            (princ " 41\n" fp)
            (princ (cdr (assoc 41 ent)) fp)
            (princ "\n" fp)
          )      
          (princ " 41\n0.0\n" fp);; I
        )      
        (princ " 42\n" fp)(princ (cadr item) fp)(princ "\n" fp)
        (setq i (1+ i))
      )
      (princ "  0\nSEQEND\n" fp)
    )
  )
  (princ)
)
;; SOLID -> POLYLINE
(defun solidToPlineDXF(ent fp / p1 p2 p3 p4 pts  i lay ltyp pt )
  (setq lay (cdr (assoc 8 ent)))
  (setq ltyp (cdr (assoc 6 ent)))
  (setq p1 (cdr (assoc 10 ent)))
  (setq p2 (cdr (assoc 11 ent)))
  (setq p4 (cdr (assoc 12 ent)))
  (setq p3 (cdr (assoc 13 ent)))
  (if (equal p3 p4 10e-10)
    (setq pts (list p1 p2 p3))
    (setq pts (list p1 p2 p3 p4))
  )
  (princ "  0\nPOLYLINE\n" fp)
  (princ (strcat "  8\n" lay "\n") fp)
  (if ltyp
    (princ (strcat "  6\n" ltyp "\n") fp)
    (princ "  6\nBYLAYER\n" fp);; 햼
  )
  (if (assoc 62 ent)
    (progn
      (princ " 62\n" fp)
      (princ (cdr (assoc 62 ent)) fp)
      (princ "\n" fp)
    )
    (princ " 62\n256\n" fp) ;; F
  )
  (princ " 66\n  1\n" fp);; 㑱}`tO(Œ)
  (princ " 10\n0.0\n" fp);; _~[
  (princ " 20\n0.0\n" fp);; _~[
  (princ " 30\n0.0\n" fp);; x
  (princ " 39\n0.0\n" fp);; 
  (princ " 70\n1\n" fp)
  (if (assoc 40 ent)
    (progn
      (princ " 40\n" fp)
      (princ (cdr (assoc 40 ent)) fp)
      (princ "\n" fp)
    )
    (princ " 40\n0.0\n" fp);; Jn
  )
  (if (assoc 41 ent)
    (progn
      (princ " 41\n" fp)
      (princ (cdr (assoc 41 ent)) fp)
      (princ "\n" fp)
    )      
    (princ " 41\n0.0\n" fp);; I
  )  
  
  ;;(princ " 40\n0.0\n" fp);; Jn
  ;;(princ " 41\n0.0\n" fp);; I  
  (setq i 0)
  (repeat (length pts)
    (setq pt (nth i pts))
    (princ "  0\nVERTEX\n" fp)
    (princ (strcat "  8\n" lay "\n") fp);; w
    (princ " 10\n" fp)(princ (car pt) fp)(princ "\n" fp)
    (princ " 20\n" fp)(princ (cadr pt) fp) (princ "\n" fp)       
    (princ " 30\n0.0\n" fp)
    (if (assoc 40 ent)
      (progn
        (princ " 40\n" fp)
        (princ (cdr (assoc 40 ent)) fp)
        (princ "\n" fp)
      )
      (princ " 40\n0.0\n" fp);; Jn
    )
    (if (assoc 41 ent)
      (progn
        (princ " 41\n" fp)
        (princ (cdr (assoc 41 ent)) fp)
        (princ "\n" fp)
      )      
      (princ " 41\n0.0\n" fp);; I
    )    
    
    ; (princ " 40\n0.0\n" fp);; Jn
    ; (princ " 41\n0.0\n" fp);; I  
    (princ " 42\n0.0\n" fp)
    (princ " 70\n0\n" fp)
    (setq i (1+ i))
  )
  (princ "  0\nSEQEND\n" fp)
)
;; ȉ~->|C 2025/11/25
(defun EllipseToPlineDXF( ename fp / obj ent num inc dist plst pt closed i lay ltyp)
  (setq obj (vlax-ename->vla-object ename) ent (entget ename))
  (setq lay (cdr (assoc 8 ent)))
  (setq ltyp (cdr (assoc 6 ent)))
  
  (setq num 36)
  (setq  inc (/ (vlax-curve-getdistatparam obj (vlax-curve-getendparam obj)) num)
        dist 0.0
      plst '()
  )
  (repeat (+ num 1)
      (setq pt (vlax-curve-getpointatdist obj dist))
      (setq plst (cons pt plst))
      (setq dist (+ dist Inc))
  ) 
  (if (and plst (>= (length plst) 2))
    (progn
      (setq closed nil);; Ȃ
      (princ "  0\nPOLYLINE\n" fp)
      (princ (strcat "  8\n" lay "\n") fp)
      (if ltyp
        (princ (strcat "  6\n" ltyp "\n") fp)
        (princ "  6\nBYLAYER\n" fp);; 햼
      )
      (if (assoc 62 ent)
        (progn
          (princ " 62\n" fp)
          (princ (cdr (assoc 62 ent)) fp)
          (princ "\n" fp)
        )
        (princ " 62\n256\n" fp) ;; F
      )
      (princ " 66\n  1\n" fp);; 㑱}`tO(Œ)
      (princ " 10\n0.0\n" fp);; _~[
      (princ " 20\n0.0\n" fp);; _~[
      (princ " 30\n0.0\n" fp);; x
      (princ " 39\n0.0\n" fp);; 
      (if closed
        (princ " 70\n1\n" fp)
        (princ " 70\n0\n" fp)
      )
      (princ " 40\n0.0\n" fp);; Jn
      (princ " 41\n0.0\n" fp);; I
      (setq i 0)
      (repeat (length plst)
        (setq pt (nth i plst))      
        (princ "  0\nVERTEX\n" fp)
        (princ (strcat "  8\n" lay "\n") fp);; w
        (princ " 10\n" fp)(princ (car pt) fp)(princ "\n" fp)
        (princ " 20\n" fp)(princ (cadr pt) fp) (princ "\n" fp)       
        (princ " 30\n0.0\n" fp)
        (princ " 40\n0.0\n" fp);; Jn
        (princ " 41\n0.0\n" fp);; I
        (princ " 42\n0.0\n" fp)
        (princ " 70\n0\n" fp)
        (setq i (1+ i))
      )
      (princ "  0\nSEQEND\n" fp)
    )
  )
)
;; EllipseToLWP
;;https://www.cadtutor.net/forum/topic/79177-lisp-to-convert-partial-ellipse-to-polyline/
(defun c:ellpl ( / lwpoly obj oldsnap num inc dist plst pt)
  (defun LWPoly (lst cls)
    (entmakex (append (list (cons 0 "LWPOLYLINE")
                            (cons 100 "AcDbEntity")
                            (cons 100 "AcDbPolyline")
                            (cons 90 (length lst))
                            (cons 70 cls))
                      (mapcar (function (lambda (p) (cons 10 p))) lst))
    )
  )
  (setq obj (vlax-ename->vla-object (car (entsel "\nPick ellipse "))))
  (setq oldsnap (getvar 'osmode))
  (setvar 'osmode 0)
  (setq num 100)
  (setq  inc (/ (vlax-curve-getdistatparam obj (vlax-curve-getendparam obj)) num)
        dist 0.0
      plst '()
  )
  (repeat (+ num 1)
      (setq pt (vlax-curve-getpointatdist obj dist))
      (setq plst (cons pt plst))
      (setq dist (+ dist Inc))
  )
  (LWPoly plst 0);; Ȃ
  (setvar 'osmode oldsnap )
  (princ)
)
 
(princ)
